<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( !class_exists( 'Atum\Components\AtumCapabilities' ) ) {
	return;
}

if ( ! class_exists( 'PWBE_ATUM' ) ) :

final class PWBE_ATUM {

	function __construct() {
		add_filter( 'pwbe_select_options', array( $this, 'pwbe_select_options' ) );
		add_filter( 'pwbe_product_columns', array( $this, 'pwbe_product_columns' ) );
	}

	function pwbe_select_options( $select_options ) {
		global $wpdb;

		$post_statuses = Atum\Components\AtumCapabilities::current_user_can('edit_private_suppliers' ) ? array( 'private', 'publish' ) : array( 'publish' );

		$query = $wpdb->prepare(
			"SELECT DISTINCT ID, post_title from $wpdb->posts
			 WHERE post_type = %s
			 AND post_status IN ('" . implode( "','", $post_statuses ) . "')",
			Atum\Suppliers\Suppliers::POST_TYPE
		);

		$suppliers = $wpdb->get_results( $query );

		foreach ( $suppliers as $supplier ) {
			$select_options['_supplier'][ $supplier->ID ]['name'] = $supplier->post_title;
			$select_options['_supplier'][ $supplier->ID ]['visibility'] = 'both';
		}

	    return $select_options;
	}

	function pwbe_product_columns( $columns ) {
		$columns[] = array(
			'name' => __( 'Purchase Price', 'atum' ),
			'type' => 'currency',
			'table' => 'meta',
			'field' => '_purchase_price',
			'readonly' => 'false',
			'visibility' => 'both',
			'sortable' => 'true',
			'views' => array( 'all' )
		);

		$columns[] = array(
			'name' => __( 'Supplier', 'atum' ),
			'type' => 'select',
			'table' => 'meta',
			'field' => '_supplier',
			'readonly' => 'false',
			'visibility' => 'both',
			'sortable' => 'false',
			'views' => array( 'all' )
		);

		$columns[] = array(
			'name' => __( "Supplier's SKU", 'atum' ),
			'type' => 'text',
			'table' => 'meta',
			'field' => '_supplier_sku',
			'readonly' => 'false',
			'visibility' => 'both',
			'sortable' => 'true',
			'views' => array( 'all' )
		);

		return $columns;
	}
}

new PWBE_ATUM();

endif;

?>