<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'wc_custom_product_data_fields' ) ) {
	return;
}

if ( ! class_exists( 'PWBE_Flatsome' ) ) :

final class PWBE_Flatsome {

	function __construct() {
		add_filter( 'pwbe_select_options', array( $this, 'pwbe_select_options' ) );
		add_filter( 'pwbe_product_columns', array( $this, 'pwbe_product_columns' ) );
	}

	function pwbe_select_options( $select_options ) {
		$data_fields = wc_custom_product_data_fields();

		foreach ( $data_fields as $field ) {
			if ( isset( $field['options'] ) ) {
				$id = 'wc_productdata_options___0___' . $field['id'];

				foreach ( $field['options'] as $key => $value ) {
					$select_options[ $id ][ $key ]['name'] = $value;
					$select_options[ $id ][ $key ]['visibility'] = 'parent';
				}
			}
		}

	    return $select_options;
	}

	function pwbe_product_columns( $columns ) {
		$data_fields = wc_custom_product_data_fields();

		foreach ( $data_fields as $field ) {
			if ( isset( $field['id'] ) ) {
				$columns[] = array(
					'name' => $field['label'],
					'type' => $field['type'],
					'table' => 'meta',
					'field' => 'wc_productdata_options___0___' . $field['id'],
					'readonly' => 'false',
					'visibility' => 'parent',
					'sortable' => 'false',
					'views' => array( 'all' )
				);
			}
		}

		return $columns;
	}
}

new PWBE_Flatsome();

endif;

?>