function Hashtable() {
	var keysToIndex = {
		__indexToValue : [],
		__indexToKeys : []
	};
	var activeEnum = [];
	var tableLength = 0;
	var self = this;

	function Enumeration(arrNm) {
		var lastIndex = null;
		var enumIndex = 0;
		while( typeof activeEnum[enumIndex] == 'number') {
			enumIndex += 1;
		}
		activeEnum[enumIndex] = 0;

		this.hasNext = this.hasMoreElements = function() {
			if(activeEnum[enumIndex] < tableLength) {
				return true;
			} else {
				if( typeof activeEnum[enumIndex] == 'number') {
					activeEnum[enumIndex] = null;
				}
				return false;
			}
		};

		this.next = this.nextElement = function() {
			if(this.hasNext) {
				lastIndex = activeEnum[enumIndex];
				return keysToIndex[arrNm][activeEnum[enumIndex]++];
			} else {
				return null;
			}
		};

		this.remove = function() {
			if( typeof lastIndex == 'number') {
				self.remove(keysToIndex.__indexToKeys[lastIndex]);
				lastIndex = null;
			}
		};
	}

	this.get = function(key) {
		if( typeof keysToIndex[key] == 'number') {
			return keysToIndex.__indexToValue[keysToIndex[key]];
		} else {
			return null;
		}
	};

	this.put = function(key, value) {
		if( typeof keysToIndex[key] == 'number') {
			keysToIndex.__indexToValue[keysToIndex[key]] = value;
		} else {
			keysToIndex[key] = tableLength;
			keysToIndex.__indexToValue[tableLength] = value;
			keysToIndex.__indexToKeys[tableLength++] = key;
		}
	};

	this.remove = function(key) {
		var remIndex = keysToIndex[key];
		if( typeof remIndex == 'number') {
			var c = 0;
			delete keysToIndex[key];
			tableLength -= 1;
			for( c = remIndex; c < tableLength; c++) {
				keysToIndex.__indexToValue[c] = keysToIndex.__indexToValue[c + 1];
				keysToIndex[(keysToIndex.__indexToKeys[c] = keysToIndex.__indexToKeys[c + 1])] = c;
			}
			for( c = 0; c < activeEnum.length; c++) {
				if((activeEnum[c]) && (remIndex < activeEnum[c])) {
					activeEnum[c] -= 1;
				}
			}
		}
	};
	this.size = function() {
		return tableLength;
	};

	this.__enumerate = function(type) {
		return new Enumeration(type);
	};

	Hashtable.prototype.elements = function() {
		return this.__enumerate('__indexToValue');
	};

	Hashtable.prototype.keys = function() {
		return this.__enumerate('__indexToKeys');
	};
	Hashtable.prototype.clear = function() {
		var e = this.keys();
		while(e.hasNext()) {
			this.remove(e.next());
		}
	};

	Hashtable.prototype.toString = function() {
		var arrow = ' =&gt; ';
		var separator = '\r\n';
		var n, e = this.keys();
		var st = '';
		while(e.hasNext()) {
			n = e.next();
			st += n + arrow + this.get(n) + separator;
		}
		return st;

	};

	Hashtable.prototype.contains = function(testVal) {
		var e = this.elements();
		while(e.hasNext()) {
			if(e.next() == testVal) {
				return true;
			}
		}
		return false;
	};

	Hashtable.prototype.containsValue = Hashtable.prototype.contains;


	Hashtable.prototype.containsKey = function(testKey) {
		return (this.get(testKey) !== null);
	};

	Hashtable.prototype.isEmpty = function() {
		return (this.size() === 0);
	};

	Hashtable.prototype.putAll = function(hTable) {
		if(hTable.constructor == Hashtable) {
			var n, e = hTable.keys();
			while(e.hasNext()) {
				n = e.next();
				this.put(n, hTable.get(n));
			}
		}
	};

	Hashtable.prototype.clone = function() {
		var ht = new Hashtable();
		ht.putAll(this);
		return ht;
	};

	Hashtable.prototype.equals = function(o) {
		return (o == this);
	};
}function startsWith(str, prefix) {
	return (str.indexOf(prefix) === 0);
}

function DomDataCollection(json_script) {

	var self = this;

	self.config = {
		recursion_level : 1,
		collection_mode : 'partial',
		functionsToExclude : [],
		function_list_size : 1024,
		json_script : json_script ? json_script : 'json2.js'
	};

	self.emptyDomData = function() {
		self.dom_data = {
			functions : {
				names : [],
				excluded : {
					size : 0,
					count : 0
				},
				truncated : false
			},
			inputs : [],
			iFrames : [],
			scripts : [],
			collection_status : DomDataCollection.NotStarted
		};
	};

	self.startInspection = function() {
		var any_collection_failure = false;
		var all_collection_failure = true;

	   BrowserDetect.init();
       if(!(BrowserDetect.browser === 'Explorer')) {
		try {
			self.inspectJSFunctions();
			all_collection_failure = false;
		} catch (e) {
			any_collection_failure = any_collection_failure || true;
		}
		}
		else {
		
		self.dom_data.functions = [];

		if(self.dom_data.functions === undefined || self.dom_data.functions.names === undefined) {
			self.dom_data.functions = {
				names : [],
				excluded : {
					size : 0,
					count : 0
				},
				truncated : false
			};
		}
		
		}

		try {
			self.inspectFrames();
			all_collection_failure = false;
		} catch (e) {
			any_collection_failure = any_collection_failure || true;
		}
		try {
			self.inspectScripts();
			all_collection_failure = false;
		} catch (e) {
			any_collection_failure = any_collection_failure || true;
		}
		try {
			self.inspectInputFields();
			all_collection_failure = false;
		} catch (e) {
			any_collection_failure = any_collection_failure || true;
		}
		if(any_collection_failure) {
			if(all_collection_failure) {
				self.dom_data.collection_status = DomDataCollection.Fail;
			} else {
				self.dom_data.collection_status = DomDataCollection.Partial;
			}
		} else {
			self.dom_data.collection_status = DomDataCollection.Success;
		}
		if(!(BrowserDetect.browser === 'Explorer')) {
		self.handleSizeLimit();
        } 
	};

	self.domDataAsJSON = function() {
		return stripIllegalChars(JSON.stringify(self.dom_data));
	};

	self.recursiveGetAllFunctionNamesUnderElement = function(elementName, element, level) {

		var paramVal;
		var paramName;
		var function_index;
		var config = self.config;
		var recursion_level = config.recursion_level;
		var collection_mode = config.collection_mode;

		if(self.dom_data.functions === undefined || self.dom_data.functions.names === undefined) {
			self.dom_data.functions = {
				names : [],
				excluded : {
					size : 0,
					count : 0
				},
				truncated : false
			};
		}
		var functions = self.dom_data.functions;
		var excluded = functions.excluded;
		for(var x in element) {
			try {
				var element_object = element[x];
				paramVal = "" + element_object;
				if(elementName.length > 0) {
					prefix = elementName + ".";
				} else {
					prefix = "";
				}
				paramName = prefix + x;
				if(isFunction(element_object)) {
					if(self.functionShouldBeCollected(element_object, x)) {
						var names = functions.names;
						function_index = names.length;
						names[function_index] = paramName;
					} else {
						// just count the excluded function
						if(collection_mode == 'partial') {
							excluded.size += paramVal.length;
							excluded.count++;
						}
					}
				}
				if(level + 1 < recursion_level) {
					self.recursiveGetAllFunctionNamesUnderElement(paramName, element_object, level + 1);
				} else {
					functions.names.sort();
				}

			} catch (e) {
				if(!window['console']) {
					window.console = {};
					window.console.info = noop;
					window.console.log = noop;
					window.console.warn = noop;
					window.console.error = noop;
				}
				if(console && console.log) {
					console.log("error counting functions: " + e.toString());
				}
			}
		}
	};
	function noop() {

	}

	function isFunction(element) {
		return typeof element == "function";
	}

	function countArgs(f) {
		return f.length;
	}

	var _functionsToExcludeSet = new Hashtable();

	self.initFunctionsToExclude = function() {
		if(_functionsToExcludeSet) {
			_functionsToExcludeSet.clear();
		}
		var functionsToExclude = self.config.functionsToExclude;
		var excluded_functions_count = functionsToExclude.length;
		while(excluded_functions_count--) {
			_functionsToExcludeSet.put(functionsToExclude[excluded_functions_count], "");
		}
	};

	self.functionShouldBeCollected = function functionShouldBeCollected(f, name) {
		if(self.config.collection_mode == 'full') {
			return true;
		} else {
			// lazy init of functionsToExclude set
			if(_functionsToExcludeSet.size() === 0) {
				self.initFunctionsToExclude();
			}
			if(_functionsToExcludeSet.containsKey(name)) {
				return false;
			} else {
				return true;
			}
		}
	};

	self.inspectJSFunctions = function() {
		self.dom_data.functions = [];
		self.recursiveGetAllFunctionNamesUnderElement("", window, 0);
	};

	self.handleSizeLimit = function() {

		var dom_data = self.dom_data;
		var config = self.config;
		var max_function_list_size = config.function_list_size;
		var functions = dom_data.functions;
		functions.names.sort();


		var dom_data_string = JSON.stringify(dom_data);

		if(max_function_list_size < 0) {
			max_function_list_size = 0;
		}


		var iter = 0;
		if(config.colllection_mode != 'full' && dom_data_string.length > max_function_list_size) {
			var names = functions.names;
			var function_names_string = names.toString();
			var length_without_functions = dom_data_string.length - JSON.stringify(names).length + '[]'.length;

			var done = false;
			var n_elements_to_keep = names.length;
			while(!done) {
				if(iter++ == 1000) {
					done = true;
				}
				lastComma = function_names_string.lastIndexOf(',');
				if(lastComma >= 0 && n_elements_to_keep > 0) {
				    quotation_marks = n_elements_to_keep * 2;
					if(length_without_functions + lastComma + quotation_marks > max_function_list_size) {
						function_names_string = function_names_string.substring(0, lastComma - 1);
						n_elements_to_keep--;
					} else {
						done = true;
					}
				} else {
					done = true;
				}
			}

			if(n_elements_to_keep > 1) {
				functions.truncated = true;
				functions.names = functions.names.slice(0, n_elements_to_keep - 1);
				dom_data.functions.truncated = true;
			} else {
				self.emptyDomData();
				dom_data = self.dom_data;
				dom_data.collection_status = DomDataCollection.Partial;
				dom_data.functions.truncated = true;
			}
		}
	};

	self.inspectFrames = function() {
		self.countElements("iframe");
	};

	self.countElements = function(tag) {
		var location;
		var items = document.getElementsByTagName(tag);
		if(self.dom_data.iFrames === undefined) {
			self.dom_data.iFrames = [];
		}
		var iFrames = self.dom_data.iFrames;
		var startIndex = iFrames.length;
		for( i = 0; i < items.length; i++) {
			iFrames[startIndex + i] = "" + items[i].src;
		}
		iFrames.sort();
	};

	self.inspectScripts = function() {
		var items = document.getElementsByTagName('script');
		self.dom_data.scripts = [];
		for(var i = 0; i < items.length; i++) {
			self.dom_data.scripts[i] = items[i].text.length;
		}
	};

	self.collectFields = function(tagName) {
		var elements = document.getElementsByTagName(tagName);
		if(self.dom_data.inputs === undefined) {
			self.dom_data.inputs = [];
		}
		var inputs = self.dom_data.inputs;
		var startIndex = inputs.length;
		var elements_index = elements.length;
		while(elements_index--) {
			var element = elements[elements_index];
			var name = element.name;
			var id = element.id;
			if(name && name.length > 0) {
				element_name = name;
			} else if(id && id.length > 0) {
				element_name = id;
			} else {
				element_name = "NO_NAME";
			}

			inputs[startIndex + elements_index] = element_name;
		}
		inputs.sort();
	};

	self.inspectInputFields = function() {
		self.collectFields("input");
		self.collectFields("textarea");
		self.collectFields("select");
		self.collectFields("button");
	};
	/**
	 * loads JSON if it does not already exist
	 */
	loadJSON = function() {
		if(!window.JSON) {
			var head = document.getElementsByTagName('head')[0];
			var script = document.createElement('script');
			script.type = 'text/javascript';
			script.src = self.config.json_script;
			head.appendChild(script);
		}
	};
	self.emptyDomData();
	loadJSON();
}

// status code constants
DomDataCollection.Success = 0;
DomDataCollection.Fail = 1;
DomDataCollection.Partial = 2;
DomDataCollection.NotStarted = 3;

function IE_FingerPrint() {

	this.deviceprint_browser = function () {
		var ua = navigator.userAgent.toLowerCase();
		t = ua + SEP + navigator.appVersion + SEP + navigator.platform;
		t += SEP + navigator.appMinorVersion + SEP + navigator.cpuClass + SEP + navigator.browserLanguage;
		t += SEP + ScriptEngineBuildVersion();
		return t;
	};

	this.deviceprint_software = function() {
		var t = "";
		var isFirst = true;
		
		try
		{
			document.body.addBehavior("#default#clientCaps");
			var compVer;
			var component_count = components.length;
			for (i = 0; i < component_count; i++) {
				compVer = activeXDetect(components[i]);
				var name = names[i];
				if (compVer) {
					if (isFirst === true) {
						t += name + PAIR + compVer;
						isFirst = false;
					} else {
						t += SEP + name + PAIR + compVer;
					}
				} else {
					t += "";
					isFirst = false;
				}
			}
		}
		catch(err) 
		{
			//error when document.body.addBehavior("#default#clientCaps")
		}
		return t;
	};
	var names =           [ "abk", // Address Book
			       		 	"wnt", // Windows Desktop Update NT
							"aol", // AOL ART Image Format Support
							"arb", // Arabic Text Display Support
							"chs", // Chinese (Simplified) Text Display Support
							"cht", // Chinese (traditional) Text Display Support
							"dht", // Dynamic HTML Data Binding
							"dhj", // Dynamic HTML Data Binding for Java
							"dan", // DirectAnimation
							"dsh", // DirectShow
							"heb", // Hebrew Text Display Support
							"ie5", // Internet Explorer 5 Browser
							"icw", // Internet Connection Wizard
							"ibe", // Internet Explorer Browsing Enhancements
							"iec", // Internet Explorer Classes for Java
							"ieh", // Internet Explorer Help
							"iee", // Internet Explorer Help Engine
							"jap", // Japanese Text Display Support
							"krn", // Korean Text Display Support
							"lan", // Language Auto-Selection
							"swf", // Macromedia Flash
							"shw", // Macromedia Shockwave Director
							"msn", // MSN Messenger Service
							"wmp", // Windows Media Player
							"obp", // Offline Browsing Pack
							"oex", // Outlook Express
							"net", // NetMeeting NT
							"pan", // Pan-European Text Display Support
							"thi", // Thai Text Display Support
							"tks", // Task Scheduler
							"uni", // Uniscribe
							"vtc", // Vector Graphics Rendering (VML)
							"vnm", // Vietnamese Text Display Support
							"mvm", // Microsoft virtual machine
							"vbs", // Visual Basic Scripting Support
							"wfd"]; // Web Folders
	/*
	 * Create a Hashtable of IE components guids
	 */
	var components =          [ "7790769C-0471-11D2-AF11-00C04FA35D02",
								"89820200-ECBD-11CF-8B85-00AA005B4340",
								"47F67D00-9E55-11D1-BAEF-00C04FC2D130",
								"76C19B38-F0C8-11CF-87CC-0020AFEECF20",
								"76C19B34-F0C8-11CF-87CC-0020AFEECF20",
								"76C19B33-F0C8-11CF-87CC-0020AFEECF20",
								"9381D8F2-0288-11D0-9501-00AA00B911A5",
								"4F216970-C90C-11D1-B5C7-0000F8051515",
								"283807B5-2C60-11D0-A31D-00AA00B92C03",
								"44BBA848-CC51-11CF-AAFA-00AA00B6015C",
								"76C19B36-F0C8-11CF-87CC-0020AFEECF20",
								"89820200-ECBD-11CF-8B85-00AA005B4383",
								"5A8D6EE0-3E18-11D0-821E-444553540000",
								"630B1DA0-B465-11D1-9948-00C04F98BBC9",
								"08B0E5C0-4FCB-11CF-AAA5-00401C608555",
								"45EA75A0-A269-11D1-B5BF-0000F8051515",
								"DE5AED00-A4BF-11D1-9948-00C04F98BBC9",
								"76C19B30-F0C8-11CF-87CC-0020AFEECF20",
								"76C19B31-F0C8-11CF-87CC-0020AFEECF20",
								"76C19B50-F0C8-11CF-87CC-0020AFEECF20",
								"D27CDB6E-AE6D-11CF-96B8-444553540000",
								"2A202491-F00D-11CF-87CC-0020AFEECF20",
								"5945C046-LE7D-LLDL-BC44-00C04FD912BE",
								"22D6F312-B0F6-11D0-94AB-0080C74C7E95",
								"3AF36230-A269-11D1-B5BF-0000F8051515",
								"44BBA840-CC51-11CF-AAFA-00AA00B6015C",
								"44BBA842-CC51-11CF-AAFA-00AA00B6015B",
								"76C19B32-F0C8-11CF-87CC-0020AFEECF20",
								"76C19B35-F0C8-11CF-87CC-0020AFEECF20",
								"CC2A9BA0-3BDD-11D0-821E-444553540000",
								"3BF42070-B3B1-11D1-B5C5-0000F8051515",
								"10072CEC-8CC1-11D1-986E-00A0C955B42F",
								"76C19B37-F0C8-11CF-87CC-0020AFEECF20",
								"08B0E5C0-4FCB-11CF-AAA5-00401C608500",
								"4F645220-306D-11D2-995D-00C04F98BBC9",
								"73FA19D0-2D75-11D2-995D-00C04F98BBC9"];

}

IE_FingerPrint.prototype = new FingerPrint();



function Mozilla_FingerPrint() {
	
}

Mozilla_FingerPrint.prototype = new FingerPrint();



function Opera_FingerPrint() {	
		
}

Opera_FingerPrint.prototype = new FingerPrint();

//----------- Timer --------------

function Timer() {
	this.startTime = new Date().getTime();
}

Timer.prototype.start = function() {
	this.startTime = new Date().getTime();
};

Timer.prototype.duration = function() {
	return (new Date().getTime()) - this.startTime;
};

//----------- Help functions -------------
function getRandomPort() {
	return Math.floor(Math.random() * 60000 + 4000);
}

//----------- Proxy Collection --------------

var ProxyCollector = {};
//----------- Function variables --------------
ProxyCollector.internalIP = "127.0.0.1";
ProxyCollector.externalIP;
ProxyCollector.internalPingTime;
ProxyCollector.externalPingTime;

ProxyCollector.setInternalPingTime = function(internalPingTimeToSet){
	ProxyCollector.internalPingTime = internalPingTimeToSet;
};

ProxyCollector.setExternalPingTime = function(externalPingTimeToSet){
	ProxyCollector.externalPingTime = externalPingTimeToSet;
};

ProxyCollector.PROXY_DETECTION_TIMEOUT = 5000;
ProxyCollector.TIMEOUT_CHECK_FREQUENCY = 1000;

ProxyCollector.isTimedOut = function(functionToReturn, currTimeout, request)
{
	_timer = new Timer();

	if ((currTimeout - _timer.duration() <= 0) && (((typeof ProxyCollector.internalPingTime === 'undefined') && ((new RegExp('internalPingTime')).test(functionToReturn))) || ((typeof ProxyCollector.externalPingTime === 'undefined') && ((new RegExp('externalPingTime')).test(functionToReturn)))))
	{
		functionToReturn.call(this, -1);
		request.abort();
	}
	else if (((typeof ProxyCollector.internalPingTime === 'undefined') && ((new RegExp('internalPingTime')).test(functionToReturn))) || ((typeof ProxyCollector.externalPingTime === 'undefined') && ((new RegExp('externalPingTime')).test(functionToReturn))))
	{
		setTimeout(function(){ProxyCollector.isTimedOut(functionToReturn, currTimeout - (_timer.duration() + ProxyCollector.TIMEOUT_CHECK_FREQUENCY), request)}, ProxyCollector.TIMEOUT_CHECK_FREQUENCY);
	}
};

ProxyCollector.doAjax = function(ip, returnFunction)
{
	var url = document.location.protocol+"//"+ ip + ":" + getRandomPort() + '/NonExistentImage' + getRandomPort() + '.gif';
	var request;
	var _timer;

	if (window.XDomainRequest)
	{
		request = new window.XDomainRequest();
		_timer = new Timer();
		try
		{
			request.timeout = ProxyCollector.PROXY_DETECTION_TIMEOUT;
			request.ontimeout = function()
			{
				returnFunction.call(this, -1);
				request.abort();
			};
			request.onprogress = function()
			{
				returnFunction.call(this, _timer.duration());
				request.abort();
			};
			request.onerror = function()
			{
				returnFunction.call(this, _timer.duration());
				request.abort();
			};
			request.open("GET", url, true);
			request.send();
		}
		catch (ex)
		{
			ProxyCollector.doAjaxViaImage(returnFunction, url);
		}
	}
	else
	{
		request = new XMLHttpRequest();
		var supportsOnTimeout = 'ontimeout' in request;

		_timer = new Timer();
		try
		{
			request.onreadystatechange = function()
			{
				if (request.readyState == 4)
				{
					if (((typeof ProxyCollector.internalPingTime === 'undefined') && ((new RegExp('internalPingTime')).test(returnFunction))) || ((typeof ProxyCollector.externalPingTime === 'undefined') && ((new RegExp('externalPingTime')).test(returnFunction))))
						returnFunction.call(this, _timer.duration());
				}
			};

			request.timeout = ProxyCollector.PROXY_DETECTION_TIMEOUT;
			request.ontimeout = function()
			{
				returnFunction.call(this, -1);
				request.abort();
			};

			request.open('GET', url, true);
			request.send();

			if (!supportsOnTimeout)
				ProxyCollector.isTimedOut(returnFunction, ProxyCollector.PROXY_DETECTION_TIMEOUT - _timer.duration(), request);
		}
		catch (ex)
		{
			ProxyCollector.doAjaxViaImage(returnFunction, url);
		}
	}
}


ProxyCollector.doAjaxViaImage = function(functionToReturn, imageURL)
{
	var img = new Image();
	var _timer = new Timer();

	img.onerror = function()
	{
		functionToReturn.call(this, _timer.duration());
	};
	img.src = imageURL;
};

ProxyCollector.collect = function()
{
	ProxyCollector.doAjax(ProxyCollector.externalIP, ProxyCollector.setExternalPingTime);

	if (typeof XDomainRequest == "object")
	{
		if (!ProxyCollector.externalPingTime)
		{
			forceIE89Synchronicity();
		}
	}
	else
	{
		ProxyCollector.doAjax(ProxyCollector.internalIP, ProxyCollector.setInternalPingTime);
	}
};

forceIE89Synchronicity = function()
{
	if (!ProxyCollector.externalPingTime)
	{
		setTimeout(forceIE89Synchronicity, 100);
	}
	else
		ProxyCollector.doAjax(ProxyCollector.internalIP, ProxyCollector.setInternalPingTime);
}

ProxyCollector.isValidIPAddress = function (ipaddr) {

	var re = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;

	if (re.test(ipaddr)) {
		var parts = ipaddr.split(".");

		if (parseInt(parseFloat(parts[0])) == 0) {
			return false;
		}

		for (var i=0; i<parts.length; i++) {
			if (parseInt(parseFloat(parts[i])) > 255) {
				return false;
			}
		}

		return true;

	} else {
		return false;
	}
}

ProxyCollector.initProxyCollection = function (){
	if(ProxyCollector.isValidIPAddress(ProxyCollector.externalIP) &&
		ProxyCollector.isValidIPAddress(ProxyCollector.internalIP) ){

		ProxyCollector.collect();
	}
}
function BlackberryLocationCollector() {

	var thisObj = this;
	
	var geolocationWatchId = null;
	
	this.getGeolocationWatchId = function() {
		return geolocationWatchId;
	};

	var geolocationLastPosition = null;

	this.getGeolocationLastPosition = function() {
		return geolocationLastPosition;
	};
	
	var geolocationStatusCode = 4;

	this.getGeolocationStatusCode = function() {
		return geolocationStatusCode;
	};
	
	var geolocationErrorMessage = "";

	this.getGeolocationErrorMessage = function() {
		return geolocationErrorMessage;
	};
	

	var GeolocationConfig = {
		aidMode: 2,
		timeout: 180,
		relevancy: 120,
		expiration: 48,
		alertDebug: false
	};

	var blackberryTimeout_id = -1;	
	
	var invokeCount = 0;
	
	this.getInvokeCount = function() {
		return invokeCount;
	};
	

	this.handleBlackBerryLocationTimeout = function()
	{
		if(blackberryTimeout_id != -1)
		{
			thisObj.stopWatch();
			geolocationStatusCode = 3;
			if (invokeCount===0 && GeolocationConfig.aidMode!==0) {
				invokeCount++;
				thisObj.startLocationWatch();
			}
		}
	};

	this.handlePosition = function()
	{
		clearTimeout(blackberryTimeout_id);
		blackberryTimeout_id=-1;
		var relevantPosition = false;
		if(blackberry.location.latitude===0 && blackberry.location.longitude===0)
		{
			if (GeolocationConfig.alertDebug) {
				alert("Got empty position");
			}
			if (geolocationLastPosition===null) {
				geolocationStatusCode = 2;
			}
		}
		else
		{
			var timestamp=null;
			if (blackberry.location.timestamp)
			{
				timestamp = getTimestampInMillis(blackberry.location.timestamp);
			} else
			{
				timestamp = new Date().getTime();
			}
			
			
			var currentTime = new Date().getTime();
			if ((currentTime - timestamp) <= (GeolocationConfig.expiration*60*60*1000)) {
				if (geolocationLastPosition === null ||
						timestamp > geolocationLastPosition.timestamp) {
					var oldTimestamp = geolocationLastPosition === null ? 0 : geolocationLastPosition.timestamp; 
					if (GeolocationConfig.alertDebug) {
						alert("Saved new position. New timestamp: "+timestamp+" Old: "+oldTimestamp);
					}
					geolocationLastPosition = {timestamp:timestamp, coords: {latitude:blackberry.location.latitude,longitude:blackberry.location.longitude}};
					geolocationStatusCode = 0;
				}
				else if (GeolocationConfig.alertDebug) {
					alert("New position is not saved. New timestamp: "+timestamp+" Old: "+geolocationLastPosition.timestamp);
				}
			}
			else if (GeolocationConfig.alertDebug) {
				alert("New position is not saved. It is expired: "+((currentTime - timestamp)*1000*60*60)+ " hours old");
			}
		}
		
		if (geolocationLastPosition!==null) {
			var currentTime = new Date().getTime();
			relevantPosition = (currentTime - geolocationLastPosition.timestamp) < (GeolocationConfig.relevancy*1000);
		}
		
		thisObj.stopWatch();
		if (GeolocationConfig.alertDebug) {
			alert("Relevant position? "+relevantPosition);
		}
		if ((invokeCount===0 && GeolocationConfig.aidMode!==0) || !relevantPosition)
		{
			invokeCount++;
			thisObj.startLocationWatch();
		}
	};
	
	this.init = function(aidMode, timeout, relevancy, expiration)
	{

		if (aidMode >= 0 && aidMode <= 2) {
			GeolocationConfig.aidMode = aidMode;
		}

		if (timeout!==null && timeout >=90 && timeout<=300) {
			GeolocationConfig.timeout = timeout;
		}

		if (relevancy!==null && relevancy >=60 && relevancy<=240) {
			GeolocationConfig.relevancy = relevancy;
		}

		if (expiration!==null && expiration >=24 && expiration<=60) {
			GeolocationConfig.expiration = expiration;
		}
	};


	this.startLocationWatch = function() {

		if (invokeCount===0) {
			blackberry.location.setAidMode(0);
		}
		else {
			blackberry.location.setAidMode(GeolocationConfig.aidMode);
		}


		var timeout = GeolocationConfig.timeout*1000;
		blackberryTimeout_id=setTimeout("geoLocator.handleBlackBerryLocationTimeout()", timeout);
		

		blackberry.location.onLocationUpdate(thisObj.handlePosition);
		blackberry.location.refreshLocation();

		geolocationWatchId = 1;
		return true;
	};
	
	this.stopWatch = function()
	{
		try {
			blackberry.location.removeLocationUpdate(thisObj.handlePosition);
		} catch(e) {
		}

		geolocationWatchId = -2;
	};
	

	this.generateGeolocationJSONStruct = function() {
		var positionToSend = null;
		if (geolocationLastPosition!==null) {
			var gmtTime = convertTimestampToGMT(geolocationLastPosition.timestamp);
			positionToSend = {
				GeoLocationInfo:[{
					Status:    	 geolocationStatusCode,
					Longitude:  geolocationLastPosition.coords.longitude,
					Latitude:     geolocationLastPosition.coords.latitude,
					Timestamp:       gmtTime
				}]
			};
		} 
		else {
			positionToSend = {
				GeoLocationInfo:[{
					Status:    geolocationStatusCode
				}]
			};
		} 
		return JSON.stringify(positionToSend);
	};
	
}
	function detectFields()
	{						
		var formPrefix = "form";
		var inputPrefix = "input";
		var formsInPage = document.getElementsByTagName('form');
		var numOfForms = formsInPage.length;
		var inputsInForm;
		var numOfInputs;
		var formsInputsData = [];
		formsInputsData.push("url=" + window.location.href);
		for ( var i = 0; i < numOfForms; i++ )
		{
			formsInputsData.push(formPrefix + "=" + formsInPage[i].name);		
			inputsInForm = formsInPage[i].getElementsByTagName('input');
			numOfInputs = inputsInForm.length;
			for ( var j = 0; j < numOfInputs;j++)
			{
				if( inputsInForm[j].type != "hidden")
				{
					formsInputsData.push(inputPrefix + "=" + inputsInForm[j].name);
				}			
			}	
		}			
		var finalFormsData = formsInputsData.join("|");		
		return finalFormsData;		
	}
	
	
	var SEP = '|';
	var PAIR = '=';
	var DEV = '~';	
	
	function FingerPrint() {
	
		var ht = new Hashtable();
		ht.put('npnul32','def'); 		// Default netscape plugin
		ht.put('npqtplugin6','qt6'); 	// Quicktime 6.5.1
		ht.put('npqtplugin5','qt5'); 	// Quicktime 6.5.1
		ht.put('npqtplugin4','qt4'); 	// Quicktime 6.5.1
		ht.put('npqtplugin3','qt3'); 	// Quicktime 6.5.1
		ht.put('npqtplugin2','qt2'); 	// Quicktime 6.5.1
		ht.put('npqtplugin','qt1');  	// Quicktime 6.5.1
		ht.put('nppdf32','pdf'); 		// Adobe Acrobat
		ht.put('NPSWF32','swf'); 		// Macromedia Flash
		ht.put('NPJava11','j11');    	// Java 1.4.2_02
		ht.put('NPJava12','j12');    	// Java 1.4.2_02
		ht.put('NPJava13','j13');    	// Java 1.4.2_02
		ht.put('NPJava32','j32');    	// Java 1.4.2_02
		ht.put('NPJava14','j14');    	// Java 2 5.0 Update 4
		ht.put('npoji600','j61');    	// Java 2 5.0 Update 4
		ht.put('NPJava131_16','j16');   // Java 1.3.1_16
		ht.put('NPOFFICE','mso');    	// Microsoft Office 2003
		ht.put('npdsplay','wpm');		// Windows Media Player
		ht.put('npwmsdrm','drm');    	// Windows DRM
		ht.put('npdrmv2','drn');    	// Netscape DRM
		ht.put('nprjplug','rjl');    	// Real Jukebox
		ht.put('nppl3260','rpl');    	// Real Player Live Connect
		ht.put('nprpjplug','rpv');    	// Real Player Version
		ht.put('npchime','chm');		// Chime
		ht.put('npCortona','cor');    	// Cortina
		ht.put('np32dsw','dsw');    	// Macromedia Director
		ht.put('np32asw','asw');		// Macromedia Authorware
	
		
		this.deviceprint_browser = function () {			
			var ua = navigator.userAgent.toLowerCase();
			var t = ua + SEP + navigator.appVersion + SEP + navigator.platform;
			return t;
		};
	

		this.deviceprint_software = function () {		
			var t = "";
			var isFirst = true;
			var temp = "";
			var key = "";
			var plugins = navigator.plugins;
			var mimeTypes = navigator.mimeTypes;
			if (plugins.length > 0)
			{					
				var fileName = "";
				var lastDir = "Plugins";
				var plugin_count = plugins.length;			
				for (i = 0; i < plugin_count; i++)
				{							
					plugin = plugins[i];
					fileName = stripFullPath(plugin.filename, lastDir,".");										
					if (isFirst===true)
					{						
						key = ht.containsKey(fileName);
						if(key)
						{
							temp += ht.get(fileName);
							isFirst=false;
						}
						else
						{
							temp = "";
							isFirst=false;
						}
					}
					else
					{
						key = ht.containsKey(fileName);
						if(key)
						{
							temp += SEP + ht.get(fileName);
						}
						else
						{
							temp += "";
						}
					}
				}				
				t = stripIllegalChars(temp);
		
			}
			else if (mimeTypes.length > 0)
			{
				key = "";
				for (i = 0; i < mimeTypes.length; i++)
				{
					mimeType = mimeTypes[i];
					if (isFirst===true)
					{
						key = ht.containsKey(mimeType);
						if(key)
						{
							t += ht.get(mimeType) + PAIR + mimeType;
							isFirst=false;
						}
						else
						{
							t += "unknown" + PAIR + mimeType;
							isFirst=false;
						}
					}
					else
					{
						key = ht.containsKey(mimeType);
						if(key)
						{
							t += SEP + ht.get(mimeType) + PAIR + mimeType;
						}
						else
						{
							temp += "";
						}
					}
				}
			}						
			return t;
		};
				

		this.deviceprint_display = function () {
			var t = "";
			if (self.screen) {
				t += screen.colorDepth + SEP + screen.width + SEP + screen.height + SEP + screen.availHeight;
			}
			return t;
		};

		this.deviceprint_all_software = function () {
			var t = "";
			var isFirst = true;
			var plugins = navigator.plugins;
			var plugin_count = plugins.length;
			if (plugin_count > 0) {
				var temp = "";
				var fileName = "";
				var key = "";
				for (i = 0; i < plugin_count; i++) {
					var plugin = plugins[i];
					fileName = plugin.filename;
					fileName = stripFullPath(fileName,"Plugins",".");									
					if (isFirst === true) {						
						temp += fileName;
						isFirst = false;						
					} else {						
						temp += SEP + fileName;						
					}
				}
				t = stripIllegalChars(temp);	
			}
			return t;
		};
				

		this.deviceprint_timezone = function () {
			var gmtHours = (new Date().getTimezoneOffset() / 60) * (-1);
			

			var today = new Date();
			if (today.deviceprint_dst()){
				 gmtHours--;
			}
			else {
			}			
			return gmtHours;
		};

		Date.prototype.deviceprint_stdTimezoneOffset = function () {
			var jan = new Date(this.getFullYear(), 0, 1);	
			var jul = new Date(this.getFullYear(), 6, 1);
			
			return Math.max(jan.getTimezoneOffset(), jul.getTimezoneOffset());
		};
		Date.prototype.deviceprint_dst = function () {
			return this.getTimezoneOffset() < this.deviceprint_stdTimezoneOffset();
		};
		
		this.deviceprint_language = function () {
			var lang;
			var language = navigator.language;
			var browserLanguage = navigator.browserLanguage;
			var systemLanguage = navigator.systemLanguage;
			var userLanguage = navigator.userLanguage;
			if (typeof (language) !== "undefined") {
				lang = "lang" + PAIR + language + "^~^";
			} else if (typeof (browserLanguage) !== "undefined") {
				lang = "lang" + PAIR + browserLanguage + "^~^";
			} else {
				lang = "lang" + PAIR + "" + "^~^";
			}
	
			if ((typeof (systemLanguage) !== "undefined"))
			{
				lang += "syslang" + PAIR + systemLanguage + "^~^";
			} else {
				lang += "syslang" + PAIR + "" + "^~^";
			}
			if ((typeof (userLanguage) !== "undefined"))
			{
				lang += "userlang" + PAIR + userLanguage;
			} else
			{
				lang += "userlang" + PAIR + "";
			}
			return lang;
		};
	

		this.deviceprint_java = function() {
			var javaEnabled = (navigator.javaEnabled()) ? true : false;
			return javaEnabled;
		};
	

		this.deviceprint_cookie = function () {
	
			var cookieEnabled = (navigator.cookieEnabled) ? true : false;

			if (typeof navigator.cookieEnabled == "undefined" && !cookieEnabled) {
				document.cookie = "testcookie";
				cookieEnabled = (document.cookie.indexOf("testcookie") !== -1) ? true : false;
			}
			return cookieEnabled;
		};
	

		this.deviceprint_appName = function() {	
			var appName = navigator.appName;
			return (typeof(appName) != "undefined" ) ? appName : "";
		};	
		

		this.deviceprint_appCodeName = function () {
			var appCodeName = navigator.appCodeName;		
			return (typeof(appCodeName) != "undefined" ) ? appCodeName : ""; 					
		};	
		

		this.deviceprint_online = function () {		
			var onLine = navigator.onLine;
			return (typeof(onLine) != "undefined" ) ? onLine : "";
		};
		

		this.deviceprint_opsProfile = function () {	
			var opsProfile = navigator.opsProfile;				
			return ((typeof(opsProfile) != "undefined") && (opsProfile !== null) ) ? opsProfile : "";
		};
		

		this.deviceprint_userProfile = function () {
			var userProfile = navigator.userProfile;			
			return ((typeof(userProfile) != "undefined") && (userProfile !== null) ) ? userProfile : "";
		};
				
		this.deviceprint_screen_availWidth = function () {	
			var availWidth = screen.availWidth;	
			return (typeof(availWidth ) != "undefined") ? availWidth  : "";
		};
		
		this.deviceprint_screen_pixelDepth = function () {
			var pixelDepth = screen.pixelDepth;		
			return (typeof(pixelDepth ) != "undefined") ? pixelDepth  : "";
		};
		
		this.deviceprint_screen_bufferDepth = function () {	
			var bufferDepth = screen.bufferDepth;		
			return (typeof(bufferDepth ) != "undefined") ? bufferDepth  : "";
		};
		
		this.deviceprint_screen_deviceXDPI = function () {	
			var deviceXDPI = screen.deviceXDPI;		
			return (typeof(deviceXDPI ) != "undefined") ? deviceXDPI  : "";
		};
		
		this.deviceprint_screen_deviceYDPI = function () {		
			var deviceYDPI = screen.deviceYDPI;		
			return (typeof(deviceYDPI ) != "undefined") ? deviceYDPI  : "";
		};
		
		this.deviceprint_screen_logicalXDPI = function () {	
			var logicalXDPI = screen.logicalXDPI;		
			return (typeof(logicalXDPI ) != "undefined") ? logicalXDPI  : "";
		};
		
		this.deviceprint_screen_logicalYDPI = function () {		
			var logicalYDPI = screen.logicalYDPI;	
			return (typeof(logicalYDPI ) != "undefined") ? logicalYDPI  : "";
		};				
		

		this.deviceprint_screen_fontSmoothingEnabled = function () {
			var fontSmoothingEnabled = screen.fontSmoothingEnabled;			
			return (typeof(fontSmoothingEnabled ) != "undefined") ? fontSmoothingEnabled  : "";
		}; 			   												    
		
		this.deviceprint_screen_updateInterval = function () {	
			var updateInterval = screen.updateInterval;		
			return (typeof(updateInterval ) != "undefined") ? updateInterval  : "";
		};		
		
		
		this.deviceprint_ping_in = function () {
			
			if(ProxyCollector && ProxyCollector.internalPingTime){
				return ProxyCollector.internalPingTime;
			}
			else{
				return "";
			}
		};
	

		this.deviceprint_ping_ex = function () {
			
			if(ProxyCollector && ProxyCollector.externalPingTime){
				return ProxyCollector.externalPingTime;
			}
			else{
				return "";
			}
		};
				
	}
	function urlEncode(text) {
		var encodedString = encodeURIComponent(text).replace(/\~/g, "%7E").replace(/\!/g, "%21")
		.replace(/\*/g, "%2A").replace(/\(/g, "%28").replace(/\)/g, "%29").replace(/\'/g, "%27")
		.replace(/\-/g, "%2D").replace(/\_/g, "%5F").replace(/\./g, "%2E");

		return encodedString;
	}
	
	
	function encode_deviceprint() {
		var t = add_deviceprint();		
		return urlEncode(t);
	}
	
	function decode_deviceprint() {
		var t = encode_deviceprint;
		return decodeURIComponent(urlEncode(t));
	}
	

	function post_deviceprint() {	
		document.forms[0].pm_fp.value = encode_deviceprint();
		return true;
	}
	
	function post_fingerprints( form ) {				
		form.deviceprint.value = encode_deviceprint();
	}

	function add_deviceprint() {

		var fp = new FingerPrint();				
						
		var t = "pm_fpua=" + fp.deviceprint_browser() + "^~^pm_fpsc=" + fp.deviceprint_display() + "^~^pm_fpsw=" + fp.deviceprint_software() +
				"^~^pm_fptz=" + fp.deviceprint_timezone() + "^~^"+ fp.deviceprint_language() + "^~^pm_fpjv=" + fp.deviceprint_java() +
				"^~^pm_fpco=" + fp.deviceprint_cookie();
		
		t = t + "^~^pm_fpasw=" + fp.deviceprint_all_software();
		
		t = t + "^~^pm_fpan=" + fp.deviceprint_appName() + "^~^pm_fpacn=" + fp.deviceprint_appCodeName() + "^~^pm_fpol=" + fp.deviceprint_online() +
			"^~^pm_fposp=" + fp.deviceprint_opsProfile() + "^~^pm_fpup=" + fp.deviceprint_userProfile() + "^~^pm_fpsaw=" + fp.deviceprint_screen_availWidth() +
			"^~^pm_fpspd=" + fp.deviceprint_screen_pixelDepth() + "^~^pm_fpsbd=" + fp.deviceprint_screen_bufferDepth() +
			"^~^pm_fpsdx=" + fp.deviceprint_screen_deviceXDPI() + "^~^pm_fpsdy=" + fp.deviceprint_screen_deviceYDPI() +			
			"^~^pm_fpslx=" + fp.deviceprint_screen_logicalXDPI() + "^~^pm_fpsly=" + fp.deviceprint_screen_logicalYDPI() +
			"^~^pm_fpsfse=" + fp.deviceprint_screen_fontSmoothingEnabled() + "^~^pm_fpsui=" + fp.deviceprint_screen_updateInterval();

		return t;
	}
	
	function form_add_data(fd, name, value) {
		if (fd && fd.length > 0) {
			fd += "&";
		} else {
			fd = "";
		}

		fd += name + '=' + escape(value.toString());
		return fd;
	}

	function form_add_deviceprint(fd, name, value) {
		fd = form_add_data(fd, name + "d", value);
		return fd;
	}

var HTML5 = 'HTML5';
var BLACKBERRY = 'blackberry';
var UNDEFINED="undefined";
var GEO_LOCATION_DEFAULT_STRUCT='{"GeoLocationInfo":[{"Status":4}]}';

var geoLocator = null;
var geoLocatorStatus = false;


function detectDeviceCollectionAPIMode()
{
	if (typeof(navigator.geolocation)!=UNDEFINED)
	{
		return HTML5;
	} else if (typeof(window.blackberry)!=UNDEFINED && blackberry.location.GPSSupported)
	{
		return BLACKBERRY;
	} else
	{
		return UNDEFINED;
	}
}


function init(accuracy, timeout, relevancy, expiration, aidMode)
{
	var type = detectDeviceCollectionAPIMode();
	
	if (type == HTML5)
	{
		geoLocator = new HTML5LocationCollector();
		geoLocator.init(accuracy, timeout, relevancy, expiration);
		return true;
	} else if (type == BLACKBERRY)
	{
		geoLocator = new BlackberryLocationCollector();
		geoLocator.init(aidMode, timeout, relevancy, expiration);
		return true;
	} 
	return false;
}


function startCollection(accuracy, timeout, relevancy, expiration, aidMode)
{
	geoLocatorStatus=init(accuracy, timeout, relevancy, expiration, aidMode);
	if (geoLocatorStatus){
		return geoLocator.startLocationWatch();		
	}else{
		return false;
	}
}


function stopCollection()
{
	if (geoLocatorStatus) {
		geoLocator.stopWatch();
	}
}


function getGeolocationStruct() {
	if (geoLocatorStatus) {
		return geoLocator.generateGeolocationJSONStruct();
	}
	else {
		return GEO_LOCATION_DEFAULT_STRUCT;
	}
}function HTML5LocationCollector() {		
	
	var thisObj = this;
	

	var geolocationWatchId = -1;
	
	this.getGeolocationWatchId = function() {
		return geolocationWatchId;
	};
	

	var geolocationLastPosition = null;

	this.getGeolocationLastPosition = function() {
		return geolocationLastPosition;
	};
	

	var geolocationStatusCode = 4;

	this.getGeolocationStatusCode = function() {
		return geolocationStatusCode;
	};
	

	var geolocationErrorMessage = "";
	
	this.getGeolocationErrorMessage = function() {
		return geolocationErrorMessage;
	};
	

	var GeolocationConfig = {
		accuracy: 100,
		timeout: 180,
		relevancy: 120,
		expiration: 48 
	};

	this.getGeolocationConfig = function() {
		return GeolocationConfig;
	};
	
	
	this.startLocationWatch = function() {
		var PositionOptions = {
			enableHighAccuracy: true,
			timeout: (GeolocationConfig.timeout*1000),
			maximumAge: GeolocationConfig.expiration
		};
		if (navigator.geolocation) {
			geolocationWatchId = navigator.geolocation.watchPosition(this.handlePosition,this.handleError,PositionOptions);
			return true;
		}
		else {
			geolocationStatusCode = 4;
		}
		return false;
	};


	this.init = function(accuracy, timeout, relevancy, expiration) {

		if (accuracy!==null && accuracy >=0 && accuracy<=200) {
			GeolocationConfig.accuracy = accuracy;
		}

		if (timeout!==null && timeout >=90 && timeout<=300) {
			GeolocationConfig.timeout = timeout;
		}

		if (relevancy!==null && relevancy >=60 && relevancy<=240) {
			GeolocationConfig.relevancy = relevancy;
		}

		if (expiration!==null && expiration >=24 && expiration<=60) {
			GeolocationConfig.expiration = expiration;
		}
	};


	this.handlePosition = function(position) {		
		var currentTime = new Date().getTime();
		var positionTimestamp = getTimestampInMillis(position.timestamp);

		if ((currentTime - positionTimestamp) <= (GeolocationConfig.expiration*60*60*1000)) {

			if (geolocationLastPosition === null || position.timestamp > geolocationLastPosition.timestamp || position.coords.accuracy < geolocationLastPosition.coords.accuracy) {
				geolocationLastPosition = position;
				geolocationStatusCode = 0;
			}
		}
		

		if (geolocationLastPosition!==null) {
			var timeDiff = currentTime-geolocationLastPosition.timestamp;
			if (timeDiff <= (GeolocationConfig.relevancy*1000) && geolocationLastPosition.coords.accuracy <= GeolocationConfig.accuracy ) {				
				thisObj.stopWatch();
			}
		}
	};


	this.generateGeolocationJSONStruct = function() {
		var positionToSend = null;
		if (geolocationLastPosition!==null) {
			var gmtTime = convertTimestampToGMT(geolocationLastPosition.timestamp);
			positionToSend = {
				GeoLocationInfo:[{
					Status:    	 geolocationStatusCode,
					Longitude:    geolocationLastPosition.coords.longitude,
					Latitude:     geolocationLastPosition.coords.latitude,
					Altitude:     Math.round(geolocationLastPosition.coords.altitude),
					HorizontalAccuracy:    Math.round(geolocationLastPosition.coords.accuracy),
					AltitudeAccuracy:    Math.round(geolocationLastPosition.coords.altitudeAccuracy),
					Heading:    Math.round(geolocationLastPosition.coords.heading),
					Speed:   Math.round(geolocationLastPosition.coords.speed),
					Timestamp:       gmtTime
				}]
			};
		} 
		else {
			positionToSend = {
				GeoLocationInfo:[{
					Status:    geolocationStatusCode
				}]
			};
		} 
		return JSON.stringify(positionToSend);
	};



	this.handleError = function(error) {
		switch(error.code) {
			case error.TIMEOUT:
				thisObj.stopWatch();
				geolocationStatusCode = 3;
				break;
			case error.POSITION_UNAVAILABLE:
				geolocationStatusCode = 2;
				geolocationErrorMessage = error.message;
				break;
			case error.PERMISSION_DENIED:
				geolocationStatusCode = 1;
				break;
			case error.UNKNOWN_ERROR:
				geolocationStatusCode = 2;
				geolocationErrorMessage = error.message;
				break;
		}		
	};
	
	this.stopWatch = function()	{
		navigator.geolocation.clearWatch(geolocationWatchId);
		geolocationWatchId = -2;
	};
		
}var UIEventCollector = (function() {

	var data = null;
	var start_time = null;
	var truncated = null;
	var config = null;
	var private_configs = ['output_size_limit'];

	_initEventCollection();
	recordEvents();

	function _initEventCollection(_config) {

		config = {
			output_size_limit : 1024,
			collection_mode : 'partial'
		};


		if(_config) {
			for(p in _config) {
					if(!(p._config === undefined)) {
						var in_private = false;
						for(var i = private_configs.length - 1; i >= 0; i--) {
							if(private_configs[i] == p) {
								found = true;
								continue;
							}
						}
						if(!in_private) {
							config[p] = _config[p];
						}
					}
			}

		}
		truncated = false;
		start_time = calcEventStartTime();
		data = {
			elements : new UIElementList(),
			events : [],
			collection_status : 0,
			toString : function() {
				return 'RecordedData: {elements: ' + this.elements + ', events: ' + this.events + '}';
			}
		};


		recordEvents();
	}


	function addInputElements() {
		var inputs = getDocumentInputElements();
		for(var i = 0, j = inputs.length; i < j; i++) {
			_addElement(inputs[i]);
		}
	}

	function getDocumentInputElements() {
		var inputElements = [];
		var inputs = document.getElementsByTagName("input");
		for(var i = 0, j = inputs.length; i < j; i++) {
			var input = inputs[i];
			if(shouldBeRecorded(input)) {
				inputElements.push(input);
			}
		}
		return inputElements;
	}

	function shouldBeRecorded(element) {
		if(element.tagName && element.tagName.toLowerCase() == "input") {
			var type = element.getAttribute("type");
			if(type == "text" || type == "checkbox" || type == "checkbox") {
				return true;
			}
		}
		return false;
	}

	function calcEventStartTime() {
		var dummy_event = (document.createEvent) ? document.createEvent("Event") : document.createEventObject();
		var start_time = dummy_event.timeStamp || new Date();
		start_time = new Date(start_time);
		if(start_time.getYear() > 2100) {
			start_time = new Date(start_time / 1000);
		}
		start_time = start_time.getTime();

		return start_time;
	}


	function _addElement(domElement) {		
		var ie = null;
		var elements = data.elements;
		var element_count = elements.size();
		var element_id = _getElementId(domElement);
		if(!data.elements.containsKey(element_id)) {
			ie = new InteractionElement();

			ie.id(element_id);
			ie.type(_getElementType(domElement));
			ie.length(domElement.value ? domElement.value.length : 0);
			elements.put(ie);
		} else {
			ie = elements.get(element_id);
		}
		return ie;
	}

	function recordEvent(event) {
		var ___event = event || window.event;
		var domElement = eventTarget(___event);						
		if(shouldBeRecorded(domElement))
		{	
			var target = _addElement(domElement);		
			target.incrementEventCount();
			var uiEvent = new UIEvent();
			
			uiEvent.index(target.index());
			
			uiEvent.type(_getEventType(___event));

			
			var ts = calcEventTimestamp(___event);
			
			uiEvent.offset(ts - start_time);
			
			data.events.push(uiEvent);
			
		}
		return true;
	};

	function recordKeyDownEvent(event) {
		var ___event = event || window.event;
		if(isPasteEvent(___event)) {
			var synthetic_paste_event = {
				target : eventTarget(___event),
				type : 'paste'
			};
			return recordEvent(synthetic_paste_event);
		} else {
			return recordEvent(___event);
		}
	}


	function isPasteEvent(evt) {
		if(evt.type == 'keydown') {
			var key = evt.which || evt.charCode || evt.keyCode;
			var v_pressed = ( typeof KeyboardEvent != 'undefined' && key == KeyboardEvent.DOM_VK_V) || key == 118 || key == 86;
			if(v_pressed && (evt.ctrlKey || evt.metaKey)) {
				return true;
			}
		}
		return false;
	}


	function eventTarget(evt) {
		return evt.target ? evt.target : evt.srcElement;
	}


	function calcEventTimestamp(evt) {
		var ts;
		if(evt.timeStamp && evt.timeStamp !== 0) {
			ts = evt.timeStamp;
			if(new Date(ts).getYear() > 2100) {
				ts = ts / 1000;
			}
		} else {
			ts = new Date().getTime();
		}

		return ts;
	}


	function debug(msg) {
//		if( msg instanceof Date) {
//			msg = msg.toDateString();
//		}
//		if( typeof msg == 'object') {
//			msg = JSON.stringify(msg);
//		}
//		if(("undefined" != typeof console) && console.log) {
//			console.log(msg);
//		}
	}

	function updateInputElementSizes() {
		addInputElements();
		var elements = data.elements;
		for(var i = elements.size(); i >= 1; i--) {
			var el = elements.getByIndex(i);
			var elemend_id = el.id();
			var htmlElement = document.getElementById(elemend_id);
			if(!htmlElement) {
				var matchingNameElements = document.getElementsByName(elemend_id);
				if(matchingNameElements.length > 0) {
					htmlElement = matchingNameElements[0];
				}
			}
			if(htmlElement && htmlElement.value) {
				el.length(htmlElement.value.length);
			}
		}
	};

	function domNodeInserted(event) {
		var _event = event || window.event;
		var new_node = event.target;

		if(new_node.nodeType == 1) {
			var child_forms = new_node.getElementsByTagName('form');
			for(var i = child_forms.length - 1; i >= 0; i--) {
				var new_form = child_forms[i];
				new_form.onsubmit = recordFormSubmitEvent;
			};
		}
	}

	function recordEvents() {

		var _recordEvent = recordEvent;

		var listenOn = document;

		if(listenOn.addEventListener) {
			listenOn.addEventListener('keydown', recordKeyDownEvent, false);
			listenOn.addEventListener('paste', _recordEvent, false);
			listenOn.addEventListener('focus', _recordEvent, true);
			listenOn.addEventListener('blur', _recordEvent, true);
		} else {
			if(listenOn.attachEvent) {
				listenOn.onkeydown = recordKeyDownEvent;
				listenOn.onfocusin = _recordEvent;
				listenOn.onfocusout = _recordEvent;
			}
		}
	}

	function getPrivateConfig() {
		return private_config;
	};

	function _getEventType(e) {

		if(e.type == "keydown") {
			return UIEvent.KeyDown;
		} else if(e.type == "submit") {
			return UIEvent.Submit;
		} else if(e.type == "paste") {
			return UIEvent.Paste;
		} else if(e.type == "focus" || e.type == "focusin") {
			return UIEvent.Focus;
		} else if(e.type == "blur" || e.type == "focusout") {
			return UIEvent.Blur;
		} else {
			return UIEvent.Unknown;
		}

	}

	function _getEventCode(code) {

		if(code == UIEvent.KeyDown) {
			return "keydown";
		} else if(code == UIEvent.Submit) {
			return "submit";
		} else if(code == UIEvent.Focus) {
			return "focus";
		} else if(code == UIEvent.Blur) {
			return "blur";
		} else if(code == UIEvent.Paste) {
			return "paste";
		} else {
			return "unknown";
		}

	}

	function _getElementType(domElement) {
		return domElement.nodeName + (domElement.type ? (':' + domElement.type) : '');
	}

	function _getElementId(domElement) {
		return domElement.id ? domElement.id : (domElement.name ? domElement.name : domElement.nodeName);
	}

	return {
		addElement : function(domElement) {
			return _addElement(domElement);
		},

		getEventType : function(e) {
			return _getEventType(e);
		},
		getEventCode : function(code) {
			return _getEventCode(code);
		},
		getRecordedData : function() {
			return data;
		},
		getElementType : function(domElement) {
			return _getElementType(domElement);
		},
		getElementId : function(domElement) {
			return _getElementId(domElement);
		},
		initEventCollection : function(_config) {
			_initEventCollection(_config);
		},
		getConfig : function() {
			return config;
		},
		serialize : function() {
			updateInputElementSizes();
			var collectedData = this.getRecordedData();
			var elements = collectedData.elements;
			var collectedElementsIndicator = [];
			for(var i=0;i<elements.length;i++){
				collectedElementsIndicator[i]=false;
			}
			var events = collectedData.events;
			var collection_status = collectedData.collection_status;
			var partial_collection = this.getConfig().collection_mode == 'partial';
			var output_size_limit = this.getConfig().output_size_limit;

			
			var eventCount = events.length;

			var listSeparator = '@';
			var elementSeparator = ';';
			var itemSeparator = ',';

			
			var collected_data_length = 2*listSeparator.length;

			
			var collectionSummary = (""+start_time) + itemSeparator + (""+collection_status);
			var truncatedIndicatorLength = 1;
			collected_data_length += truncatedIndicatorLength;
			collected_data_length += itemSeparator.length;
			collected_data_length += collectionSummary.length;
			
			
			var elementsStr = "";
			debug('serializing elements ');
			for (var elementCount = elements.size(); elementCount>0; elementCount--) {
				var cur_element=elements.getByIndex(elementCount);
				var cur_element_with_sep = cur_element.serialize() + elementSeparator;

			
				debug('elementsStr.length: ' + elementsStr.length)				
				if(partial_collection 
					&& ((collected_data_length + elementsStr.length + cur_element_with_sep.length) > output_size_limit)) {
					truncated = true;
					break;
				}
				
			
				var isCheckbox = cur_element.type().match("INPUT:checkbox");
				
			
				if(isCheckbox == null)
				{
					if ( cur_element.length() > 0 && cur_element.eventCount() == 0) {
						debug('collecting element without input: ' +cur_element );
						elementsStr = cur_element_with_sep + elementsStr;
					}
				}				
			}
			
			

			collected_data_length += elementsStr.length;
			var eventsStr = "";
			debug('serializing events ');
			
			while(eventCount--) {
				var cur_evt = events[eventCount];
				var cur_idx = cur_evt.index();
				var cur_event_with_sep = cur_evt.serialize() + elementSeparator;
				var cur_element_with_sep = elements.getByIndex(cur_idx).serialize() + elementSeparator;
				
				var cur_event_addition = cur_event_with_sep.length;
				if( !collectedElementsIndicator[cur_idx] ) {
					cur_event_addition+=cur_element_with_sep.length;
				}
				debug('eventsStr.length: ' + eventsStr.length)
				if(partial_collection 
					&& ((collected_data_length + eventsStr.length 
							+ cur_event_addition) > output_size_limit)) {
					truncated = true;
					break;
				}

				debug('collecting event: ' +cur_evt );
				
				if( !collectedElementsIndicator[cur_idx] ) {
					elementsStr = cur_element_with_sep + elementsStr;
					collected_data_length += cur_element_with_sep.length;
					debug('also adding element event: ' +cur_element_with_sep );
				}
				collectedElementsIndicator[cur_idx] = true;
				eventsStr = cur_event_with_sep + eventsStr;
			}
			
			
			if(elementsStr.length > 0) {
				elementsStr = elementsStr.substring(0, elementsStr.length - 1);
			}
			
			
			if(eventsStr.length > 0) {
				eventsStr = eventsStr.substring(0, eventsStr.length - 1);
			}

			
			var truncatedStr = truncated ? 1 : 0;

			
			var serialized = elementsStr + listSeparator + eventsStr + listSeparator + truncatedStr + itemSeparator + collectionSummary;
			return serialized;
		}
	};
})();
function UIEvent() {
	var self = (this === window) ? {} : this;
	self.index = function(type) {
		if(arguments.length === 0) {
			return self._index;
		} else {
			self._index = arguments[0];
		}
	};
	self.offset = function(offset) {
		if(arguments.length === 0) {
			return self._offset;
		} else {
			self._offset = arguments[0];
		}
	};
	self.type = function(type) {
		if(arguments.length === 0) {
			return self._type;
		} else {
			self._type = arguments[0];
		}
	};
	
	
	self.serialize = function() {
		var sep = ",";
		var offset = "0";
		return self.index() + sep + self.type() + sep + offset;
	};
	self.toString = function() {
		return 'UIEvent: [index: ' + self.index() + ', type: ' + self.type() + ', offset: ' + self.offset() + ']';
	};
}


UIEvent.Unknown = 0;
UIEvent.KeyDown = 1;
UIEvent.Submit = 2;
UIEvent.Focus = 3;
UIEvent.Blur = 4;
UIEvent.Paste = 5;

function InteractionElement() {
	var self = (this === window) ? {} : this;
	self._eventCount=0;
	
	self.id = function(id) {
		if(arguments.length === 0) {
			return self._id;
		} else {
			self._id = arguments[0];
		}
	};
	self.index = function(type) {
		if(arguments.length === 0) {
			return self._index;
		} else {
			self._index = arguments[0];
		}
	};
	self.length = function(length) {
		if(arguments.length === 0) {
			return self._length;
		} else {
			self._length = arguments[0];
		}
	};
	self.type = function(type) {
		if(arguments.length === 0) {
			return self._type;
		} else {
			self._type = arguments[0];
		}
	};

	self.incrementEventCount = function() {
		self._eventCount++;
	}
	
	self.eventCount = function() {
		return self._eventCount;
	}	
	
	
	self.serialize = function() {
		var separator = ",";
		var id = self.index(); 
		return self.index() + separator + id + separator + self.type() + separator + self.length();
	};
	
	self.toString = function() {
		return 'InteractionElement: [id: ' + self.id() + ', index: ' + self.index() + ', length: ' + self.length() + ', type: ' + self.type() + ']';
	};
};


function UIElementList() {
	var self = (this === window) ? {} : this;

	var _nameMap = new Hashtable();
	var _indexMap = new Hashtable();

	self.get = function(key) {
		return _nameMap.get(key);
	};
	self.getByIndex = function(index) {
		return _indexMap.get(index);
	};
	self.containsKey = function(key) {
		return _nameMap.containsKey(key);
	};
	self.indexByKey = function(key) {
		return get(key).index();
	};
	self.size = function() {
		return _nameMap.size();
	};
	self.put = function(value) {
		var key = value.id();
		if(!_nameMap.containsKey(key)) {
			_nameMap.put(key, value);
			var newIndex = _nameMap.size();
			
			value.index(newIndex);
			_indexMap.put(newIndex, value);
		}
	};
	self.toString = function() {
		return '[size: ' + _nameMap.size() + ', names: [' + _nameMap + '], indexes: [' + _indexMap + ']]';
	};
};
function activeXDetect(componentClassID) {
	var componentVersion = null;
	try {
		componentVersion = document.body.getComponentVersion('{' + componentClassID + '}', 'ComponentID');
	}
	catch(err) {
		
	}
	return (componentVersion !== null) ? componentVersion : false;
}

function stripIllegalChars(value) {
	t = "";
	
	value = value.toLowerCase();
	var value_length = value.length;
	for(var i = 0; i < value_length; i++) {
		var char_i = value.charAt(i);
		if(char_i != '\n' && char_i != '/' && char_i != "\\") {
			t += char_i;
		} else if(char_i == '\n') {
			t += "n";
		}
	}
	return t;
}

function stripFullPath(tempFileName, filePrefix, fileSuffix) {
	var prefix = filePrefix;
	var suffix = fileSuffix;
	var fileName = tempFileName;

	
	var prefixStart = fileName.lastIndexOf(prefix);
	if(prefixStart >= 0) {
		filenameLen = fileName.length;
		fileName = fileName.substring(prefixStart + prefix.length, filenameLen);
	}

	
	var suffixStart = fileName.indexOf(suffix);
	if(suffixStart >= 0) {
		fileName = fileName.slice(0, suffixStart);
	}

	return fileName;
}

// taken from http://www.quirksmode.org/js/detect.html
var BrowserDetect = {
	init : function() {
		this.browser = this.searchString(this.dataBrowser) || "an unknown browser";
		this.version = this.searchVersion(navigator.userAgent) || this.searchVersion(navigator.appVersion) || "an unknown version";
		this.OS = this.searchString(this.dataOS) || "an unknown OS";
	},
	searchString : function(data) {
		var data_length = data.length;
		for(var i = 0; i < data_length; i++) {
			var datum = data[i];
			var dataString = datum.string;
			var dataProp = datum.prop;
			var identity = datum.identity;
			this.versionSearchString = datum.versionSearch || identity;
			if(dataString) {
				if(dataString.toLowerCase().indexOf(datum.subString.toLowerCase()) !== -1) {
					return identity;
				}
			} else if(dataProp) {
				return identity;
			}
		}
	},
	searchVersion : function(dataString) {
		var index = dataString.toLowerCase().indexOf(this.versionSearchString.toLowerCase());
		if(index === -1) {
			return;
		}
		
		var suffixWithVersion = dataString.substring(index + this.versionSearchString.length);
		if(suffixWithVersion.indexOf(' ') === 0 || suffixWithVersion.indexOf('/') === 0) {
			suffixWithVersion = suffixWithVersion.substring(1);
		}
		return parseFloat(suffixWithVersion);
	},
	dataBrowser : [{
		string : navigator.userAgent,
		subString : "Chrome",
		identity : "Chrome"
	}, {
		string : navigator.userAgent,
		subString : "OmniWeb",
		versionSearch : "OmniWeb/",
		identity : "OmniWeb"
	}, {
		string : navigator.userAgent.toLowerCase(),
		subString : "opera",
		identity : "Opera",
		versionSearch : "version"
	}, {
		string : navigator.vendor,
		subString : "Apple",
		identity : "Safari",
		versionSearch : "Version"
	}, {
		string : navigator.userAgent,
		subString : "mobile safari",
		identity : "Mobile Safari",
		versionSearch : "mobile safari"
	}, {
		string : navigator.vendor,
		subString : "iCab",
		identity : "iCab"
	}, {
		string : navigator.vendor,
		subString : "KDE",
		identity : "Konqueror"
	}, {
		string : navigator.userAgent,
		subString : "Firefox",
		identity : "Firefox"
	}, {
		string : navigator.vendor,
		subString : "Camino",
		identity : "Camino"
	}, {
		string : navigator.userAgent.toLocaleLowerCase(),
		subString : "blackberry",
		identity : "BlackBerry",
		versionSearch : '0/'
	}, {
		string : navigator.userAgent,
		subString : "Netscape",
		identity : "Netscape"
	}, {
		string : navigator.userAgent,
		subString : "MSIE",
		identity : "Explorer",
		versionSearch : "MSIE"
	}, {
		string : navigator.userAgent,
		subString : "Gecko",
		identity : "Mozilla",
		versionSearch : "rv"
	}, {
		string : navigator.userAgent,
		subString : "Mozilla",
		identity : "Netscape",
		versionSearch : "Mozilla"
	}],
	dataOS : [{
		string : navigator.userAgent,
		subString : "BlackBerry",
		identity : "BlackBerry"
	},
	
	{
		string : navigator.userAgent.toLowerCase(),
		subString : "android",
		identity : "Android"
	}
	
	, {
		string : navigator.userAgent,
		subString : "Symbian",
		identity : "Symbian"
	}, {
		string : navigator.platform,
		subString : "Mac",
		identity : "Mac"
	}, {
		string : navigator.userAgent,
		subString : "iPhone",
		identity : "iPhone/iPod"
	}, {
		string : navigator.platform,
		subString : "Linux",
		identity : "Linux"
	},
	
	{
		string : navigator.userAgent,
		subString : "Windows CE",
		identity : "Windows CE"
	}, {
		string : navigator.platform,
		subString : "Win",
		identity : "Windows"
	}]
};

function convertTimestampToGMT(timestamp) {
	var date = timestamp;
	if(!( timestamp instanceof Date)) {

		date = new Date(timestamp);
	}
	offsetFromGmt = date.getTimezoneOffset() * 60000;
	return date.getTime() + offsetFromGmt;
}


function getTimestampInMillis(timestamp) {
	var res = timestamp;
	if( timestamp instanceof Date) {
		res = timestamp.getTime();
	}
	return res;
}

function debug(msg) {}
