
// backward compatibility
console = console || { log: function () { } };



// Dom ready
$(function () {

    window.ACCEPTED_CARD = window.ACCEPTED_CARD || {};
    //For 3ds
    load3DSValues();

    var BANK_ASB = "asb";
    var BANK_COOPERATIVEBANK = "cooperativebank";
    var BANK_WESTPAC = "westpac";
    var BANK_HEARTLAND = "heartland";
    var RE_MOBILE = /^02[012789]{1}[0-9]{6,8}$/; //starts with 02 and is between 9 and 11 characters
    var RE_CUSTOMERID = /^[1-9]{1}[0-9]{6}$/;
    var RE_WESTPAC_TELEID = /^[0-9]{4,9}$/; //between 4-9 characters, all numbers
    var RE_WESTPAC_SELFSELECTEDID = /^(?=.*[a-zA-Z])[0-9a-zA-Z._\-\\]{4,20}$/; //between 4-20 characters including special chars, must have at least 1 letter
    var RE_CC = {
        visa: /^4.*$/,
        mastercard: /^(22|23|24|25|26|27|51|52|53|54|55).*$/,
        amex: /^(34|37).*$/,
        diners: /^(30|36|38).*$/,
        qcard: /^6015.*$/
    };
   

    //If google is enabled, disable the loading screen after button loads or after
    //2 seconds. Loading screen is only enabled for google pay merchants
    var isGooglePayEnabled = $("#input_google_pay_enabled").val();
    var loadingContainer = $("#loading_container_body");
    var mainContainer = $("#container_body");
    if (isGooglePayEnabled.toLowerCase() == "true") {
       
      
        //Check whether the Google button is now existing for
        //a set amount of loops
        var gpayCheckCounter = 0;
        var gpayTimeLimitIn100ms = 50;
        var checkGpayExist = setInterval(function () {

            //Add an attribute to stop validation for Google pay
            if ($('.gpay-button').length) {
                $('.gpay-button').addClass('cancel');
            }


            //2 second timeout for now
            if ($('.gpay-button').length || gpayCheckCounter == gpayTimeLimitIn100ms) {
               
                loadingContainer.hide();
                mainContainer.show();
                clearInterval(checkGpayExist);
            }

            //Hide the whole section if it doesn't load in 2 seconds
            if (gpayCheckCounter == gpayTimeLimitIn100ms) {
                $('#container_google_pay').hide();
                logError("Google Pay button didn't load in time. Timeout reached.");
            }


            gpayCheckCounter += 1;
        }, 100);
       
    } else {
     
        loadingContainer.hide();
        mainContainer.show();

       
    }

    
    
    // jquery input masks
    // https://github.com/RobinHerbots/jquery.inputmask

    if (navigator.userAgent.indexOf("Android") > 0
        && navigator.userAgent.indexOf("Chrome") > 0) {
        // no masking for this browser on android mobile
        $("#input_cn").inputmask({
            "placeholder": "",
            "mask": "9999 9999 9999 9999"
        });

        $("#input_expiry")
            .inputmask({
                "placeholder": "",
                "mask": "99/99"
            })
            .prop("placeholder", "MM/YY");
    } else {
        $("#input_cn").inputmask({
            "placeholder": "",
            "mask": "9999 9999 9999 9999"
        });
        $("#input_expiry").inputmask({
            "placeholder": "",
            "mask": "99/99"
        });
    }



    $("#input_cvv").inputmask({
        "placeholder": "",
        "mask": "9{3,4}"
    });

    $("#input_email").inputmask({
        "placeholder": ""
    });

    $("#input_mobile").inputmask({
        "placeholder": "",
        "mask": "9{3} 9{3} 9{3,5}"
    });


    /* events */
    $('[data-toggle="tooltip"]').tooltip();

    // payment method selection
    $(".section-paymethod-header").on("click", function (e) {
        $("#container_paymethod_details").addClass("dirty");

        // turn off all
        $(".section-paymethod .radio").removeClass("fa-dot-circle-o").addClass("fa-circle-o");
        $(".section-paymethod").removeClass("selected");

        // set current
        $(this).closest(".section-paymethod").addClass("selected");
        $(this).find(".radio").addClass("fa-dot-circle-o");


        var amount = Number($("#input_amount").val());
        var surcharge = Number($("#input_surcharge").val());
        var total = amount;

        if ($("#container_paymethod_details").attr("data-bundle") === "oeonly" || $("#container_paymethod_oe").hasClass("selected")) {
            $("#input_payment_type").val("eftpos");
        }
        else {
            total = amount + surcharge;
            $("#input_payment_type").val("clickpay");
        }

        $("#label_amount").text("$" + total.toFixed(2));

    });

    // oe bank
    $("#input_bank")
        .val("")
        .on("change", function (e) {
            var bank = $(this).val();

            switch (bank) {
                case BANK_ASB:
                    $("#label_step2").text("STEP 2: ENTER YOUR MOBILE NUMBER");
                    $("#form_group_store_oe").show();
                    break;
                case BANK_HEARTLAND:
                    $("#label_step2").text("STEP 2: ENTER YOUR MOBILE NUMBER");
                    $("#form_group_store_oe").show();
                    break;
                case BANK_COOPERATIVEBANK:
                    $("#form_group_store_oe").hide();
                    $("#label_step2").text("STEP 2: ENTER YOUR MOBILE NUMBER OR CUSTOMER NUMBER");
                    break;
                case BANK_WESTPAC:
                    $("#form_group_store_oe").hide();
                    $("#label_step2").text("STEP 2: ENTER YOUR MOBILE NUMBER OR WESTPAC ONE ID");
                    break;
            }

            // clean and remove errors
            var $mobile = $("#input_mobile");
            $mobile.removeClass("allow-error")
                .prop("disabled", false)
                .val("");
            var validator = $("#aspnetForm").validate();
            validator.errorList = [];
            validator.showErrors(null);
            validator.resetForm(); // reset validation when changing banks
        });

    $("#input_mobile").on("keyup", function (e) {
        var $this = $(this);
        var firstChar = ($this.val() + " ").charAt(0);
        if ($("#input_bank").val() == BANK_COOPERATIVEBANK && /[1-9]/.test(firstChar)) {
            $this.inputmask({
                "placeholder": "",
                "mask": "9{7}"
            });
        } else if ($("#input_bank").val() == BANK_WESTPAC) {
            //This only masks phone numbers, others don't have any space
            let bankInput = $this.val().replace(/\s+/g, ''); //Get rid of space added by masking
            if (bankInput.length <= 11
                && bankInput.substring(0, 2) == "02"
                && !isNaN(bankInput)) { //if less than 11 and starts with 02 then display like a phone number
                $this.inputmask(
                    {
                        "placeholder": "",
                        "mask": "*{3} *{3} *{3,6}",
                        "definitions": {
                            '*': {
                                validator: "[0-9A-Za-z\\\\_.-]"
                            }
                        }
                    }
                );
            } else { //Maximum 20 char for 
                $this.inputmask(
                    {
                        "placeholder": "",
                        "mask": "*{20}",
                        "definitions": {
                            '*': {
                                validator: "[0-9A-Za-z\\\\_.-]"
                            }
                        }
                    }
                );
            }

             
        }

        else {
            $this.inputmask({
                "placeholder": "",
                "mask": "9{3} 9{3} 9{3,5}"
            });
        }

    });

    // card Highlight
    $("#input_cn")
        .on("keyup", function () {
            var fieldVal = $(this).val().replace(/\s/g, '');     //remove spaces

            var $cardsContainer = $('.supported-cards');
            var $cards = $('[data-card]', $cardsContainer);

            var cardMatchClass = 'matched';

            $cards.removeClass(cardMatchClass);

            for (var key in RE_CC) {

                if (RE_CC[key].test(fieldVal)) {

                    var thisCard = $("[data-card='" + key + "']", $cardsContainer);

                    thisCard.addClass(cardMatchClass);
                }
            }
        })
        .on("focusout", function () {
            // change maxlength on csc
            var $csc = $("#input_cvv")
            if ($("[data-card=amex].matched").length) {
                $csc.inputmask({
                    "placeholder": "",
                    "mask": "9{4}"
                });
            } else {
                $csc.inputmask({
                    "placeholder": "",
                    "mask": "9{3}"
                });
            }

            // trigger csc validation
            if ($csc.val()) {
                var validator = $("form").validate();
                validator.element("#input_cvv");
            }
        });

    $("#input_cardname").on("focusout", function () {
        var $this = $(this);

        try {
            var clean = ($this.val() || "").replace(/[?%^<>&\"'\\/]/g, "").toUpperCase();
            $this.val(clean);

        } catch (e) {
            $this.val($this.val().toUpperCase());
        }

    });


    //Credit Card Validator
    $.validator.addMethod("allowedcardtype", function (value, element) {
        value = value.replace(/\s/g, '');
        var valid = (window.ACCEPTED_CARD.visa && RE_CC.visa.test(value))
            || (window.ACCEPTED_CARD.mastercard && RE_CC.mastercard.test(value))
            || (window.ACCEPTED_CARD.amex && RE_CC.amex.test(value))
            || (window.ACCEPTED_CARD.diners && RE_CC.diners.test(value))
            || (window.ACCEPTED_CARD.qcard && RE_CC.qcard.test(value));

        return this.optional(element) || valid;
    }, "Please enter a valid card number");


    //Mobile Number Validator
    $.validator.addMethod("checkMobileNumber", function (value, element) {

        var val = value.replace(/\s/g, ''); // remove spaces
        var $element = $(element);
        var allowErrorClass = "allow-error";

        switch ($("#input_bank").val()) {
            case BANK_COOPERATIVEBANK:
                if (val.substring(0, 1) == "0") {
                    $.validator.messages.checkMobileNumber = "Please enter a valid mobile number";
                    if (val.length >= 9)
                        $element.addClass(allowErrorClass);
                } else {
                    $.validator.messages.checkMobileNumber = "Please enter a valid customer number";
                    if (val.length >= 7)
                        $element.addClass(allowErrorClass);
                }

                if ($element.hasClass("dirty")) {
                    if (RE_MOBILE.test(val)) {
                        $("#input_payerid_type").val("mobile");
                        return true;
                    } else if (RE_CUSTOMERID.test(val)) {
                        $("#input_payerid_type").val("customerid");
                        return true;
                    }
                    return false; // not valid
                }

                return true; // we are ok

                break;
            case BANK_ASB:
                $.validator.messages.checkMobileNumber = "Please enter a valid mobile number";

                if ($element.hasClass("dirty"))
                    return RE_MOBILE.test(val);

                return true;
                break;
            case BANK_HEARTLAND:
                $.validator.messages.checkMobileNumber = "Please enter a valid mobile number";

                if ($element.hasClass("dirty"))
                    return RE_MOBILE.test(val);

                return true;
                break;
            case BANK_WESTPAC:
                $.validator.messages.checkMobileNumber = "Please enter a valid mobile number or Westpac One ID"; //By default we don't know if phone or Westpac Id
                
                if ($element.hasClass("dirty")) {
                    if (RE_MOBILE.test(val)) {
                        $("#input_payerid_type").val("mobile");
                        return true;
                    } else if (
                        ((val.length == 9 && val.substring(0, 2) != "02") || val.length < 9) //If it's 9 characters, we assume it's a phone number so we skip teleId check
                        && RE_WESTPAC_TELEID.test(val)) {
                        $("#input_payerid_type").val("customerid"); // TeleId then it's Westpac 1 Id, which we pass back as customerId
                        return true;
                    } else if (RE_WESTPAC_SELFSELECTEDID.test(val)) {
                        $("#input_payerid_type").val("customerid"); // self selected id then it's also Westpac 1 Id, which we pass back as customerId
                        return true;
                    }
                    return false; // not valid
                }

                return true; // we are ok
                break;
        }
    }, "Please enter a valid mobile number");

    $.validator.addMethod("checkValidExpiry", function (value, element) {
        var today = new Date();
        var thisYear = today.getFullYear();

        value = (value || "").replace(/\s|\//gi, ''); //remove slash and spaces

        var expMonth = +value.substr(0, 2);
        var expYear = 2000 + +value.substr(2, 2);

        return (expMonth >= 1
            && expMonth <= 12
            && (expYear >= thisYear && expYear < thisYear + 20)
            && (expYear == thisYear ? expMonth >= (today.getMonth() + 1) : true));
    }, "Please enter valid expiry date");


    // https://jqueryvalidation.org/reference/
    $('.jq-validate').each(function () {

        $(this).validate({
            debug: false,
            submitHandler: function (form) {

            },

            ignore: ':hidden',

            /*apply onkeup validation only after the onfocus is applied*/

            onkeyup: function (element, event) {
                var $element = $(element);

                var isOETab = $("#container_paymethod_oe").is(".selected");
                var isCardNameValid = $element.is("#input_cardname") && ($element.val() || "").length > 0;

                // oe always trigger onkeyup
                if (!isOETab && !isCardNameValid && !$element.hasClass("dirty"))
                    return false;

                $element.valid();
            },

            onfocusout: function (element, event) {

                var $element = $(element);

                $element.valid();

                // mark field as dirty
                $element.addClass("dirty");
            },

            //focusCleanup: true,

            options: {},

            rules: {
                ctl00$ContentPlaceHolder1$input_cn: {
                    required: true,
                    maxlength: 20,
                    creditcard: true,
                    allowedcardtype: true
                },

                ctl00$ContentPlaceHolder1$input_expiry: {
                    required: true,
                    minlength: 4,
                    maxlength: 5,
                    checkValidExpiry: true
                },

                ctl00$ContentPlaceHolder1$input_cardname: {
                    required: true,
                    minlength: 1,
                    maxlength: 50
                },

                ctl00$ContentPlaceHolder1$input_cvv: {
                    required: function (element) {
                        var required = true;
                        if ($("[data-card=diners].matched").length)
                            required = false;

                        return required;
                    },
                    minlength: function (element) {
                        if ($("[data-card=amex].matched").length)
                            return 4;
                        return 3;
                    },
                    maxlength: function (element) {
                        if ($("[data-card=amex].matched").length)
                            return 4;
                        return 3;
                    }
                },

                ctl00$ContentPlaceHolder1$input_email: {
                    required: false,
                    minlength: 5,
                    maxlength: 100,
                    email: true
                },

                ctl00$ContentPlaceHolder1$input_bank: {
                    required: true
                },

                ctl00$ContentPlaceHolder1$input_mobile: {
                    required: true,
                    checkMobileNumber: true
                }

            },

            messages: {

                ctl00$ContentPlaceHolder1$input_cn: {
                    minlength: "Please enter a valid card number",
                    required: "Please enter a valid card number",
                    creditcard: "Please enter a valid card number"
                },

                ctl00$ContentPlaceHolder1$input_expiry: {
                    required: "Please enter a valid expiry date",
                    minlength: "Please enter a valid expiry date"
                },

                ctl00$ContentPlaceHolder1$input_cardname: {
                    required: "Please enter a valid name"
                },

                ctl00$ContentPlaceHolder1$input_cvv: {
                    required: "Please enter the CVV",
                    minlength: "Please enter a valid CVV",
                    maxlength: "Please enter a valid CVV"
                },

                ctl00$ContentPlaceHolder1$input_email: {
                    email: "Your email address must be in the format of name@domain.com",
                    minlength: "Your email address must be in the format of name@domain.com"
                },

                ctl00$ContentPlaceHolder1$input_bank: {
                    required: "Please select bank"
                },

                ctl00$ContentPlaceHolder1$input_mobile: {
                    required: "Please enter a valid number",
                    minlength: "Please enter a valid number"
                }
            },

            highlight: function (el) {
                $(el).closest('.form-group').addClass('has-error');
            },

            unhighlight: function (el) {
                $(el).closest('.form-group').removeClass('has-error');
            },

            errorElement: 'span',
            errorClass: 'help-block',

            errorPlacement: function (error, el) {
                if (el.parent('.input-group').length) {
                    error.insertAfter(el.parent());
                } else {
                    error.insertAfter(el);
                }
            }
        });

    });


    

});



/*submit click*/
function onSubmitClick() {
    //e = e || window.event || event;

    $('input').addClass('dirty');

    var valid = $("#aspnetForm").valid();

    if (!valid)
        return false;

    //fire the actual submit when form is valid
    $('#btn_submit').click();
    return true;
};


function logError(error) {

    var url = window.location.href;
    var urlSections = url.split("?");
    var urlParamsIncludingToken = urlSections[1].substring(urlSections[1].indexOf("q="));

    var token = urlParamsIncludingToken.split("&")[0].replace("q=", "");
    var requestId = $("#input_request_id").val();

    if (token && error) {
        var message = {
            token: token,
            error: error,
            requestid: requestId
        }


        $.ajax({
            type: "POST",
            url: '/webpayments/Integration/StandardV3.aspx/LogError',
            dataType: "json",
            contentType: "application/json; charset=utf-8",
            data: JSON.stringify(message),
            error: function (error) {
                console.log("Failed to log error. Error occurred: " + error);
            },
            failure: function (failure) {
                console.log("Failed to log error. response: " + failure);
            }
        });

    }
}


function load3DSValues() {
    $('#input_color_depth').val(screen.colorDepth);
    $('#input_screen_height').val(screen.height);
    $('#input_screen_width').val(screen.width);

    $('#input_time_zone').val((new Date()).getTimezoneOffset());
   
}