<?php
/**
 * Plugin Name: E-World Abandoned Cart
 * Description: Abandoned Cart
 * Version:     1.0
 * Plugin URI: http://eworldsystems.co.uk/
 * Author: By E-World Team
 * Text Domain: abandomend-cart
 */


function bandend_cart_scripts()
{
    $plugin_url = plugin_dir_url(__FILE__);
    if (is_checkout()) {
        wp_enqueue_script('script-jquery', 'https://code.jquery.com/jquery-3.3.1.min.js');
    }


    wp_enqueue_script('script-tracker', $plugin_url . 'assets/main.js');

    wp_localize_script('script-tracker', 'ajax_tracker', array(
        'ajax_url' => admin_url('admin-ajax.php')
    ));

}

add_action('wp_enqueue_scripts', 'bandend_cart_scripts');


add_action('wp_ajax_nopriv_post_ajax_tracker', 'post_ajax_tracker');
add_action('wp_ajax_post_ajax_tracker', 'post_ajax_tracker');


function post_ajax_tracker()
{
    if (isset($_POST['emailaddress'])) {

        global $woocommerce;
        $items = $woocommerce->cart->get_cart();
        $product_array = array();

        foreach ($items as $item => $values) {
            $product_array = array(
                'id' => $values['data']->get_id(),
                'name' => $values['data']->get_title(),
                'price' => $values['data']->get_price()
            );
        }

        $args_product = array(
            'post_type' => 'shop_order',
            'post_status' => 'wc-completed',
            'posts_per_page' => -1,
            'date_query' => array(
                array(
                    'after' => 'yesterday',
                    'inclusive' => true,
                ),
            ),
        );

        $query_products = new WP_Query($args_product);


        $email_checklist = get_option('tracker_email_checklist');

        if (is_array($email_checklist)) {

            $email_checklist[$_POST['emailaddress']] = array(
                'name' => $_POST['firstname'],
                'lastname' => $_POST['lastname'],
                'phone' => $_POST['phone'],
                'date' => date('Y-m-d H:i:s'),
                'products' => $product_array,
            );

            echo 'success';

        } else {

            $email_checklist = array();
            $email_checklist[$_POST['emailaddress']] = array(
                'name' => $_POST['firstname'],
                'lastname' => $_POST['lastname'],
                'phone' => $_POST['phone'],
                'date' => date('Y-m-d'),
                'products' => $product_array,
            );
            echo 'success';
        }


        if ($query_products->have_posts()) :
            while ($query_products->have_posts()) : $query_products->the_post();
                $email_address = get_post_meta(get_the_ID(), '_billing_email', true);

                if (array_key_exists($email_address, $email_checklist)) {
                    unset($email_checklist[$email_address]);
                }

            endwhile;
            wp_reset_postdata();
        endif;

        update_option('tracker_email_checklist', $email_checklist);

    }

    exit();
}


add_action('admin_menu', 'e_world_abandned_cart_create_menu');


function e_world_abandned_cart_create_menu()
{
    //create new top-level menu
    add_menu_page(
        'E-world Abandned Cart',
        'Abandoned Cart',
        'read', 'e-world-abandned-cart',
        'abandned_cart_settings_page',
        'dashicons-admin-page',
        3
    );
}

function abandned_cart_settings_page()
{
    $email_checklist = get_option('tracker_email_checklist');
    $email_checklist = array_reverse($email_checklist);
    global $wpdb;

    if ($_POST) {
        $email_checklist[$_POST['sale_email']]['customer_note_author'] = $_POST['customer_note_author'];
        $email_checklist[$_POST['sale_email']]['customer_note'] = $_POST['customer_note'];
        $email_checklist[$_POST['sale_email']]['customer_note_date'] = date('Y-m-d');

        update_option('tracker_email_checklist', $email_checklist);
    }
    ?>        <!-- Table for Show data -->

    <style>
        .status_wc-completed {
            padding: 3px 8px;
            background: #11af11;
            color: #fff;
            border-radius: 4px;
        }

        .status_wc-cancelled {
            padding: 3px 8px;
            background: #f39014;
            color: #fff;
            border-radius: 4px;
        }

        .status_wc-failed {
            padding: 3px 8px;
            background: #f31414;
            color: #fff;
            border-radius: 4px;
        }

        .btn_add_note, .btn_add_notes {
            padding: 4px 8px;
            text-decoration: none;
            border: none;
            border: 1px solid #ccc;
            border-radius: 2px;
            border: 1px solid #ccc;
            text-shadow: none;
            font-weight: 600;
            font-size: 13px;
            line-height: normal;
            color: #0073aa;
            cursor: pointer;
            outline: 0;
            background-color: #fff;
        }

        #modal_abandned_overlay {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            background-color: #0000004d;
            z-index: 9999;
        }

        #modal_abandned {
            position: absolute;
            top: 20%;
            background: #fff;
            width: 600px;
            height: 300px;
            left: 50%;
            transform: translateX(-50%);
            box-shadow: 0px 0px 4px #00000057;
        }

        .modal_abandned_close {
            position: absolute;
            right: 5px;
            top: 5px;
            font-size: 31px;
            color: #9d9d9d;
            cursor: pointer;
        }

        .dashicons_abandned {
            color: #008dc9;
            cursor: pointer;
        }

        .dashicons_abandned > div {
            padding: 10px;
            background: #dcdcdc;
            position: absolute;
            top: 24px;
            right: 5px;
            display: none;
            color: #000;
            font-size: 15px;
            width: 200px;
            text-align: left;
            line-height: 20px;
            box-shadow: 0px 0px 4px #0000008c;
            z-index: 9;
        }

        .dashicons_abandned > div > span {
            display: block;
            font-style: italic;
            font-size: 13px;
            float: right;
            margin-top: 15px;
        }

        .dashicons_abandned {
            position: relative;
        }

        .dashicons_abandned:hover div {
            display: block
        }
    </style>
    <table class="wp-list-table widefat fixed striped comments" cellspacing="0">
        <thead>
        <tr>
            <td id="cb" class="manage-column column-cb check-column" scope="col">
                <label class="screen-reader-text" for="cb-select-all-1">Select All</label>
                <input id="cb-select-all-1" type="checkbox">
            </td>
            <th scope="col" id="comment" class="manage-column column-comment column-primary">First Name / Last Name</th>
            <th id="columnname" class="manage-column  num" scope="col">Email</th>
            <th id="columnname" class="manage-column  num" scope="col">Phone</th>
            <th id="columnname" class="manage-column  num" scope="col">Products</th>
            <th id="columnname" class="manage-column  num" scope="col">Status</th>
            <th id="columnname" class="manage-column  num" scope="col">Date</th>
            <th id="columnname" class="manage-column  num" scope="col">Note</th>
        </tr>
        </thead>
        <tfoot>
        <tr>
            <td class="manage-column column-cb check-column" scope="col">
                <label class="screen-reader-text" for="cb-select-all-1">Select All</label>
                <input id="cb-select-all-1" type="checkbox">
            </td>
            <th scope="col" id="comment" class="manage-column column-comment column-primary">First Name / Last Name</th>
            <th class="manage-column  num" scope="col">Email</th>
            <th class="manage-column  num" scope="col">Phone</th>
            <th class="manage-column  num" scope="col">Products</th>
            <th class="manage-column  num" scope="col">Status</th>
            <th class="manage-column  num" scope="col">Date</th>
            <th id="columnname" class="manage-column  num" scope="col">Note</th>
        </tr>
        </tfoot>

        <tbody>
        <?php if ($email_checklist) : foreach ($email_checklist as $key => $checklist) :
            $myrows = $wpdb->get_results(
                "SELECT `post_id` 
								FROM `wp_postmeta` 
								WHERE `meta_key` = '_billing_email'
								AND  `meta_value` = '" . $key . "' ",
                ARRAY_A)[0];
            if (get_post_status($myrows['post_id']) != 'wc-completed') {
                $to = "info@autocovers.co.uk";
                $subject = "Abandomend Order";
                $txt = "Email:" . $key . "\r\n Phone Number:" . $checklist['phone'] . "\r\n Name " . $checklist['name'];
                $headers = "From: autocovers.co.uk";
//                mail($to, $subject, $txt, $headers);
                ?>
                <tr class="<?php echo $key % 2 == 0 ? 'even' : 'odd'; ?>" valign="top">
                    <th class="check-column" scope="row">
                        <label class="screen-reader-text" for="cb-select-2461">Select comment</label>
                        <input id="cb-select-2461" type="checkbox" name="delete_comments[]" value="2461">
                    </th>
                    <td class="author column-author">
                        <?php echo $checklist['name']; ?>
                        <?php echo $checklist['lastname']; ?>
                    </td>
                    <td class="author column-author" style="text-align: center">
                        <?php echo $key ?>
                    </td>
                    <td class="author column-author" style="text-align: center">
                        <?php echo $checklist['phone']; ?>
                    </td>
                    <td class="author column-author" style="text-align: center">
                        <?php
                        if ($checklist['products']) :
                            echo '<a href="' . get_the_permalink($checklist['products']['id']) . '">' . $checklist['products']['id'] . '</a> ';
                        endif
                        ?>
                    </td>
                    <td class="author column-author" style="text-align: center">
                        <?php

                        echo '<a href="/wp-admin/post.php?post=' . $myrows['post_id'] . '&action=edit" class="status_' . get_post_status($myrows['post_id']) . ' ">' . get_post_status($myrows['post_id']) . '</a>';
                        ?>
                    </td>
                    <td class="author column-author" style="text-align: center">
                        <?php echo $checklist['date']; ?>
                    </td>
                    <td class="author column-author" style="text-align: center">
                        <?php
                        if ($checklist['customer_note']) {
                            echo '<span class="dashicons dashicons-admin-comments dashicons_abandned"><div>' . $checklist['customer_note'] . '<span> By ' . $checklist['customer_note_author'] . ': ' . $checklist['customer_note_date'] . '</span></div</span>';
                        } else {
                            echo '<a href="" class="btn_add_note" data-email="' . $key . '">Add note</a>';
                        }
                        ?>
                    </td>
                </tr>
            <?php } ?>
        <?php endforeach; endif; ?>
        </tbody>
    </table>
    <div id="modal_abandned_overlay">
        <div id="modal_abandned">
            <span class="modal_abandned_close">&times;</span>
            <form style="margin-top: 50px;padding: 0 25px;" action="" method="POST">
                <?php
                $current_user = wp_get_current_user();
                ?>
                <input type="hidden" name="sale_email" id="sale_email">
                <input type="hidden" name="customer_note_author" value="<?php echo $current_user->user_login; ?>">
                <textarea name="customer_note" rows="7" style="width: 100%;"></textarea>
                <input type="submit" name="" class="btn_add_notes value=" ADD" style="float: right;">
            </form>
        </div>
    </div>
    <script>
        jQuery(document).on('click', '.btn_add_note', function (e) {
            e.preventDefault();
            jQuery('#sale_email').val(jQuery(this).data('email'));
            jQuery('#modal_abandned_overlay').show();
        });

        jQuery(document).on('click', '.modal_abandned_close', function (e) {
            e.preventDefault();
            jQuery('#modal_abandned_overlay').hide();
        });
    </script>
<?php }