/**
 * Block Icon Component.
 *
 * @since 2.8
 */

/**
 * WordPress Dependencies
 */
import { Icon } from '@wordpress/components';

/**
 * Block Icon.
 *
 * Renders the AffiliateWP Logo.
 *
 * @returns {JSX.Element} Rendered form component.
 * @constructor
 */
const blockIcon = ( { color } ) => {

	const fill = color ? '#E34F43' : '';

	return (
		<Icon
			icon={
				<svg width="24" height="24" viewBox="0 0 24 24"><path d="M19.3657 14.051C19.1474 14.051 18.9334 14.0722 18.7215 14.1019L15.668 8.60516C16.3419 7.79993 16.7487 6.76373 16.7487 5.63429C16.7508 3.07876 14.6721 1 12.1165 1C9.56101 1 7.48013 3.07876 7.48013 5.63429C7.48013 6.74254 7.87215 7.75967 8.52269 8.55642L5.33993 14.1104C5.10895 14.0743 4.87586 14.051 4.63429 14.051C2.07876 14.051 0 16.1298 0 18.6853C0 21.2409 2.07876 23.3196 4.63429 23.3196C7.18983 23.3196 9.26859 21.2409 9.26859 18.6853C9.26859 17.5771 8.87657 16.5599 8.22603 15.7632L11.4088 10.2114C11.6398 10.2474 11.8729 10.2707 12.1144 10.2707C12.3327 10.2707 12.5467 10.2495 12.7586 10.2198L15.8121 15.7145C15.1383 16.5197 14.7314 17.5559 14.7314 18.6853C14.7314 21.2409 16.8102 23.3196 19.3657 23.3196C21.9212 23.3196 24 21.2409 24 18.6853C24 16.1298 21.9212 14.051 19.3657 14.051ZM12.1165 4.04715C12.9917 4.04715 13.7037 4.75914 13.7037 5.63429C13.7037 6.50945 12.9917 7.22144 12.1165 7.22144C11.2414 7.22144 10.5294 6.50945 10.5294 5.63429C10.5294 4.75914 11.2414 4.04715 12.1165 4.04715ZM4.63429 20.2725C3.75914 20.2725 3.04715 19.5605 3.04715 18.6853C3.04715 17.8102 3.75914 17.0982 4.63429 17.0982C5.50945 17.0982 6.22144 17.8102 6.22144 18.6853C6.22144 19.5605 5.50945 20.2725 4.63429 20.2725ZM19.3657 20.2725C18.4906 20.2725 17.7786 19.5605 17.7786 18.6853C17.7786 17.8102 18.4906 17.0982 19.3657 17.0982C20.2409 17.0982 20.9529 17.8102 20.9529 18.6853C20.9529 19.5605 20.2409 20.2725 19.3657 20.2725Z" fill={fill} /></svg>
			}
		/>
	);
}
export default blockIcon;