<?php
/**
 * Plugin Name: Products Revisions
 * Description: This plugin saving product Revisions
 * Version:     1.0
 */

/**
 * Add revisions for products
 */
add_filter( 'woocommerce_register_post_type_product', 'add_revisions_to_product' );
function add_revisions_to_product( $args ) {
    $args['supports'][] = 'revisions';
    return $args;
}

add_action( 'save_post', 'my_plugin_save_post' );
function my_plugin_save_post( $post_id ) {
    if ( $parent_id = wp_is_post_revision( $post_id ) ) {
        global $wpdb;

        // Product categories
        $revision_category = '';
        $categories = wp_get_post_terms( $parent_id, 'product_cat' );
        foreach ($categories as $category){
            $revision_category .= $category->name."\n\r";
        }

        // Product thumbnail
        $thumbnail_id = get_post_meta( $parent_id, '_thumbnail_id', true );

        // Product gallery
        $_product_image_gallery = get_metadata( 'post', $parent_id, '_product_image_gallery', true );

        // Product second title
        $product_second_title = get_post_meta( $parent_id, 'product_second_title', true );

        // Product regular price
        $_regular_price = get_post_meta( $parent_id, '_regular_price', true );

        // Product sale price
        $_sale_price = get_post_meta( $parent_id, '_sale_price', true );

        // Product content meta field
        $product_content = get_post_meta( $parent_id, 'product_content', true );
        $product_content = esc_html($product_content);
        $product_content = wp_specialchars_decode($product_content,ENT_COMPAT );

        // Product technical specifications meta field
        $technical_specifications = get_post_meta( $parent_id, 'technical_specifications', true );
        $technical_specifications = esc_html($technical_specifications);
        $technical_specifications = wp_specialchars_decode($technical_specifications,ENT_COMPAT );

        // Insert Revision meta fields to `postmeta` table (BEGIN)
        if ( false !== $product_content ) {
            $wpdb->query( "INSERT INTO `wp_postmeta` (`post_id`, `meta_key`, `meta_value`) VALUES (".$post_id.", 'product_content', '".$product_content."')");
        }
        if ( false !== $thumbnail_id ) {
            $wpdb->query( "INSERT INTO `wp_postmeta` (`post_id`, `meta_key`, `meta_value`) VALUES (".$post_id.", '_thumbnail_id', '".$thumbnail_id."')");
        }
        if ( false !== $_product_image_gallery ) {
            $wpdb->query( "INSERT INTO `wp_postmeta` (`post_id`, `meta_key`, `meta_value`) VALUES (".$post_id.", '_product_image_gallery', '".$_product_image_gallery."')");
        }
        if ( false !== $technical_specifications ) {
            $wpdb->query( "INSERT INTO `wp_postmeta` (`post_id`, `meta_key`, `meta_value`) VALUES (".$post_id.", 'technical_specifications', '".$technical_specifications."')");
        }
        if ( false !== $product_second_title ) {
            $wpdb->query( "INSERT INTO `wp_postmeta` (`post_id`, `meta_key`, `meta_value`) VALUES (".$post_id.", 'product_second_title', '".$product_second_title."')");
        }
        if ( false !== $_regular_price ) {
            $wpdb->query( "INSERT INTO `wp_postmeta` (`post_id`, `meta_key`, `meta_value`) VALUES (".$post_id.", '_regular_price', '".$_regular_price."')");
        }
        if ( false !== $_sale_price ) {
            $wpdb->query( "INSERT INTO `wp_postmeta` (`post_id`, `meta_key`, `meta_value`) VALUES (".$post_id.", '_sale_price', '".$_sale_price."')");
        }
        if ( false !== $revision_category ) {
            $wpdb->query( "INSERT INTO `wp_postmeta` (`post_id`, `meta_key`, `meta_value`) VALUES (".$post_id.", 'revision_category', '".$revision_category."')");
        }
        // Insert Revision meta fields to `postmeta` table (END)
    }
}


add_filter( '_wp_post_revision_fields', 'add_my_own_fields', 10, 2 );
function add_my_own_fields( $fields, $post ) {
    $fields['_thumbnail_id'] = 'Thumbnail';
    $fields['_product_image_gallery'] = 'Gallery';
    $fields['_regular_price'] = 'Regular price';
    $fields['_sale_price'] = 'Sale price';
    $fields['product_second_title'] = 'Product second title';
    $fields['product_content'] = 'Product content';
    $fields['technical_specifications'] = 'Technical specifications';
    $fields['revision_category'] = 'Revision category';

    return $fields;
}

/**
 * create settings page
 */
add_action('admin_menu', 'e_world_revision_menu_page');
function e_world_revision_menu_page() {
    //create new top-level menu
    add_menu_page('Revisions', 'Revisions', 'read', 'e-world-revisions', 'revisions_settings_page', 'dashicons-backup');
}

function revisions_settings_page() {
    wp_reset_query();
    $paged = $_GET['paged'] ? $_GET['paged'] : 1;
    $posts_per_page = 20;

    $args = array(
        'post_type' => 'revision',
        'post_status' => 'revision',
        'posts_per_page' => $posts_per_page,
        'paged'          => $paged
    );

    $revision = new WP_Query( $args );


    $page_links = paginate_links( array(
        'base' => add_query_arg( 'paged', '%#%' ),
        'format' => '',
        'prev_text' => __('&laquo;'),
        'next_text' => __('&raquo;'),
        'total' => ceil($revision->found_posts / $posts_per_page),
        'current' => $_GET['paged'],
        'end_size' => 3,
        'mid_size' => 2,

    ));

    ?>
    <div class="wrap">
        <?php if( $revision->have_posts() ) : ?>

            <h4>Total <i><?php echo $revision->found_posts; ?></i> revisions</h4>
            <h5>Showing <i><?php echo $revision->post_count; ?></i> revisions</h5>

            <div class="tablenav">
                <div class="tablenav-pages"><?php echo $page_links; ?></div>
            </div>

            <!-- Table for Show data -->
            <table  class="wp-list-table widefat fixed striped comments" cellspacing="0">
                <thead>
                    <tr>
                        <th scope="col" class="manage-column column-comment column-primary"><strong>Revision</strong></th>
                        <th class="manage-column num" scope="col"><strong>Author</strong></th>
                        <th class="manage-column column-date" scope="col"><strong>Date</strong></th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th scope="col" id="comment" class="manage-column column-comment column-primary"><strong>Revision</strong></th>
                        <th class="manage-column  num" scope="col"><strong>Author</strong></th>
                        <th class="manage-column column-date" scope="col"><strong>Date</strong></th>
                    </tr>
                </tfoot>

                <tbody>
                <?php while ($revision -> have_posts()): $revision->the_post(); ?>
                    <tr valign="top">
                        <td class="author column-author" >
                            <a href="<?php echo get_edit_post_link( get_the_ID() ); ?>"><?php the_title(); ?></a>
                        </td>
                        <td class="author column-author" style="text-align: center">
                            <span><?php echo get_the_author(); ?></span>
                        </td>
                        <td class="author column-author">
                            <span><?php echo get_the_date('Y-m-d H:m:s'); ?></span>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
            <div class="tablenav">
                <div class="tablenav-pages"><?php echo $page_links; ?></div>
            </div>
        <?php else: ?>

            <h2>There is not revision yet.</h2>

        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
    </div>
    <?php
}