<?php
/**
* Plugin Name: E-World Automation
* Version: 0.0.1
* Author: E-World
* Author URI: https://www.facebook.com/eworldllc/
**/

require __DIR__ . '/vendor/autoload.php';
use Automattic\WooCommerce\Client;

/**
 * No payment option
 */
add_action('wp_loaded', 'init_custom_gateway_class');
function init_custom_gateway_class() {

    if(!is_user_logged_in()) return;

    class WC_Gateway_Custom extends WC_Payment_Gateway {

        public $domain;



        /**

            * Constructor for the gateway.

            */

        public function __construct()

        {

            $this->domain = 'no_payment';

            $this->id = 'no_payment';

            $this->icon = apply_filters('woocommerce_custom_gateway_icon', '');

            $this->has_fields = false;

            $this->method_title = __('No payment', $this->domain);

            $this->method_description = __('Allows payments with custom gateway.', $this->domain);



            // Load the settings.

            $this->init_form_fields();

            $this->init_settings();



            // Define user set variables

            $this->title = $this->get_option('title');

            $this->description = $this->get_option('description');

            $this->instructions = $this->get_option('instructions', $this->description);

            $this->order_status = $this->get_option('order_status', 'processing');



            // Actions

            add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));

            add_action('woocommerce_thankyou_custom', array($this, 'thankyou_page'));



            // Customer Emails

            //add_action('woocommerce_email_before_order_table', array($this, 'email_instructions'), 10, 3);

        }



        /**

            * Initialise Gateway Settings Form Fields.

            */

        public function init_form_fields() {

            $this->form_fields = array(

                'enabled' => array(

                    'title' => __('Enable/Disable', $this->domain),

                    'type' => 'checkbox',

                    'label' => __('Enable No Payment', $this->domain),

                    'default' => 'yes'

                ),

                'title' => array(

                    'title' => __('Title', $this->domain),

                    'type' => 'text',

                    'description' => __('This controls the title which the user sees during checkout.', $this->domain),

                    'default' => __('No Payment', $this->domain),

                    'desc_tip' => true,

                ),

                'order_status' => array(

                    'title' => __('Order Status', $this->domain),

                    'type' => 'select',

                    'class' => 'wc-enhanced-select',

                    'description' => __('Choose whether status you wish after checkout.', $this->domain),

                    'default' => 'wc-processing',

                    'desc_tip' => true,

                    'options' => wc_get_order_statuses()

                ),

                'description' => array(

                    'title' => __('Description', $this->domain),

                    'type' => 'textarea',

                    'description' => __('Payment method description that the customer will see on your checkout.', $this->domain),

                    'default' => __('Payment Information', $this->domain),

                    'desc_tip' => true,

                ),

                'instructions' => array(

                    'title' => __('Instructions', $this->domain),

                    'type' => 'textarea',

                    'description' => __('Instructions that will be added to the thank you page and emails.', $this->domain),

                    'default' => '',

                    'desc_tip' => true,

                ),

            );

        }



        /**

            * Output for the order received page.

            */

        public function thankyou_page() {

            if ($this->instructions)

                echo wpautop(wptexturize($this->instructions));

        }



        /**

            * Process the payment and return the result.

            *

            * @param int $order_id

            * @return array

            */

        public function process_payment($order_id) {

            $order = wc_get_order($order_id);

            $status = 'wc-' === substr($this->order_status, 0, 3) ? substr($this->order_status, 3) : $this->order_status;

            // Set order status

            $order->update_status($status, __('Checkout with no payment. ', $this->domain));

            // Reduce stock levels

            $order->reduce_order_stock();

            // Remove cart

            WC()->cart->empty_cart();

            // Return thankyou redirect

            return array(

                'result' => 'success',

                'redirect' => $this->get_return_url($order)

            );

        }

    }

}

add_filter('woocommerce_payment_gateways', 'add_custom_gateway_class');

function add_custom_gateway_class($methods) {

    if(!is_user_logged_in()) return $methods;
    
    $methods[] = 'WC_Gateway_Custom';

    return $methods;

}

function no_payment_order( $order_id ){

    $order = wc_get_order( $order_id );

    if( $order->get_payment_method() == 'no_payment' ){

        update_post_meta( $order_id, '_order_total', 0 );

    }

}
add_action( 'woocommerce_new_order', 'no_payment_order', 10, 1 );

/**
 * Send emails by freshdesk API
 */

function freshdesk_email( $subject, $cc_email, $message, $attachment = '' ){

    $api_key = "OcyYdjkXFrR7gZyF2zmT";

    $password = "x";

    $yourdomain = "eworldsystems";



    $ticket_data = array(

        "subject" => $subject,

        "email" => $cc_email,

        //"cc_emails[]" =>  $cc_email

    );

    if( $attachment ){

        $ticket_data["attachments[]"] = curl_file_create($attachment, "application/pdf", basename($attachment) );

    }



    $ticket_data['description'] = $message;

    $ticket_data['priority'] = 1;

    $ticket_data['status'] = 5;

    //$ticket_data['source'] = 10;

    $ticket_data['type'] = 'Other';

    $ticket_data['email_config_id'] = 23000009214;



    $url = "https://$yourdomain.freshdesk.com/api/v2/tickets/outbound_email";

    $ch = curl_init($url);

    curl_setopt($ch, CURLOPT_POST, true);

    curl_setopt($ch, CURLOPT_HEADER, true);

    curl_setopt($ch, CURLOPT_USERPWD, "$api_key:$password");

    curl_setopt($ch, CURLOPT_POSTFIELDS, $ticket_data);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $server_output = curl_exec($ch);

    $info = curl_getinfo($ch);

    $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);

    $headers = substr($server_output, 0, $header_size);

    $response = substr($server_output, $header_size);

    curl_close($ch);

    $result = json_decode($response);



    return $result;

}

/**
 * Add order to Global website
 */
function order_created_hook( $order_id ){
    $woocommerce = new Client(
        'http://auto.boosterserver.com',
        'ck_48d94fef3b51c858c21f2a8f771e49486abe6261',
        'cs_8213300dc5518cce977cd9c2a850bb0dd6c0afcf',
        [
            'wp_api' => true,
            'version' => 'wc/v2',
        ]
    );

    $order = wc_get_order( $order_id );
    $order_data = $order->get_data();

    $data = [
        'payment_method' => $order_data['payment_method'],
        'payment_method_title' => $order_data['payment_method_title'],
        'status' => $order_data['status'],
        'currency' => $order_data['currency'],
        'billing' => [
            'first_name' => $order_data['billing']['first_name'],
            'last_name' => $order_data['billing']['last_name'],
            'address_1' => $order_data['billing']['address_1'],
            'address_2' => $order_data['billing']['address_2'],
            'city' => $order_data['billing']['city'],
            'state' => $order_data['billing']['state'],
            'postcode' => $order_data['billing']['postcode'],
            'country' => $order_data['billing']['country'],
            'company' => $order_data['billing']['company'],
            'email' => $order_data['billing']['email'],
            'phone' => $order_data['billing']['phone']
        ],
        'shipping' => [
            'first_name' => $order_data['shipping']['first_name'],
            'last_name' => $order_data['shipping']['last_name'],
            'address_1' => $order_data['shipping']['address_1'],
            'address_2' => $order_data['shipping']['address_2'],
            'city' => $order_data['shipping']['city'],
            'state' => $order_data['shipping']['state'],
            'postcode' => $order_data['shipping']['postcode'],
            'country' => $order_data['shipping']['country'],
            'company' => $order_data['shipping']['company']
        ],
        'customer_note' => $order_data['customer_note'],
        'meta_data' => [
            [
                'key' => 'paypal_email',
                'value' => get_post_meta($order_id,'paypal_email',true)
            ],
            [
                'key' => 'from_country',
                'value' => 'IR'
            ],
            [
                'key' => 'country_id',
                'value' => $order_id
            ],
            [
                'key' => 'sales_person',
                'value' => 'Suzy'
            ],
            [
                'key' => 'note_read',
                'value' => 'no'
            ]
        ]
    ];


    try {
        $global_order = $woocommerce->post('orders', $data);
    } catch (Exception $e) {
        error_log('------------------- Order not sent to OPS -------------------');
        error_log($e->getMessage());
    }


    $global_order_id = $global_order->id;

    update_post_meta( $order_id, 'global_order_id', $global_order_id );
}
add_action( 'woocommerce_new_order', 'order_created_hook', 100, 1 );

/**
 * Add order Items to Global site
 */
function new_order_item_added($item_id, $item, $order_id){

    // Check if Order already exist the items not adding again to Automation
    if( !did_action( 'woocommerce_new_order' ) ){
        $log = "\r\nOrder items already exist - Order ID: ".$order_id.", Item ID: ".$item_id;
        file_put_contents( 'action_log.txt', $log, FILE_APPEND | LOCK_EX );

        return;
    }

    // if item is Coupon
    if ( is_a($item, 'WC_Order_Item_Coupon') ) {
        $order = wc_get_order( $order_id );
        $coupon = $order->get_used_coupons()[0];
        $woo = new Client(
            'http://auto.boosterserver.com',
            'ck_48d94fef3b51c858c21f2a8f771e49486abe6261',
            'cs_8213300dc5518cce977cd9c2a850bb0dd6c0afcf',
            [
                'wp_api' => true,
                'version' => 'wc/v2',
            ]
        );

        $global_order_id = get_post_meta($order_id, 'global_order_id', true);

        $data = [

            'coupon_lines' => [

                [

                    'code' => $coupon

                ]

            ]



        ];

        try {
            $woo->put('orders/' . $global_order_id, $data);
        } catch (Exception $e) {
            error_log('------------------- Coupons not sent to OPS -------------------');
            error_log($e->getMessage());
        }

    }

    // if item is Product
    if ( is_a($item, 'WC_Order_Item_Product') ) {
        $woo = new Client(
            'http://auto.boosterserver.com',
            'ck_48d94fef3b51c858c21f2a8f771e49486abe6261',
            'cs_8213300dc5518cce977cd9c2a850bb0dd6c0afcf',
            [
                'wp_api' => true,
                'version' => 'wc/v2',
            ]
        );

        $product_id = $item->get_product_id();
        $_product = wc_get_product( $product_id );
        $image = wp_get_attachment_image_src( get_post_thumbnail_id($product_id), 'single-post-thumbnail' );

        $image_info = pathinfo ($image[0]);
        $image_src = $image_info['dirname'] .'/'. rawurlencode($image_info['basename']);

        $global_order_id = get_post_meta($order_id, 'global_order_id', true);
        $coverage = '';
        $frequency = '';
        $terms = get_the_terms( $product_id, 'product_cat' );
        $by_use = get_term_by( 'slug', 'coverages', 'product_cat', 'ARRAY_A' )['term_id'];
        $freq = get_term_by( 'slug', 'frequencies', 'product_cat', 'ARRAY_A' )['term_id'];
        $line_subtotal = $item->legacy_values['line_subtotal'];
        $line_total = $item->legacy_values['line_total'];
        $meta_data = $item->get_formatted_meta_data();
        $meta_output = '';

        // Prepare meta data ( product upgrades )
        foreach ( $meta_data as $meta ){
            $meta_output .= "<li>{$meta->display_key}: {$meta->display_value}</li>";
        }
        if( $meta_output ){
            $meta_output = str_replace('<p>', '', $meta_output );
            $meta_output = str_replace('</p>', '', $meta_output );
            $meta_output = '<ul>'.$meta_output.'</ul>';
        }

        // for "no payment" option
        $payment_method = get_post_meta( $order_id, '_payment_method', true);
        if( $payment_method == 'no_payment' ){
            $line_subtotal = 0;
            $line_total = 0;
        }

        $supplier = '';
        foreach ( $terms as $term ) {
            if($term->parent == $by_use){
                $coverage = $term->slug;
            }

            if($term->parent == $freq){
                $frequency = $term->slug;
            }

            if( $term->slug == "tom" || $term->slug == "wave" || $term->slug == "bobby" ){
                $supplier = $term->slug;
            }
        }

        $order_supplier = get_post_meta( $order_id, 'supplier', true );
        if( $order_supplier ){
            if( !strpos( $order_supplier, $supplier ) ){
                $order_supplier .= ','.$supplier;
            }
        }else{
            $order_supplier = $supplier;
        }

        update_post_meta( $order_id, 'supplier', $order_supplier );


        // get coverage global id
        switch ( $coverage ) {

            case "up-to-100-sqm":

                $coverage_id = 18;

                break;

            case "bis-zu-150-m²":

                $coverage_id = 19;

                break;

            case "bis-zu-300-m2":

                $coverage_id = 20;

                break;

            case "bis-zu-600-m2":

                $coverage_id = 21;

                break;

            case "bis-zu-1000-m2":

                $coverage_id = 22;

                break;

            case "bis-zu-1500-m²":

                $coverage_id = 23;

                break;

            case "bis-zu-2500-m²":

                $coverage_id = 24;

                break;

            case "bis-zu-5000-m2":

                $coverage_id = 25;

                break;

            default:

                $coverage_id = 15; // uncategorized id

        }

        // get frequency global id
        switch ( $frequency ) {

            case "3g-2100-mhz":

                $frequency_id = 35;

                break;

            case "4g-lte-1800-mhz":

                $frequency_id = 36;

                break;

            case "4g-800":

                $frequency_id = 34;

                break;

            case "800-1800-mhz":

                $frequency_id = 31;

                break;

            case "8002100-mhz":

                $frequency_id = 30;

                break;

            case "900-mhz":

                $frequency_id = 33;

                break;

            case "900-1800-mhz":

                $frequency_id = 28;

                break;

            case "900-1800-2100-mhz":

                $frequency_id = 27;

                break;

            case "900-2100-mhz":

                $frequency_id = 29;

                break;

            case "900800-mhz":

                $frequency_id = 32;

                break;

            case "800-900-1800-2100-2600-mhz":

                $frequency_id = 26;

                break;

            case "800-900-1800-mhz":

                $frequency_id = 38;

                break;

            case "1800-mhz":

                $frequency_id = 40;

                break;

            case "800-1800-2100-mhz":

                $frequency_id = 49;

                break;

            default:

                $frequency_id = 15; // uncategorized id

        }

        if( get_post_meta($product_id, 'global_product_id', true) ){
            $global_product_id = get_post_meta($product_id, 'global_product_id', true);
        }else{
            $product_data = [
                'name' => $_product->get_title(),
                'type' => 'simple',
                'regular_price' => $_product->get_regular_price(),
                'sale_price' => $_product->get_sale_price(),
                'categories' => [
                    [
                        'id' => $coverage_id
                    ],
                    [
                        'id' => $frequency_id
                    ]
                ],
                'images' => [
                    [
                        'src' => $image_src,
                        'position' => 0
                    ]
                ],
                'meta_data' => [
                    [
                        'key' => 'from_country',
                        'value' => 'IR'
                    ],
                    [
                        'key' => 'country_id',
                        'value' => $product_id
                    ],
                    [
                        'key' => 'country_url',
                        'value' => get_the_permalink( $product_id )
                    ],
                    [
                        'key' => 'supplier',
                        'value' => $supplier
                    ]
                ]
            ];

            try {
                $global_product = $woo->post('products', $product_data );
            } catch (Exception $e) {
                error_log('------------------- Product not created on OPS -------------------');
                error_log($e->getMessage());
            }

            $global_product_id = $global_product->id;
            update_post_meta( $product_id, 'global_product_id', $global_product_id );
        }

        $data = [
            'line_items' => [
                [
                    'product_id' => $global_product_id,
                    'quantity' => $item->get_quantity(),
                    'subtotal' => (string) $line_subtotal,
                    'total' => (string) $line_total,
                    'meta_data' => [
                        [
                            'key' => 'extra_info',
                            'value' => $meta_output
                        ]
                    ]
                ]
            ],
            'meta_data' => [
                [
                    'key' => 'supplier',
                    'value' => $order_supplier
                ]
            ]
        ];


        try {
            $woo->put('orders/' . $global_order_id, $data);
        } catch (Exception $e) {
            error_log('------------------- Line item not sent to OPS -------------------');
            error_log($e->getMessage());
        }
    }
}

add_action( 'woocommerce_new_order_item', 'new_order_item_added',  10, 3 );

/**
 * Change order status in Global website
 */
function woo_order_status_change_custom( $order_id, $old_status, $new_status) {

    $manual_cancelled = get_post_meta( $order_id, 'manual_cancelled', true );



    // if from automation status changed to "manual_cancelled" do nothing

    if( $manual_cancelled && $new_status == 'cancelled' ){

        return;

    }

    

    $woo = new Client(

        'http://auto.boosterserver.com',

        'ck_48d94fef3b51c858c21f2a8f771e49486abe6261',

        'cs_8213300dc5518cce977cd9c2a850bb0dd6c0afcf',

        [

            'wp_api' => true,

            'version' => 'wc/v2',

        ]

    );



    $global_order_id = get_post_meta($order_id, 'global_order_id', true);



    $data = [

        'status' => $new_status,

        'payment_method' => get_post_meta( $order_id, '_payment_method', true ),

        'payment_method_title' => get_post_meta( $order_id, '_payment_method_title', true ),

        'meta_data' => [

            [

                'key' => 'paypal_email',

                'value' => get_post_meta($order_id,'paypal_email',true)

            ],

        ]

    ];



    if( $global_order_id ){

        if( $new_status != 'replacement' ){

            try {
                $woo->put('orders/' . $global_order_id, $data);
            } catch (Exception $e) {
                error_log('------------------- Order status not changed on OPS -------------------');
                error_log($e->getMessage());
            }

        }

    }

}
add_action('woocommerce_order_status_changed', 'woo_order_status_change_custom', 10, 3);

/**
 * Send PDF invoice to Global
 */

function send_pdf_to_global($attachments, $email_id, $order){

        $woo = new Client(
            'http://auto.boosterserver.com',
            'ck_48d94fef3b51c858c21f2a8f771e49486abe6261',
            'cs_8213300dc5518cce977cd9c2a850bb0dd6c0afcf',
            [
                'wp_api' => true,
                'version' => 'wc/v2',
            ]
        );

        $order_id = $order->get_id();
        $global_order_id = get_post_meta($order_id, 'global_order_id', true);

        $data = [
            'meta_data' => [
                [
                    'key' => 'pdf_invoice_number',
                    'value' => get_post_meta( $order_id, '_wcpdf_invoice_number', true)
                ]
            ]
        ];


        try {
            $woo->put('orders/' . $global_order_id, $data);
        } catch (Exception $e) {
            error_log('------------------- Invoice number not sent to OPS -------------------');
            error_log($e->getMessage());
        }

        $target_url = 'http://auto.boosterserver.com/order/';
        $cFile = curl_file_create($attachments[0]);
        $info = array('secret_key' => '123456', 'file_contents'=> $cFile);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$target_url);
        curl_setopt($ch, CURLOPT_POST,1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $info);
        $result = curl_exec ($ch);
        curl_close($ch);
   
}
//add_filter( 'woocommerce_email_attachments', 'send_pdf_to_global', 100, 3 );

/**
 * Send email when order completed via Freshdesk
 */
function send_email_after_completed( $order_id, $old_status, $new_status) {

    if( $new_status == 'completed' ){



        $email_obj = new WC_Email_Customer_Completed_Order();

        $email_obj->trigger( $order_id );



        $email = $email_obj;

        $sent_to_admin = false;

        $plain_text = false;

        $order = wc_get_order($order_id);

        $email_heading = 'Your order is complete';

        $order_data = $order->get_data();

        $customer_email = $order_data['billing']['email'];



        $invoice_id = get_post_meta( $order_id, '_wcpdf_invoice_number', true );

        $pdf_invoice = get_site_url().'/wp-content/uploads/wpo_wcpdf/attachments/invoice-'.$invoice_id.'.pdf';

        $file_real_path = ABSPATH.'wp-content/uploads/wpo_wcpdf/attachments/invoice-'.$invoice_id.'.pdf';



        // Buffer.

        ob_start();

        do_action( 'woocommerce_email_header', $email_heading, $email ); ?>

        <p><?php printf( __( "Hi there. Your recent order on %s has been completed. Your order details are shown below for your reference:", 'woocommerce' ), get_option( 'blogname' ) ); ?></p>



        <?php

        do_action( 'woocommerce_email_order_details', $order, $sent_to_admin, $plain_text, $email );

        do_action( 'woocommerce_email_order_meta', $order, $sent_to_admin, $plain_text, $email );

        do_action( 'woocommerce_email_customer_details', $order, $sent_to_admin, $plain_text, $email );

        do_action( 'woocommerce_email_footer', $email );



        // Get contents.

        $message = ob_get_clean();

        // Add inline styles to content

        $message = $email_obj->style_inline( $message );



        freshdesk_email( "New order", $customer_email, $message, $file_real_path );

    }

}
//add_action('woocommerce_order_status_changed', 'send_email_after_completed', 10, 3);
