<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.eworldsystems.co.uk/
 * @since      1.0.0
 *
 * @package    Eworld_Banners
 * @subpackage Eworld_Banners/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Eworld_Banners
 * @subpackage Eworld_Banners/admin
 * @author     EWorld <info@eworldsystems.co.uk>
 */
class Eworld_Banners_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	public function create_custom_post_type() {
        $labels = array(
            'name'                  => _x( 'Banners', 'Post type general name', 'brtemplate' ),
            'singular_name'         => _x( 'Banner', 'Post type singular name', 'brtemplate' ),
            'menu_name'             => _x( 'Banners', 'Admin Menu text', 'brtemplate' ),
            'name_admin_bar'        => _x( 'Banner', 'Add New on Toolbar', 'brtemplate' ),
            'add_new'               => __( 'Add New', 'brtemplate' ),
            'add_new_item'          => __( 'Add New Banner', 'brtemplate' ),
            'new_item'              => __( 'New Banner', 'brtemplate' ),
            'edit_item'             => __( 'Edit Banner', 'brtemplate' ),
            'view_item'             => __( 'View Banner', 'brtemplate' ),
            'all_items'             => __( 'All Banners', 'brtemplate' ),
            'search_items'          => __( 'Search Banners', 'brtemplate' ),
            'parent_item_colon'     => __( 'Parent Banners:', 'brtemplate' ),
            'not_found'             => __( 'No Banners found.', 'brtemplate' ),
            'not_found_in_trash'    => __( 'No Banners found in Trash.', 'brtemplate' ),
            'featured_image'        => _x( 'Banner Cover Image', 'Overrides the “Featured Image” phrase for this post type. Added in 4.3', 'brtemplate' ),
            'set_featured_image'    => _x( 'Set cover image', 'Overrides the “Set featured image” phrase for this post type. Added in 4.3', 'brtemplate' ),
            'remove_featured_image' => _x( 'Remove cover image', 'Overrides the “Remove featured image” phrase for this post type. Added in 4.3', 'brtemplate' ),
            'use_featured_image'    => _x( 'Use as cover image', 'Overrides the “Use as featured image” phrase for this post type. Added in 4.3', 'brtemplate' ),
            'archives'              => _x( 'Banner archives', 'The post type archive label used in nav menus. Default “Post Archives”. Added in 4.4', 'brtemplate' ),
            'insert_into_item'      => _x( 'Insert into Banner', 'Overrides the “Insert into post”/”Insert into page” phrase (used when inserting media into a post). Added in 4.4', 'brtemplate' ),
            'uploaded_to_this_item' => _x( 'Uploaded to this Banner', 'Overrides the “Uploaded to this post”/”Uploaded to this page” phrase (used when viewing media attached to a post). Added in 4.4', 'brtemplate' ),
            'filter_items_list'     => _x( 'Filter Banners list', 'Screen reader text for the filter links heading on the post type listing screen. Default “Filter posts list”/”Filter pages list”. Added in 4.4', 'brtemplate' ),
            'items_list_navigation' => _x( 'Banners list navigation', 'Screen reader text for the pagination heading on the post type listing screen. Default “Posts list navigation”/”Pages list navigation”. Added in 4.4', 'brtemplate' ),
            'items_list'            => _x( 'Banners list', 'Screen reader text for the items list heading on the post type listing screen. Default “Posts list”/”Pages list”. Added in 4.4', 'brtemplate' ),
        );
        
        $args = array(
            'labels'             => $labels,
            'description'        => 'Banner custom post type.',
            'menu_icon'          => 'dashicons-images-alt2',
            'public'             => false,
            'publicly_queryable' => false,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => array( 'slug' => 'banner' ),
            'capability_type'    => 'post',
            'has_archive'        => false,
            'hierarchical'       => false,
            'menu_position'      => 20,
            'supports'           => array( 'title', 'thumbnail' ),
            'taxonomies'         => array(),
            'show_in_rest'       => false
        );

        register_post_type( 'banner', $args );
    }
    
    public function set_banner_acf_fields(){
        if( function_exists('acf_add_local_field_group') ):

            acf_add_local_field_group(array(
                'key' => 'group_61baf8ae25bbe',
                'title' => 'Banners fierlds',
                'fields' => array(
                    array(
                        'key' => 'field_61bafbe69549d',
                        'label' => 'Banner background image (desktop)',
                        'name' => 'banner_background_image',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'url',
                        'preview_size' => 'full',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                    ),
                    array(
                        'key' => 'field_61bb4ad25c156',
                        'label' => 'Banner background image (tablet)',
                        'name' => 'banner_background_image_tablet',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'url',
                        'preview_size' => 'full',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                    ),
                    array(
                        'key' => 'field_61bb4af95c157',
                        'label' => 'Banner background image (mobile)',
                        'name' => 'banner_background_image_mobile',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'url',
                        'preview_size' => 'full',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                    ),
                    array(
                        'key' => 'field_61bafb0cd7b52',
                        'label' => '',
                        'name' => 'banner_fields',
                        'type' => 'flexible_content',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layouts' => array(
                            'layout_61bb426c5b8f9' => array(
                                'key' => 'layout_61bb426c5b8f9',
                                'name' => 'banner_content_row',
                                'label' => 'Content',
                                'display' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_61bb426c5b8fa',
                                        'label' => '',
                                        'name' => 'banner_content_fields',
                                        'type' => 'flexible_content',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'layouts' => array(
                                            'layout_61bb22af4b191' => array(
                                                'key' => 'layout_61bb22af4b191',
                                                'name' => 'banner_text_row',
                                                'label' => 'Text',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61bb24d33d0b6',
                                                        'label' => 'Text',
                                                        'name' => 'banner_item',
                                                        'type' => 'text',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'default_value' => '',
                                                        'placeholder' => '',
                                                        'prepend' => '',
                                                        'append' => '',
                                                        'maxlength' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                            'layout_61bafe113498d' => array(
                                                'key' => 'layout_61bafe113498d',
                                                'name' => 'banner_image_row',
                                                'label' => 'Image',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61bafc71cb6e1',
                                                        'label' => 'Banner image',
                                                        'name' => 'banner_image',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                    array(
                                                        'key' => 'field_61bb4b1e5c159',
                                                        'label' => 'Banner image (tablet)',
                                                        'name' => 'banner_image_tablet',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                    array(
                                                        'key' => 'field_61bb4b1e5c158',
                                                        'label' => 'Banner image (mobile)',
                                                        'name' => 'banner_image_mobile',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                            'layout_61bb43525b8fd' => array(
                                                'key' => 'layout_61bb43525b8fd',
                                                'name' => 'banner_image_bg_image_row',
                                                'label' => 'Background image',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61bb43525b8fe',
                                                        'label' => 'Background image',
                                                        'name' => 'banner_image_bg_image',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                    array(
                                                        'key' => 'field_61bb4b355c15b',
                                                        'label' => 'Background image (tablet)',
                                                        'name' => 'banner_image_bg_image_tablet',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                    array(
                                                        'key' => 'field_61bb4b355c15a',
                                                        'label' => 'Background image (mobile)',
                                                        'name' => 'banner_image_bg_image_mobile',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                        ),
                                        'button_label' => 'Add Item',
                                        'min' => '',
                                        'max' => '',
                                    ),
                                ),
                                'min' => '',
                                'max' => '',
                            ),
                            'layout_61bafdf73ddc7' => array(
                                'key' => 'layout_61bafdf73ddc7',
                                'name' => 'banner_sale',
                                'label' => 'Sale',
                                'display' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_61bafe0c3ddc8',
                                        'label' => '',
                                        'name' => 'banner_sale_fields',
                                        'type' => 'flexible_content',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'layouts' => array(
                                            'layout_61bafe113498d' => array(
                                                'key' => 'layout_61bafe113498d',
                                                'name' => 'banner_text_row',
                                                'label' => 'Text',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61baf8eaa082d',
                                                        'label' => 'Text',
                                                        'name' => 'banner_item',
                                                        'type' => 'text',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'default_value' => '',
                                                        'placeholder' => '',
                                                        'prepend' => '',
                                                        'append' => '',
                                                        'maxlength' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                            'layout_61bb243022c56' => array(
                                                'key' => 'layout_61bb243022c56',
                                                'name' => 'banner_sale_text_row',
                                                'label' => 'Sale text',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61bb243022c57',
                                                        'label' => 'Sale text',
                                                        'name' => 'banner_item',
                                                        'type' => 'text',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'default_value' => '',
                                                        'placeholder' => '',
                                                        'prepend' => '',
                                                        'append' => '',
                                                        'maxlength' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                            'layout_61bb155bf7765' => array(
                                                'key' => 'layout_61bb155bf7765',
                                                'name' => 'banner_sale_percentage_row',
                                                'label' => 'Sale percentage',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61bb155bf7766',
                                                        'label' => 'Sale percentage',
                                                        'name' => 'banner_item',
                                                        'type' => 'number',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'default_value' => '',
                                                        'placeholder' => '',
                                                        'prepend' => '',
                                                        'append' => '%',
                                                        'min' => '',
                                                        'max' => '',
                                                        'step' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                            'layout_61bafe6d3ddc9' => array(
                                                'key' => 'layout_61bafe6d3ddc9',
                                                'name' => 'banner_sale_image_row',
                                                'label' => 'Sale image',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61bafe6d3ddca',
                                                        'label' => 'Sale image',
                                                        'name' => 'banner_sale_image',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                    array(
                                                        'key' => 'field_61bb4b685c15d',
                                                        'label' => 'Sale image (tablet)',
                                                        'name' => 'banner_sale_image_tablet',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                    array(
                                                        'key' => 'field_61bb4b675c15c',
                                                        'label' => 'Sale image (mobile)',
                                                        'name' => 'banner_sale_image_mobile',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                            'layout_61bafe923ddcb' => array(
                                                'key' => 'layout_61bafe923ddcb',
                                                'name' => 'banner_sale_background_image_row',
                                                'label' => 'Sale background image',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61bafe923ddcc',
                                                        'label' => 'Sale background image',
                                                        'name' => 'banner_sale_background_image',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                    array(
                                                        'key' => 'field_61bb4b6f5c15f',
                                                        'label' => 'Sale background image (tablet)',
                                                        'name' => 'banner_sale_background_image_tablet',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                    array(
                                                        'key' => 'field_61bb4b6f5c15e',
                                                        'label' => 'Sale background image (copy)',
                                                        'name' => 'banner_sale_background_image_copy',
                                                        'type' => 'image',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'return_format' => 'url',
                                                        'preview_size' => 'full',
                                                        'library' => 'all',
                                                        'min_width' => '',
                                                        'min_height' => '',
                                                        'min_size' => '',
                                                        'max_width' => '',
                                                        'max_height' => '',
                                                        'max_size' => '',
                                                        'mime_types' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                        ),
                                        'button_label' => 'Add Item',
                                        'min' => '',
                                        'max' => '',
                                    ),
                                ),
                                'min' => '',
                                'max' => '',
                            ),
                            'layout_61bafbe595496' => array(
                                'key' => 'layout_61bafbe595496',
                                'name' => 'banner_coupon_text_row',
                                'label' => 'Coupon',
                                'display' => 'block',
                                'sub_fields' => array(
                                    array(
                                        'key' => 'field_61bb221e4b18c',
                                        'label' => '',
                                        'name' => 'banner_coupon_fields',
                                        'type' => 'flexible_content',
                                        'instructions' => '',
                                        'required' => 0,
                                        'conditional_logic' => 0,
                                        'wrapper' => array(
                                            'width' => '',
                                            'class' => '',
                                            'id' => '',
                                        ),
                                        'layouts' => array(
                                            'layout_61bafe113498d' => array(
                                                'key' => 'layout_61bafe113498d',
                                                'name' => 'banner_coupon_text_row',
                                                'label' => 'Coupon text',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61bb221e4b18d',
                                                        'label' => 'Coupon text',
                                                        'name' => 'banner_item',
                                                        'type' => 'text',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'default_value' => '',
                                                        'placeholder' => '',
                                                        'prepend' => '',
                                                        'append' => '',
                                                        'maxlength' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                            'layout_61bb22af4b191' => array(
                                                'key' => 'layout_61bb22af4b191',
                                                'name' => 'banner_coupon_code_row',
                                                'label' => 'Coupon code',
                                                'display' => 'block',
                                                'sub_fields' => array(
                                                    array(
                                                        'key' => 'field_61bafbe495495',
                                                        'label' => 'Coupon code',
                                                        'name' => 'banner_item',
                                                        'type' => 'text',
                                                        'instructions' => '',
                                                        'required' => 0,
                                                        'conditional_logic' => 0,
                                                        'wrapper' => array(
                                                            'width' => '',
                                                            'class' => '',
                                                            'id' => '',
                                                        ),
                                                        'default_value' => '',
                                                        'placeholder' => '',
                                                        'prepend' => '',
                                                        'append' => '',
                                                        'maxlength' => '',
                                                    ),
                                                ),
                                                'min' => '',
                                                'max' => '',
                                            ),
                                        ),
                                        'button_label' => 'Add Item',
                                        'min' => '',
                                        'max' => '',
                                    ),
                                ),
                                'min' => '',
                                'max' => '',
                            ),
                        ),
                        'button_label' => 'Add Item',
                        'min' => '',
                        'max' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => 'banner',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'seamless',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

            endif;
    }

    public function plugin_update_checker(){
        require EWORLD_BANNERS_DIR . 'includes/plugin-update-checker/plugin-update-checker.php';
        $myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
            'http://localhost/api/update.json',
            EWORLD_BANNERS_DIR . '/' . $this->plugin_name . '.php',
            $this->plugin_name
        );
    }
}
