<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.eworldsystems.co.uk/
 * @since             1.0.0
 * @package           Eworld_Banners
 *
 * @wordpress-plugin
 * Plugin Name:       EWorld Banners
 * Plugin URI:        https://www.eworldsystems.co.uk/
 * Description:       This is a short description of what the plugin does. It's displayed in the WordPress admin area.
 * Version:           1.0.0
 * Author:            EWorld
 * Author URI:        https://www.eworldsystems.co.uk/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       eworld-banners
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'EWORLD_BANNERS_VERSION', '1.0.0' );
define( 'EWORLD_BANNERS_NAME', 'eworld-banners' );
define( 'EWORLD_BANNERS_DB_PREFIX', 'eb_' );

if( ! defined( 'EWORLD_BANNERS_BASENAME' ) )
    define( 'EWORLD_BANNERS_BASENAME', plugin_basename( __FILE__ ) );

if( ! defined( 'EWORLD_BANNERS_DIR' ) )
    define( 'EWORLD_BANNERS_DIR', plugin_dir_path( __FILE__ ) );

if( ! defined( 'EWORLD_BANNERS_BASE_URL' ) )
    define( 'EWORLD_BANNERS_BASE_URL', plugin_dir_url(__FILE__ ) );

if( ! defined( 'EWORLD_BANNERS_ADMIN_PATH' ) )
    define( 'EWORLD_BANNERS_ADMIN_PATH', plugin_dir_path( __FILE__ ) . 'admin' );

if( ! defined( 'EWORLD_BANNERS_ADMIN_URL' ) )
    define( 'EWORLD_BANNERS_ADMIN_URL', plugin_dir_url( __FILE__ ) . 'admin' );

if( ! defined( 'EWORLD_BANNERS_PUBLIC_PATH' ) )
    define( 'EWORLD_BANNERS_PUBLIC_PATH', plugin_dir_path( __FILE__ ) . 'public' );

if( ! defined( 'EWORLD_BANNERS_PUBLIC_URL' ) )
    define( 'EWORLD_BANNERS_PUBLIC_URL', plugin_dir_url( __FILE__ ) . 'public' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-eworld-banners-activator.php
 */
function activate_eworld_banners() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-eworld-banners-activator.php';
	Eworld_Banners_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-eworld-banners-deactivator.php
 */
function deactivate_eworld_banners() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-eworld-banners-deactivator.php';
	Eworld_Banners_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_eworld_banners' );
register_deactivation_hook( __FILE__, 'deactivate_eworld_banners' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-eworld-banners.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_eworld_banners() {

	$plugin = new Eworld_Banners();
	$plugin->run();

}
run_eworld_banners();
