<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://www.eworldsystems.co.uk/
 * @since      1.0.0
 *
 * @package    Eworld_Banners
 * @subpackage Eworld_Banners/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Eworld_Banners
 * @subpackage Eworld_Banners/includes
 * @author     EWorld <info@eworldsystems.co.uk>
 */
class Eworld_Banners_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'eworld-banners',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
