<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://www.eworldsystems.co.uk/
 * @since      1.0.0
 *
 * @package    Eworld_Banners
 * @subpackage Eworld_Banners/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Eworld_Banners
 * @subpackage Eworld_Banners/public
 * @author     EWorld <info@eworldsystems.co.uk>
 */
class Eworld_Banners_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Eworld_Banners_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Eworld_Banners_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/eworld-banners-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Eworld_Banners_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Eworld_Banners_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/eworld-banners-public.js', array( 'jquery' ), $this->version, false );

	}
    
    // retrieves the attachment ID from the file URL
    public function pippin_get_image_id($image_url) {
        global $wpdb;
        $attachment = $wpdb->get_col($wpdb->prepare("SELECT ID FROM $wpdb->posts WHERE guid='%s';", $image_url )); 
        return $attachment[0]; 
    }
    
    public function eb_header_banner(){
        $banners = get_posts(array(
            'post_type' => 'banner',
            'post_status' => 'publish'
        ));
        foreach( $banners as $key => $banner ):
            $fields = get_field( 'banner_fields', $banner->ID );
        
            $banner_background_image = get_field( 'banner_background_image', $banner->ID );
            $banner_background_image_tablet = get_field( 'banner_background_image_tablet', $banner->ID );
            $banner_background_image_mobile = get_field( 'banner_background_image_mobile', $banner->ID );
        
            $banner_sale_image = '';
            $banner_sale_image_tablet = '';
            $banner_sale_image_mobile = '';
        
            $banner_sale_bg_image = '';
            $banner_sale_bg_image_tablet = '';
            $banner_sale_bg_image_mobile = '';
        
            $banner_image_bg_image = '';
            $banner_image_bg_image_tablet = '';
            $banner_image_bg_image_mobile = '';
        
            $banner_image = '';
            $banner_image_tablet = '';
            $banner_image_mobile = '';
            
            ?>
            <section class="eb_banner_wrap">
                <div class="eb_banner_content">
                <?php
                foreach( $fields as $k => $field ):
        
                    if( isset( $field['banner_text'] ) && $field['banner_text'] != '' ){
                        $banner_text = $field['banner_text'];
                        ?>
                        <div class="eb_banner_text"><?php echo $banner_text; ?></div>
                        <?php
                    }
        
                    if( isset( $field['banner_sale_fields'] ) && $field['banner_sale_fields'] != '' ){

                        $banner_sale_fields = array();
                        
                        foreach( $field['banner_sale_fields'] as $k => $banner_sale_field ){
                            if( strpos( $banner_sale_field['acf_fc_layout'], 'background_image' ) !== false ){
                                $images = array_values( $banner_sale_field );
                                $banner_sale_bg_image = $images[1];
                                $banner_sale_bg_image_tablet = $images[2];
                                $banner_sale_bg_image_mobile = $images[3];
                            }elseif( strpos( $banner_sale_field['acf_fc_layout'], 'image' ) !== false ){
                                $images = array_values( $banner_sale_field );
                                $banner_sale_image = $images[1];
                                $banner_sale_image_tablet = $images[2];
                                $banner_sale_image_mobile = $images[3];
                            }elseif( strpos( $banner_sale_field['acf_fc_layout'], 'sale' ) !== false ){
                                if( strpos( $banner_sale_field['acf_fc_layout'], 'percentage' ) !== false ){
                                    $banner_sale_fields[ 'sales' ][ 'percentage' ] = array_values( $banner_sale_field )[1];
                                }else{
                                    $banner_sale_fields[ 'sales' ][] = array_values( $banner_sale_field )[1];
                                }
                            }else{
                                $banner_sale_fields[ 'text' ] = array_values( $banner_sale_field )[1];
                            }
                        }
                        
                        
                        $i = 0;
                        foreach( $banner_sale_fields as $k => $banner_sale_field ):
                            if( $k == 'text' ){
                                ?>
                                <div class="eb_banner_left">
                                    <div class="eb_banner_text"><?php echo $banner_sale_field; ?></div>
                                <?php
                            }elseif( $k == 'sales' ){
                                ?>
                                <div class="eb_banner_upto">
                                    <div class="eb_banner_upto_img">
                                        <div class="eb_banner_upto_text">
                                        <?php
                                        foreach( $banner_sale_field as $j => $sale_field ):
                                            if( $j === 'percentage' ):
                                            ?>
                                                <div class="eb_banner_upto_percent"><?php echo $sale_field . '%'; ?></div>
                                                <?php
                                            else:
                                                ?>
                                                <div class="eb_banner_upto_text_up"><?php echo $sale_field; ?></div>
                                            <?php
                                            endif;
                                        endforeach;
                                        ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                            }
                            if( $i == count( array_values( $banner_sale_fields ) ) - 1 ):
                                ?></div><?php
                            endif;
                        $i++;
                        endforeach;
                    }
        
                    if( isset( $field['banner_content_fields'] ) && $field['banner_content_fields'] != '' ){
                        $banner_content = array();
                        
                        foreach( $field['banner_content_fields'] as $k => $banner_field ){
                            if( strpos( $banner_field['acf_fc_layout'], 'bg_image' ) !== false ){
                                $images = array_values( $banner_field );
                                $banner_image_bg_image = $images[1];
                                $banner_image_bg_image_tablet = $images[2];
                                $banner_image_bg_image_mobile = $images[3];
                            }elseif( strpos( $banner_field['acf_fc_layout'], 'image' ) !== false ){
                                $images = array_values( $banner_field );
                                $banner_image = $images[1];
                                $banner_image_tablet = $images[2];
                                $banner_image_mobile = $images[3];
                                
                                $image_id = $this->pippin_get_image_id( $banner_image );
                                $banner_image_srcset = '';
                                if( $image_id ){
                                    $banner_image_srcset = wp_get_attachment_image_srcset( $image_id );
                                }
                            }
                            $banner_content[ rtrim(array_values( $banner_field )[0], '_row') ] = array_values( $banner_field )[1];
                        }
                        ?>
                        <div class="eb_banner_deer">
                            <img src="<?php echo $banner_content['banner_image']; ?>" srcset="<?php echo $banner_image_srcset; ?>">
                        </div>
                        <?php
                    }
        
                    if( isset( $field['banner_coupon_fields'] ) && $field['banner_coupon_fields'] != '' ){
                        $banner_coupon_fields = $field['banner_coupon_fields'];
                        ?>
                        <div class="eb_banner_boost">
                            <?php
                            foreach( $banner_coupon_fields as $k => $banner_coupon_field ):
                                $banner_coupon_field_class = $banner_coupon_field['acf_fc_layout'] == 'banner_coupon_code_row' ? 'eb_banner_boost_button' : 'eb_banner_boost_text';
                                ?>
                                <div class="<?php echo $banner_coupon_field_class; ?>"><?php echo $banner_coupon_field['banner_item']; ?></div>
                                <?php
                            endforeach;
                            ?>
                        </div>
                        <?php
                    }

                endforeach;
                ?>
                </div>
                <style>
                    <?php if( $banner_background_image != '' ): ?>
                    .eb_banner_wrap {
                        background-image: url("<?php echo $banner_background_image; ?>");
                    }
                    <?php endif; ?>
                    
                    <?php if( $banner_sale_bg_image != '' ): ?>
                    .eb_banner_upto_img {
                        background-image: url("<?php echo $banner_sale_bg_image; ?>");
                    }
                    <?php endif; ?>
                    
                    <?php if( $banner_image_bg_image != '' ): ?>
                    .eb_banner_deer {
                        background-image: url("<?php echo $banner_image_bg_image; ?>");
                    }
                    <?php endif; ?>
                    
                    @media (max-width: 1024px) {
                        <?php if( $banner_background_image_tablet != '' ): ?>
                        .eb_banner_wrap {
                            background-image: url("<?php echo $banner_background_image_tablet; ?>");
                        }
                        <?php endif; ?>
                        
                        <?php if( $banner_sale_bg_image_tablet != '' ): ?>
                        .eb_banner_upto_img {
                            background-image: url("<?php echo $banner_sale_bg_image_tablet; ?>");
                        }
                        <?php endif; ?>
                    
                        <?php if( $banner_image_bg_image_tablet != '' ): ?>
                        .eb_banner_deer {
                            background-image: url("<?php echo $banner_image_bg_image_tablet; ?>");
                        }
                        <?php endif; ?>
                    }
                    
                    @media (max-width: 600px) {
                        <?php if( $banner_background_image_mobile != '' ): ?>
                        .eb_banner_wrap {
                            background-image: url("<?php echo $banner_background_image_mobile; ?>");
                        }
                        <?php endif; ?>
                        
                        <?php if( $banner_sale_bg_image_mobile != '' ): ?>
                        .eb_banner_upto_img {
                            background-image: url("<?php echo $banner_sale_bg_image_mobile; ?>");
                        }
                        <?php endif; ?>
                    
                        <?php if( $banner_image_bg_image_mobile != '' ): ?>
                        .eb_banner_deer {
                            background-image: url("<?php echo $banner_image_bg_image_mobile; ?>");
                        }
                        <?php endif; ?>
                    }
                </style>
            </section>
            <?php
        endforeach;
    }
}
