<?php



/**

* Plugin Name: E-World CSV Reviews Import

* Description: Importing reviews in CSV

* Version:  0.0.1

* Author: E-World

* Author URI: https://www.facebook.com/eworldllc/

**/



if(!defined('ABSPATH')) exit;



if(!class_exists('eworld_csv_import')){



    final class eworld_csv_import {



        private static $instance, $errors, $report;



        public static function push_error($error){

            if(!self::$errors) self::$errors = array();

            self::$errors[] = '<p><strong>' . $error . '</strong></p>';

        }



        public static function push_report($report_text){

            if(!self::$report) self::$report = array();

            self::$report[] = '<p>' . $report_text . '</p>';

        }

        public static function get_errors(){

            return implode(self::$errors);

        }

        public static function get_report(){

            return implode(self::$report);

        }



        public static function init(){

            if(!self::$instance){

                self::get_instance();

            } else {

                return;

            }

            self::add_plugin_links();

            self::get_instance()->add_plugin_menu_page();

            self::import_reviews();

        }



        private static function add_plugin_links(){

            add_action('init', function(){

                add_filter('plugin_action_links_'.plugin_basename(__FILE__), function($links){

                    array_unshift($links, 

                        '<a href="' .

                        admin_url( 'tools.php?page=eworld_csv_import_reviews' ) .

                        '">' . __('Import') . '</a>'

                    );

                    return $links;

                });

            });

        }

        

        public function add_plugin_menu_page(){

            add_action('admin_menu', function(){

                add_submenu_page(

                    'tools.php',

                    'Reviews CSV Import', 

                    'Reviews CSV Import', 

                    'manage_options', 

                    'eworld_csv_import_reviews', 

                    array($this, 'render_menu_page_content'), 

                    'dashicons-format-status',

                    55

                );

            });

        }



        public static function post_reviews($data){

            $post_comment_data = array();

            $total_comment_count = 0;

            for($i = 0; $i < count($data); $i++){

                $comment = $data[$i];

                $post_id = $comment[0];

                $content = $comment[1];

                $author = $comment[2];

                $rating = $comment[3];

                // check for a valid date and time

                if(boolval(strtotime($comment[4]))){

                    $date = date('Y-m-d H:i:s', strtotime($comment[4]));

                    // check if post is a product

                    if(get_post_type($post_id) == 'product'){

                        // insert comment

                        $inserted_comment_id = wp_insert_comment( array(

                            'comment_post_ID'      => $post_id,

                            'comment_author'       => $author,

                            'comment_content'      => $content,

                            'comment_type'         => 'review',

                            'comment_date'         => $date,

                            'comment_approved'     => 1

                        ));

                        update_comment_meta( $inserted_comment_id, 'rating', $rating );

                        // store data for report

                        $post_comment_data[$post_id] = $post_comment_data[$post_id] ? $post_comment_data[$post_id] + 1 : 1;

                        $total_comment_count++;

                    }

                } else {

                    self::push_error('There is an issue with date parsing!');

                }

            }



            // loop the report data and push

            foreach($post_comment_data as $post_id => $value){

                self::push_report('<strong>' . $value . '</strong> review(s) are added to <a href="' . get_permalink($post_id) . '" target="_blank"><strong>' . get_the_title($post_id) . '</strong></a>');

            }

            self::push_report('<h3 style="margin-bottom: 5px;">Total <strong>' . $total_comment_count . '</strong> review(s) are added</h3>');

        }



        /**

         * Parsing CSV file

         * @source https://stackoverflow.com/a/8099915

         */

        private static function parse_csv($file){

            $fp = fopen($file, 'rb');

            $data = array();

            while(!feof($fp)){

                $data[] = fgetcsv($fp);

            }

            return $data;

        }



        private static function import_reviews(){

            add_action('init', function(){

                if(is_admin() && isset($_POST['_wpnonce']) &&  wp_verify_nonce($_POST['_wpnonce'], 'import_csv_reviews')){

                    // check if file is uploaded

                    if(isset($_FILES['csv']) && file_exists($_FILES['csv']['tmp_name'])){

                        // check if file has json extension

                        if(pathinfo($_FILES['csv']['name'], PATHINFO_EXTENSION) == 'csv'){

                            $parsed_data = self::parse_csv($_FILES['csv']['tmp_name']);

                            // check if json is valid

                            if($parsed_data){

                                self::post_reviews($parsed_data);

                            } else {

                                self::push_error('The issue occured parsing CSV file!');

                            }

                        } else {

                            self::push_error('File must have CSV extension');

                        }

                    } else {

                        self::push_error('CSV File is required!');

                    }

                }

            });

        }



        public function render_menu_page_content(){

            // register nonces

            $import_nonce = wp_create_nonce('import_csv_reviews');

            ?>

            <div class="wrap">

                <h1>Import product reviews in CSV format</h1>

                <?php self::render_errors() ?>

                <?php self::render_report() ?>

                <h2 style="margin: 10px 0 8px;">Import reviews</h2>

                <form enctype="multipart/form-data" action="" method="post">

                    <?php wp_nonce_field('import_csv_reviews', '_wpnonce') ?>

                    <input required="true" type="file" name="csv" style="border: 1px solid lightgray; padding: 5px; border-radius: 2px; background: white;">

                    <p>

                        <input type="submit" class="button button-primary" value="Import Reviews">

                    </p>

                </form>

            </div>

            <?php

        }

        public static function render_errors(){

            if(self::$errors){

                ?>

                <div class="notice notice-error">

                    <h3 style="margin-bottom: 0;">Error:</h3>

                    <?=self::get_errors()?>

                </div>

            <?php

            }

        }

        public static function render_report(){

            if(self::$report){

                ?>

                <div class="notice notice-info">

                    <h3>Imported Data:</h3>

                    <?=self::get_report()?>

                </div>

            <?php

            }

        }

        public static function get_instance(){

            if(static::$instance == NULL){

                static::$instance = new eworld_csv_import();

            }

            return static::$instance;

        }

    }

    eworld_csv_import::init();

}