<?php

/**
* Plugin Name: E-World Products CSV Export
* Description: Export WooCommerce products
* Version:  0.0.1
* Author: E-World
* Author URI: https://www.facebook.com/eworldllc/
**/

if(!defined('ABSPATH')) exit;

if(!class_exists('eworld_csv_product_export')){

    final class eworld_csv_product_export {

        private static $instance;

        public static function get_instance(){
            if(static::$instance == NULL){
                static::$instance = new eworld_csv_product_export();
            }
            return static::$instance;
        }

        public static function init(){
            if(!self::$instance){
                self::get_instance();
                self::add_plugin_links();
                self::get_instance()->add_plugin_menu_page();
                self::export_products();
            }
        }

        private static function add_plugin_links(){
            add_action('init', function(){
                add_filter('plugin_action_links_'.plugin_basename(__FILE__), function($links){
                    array_unshift($links, 
                        '<a href="' .
                        admin_url('edit.php?post_type=product&page=eword-csv-product-export') .
                        '">' . __('Export Products') . '</a>'
                    );
                    return $links;
                });
            });

        }

        public function add_plugin_menu_page(){
            add_action('admin_menu', function(){
                add_submenu_page( 
                    'edit.php?post_type=product',
                    'Product CSV Export', 
                    'CSV Export', 
                    'manage_options', 
                    'eword-csv-product-export', 
                    array($this, 'render_menu_page_content'), 
                    'dashicons-format-status',
                    55
                );
            });
        }

        private static function get_product_price($price, $product){
            $price_output = '';
            $currency = get_woocommerce_currency_symbol();
            switch ($price){
                case 'sale':
                    if($product->is_on_sale()){
                        if($product->is_type('variable')){
                            $price_output = $product->get_variation_sale_price('min');
                        } else {
                            $price_output = $product->get_sale_price();
                        }
                    }
                    break;
                case 'regular':
                    if($product->is_type('variable')){
                        $price_output = $product->get_variation_regular_price('min');
                    } else {
                        $price_output = $product->get_regular_price();
                    }
                    break;
            }
            return $price_output;
        }

        public static function generate_products_csv(){
            // query products
            $query = new WC_Product_Query(array(
                'limit' => -1,
            ));
            $products = $query->get_products();

            // csv headers
            header('Content-Disposition: attachment; filename="' . date("m-d-y") . '-products-export.csv"');
            header('Content-Type: text/csv');
            header('Expires: 0');
            header('Cache-Control: no-cache');
            // output buffering
            ob_start();
            // output handle
            $fp = fopen('php://output', 'wb');
            // put header info
            fputcsv($fp, array(
                "ID",
                "NAME",
                "PERMALINK",
                "FEATURED_IMAGE",
                "REGULAR_PRICE",
                "SALE_PRICE",
                "SHORT_DESCRIPTION"
            ));

            // loop products and put csv
            for($i = 0; $i < count($products); $i++){
                $product = $products[$i];
                if(is_a($product, 'WC_Product') && $product->get_id()){
                    $to_put = array(
                        $product->get_id(), // ID
                        sanitize_text_field($product->get_name()), // NAME
                        $product->get_permalink(), // PERMALINK
                        wp_get_attachment_image_src($product->get_image_id(), 'full')[0], // FEATURED_IMAGE
                        sanitize_text_field(self::get_product_price('regular', $product)), // REGULAR_PRICE
                        sanitize_text_field(self::get_product_price('sale', $product)), // SALE_PRICE
                        sanitize_text_field($product->get_short_description()) // SHORT_DESCRIPTION
                    );
                    fputcsv($fp, $to_put);
                }
            }
            // buffer size
            $size = ob_get_length();
            fclose($fp);
            // size header
            header('Content-Length: '. $size);
            // flush buffering
            ob_end_flush();
            // stop scripts
            exit();
        }

        private static function export_products(){
            add_action('init', function(){
                if(isset($_GET['_wpnonce']) && wp_verify_nonce($_GET['_wpnonce'], 'export_products')){
                    self::generate_products_csv();
                }
            });
        }

        public function render_menu_page_content(){
            $export_nonce = wp_create_nonce('export_products');
            ?>
            <div class="wrap">
                <h1>Export WooCommerce Products</h1>
                <h2 style="margin-bottom: 5px;">Export products</h2>
                <a href="<?=add_query_arg(array('_wpnonce'=>$export_nonce));?>" target="_blank" class="button button-primary" style="margin: 10px 0;">Export All Products</a>
            </div>
            <?php
        }
    }
    eworld_csv_product_export::init();
}