<?php
/**
* Plugin Name: E-World Installation Requests
* Description: Adding <strong>[installation-form]</strong> shortcode and <strong>Installation Requests</strong> Menu Page
* Version: 0.0.2
* Author: E-World
* Author URI: https://www.facebook.com/eworldllc/
* Requires: ACF PRO
**/

if(!defined('ABSPATH')) exit;

if(!class_exists('eworld_installation_request_form')){

  final class eworld_installation_request_form {

    private static $instance, $errors;

    public static function init(){

      if(!self::check_deps()){

        self::deactivate();

        return;

      }

      if(!self::$instance){

        self::get_instance();

      } else {

        return;

      }

      self::create_post_type();

      self::init_post_pattern();

      self::add_post_type_template();

      self::enqueue_assets();

      self::add_acf_option_sub_page();

      self::create_acf_field_group();

      self::add_shortcode();

      self::add_plugin_settings_link();

    }

    /**
     * @return string post_type
     * @since 0.0.2
     */
    public static function get_post_type(){

      return 'installation_request';

    }

    /**
     * Get Errors
     * @return array of errors
     * @uses 
     *  errors static variable
     * @since 0.0.2
     */
    public static function get_error(){

      if(!self::$errors) return '';

      return self::$errors;

    }

    /**
     * Set error
     * @uses 
     *  errors static variable
     *  @method get_error_message_data
     * @since 0.0.2
     */
    public static function set_error($error_slug){

      $error_data = self::get_error_message_data();

      if(isset($error_data['errors']) && isset($error_data['errors']['undefined_error'])){

        if(isset($error_data['errors'][$error_slug])){

          self::$errors = $error_data['errors'][$error_slug];

        } else {

          self::$errors = $error_data['errors']['undefined_error'];

        }

      } else {

        self::$errors = '';

      }

    }

    /**
     * Deactivate This Plugin
     * @hook admin_init
     * @since 0.0.2
     */
    public static function deactivate(){

      add_action('admin_init', function(){

        deactivate_plugins(__FILE__);

      });

    }

    /**
     * Check Plugin Dependencies
     * @return boolean
     * @since 0.0.2
     */
    private static function check_deps(){

      if(!class_exists('ACF')){

        return false;

      }

      return true;
      
    }

    /**
     * Add template to 'installation_request' post type
     * @uses 
     *  @method render_template
     *  @method get_post_type
     * @hook single_template
     * @since 0.0.2
    */
    public static function add_post_type_template(){

      add_filter('single_template', function($template){

        global $post;

        if($post->post_type == self::get_post_type()){
     
          return plugin_dir_path(__FILE__) . '/render/post.php';

        }

        return $template;

      }, 99);

    }

    /**
     * Init Post Pattern for posting a request
     * @uses 
     *  @method try_post
     *  @method validate_form
     *  @method post_installation_request
     * @hook template_redirect
     * @since 0.0.2
    */
    public static function init_post_pattern(){

      add_action('template_redirect', function(){

        if(self::try_post()){

          if(self::validate_form() == true){

            if(self::post_request() == true){
  
              self::return_json(array(
  
                "status" => "posted"
  
              ));
  
            } else {

              self::return_json(array(
  
                "status" => "error",

                "error" => self::get_error()
  
              ));

            }
  
          } else {

            self::return_json(array(
  
              "status" => "error",

              "error" => self::get_error()

            ));
  
          }

        }

      });

    }

    /**
     * Adding schortcode settings option link
     * @since 0.0.2
     */
    private static function add_plugin_settings_link(){

      add_filter('plugin_action_links_'.plugin_basename(__FILE__), function($links){
          
          array_unshift($links, '<a href="' .
          admin_url( 'edit.php?post_type=installation_request&page=acf-installation-form-customize' ) .
          '">' . __('Customize Shortcode') . '</a>');
          
          return $links;
      });

    }

    /**
     * Returns given JSON and stops all scripts
     * @since 0.0.2
     * 
     */
    private static function return_json($arr){

      header('Content-Type: application/json');

      echo json_encode($arr);

      exit();

    }
    
    /**
     * Posts the Request
     * @since 0.0.2
     * @uses 
     *  @method get_form_data,
     *  @method get_form_field_label
     *  @method post_has_dublicates
     *  @method post_attachments
     *  @method post_mail
     *  @method set_error
     *  @method get_post_type
     * @return boolean true if posted succesfully
     */
    public static function post_request(){

      // post title 
      $post_title = sanitize_text_field($_POST['first_name']);

      // form html content
      $post_content = '<ul style="padding: 10px 10px 10px 25px;">';

      foreach(self::get_form_data() as $field_key=>$field_value){

        if(array_key_exists($field_key, $_POST) && !empty(sanitize_text_field($_POST[$field_key]))){

          $post_content .= '<li><strong>' . self::get_form_field_label($field_value) . '</strong> ';

          $post_content .= sanitize_text_field($_POST[$field_key]) . '</li>';

        }

      }

      // check for dublicates
      if(self::post_has_dublicates($post_content)){

        self::set_error('dublicate_error');

        return false;

      }

      // post the attachemnts
      if(isset($_FILES['installation_upload'])){

        $attachemnts = self::post_attachments($_FILES['installation_upload']);

        if(!$attachemnts == false && !is_array($attachemnts)){
  
          self::set_error('attachment_error');
  
          return false;
  
        } else {
  
          foreach($attachemnts as $attachemnt_id){
            
            $image_src = wp_get_attachment_image_src($attachemnt_id, 'small')[0];
  
            $image_full_src = wp_get_attachment_image_src($attachemnt_id, 'full')[0];
  
            $post_content .= '<li><a href="' . $image_full_src . '" target="_blank"><img src="' . $image_src . '" width="200"></a></li>';
  
          }
  
        }

      }

      $post_content .= '</ul>';
      
      $post_id = wp_insert_post(array(
        'post_type' => self::get_post_type(),
        'post_title' => $post_title,
        'post_content' => $post_content,
        'post_status' => 'publish',
        'comment_status' => 'closed',
        'publicly_queryable' => true,
        'ping_status' => 'closed',
      ), true);

      if(is_wp_error($post_id)){

        self::set_error('undefined_error');

        return false;

      } 

      self::post_mail($post_content, filter_var($_POST['email'], FILTER_SANITIZE_EMAIL));

      return true;

    }

    /**
     * Posts files as an attacment
     * @since 0.0.2
     * @return array|false 
     *  array of attachment ids
     *  empty array if there are no images
     *  or false if error occured
     */
    public static function post_attachments($files){

      $to_return = array();

      if(!$files || empty($files['tmp_name'])) return array();

      for($i=0; $i < count($files['tmp_name']); $i++){ 
         
        $file_temp = $files['tmp_name'][$i];

        if(!$file_temp) continue;

        $file_name = $files['name'][$i];

        $file_mime_type = mime_content_type($file_temp);

        $file_path = wp_upload_dir()['path'] . '/' . $file_name;

        if(!move_uploaded_file($file_temp, $file_path)) return false;

        $attachemnt_id = wp_insert_attachment(array(
          'guid'           => $file_path,
          'post_mime_type' => $file_mime_type,
          'post_title'     => sanitize_file_name($file_name),
          'post_content'   => '',
          'post_status'    => 'inherit'
        ), $file_path, true);

        if(is_wp_error($attachemnt_id)){

          return false;
  
        }

        require_once(ABSPATH . 'wp-admin/includes/image.php');

        wp_update_attachment_metadata($attachemnt_id, wp_generate_attachment_metadata($attachemnt_id, $file_path));

        $to_return[] = $attachemnt_id;

      }

      return $to_return;

    }

    /**
     * Posts Email
     * @uses @method get_mail_data
     * @param message (string)
     * @param subject (string)
     * @return boolean true if posted successfully
     * @since 0.0.2
     */
    public static function post_mail($message = '', $to = ''){

      require_once("wp-load.php");

      $mail_data = self::get_mail_data();

      // add recipients if there are ones in mail data
      if($mail_data['recipients'] && !empty($mail_data['recipients'])){

        $recipients_to_merge = array_map(function($item){

          return filter_var($item['email_address'], FILTER_SANITIZE_EMAIL);

        }, $mail_data['recipients']);

        $to = array_merge(array($to), $recipients_to_merge);

      }

      $headers = array(
        'content-type: text/html', 
        'From: ' . $mail_data['from']
      );

      wp_mail($to, $mail_data['subject'], $message, $headers);

    }

     /**
     * @since 0.0.2
     * @return string formfield label
     */
    public static function get_form_field_label($field){

      if(is_string($field)) return $field;

      if(is_array($field) && isset($field['title'])) return $field['title'];

    }

    /**
     * Check if user try to post
     * @since 0.0.2
     * @return boolean
     */
    public static function try_post(){

      if(!isset($_POST['nonce'])) return false;

      if(!wp_verify_nonce($_POST['nonce'], 'post_' . self::get_post_type())) return false;

      return true;

    }

    /**
     * @since 0.0.2
     * @return boolean
     * @uses:
     *  @method get_validated_fields, 
     *  wp_nonce_field function
     *  checking 'nonce' field width 'post_installation' action
     */
    public static function validate_form(){

      foreach(self::get_validated_fields() as $field_key=>$field_rules){

        $field_value = sanitize_text_field($_POST[$field_key]);

        if(array_key_exists('required', $field_rules) && $field_rules['required'] == true && empty($field_value)){

          return false;

        } if(array_key_exists('email', $field_rules) && $field_rules['email'] == true && !filter_var($field_value, FILTER_VALIDATE_EMAIL)){

          return false;

        }

      }

      return true;

    }

    /**
     * @since 0.0.2
     * @return boolean true if dublicates were found
     * @global wpdb
     */
    public static function post_has_dublicates($content){

      global $wpdb;

      $query =  "SELECT COUNT(*) as n FROM {$wpdb->prefix}posts WHERE post_type = " . "'" . self::get_post_type() . "'" . " AND post_status = 'publish'";

      foreach(self::get_validated_fields() as $field_key=>$field){

        $keyword = sanitize_text_field($_POST[$field_key]);

        $query .= " AND post_content LIKE '%$keyword%'";

      }

      $result = $wpdb->get_results($query, OBJECT);

      $number_of_posts = intval($result[0]->n);

      if($number_of_posts > 0) return true;

      return false;

    }

    /**
     * @since 0.0.2
     * @return array of registered fields with validation requirements
     */
    public static function get_validated_fields(){

      return array(
        'first_name' => array(
          'required' => true
        ),
        'phone_number' => array(
          'required' => true
        ),
        'last_name' => array(
          'required' => true
        ),
        'email' => array(
          'required' => true,
          'email' => true
        ),
        'street_address' => array(
          'required' => true
        ),
        'city' => array(
          'required' => true
        ),
        'postcode' => array(
          'required' => true
        ),
        'project_type' => array(
          'required' => true
        )
      );

    }

    /**
     * @since 0.0.2
     * @return array of form data from ACF cusom field
     */
    private static function get_mail_data(){

      if(!function_exists('get_field')) return NULL;

      return get_field('installation_form_mail_data', 'option');

    }

    /**
     * @since 0.0.2
     * @return array of form data from ACF cusom field
     */
    private static function get_error_message_data(){

      if(!function_exists('get_field')) return NULL;

      return get_field('installation_form_error_message', 'option');

    }

    /**
     * @since 0.0.2
     * @return array of form data from ACF cusom field
     */
    private static function get_success_message_data(){

      if(!function_exists('get_field')) return NULL;

      return get_field('installation_form_success_message', 'option');

    }

    /**
     * @since 0.0.2
     * @return array of form data from ACF cusom field
     */
    private static function get_form_data(){

      if(!function_exists('get_field')) return NULL;

      return get_field('installation_form', 'option');

    }

    /**
     * Add [installation-form] Shortcode
     * @since 0.0.2
     * @uses:
     *  @method validate_form,
     *  @method render_template
     */
    public static function add_shortcode(){

      add_action('wp_head', function(){

        if(!self::if_page_is_included()) return;

        add_shortcode('installation-form', function(){

          self::render_template('success');
  
          self::render_template('error');
  
          self::render_template('form');
  
        });

      });

    }

    /**
     * Rendering plugin template
     * @since 0.0.2
     */
    public static function render_template($template_slug){

      $template = 'render/' . $template_slug . '.php';

      if(!file_exists(dirname( __FILE__ ) . '/' . $template)) return;

      require $template;

    }

    /**
    * Function to check if field is validated
    * @since 0.0.2
    * @return boolean
    * @uses @method get_validated_fields
    */
   private static function is_validated($field_name){

     if(array_key_exists($field_name, self::get_validated_fields()) && !empty(self::get_validated_fields()[$field_name])){

       return true;

     }

     return false;

   }

    /**
     * Add acf custom fields attached to the option page 
     * @source ACF Export Fields Tool
     * @since 0.0.2
     * Requires 'acf_add_local_field_group' function (ACF Core)
     */
    public static function create_acf_field_group(){

      if( function_exists('acf_add_local_field_group') ){

        acf_add_local_field_group(array(
          'key' => 'group_5d5a53b52886c',
          'title' => 'Installation Requests Customize',
          'fields' => array(
            array(
              'key' => 'field_5d5f9fe091b42',
              'label' => 'Pages to Setup',
              'name' => 'installation_form_pages',
              'type' => 'post_object',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'post_type' => '',
              'taxonomy' => '',
              'allow_null' => 0,
              'multiple' => 1,
              'return_format' => 'id',
              'ui' => 1,
            ),
            array(
              'key' => 'field_5d5fa02d91b43',
              'label' => 'Note',
              'name' => '',
              'type' => 'message',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'message' => 'Use the <b>Pages to Setup</b> to optimize your website!. When you choose the pages you want to setup the form all styles and scripts, including the shortcode will be active only on chosen specific pages! This will exclude unnecessary media to be uploaded on all pages!',
              'new_lines' => 'wpautop',
              'esc_html' => 0,
            ),
            array(
              'key' => 'field_5d5a5b75b5f88',
              'label' => 'Form',
              'name' => '',
              'type' => 'tab',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'placement' => 'top',
              'endpoint' => 0,
            ),
            array(
              'key' => 'field_5d5a57c2b5f87',
              'label' => 'Form Customize',
              'name' => 'installation_form',
              'type' => 'group',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'layout' => 'block',
              'sub_fields' => array(
                array(
                  'key' => 'field_5d5a5c0f25df0',
                  'label' => 'Form Title',
                  'name' => 'title1',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'HIRE AN EXPERT',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a5c6025df1',
                  'label' => 'Form Description',
                  'name' => 'description1',
                  'type' => 'textarea',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'If you encounter any challenges during the installation process, feel free to request an installation service. They have specialists who are eager to come to your assistance. Send us a request and we will get back to you with specialists who will be happy to assist.',
                  'placeholder' => '',
                  'maxlength' => '',
                  'rows' => 4,
                  'new_lines' => '',
                ),
                array(
                  'key' => 'field_5d5a5dfb6e0fa',
                  'label' => 'CONTACT INFORMATION',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 0,
                ),
                array(
                  'key' => 'field_5d5a5e1c6e0fc',
                  'label' => 'Title',
                  'name' => 'contact_information_title',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'CONTACT INFORMATION',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a5fb375588',
                  'label' => 'First Name (label)',
                  'name' => 'first_name',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'First Name:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a5fc475589',
                  'label' => 'Company Name (label)',
                  'name' => 'company_name',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Company Name:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a5fd17558a',
                  'label' => 'Email (label)',
                  'name' => 'email',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Email:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a604b7558b',
                  'label' => 'Phone Number (label)',
                  'name' => 'phone_number',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Phone Number:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a60697558c',
                  'label' => 'Last Name (label)',
                  'name' => 'last_name',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Last Name:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a60ab7558d',
                  'label' => 'Preferred contact method',
                  'name' => 'contact_method',
                  'type' => 'group',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'layout' => 'row',
                  'sub_fields' => array(
                    array(
                      'key' => 'field_5d5a60b77558e',
                      'label' => 'Title',
                      'name' => 'title',
                      'type' => 'text',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => 'Preferred contact method:',
                      'placeholder' => '',
                      'prepend' => '',
                      'append' => '',
                      'maxlength' => '',
                    ),
                    array(
                      'key' => 'field_5d5a60bd7558f',
                      'label' => 'Choices',
                      'name' => 'choices',
                      'type' => 'repeater',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'collapsed' => '',
                      'min' => 2,
                      'max' => 0,
                      'layout' => 'row',
                      'button_label' => 'Add Choice',
                      'sub_fields' => array(
                        array(
                          'key' => 'field_5d5a60cf75590',
                          'label' => 'Label',
                          'name' => 'label',
                          'type' => 'text',
                          'instructions' => '',
                          'required' => 1,
                          'conditional_logic' => 0,
                          'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                          ),
                          'default_value' => '',
                          'placeholder' => '',
                          'prepend' => '',
                          'append' => '',
                          'maxlength' => '',
                        ),
                      ),
                    ),
                  ),
                ),
                array(
                  'key' => 'field_5d5a5e116e0fb',
                  'label' => 'CONTACT INFORMATION END',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 1,
                ),
                array(
                  'key' => 'field_5d5a62ea1e126',
                  'label' => 'INSTALLATION SITE DETAILS',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 0,
                ),
                array(
                  'key' => 'field_5d5a6483a2f98',
                  'label' => 'Title',
                  'name' => 'installation_site_details_title',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'INSTALLATION SITE DETAILS',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a62fc1e128',
                  'label' => 'Street Address',
                  'name' => 'street_address',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Street Address:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a630d1e129',
                  'label' => 'City',
                  'name' => 'city',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'City:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a63191e12a',
                  'label' => 'County',
                  'name' => 'county',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'County:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a632b1e12b',
                  'label' => 'Postcode',
                  'name' => 'postcode',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Postcode:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a63301e12c',
                  'label' => 'Project Type',
                  'name' => 'project_type',
                  'type' => 'group',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'layout' => 'row',
                  'sub_fields' => array(
                    array(
                      'key' => 'field_5d5a63441e12d',
                      'label' => 'Title',
                      'name' => 'title',
                      'type' => 'text',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => 'Project Type:',
                      'placeholder' => '',
                      'prepend' => '',
                      'append' => '',
                      'maxlength' => '',
                    ),
                    array(
                      'key' => 'field_5d5a63b6e6d01',
                      'label' => 'Default Label',
                      'name' => 'default_label',
                      'type' => 'text',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => '- Please Select -',
                      'placeholder' => '',
                      'prepend' => '',
                      'append' => '',
                      'maxlength' => '',
                    ),
                    array(
                      'key' => 'field_5d5a63581e12e',
                      'label' => 'Choices',
                      'name' => 'choices',
                      'type' => 'repeater',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'collapsed' => '',
                      'min' => 2,
                      'max' => 0,
                      'layout' => 'row',
                      'button_label' => 'Add Choice',
                      'sub_fields' => array(
                        array(
                          'key' => 'field_5d5a63641e12f',
                          'label' => 'Label',
                          'name' => 'label',
                          'type' => 'text',
                          'instructions' => '',
                          'required' => 1,
                          'conditional_logic' => 0,
                          'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                          ),
                          'default_value' => '',
                          'placeholder' => '',
                          'prepend' => '',
                          'append' => '',
                          'maxlength' => '',
                        ),
                      ),
                    ),
                  ),
                ),
                array(
                  'key' => 'field_5d5a6572f6778',
                  'label' => 'Total Coverage Area',
                  'name' => 'total_coverage_area',
                  'type' => 'group',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'layout' => 'row',
                  'sub_fields' => array(
                    array(
                      'key' => 'field_5d5a6572f6779',
                      'label' => 'Title',
                      'name' => 'title',
                      'type' => 'text',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => 'Total Coverage Area:',
                      'placeholder' => '',
                      'prepend' => '',
                      'append' => '',
                      'maxlength' => '',
                    ),
                    array(
                      'key' => 'field_5d5a6572f677a',
                      'label' => 'Default Label',
                      'name' => 'default_label',
                      'type' => 'text',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => '- Please Select -',
                      'placeholder' => '',
                      'prepend' => '',
                      'append' => '',
                      'maxlength' => '',
                    ),
                    array(
                      'key' => 'field_5d5a6572f677b',
                      'label' => 'Choices',
                      'name' => 'choices',
                      'type' => 'repeater',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'collapsed' => '',
                      'min' => 2,
                      'max' => 0,
                      'layout' => 'row',
                      'button_label' => 'Add Choice',
                      'sub_fields' => array(
                        array(
                          'key' => 'field_5d5a6572f677c',
                          'label' => 'Label',
                          'name' => 'label',
                          'type' => 'text',
                          'instructions' => '',
                          'required' => 1,
                          'conditional_logic' => 0,
                          'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                          ),
                          'default_value' => '',
                          'placeholder' => '',
                          'prepend' => '',
                          'append' => '',
                          'maxlength' => '',
                        ),
                      ),
                    ),
                  ),
                ),
                array(
                  'key' => 'field_5d5a65ffd03b8',
                  'label' => '# of Users',
                  'name' => 'users',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => '# of Users:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a660dd03b9',
                  'label' => '# of Floors',
                  'name' => 'floors',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => '# of Floors:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a70c90f530',
                  'label' => 'Project Budget',
                  'name' => 'project_budget',
                  'type' => 'group',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'layout' => 'row',
                  'sub_fields' => array(
                    array(
                      'key' => 'field_5d5a70c90f531',
                      'label' => 'Title',
                      'name' => 'title',
                      'type' => 'text',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => 'What is your project budget?',
                      'placeholder' => '',
                      'prepend' => '',
                      'append' => '',
                      'maxlength' => '',
                    ),
                    array(
                      'key' => 'field_5d5a70c90f532',
                      'label' => 'Default Label',
                      'name' => 'default_label',
                      'type' => 'text',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => '- Please Select -',
                      'placeholder' => '',
                      'prepend' => '',
                      'append' => '',
                      'maxlength' => '',
                    ),
                    array(
                      'key' => 'field_5d5a70c90f533',
                      'label' => 'Choices',
                      'name' => 'choices',
                      'type' => 'repeater',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'collapsed' => '',
                      'min' => 2,
                      'max' => 0,
                      'layout' => 'row',
                      'button_label' => 'Add Choice',
                      'sub_fields' => array(
                        array(
                          'key' => 'field_5d5a70c90f534',
                          'label' => 'Label',
                          'name' => 'label',
                          'type' => 'text',
                          'instructions' => '',
                          'required' => 1,
                          'conditional_logic' => 0,
                          'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                          ),
                          'default_value' => '',
                          'placeholder' => '',
                          'prepend' => '',
                          'append' => '',
                          'maxlength' => '',
                        ),
                      ),
                    ),
                  ),
                ),
                array(
                  'key' => 'field_5d5a661fd03ba',
                  'label' => 'Approximate dimensions',
                  'name' => 'approximate_dimensions',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Approximate dimensions:',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a62f31e127',
                  'label' => 'INSTALLATION SITE DETAILS END',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 1,
                ),
                array(
                  'key' => 'field_5d5a66a2d03bd',
                  'label' => 'UPLOADS',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 0,
                ),
                array(
                  'key' => 'field_5d5a66c9d03bf',
                  'label' => 'Title',
                  'name' => 'uploads_title',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'UPLOAD A FLOOR PLAN',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5d23775788e',
                  'label' => 'Field Label',
                  'name' => 'uploads_field_label',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'You can upload multiple images',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a66c1d03be',
                  'label' => 'UPLOADS END',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 1,
                ),
                array(
                  'key' => 'field_5d5a71fb20bd2',
                  'label' => 'ADDITIONAL COMMENTS & REQUESTS',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 0,
                ),
                array(
                  'key' => 'field_5d5a721020bd4',
                  'label' => 'Title',
                  'name' => 'comments',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'ADDITIONAL COMMENTS & REQUESTS',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a720920bd3',
                  'label' => 'ADDITIONAL COMMENTS & REQUESTS END',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 1,
                ),
                array(
                  'key' => 'field_5d5a723a02194',
                  'label' => 'SUBMIT BUTTON',
                  'name' => 'submit_button',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Submit',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
              ),
            ),
            array(
              'key' => 'field_5d5a8c1fef5dc',
              'label' => 'Success',
              'name' => '',
              'type' => 'tab',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'placement' => 'top',
              'endpoint' => 0,
            ),
            array(
              'key' => 'field_5d5a8bb9ef5d7',
              'label' => 'Success Message',
              'name' => 'installation_form_success_message',
              'type' => 'group',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'layout' => 'block',
              'sub_fields' => array(
                array(
                  'key' => 'field_5d5a8bc7ef5d8',
                  'label' => 'Title',
                  'name' => 'title',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Thank You!',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5a8be5ef5d9',
                  'label' => 'Text',
                  'name' => 'content',
                  'type' => 'textarea',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Your form has been successfully submitted. We appreciate you contacting Booster Planet Customer Support. We\'ll respond to your request within 1 - 2 business days.',
                  'placeholder' => '',
                  'maxlength' => '',
                  'rows' => 4,
                  'new_lines' => '',
                ),
                array(
                  'key' => 'field_5d5a8c07ef5db',
                  'label' => 'CTA Link',
                  'name' => 'cta_link',
                  'type' => 'page_link',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'post_type' => '',
                  'taxonomy' => '',
                  'allow_null' => 0,
                  'allow_archives' => 1,
                  'multiple' => 0,
                ),
                array(
                  'key' => 'field_5d5a8bfdef5da',
                  'label' => 'CTA Link Text',
                  'name' => 'cta_link_text',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Keep Shopping',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
              ),
            ),
            array(
              'key' => 'field_5d5d0d5973f0e',
              'label' => 'Errors',
              'name' => '',
              'type' => 'tab',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'placement' => 'top',
              'endpoint' => 0,
            ),
            array(
              'key' => 'field_5d5d0d5073f09',
              'label' => 'Error Message',
              'name' => 'installation_form_error_message',
              'type' => 'group',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'layout' => 'row',
              'sub_fields' => array(
                array(
                  'key' => 'field_5d5d0d5073f0a',
                  'label' => 'Title',
                  'name' => 'title',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Oops!',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5d1181919ec',
                  'label' => 'Error Labels',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 0,
                ),
                array(
                  'key' => 'field_5d5d15a48def3',
                  'label' => 'Note',
                  'name' => '',
                  'type' => 'message',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'message' => 'If specific error occures and the label field for that error is not filled, undefined error text message will be displayed',
                  'new_lines' => 'wpautop',
                  'esc_html' => 0,
                ),
                array(
                  'key' => 'field_5d5d139742e18',
                  'label' => 'Errors',
                  'name' => 'errors',
                  'type' => 'group',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'layout' => 'row',
                  'sub_fields' => array(
                    array(
                      'key' => 'field_5d5d0d5073f0b',
                      'label' => 'Undefined Error',
                      'name' => 'undefined_error',
                      'type' => 'textarea',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => 'Your request was not posted due to some technical issues! Please try again later and sorry for inconvenience caused!',
                      'placeholder' => '',
                      'maxlength' => '',
                      'rows' => 4,
                      'new_lines' => '',
                    ),
                    array(
                      'key' => 'field_5d5d1163919eb',
                      'label' => 'Dublicate Request Found',
                      'name' => 'dublicate_error',
                      'type' => 'textarea',
                      'instructions' => '',
                      'required' => 0,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => 'Your request was not posted beacuse we found a dublicate request! 
        Please check if you have already posted your data earlier. Sorry for inconvenience caused!',
                      'placeholder' => '',
                      'maxlength' => '',
                      'rows' => 4,
                      'new_lines' => '',
                    ),
                    array(
                      'key' => 'field_5d5d151942e19',
                      'label' => 'Images are not uploaded',
                      'name' => 'attachment_error',
                      'type' => 'textarea',
                      'instructions' => '',
                      'required' => 0,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => 'Your request was not posted due to some technical issues caused by the images you posted! Please post another attachment or try again later! Sorry for inconvenience caused!',
                      'placeholder' => '',
                      'maxlength' => '',
                      'rows' => 4,
                      'new_lines' => '',
                    ),
                  ),
                ),
                array(
                  'key' => 'field_5d5d1192919ed',
                  'label' => 'Error Labels End',
                  'name' => '',
                  'type' => 'accordion',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'open' => 0,
                  'multi_expand' => 0,
                  'endpoint' => 1,
                ),
                array(
                  'key' => 'field_5d5d0d5073f0c',
                  'label' => 'CTA Link',
                  'name' => 'cta_link',
                  'type' => 'page_link',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'post_type' => '',
                  'taxonomy' => '',
                  'allow_null' => 0,
                  'allow_archives' => 1,
                  'multiple' => 0,
                ),
                array(
                  'key' => 'field_5d5d0d5073f0d',
                  'label' => 'CTA Link Text',
                  'name' => 'cta_link_text',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => 'Keep Shopping',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
              ),
            ),
            array(
              'key' => 'field_5d5b8bf8f531d',
              'label' => 'Email',
              'name' => '',
              'type' => 'tab',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'placement' => 'top',
              'endpoint' => 0,
            ),
            array(
              'key' => 'field_5d5b8c03f531e',
              'label' => 'Mail Data',
              'name' => 'installation_form_mail_data',
              'type' => 'group',
              'instructions' => '',
              'required' => 0,
              'conditional_logic' => 0,
              'wrapper' => array(
                'width' => '',
                'class' => '',
                'id' => '',
              ),
              'layout' => 'row',
              'sub_fields' => array(
                array(
                  'key' => 'field_5d5b8dc960b9d',
                  'label' => 'Message From',
                  'name' => 'from',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => '',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5b8c3bf5321',
                  'label' => 'Message Subject',
                  'name' => 'subject',
                  'type' => 'text',
                  'instructions' => '',
                  'required' => 1,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'default_value' => '',
                  'placeholder' => '',
                  'prepend' => '',
                  'append' => '',
                  'maxlength' => '',
                ),
                array(
                  'key' => 'field_5d5b8c10f531f',
                  'label' => 'Additional Recipients',
                  'name' => 'recipients',
                  'type' => 'repeater',
                  'instructions' => '',
                  'required' => 0,
                  'conditional_logic' => 0,
                  'wrapper' => array(
                    'width' => '',
                    'class' => '',
                    'id' => '',
                  ),
                  'collapsed' => '',
                  'min' => 0,
                  'max' => 0,
                  'layout' => 'row',
                  'button_label' => 'Add Recipient',
                  'sub_fields' => array(
                    array(
                      'key' => 'field_5d5b8c1cf5320',
                      'label' => 'Email Address',
                      'name' => 'email_address',
                      'type' => 'email',
                      'instructions' => '',
                      'required' => 1,
                      'conditional_logic' => 0,
                      'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                      ),
                      'default_value' => '',
                      'placeholder' => '',
                      'prepend' => '',
                      'append' => '',
                    ),
                  ),
                ),
              ),
            ),
          ),
          'location' => array(
            array(
              array(
                'param' => 'options_page',
                'operator' => '==',
                'value' => 'acf-installation-form-customize',
              ),
            ),
          ),
          'menu_order' => 0,
          'position' => 'normal',
          'style' => 'default',
          'label_placement' => 'top',
          'instruction_placement' => 'label',
          'hide_on_screen' => '',
          'active' => true,
          'description' => '',
        ));
        
      }

    }

    /**
     * Add acf option pages for custom fields
     * @since 0.0.2
     * Requires 'acf_add_options_page' function (ACF Core)
     */
    public static function add_acf_option_sub_page(){

        if(function_exists('acf_add_options_page')){

          acf_add_options_sub_page(array(
            'page_title' 	=> 'Customize Appearance',
            'menu_title'	=> 'Customize',
            'menu_slug' => 'acf-installation-form-customize',
            'parent_slug'	=> 'edit.php?post_type=' . self::get_post_type()
        ));
  
        }

    }

    /**
     * Create 'installation_request' post type
     * @hook init
     * @since 0.0.2
     */
    public static function create_post_type(){
      
        register_post_type(self::get_post_type(),
          array(
            'labels' => array(
              'name' => __('Installation Requests'),
              'singular_name' => __('Installation Request')
            ),
            'menu_icon' => 'dashicons-email-alt',
            'menu_position' => 25,
            'public' => true,
            'supports' => array(
              'title',
              'editor',
              'custom-fields'
            ),
            'show_in_nav_menus' => false,
            'show_in_menu' => true,
            'exclude_from_search' => true,
            'show_in_admin_bar' => true,
            'has_archive' => false,
          )
        );

    }
    
    /**
     * Return if the page is included into the list
     * @return boolean true if page is in the set 
     * @since 0.0.2
     */
    public static function if_page_is_included(){

      $included_pages = get_field('installation_form_pages', 'option');

      if(!$included_pages) return true;

      if(!get_the_ID()) return true;

      return in_array(get_the_ID(), $included_pages);

    }

    /**
     * Enqueue plugin scripts and styles
     * @since 0.0.2
     * @hook wp_enqueue_scripts
     */
    public static function enqueue_assets(){

      add_action('wp_enqueue_scripts', function(){

        if(!self::if_page_is_included()) return;

        wp_enqueue_style('eworld-' . self::get_post_type(), plugin_dir_url(__FILE__) . 'style.css' , array(), '0.0.2');
      
        wp_enqueue_script('eworld-' . self::get_post_type(), plugin_dir_url(__FILE__) . 'script.js', array('jquery'), '0.0.2', true);
    
        // pass validation rules to javascript
        wp_localize_script(
          'eworld-' . self::get_post_type(),
          'eworld_installation_form_rules',
          self::get_validated_fields()
        );

      }, 999);

    }

    /**
     * Getting Singleton pattern class instance
     * @since 0.0.2
     */
    private static function get_instance(){

      if(static::$instance == NULL){

        static::$instance = new eworld_installation_request_form();

      }

      return static::$instance;

    }

    private function __construct(){}

    private function __clone(){}

    private function __wakeup(){}

  }

  
  add_action('init', function(){

    eworld_installation_request_form::init();

  });

}