<?php 
/**
 * Installation Requests Form Template
 * @uses 
 *  @method get_form_data 
 *  @method is_validated
 */

if(!defined('ABSPATH')) exit;

$form_data = self::get_form_data();

if(!$form_data) return;

$validated_html = ' *';

?>

<div class="installation_page_form">

<div class="installation_page_form_loader"><i></i></div>

  <div class="installation_page_grid">

    <h2 class="installation_page_form_title"><?php echo $form_data['title1']?></h2>

    <p class="installation_page_form_desc"><?php echo $form_data['description1']?></p>

    <form id="installation_page_form" method="post" enctype="multipart/form-data">

      <?php wp_nonce_field('post_' . self::get_post_type(), 'nonce'); ?>

      <ul class="installation_page_form_rows">

        <li class="rowspan">

          <h3 class="installation_page_form_subtitle"><?php echo $form_data['contact_information_title']?></h3>

        </li>

        <li class="row">

          <label for="first_name"><?php echo $form_data['first_name']; echo self::is_validated('first_name') ? $validated_html : ''?></label>

          <input type="text" name="first_name" id="first_name">

          <label for="company_name"><?php echo $form_data['company_name']; echo self::is_validated('company_name') ? $validated_html : ''?></label>

          <input type="text" name="company_name" id="company_name">

          <label for="email"><?php echo $form_data['email']; echo self::is_validated('email') ? $validated_html : ''?></label>

          <input type="text" name="email" id="email">

        </li>

        <li class="row">

          <label for="phone_number"><?php echo $form_data['phone_number']; echo self::is_validated('phone_number') ? $validated_html : ''?></label>

          <input type="text" name="phone_number" id="phone_number">

          <label for="last_name"><?php echo $form_data['last_name']; echo self::is_validated('last_name') ? $validated_html : ''?></label>

          <input type="text" name="last_name" id="last_name">

          <label><?php echo $form_data['contact_method']['title']; echo self::is_validated('contact_method') ? $validated_html : ''?></label>

          <?php foreach($form_data['contact_method']['choices'] as $index=>$value): ?>

          <input type="radio" name="contact_method" id="contact_option_<?=$index?>" value="<?=$value['label']?>">

          <label for="contact_option_<?=$index?>" class="radio"><?=$value['label']?></label><br>

          <?php endforeach; ?>

        </li>

        <li class="rowspan">

          <h3 class="installation_page_form_subtitle"><?php echo $form_data['installation_site_details_title']?></h3>

        </li>

        <li class="rowspan">

          <label for="street_address"><?php echo $form_data['street_address']; echo self::is_validated('street_address') ? $validated_html : ''?></label>

          <input type="text" name="street_address" id="street_address">

        </li>

        <li class="row">

          <label for="city"><?php echo $form_data['city']; echo self::is_validated('city') ? $validated_html : ''?></label>

          <input type="text" name="city" id="city">

          <label for="postcode"><?php echo $form_data['postcode']; echo self::is_validated('postcode') ? $validated_html : ''?></label>

          <input type="text" name="postcode" id="postcode">

        </li>

        <li class="row">

          <label for="county"><?php echo $form_data['county']; echo self::is_validated('county') ? $validated_html : ''?></label>

          <input type="text" name="county" id="county">

          <label for="project_type"><?php echo $form_data['project_type']['title']; echo self::is_validated('project_type') ? $validated_html : ''?></label>

          <select id="project_type" name="project_type">

              <option value=""><?php echo $form_data['project_type']['default_label']?></option>

              <?php foreach($form_data['project_type']['choices'] as $index=>$value): ?>

              <option value="<?=$value['label']?>"><?=$value['label']?></option>

              <?php endforeach; ?>

            </select>

        </li>

        <li class="tri">

          <label for="total_coverage_area"><?php echo $form_data['total_coverage_area']['title']; echo self::is_validated('total_coverage_area') ? $validated_html : ''?></label>

          <select id="total_coverage_area" name="total_coverage_area">

            <option value=""><?php echo $form_data['total_coverage_area']['default_label']?></option>

            <?php foreach($form_data['total_coverage_area']['choices'] as $index=>$value): ?>

            <option value="<?=$value['label']?>"><?=$value['label']?></option>

            <?php endforeach; ?>

          </select>

        </li>

        <li class="tri">

          <label for="users"><?php echo $form_data['users']; echo self::is_validated('users') ? $validated_html : ''?></label>

          <input type="text" name="users" id="users">

        </li>

        <li class="tri">

          <label for="floors"><?php echo $form_data['floors']; echo self::is_validated('floors') ? $validated_html : ''?></label>

          <input type="text" name="floors" id="floors">

        </li>

        <li class="row">

          <label for="approximate_dimensions"><?php echo $form_data['approximate_dimensions']; echo self::is_validated('approximate_dimensions') ? $validated_html : ''?></label>

          <input type="text" name="approximate_dimensions" id="approximate_dimensions">

        </li>

        <li class="row">

          <label for="budget"><?php echo $form_data['project_budget']['title']; echo self::is_validated('project_budget') ? $validated_html : ''?></label>

          <select id="project_budget" name="project_budget">

            <option value=""><?php echo $form_data['project_budget']['default_label']?></option>

            <?php foreach($form_data['project_budget']['choices'] as $index=>$value): ?>

            <option value="<?=$value['label']?>"><?=$value['label']?></option>

            <?php endforeach; ?>

          </select>

        </li>

        <li class="rowspan">

          <h3 class="installation_page_form_subtitle"><?php echo $form_data['uploads_title']?></h3>

        </li>

        <li class="rowspan">

          <label for="installation_upload"><?php echo $form_data['uploads_field_label'] ?></label>

          <input type="file" id="installation_upload" name="installation_upload[]" accept="image/gif, image/jpeg, image/png" multiple>

        </li>

        <li class="rowspan">

          <h3 class="installation_page_form_subtitle"><?php echo $form_data['comments']?></h3>

        </li>

        <li class="rowspan">

          <textarea name="comments" id="comments"></textarea>

        </li>

        <li class="rowspan">

          <input type="submit" value="<?php echo $form_data['submit_button']?>">

        </li>

      </ul>

    </form>

  </div>

</div>