(function($) {

	if(typeof $.fn.eworld_modified !== "function"){

		$.fn.validate = function(props, callback){

			"use strict";
	
			if(!$(this).length) return this;
	
			var state = $.extend({
	
				form: this,
	
				fields: $(this).find('[name]'),
	
				rules: {},
	
				messages: {},
	
				errors: {},
	
				status: true,
	
				listening: false,
	
				dynamic: false
	
			}, props);
	
			var checkFields = function(){
	
				state.errors = {};
	
				state.status = true;
	
				for(var field in state.rules){
	
					if(state.rules.hasOwnProperty(field)){
	
						checkField({
	
							name: field,
	
							dom: $(state.form).find('[name="' + field + '"]').last()[0]
	
						});
	
					}
	
				}
	
				if(!$.isEmptyObject(state.errors)){
	
					state.status = false;
	
				}
	
			};
	
			var checkField = function(props){
	
				var field = $.extend({
	
					value: $.grep($(state.form).serializeArray(), function(item){
	
						return item.name === props.name;
	
					}).length ?
	
						$.grep($(state.form).serializeArray(), function(item){
	
							return item.name === props.name;
	
						})[0].value : (state.dynamic === true) ?
	
							undefined
	
						: '',
	
					status: true
	
				}, props);
	
				if(field.value === undefined || !state.rules.hasOwnProperty(field.name)) return true;
	
				if(state.rules[field.name].required && !field.value.trim()){
	
					field.status = false;
	
					state.errors[field.name] = {
	
						field: field.dom,
	
						message: state.messages[field.name] && state.messages[field.name].required ?
	
						state.messages[field.name].required :
	
						'This field is required!'
	
					};
	
	
				} else if(state.rules[field.name].min && field.value.trim().length < state.rules[field.name].min){
	
					field.status = false;
	
					var multiple = state.rules[field.name].min === 1 ? '' : 's';
	
					state.errors[field.name] = {
	
						field: field.dom,
	
						message: state.messages[field.name] && state.messages[field.name].min ?
	
							state.messages[field.name].min :
	
							'This field requires at least ' + state.rules[field.name].min + ' character' + multiple + '!'
	
					};
	
				} else if(state.rules[field.name].max && field.value.length > state.rules[field.name].max){
	
					field.status = false;
	
					state.errors[field.name] = {
	
						field: field.dom,
	
						message: state.messages[field.name] && state.messages[field.name].min ?
	
							state.messages[field.name].max :
	
							'This field requires not more than ' + state.rules[field.name].max + ' characters!'
	
					};
	
				} else if(state.rules[field.name].number && isNaN(field.value) && field.value.trim()){
	
					field.status = false;
	
					state.errors[field.name] = {
	
						field: field.dom,
	
						message: state.messages[field.name] && state.messages[field.name].min ?
	
							state.messages[field.name].max :
	
							'This field must contain only numeric value!'
	
					};
	
				} else if(state.rules[field.name].email && !/^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(field.value) && field.value.trim()){
	
					field.status = false;
	
					state.errors[field.name] = {
	
						field: field.dom,
	
						message: state.messages[field.name] && state.messages[field.name].email ?
	
							state.messages[field.name].email :
	
							'Email address is not valid!'
	
					};
	
				} else if(state.rules[field.name].url && !/[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/.test(field.value) && field.value.trim()){
	
					field.status = false;
	
					state.errors[field.name] = {
	
						field: field.dom,
	
						message: state.messages[field.name] && state.messages[field.name].url ?
	
							state.messages[field.name].url :
	
							'URL address is not valid!'
	
					};
	
				}
	
				return field.status;
	
			};
	
			var renderErrors = function(){
	
				for(var field in state.rules){
	
					$(state.form).find('[name="' + field + '"]').addClass('error');
	
					if(state.rules.hasOwnProperty(field) && state.errors.hasOwnProperty(field)){
	
						if($(state.errors[field].field).next('label.error').length){
	
						$(state.errors[field].field)
							.next('label.error').html(state.errors[field].message);
	
						} else {
	
							$(state.errors[field].field).after(
	
								$('<label class="error" data-for="' + field + '">' + state.errors[field].message + '</label>')
	
							);
	
							if($(state.errors[field].field).attr('id')){
	
								$(state.errors[field].field).next('label.error').attr('for', $(state.errors[field].field).attr('id'));
	
							}
	
						}
	
					} if(state.rules.hasOwnProperty(field) && !state.errors.hasOwnProperty(field)){
	
						$(state.form).find('[name="' + field + '"]').removeClass('error');
	
						$(state.form).find('[data-for="' + field + '"]').remove();
	
					}
	
				}
	
	
			};
	
			var listenFields = function(){
	
				state.fields.on('keyup change', function(){
	
					var field = this;
	
					if(checkField({
	
						name: $(field).attr('name'),
	
						dom: $(state.form).find('[name="' + $(field).attr('name') + '"]').last()[0]
	
						})){
	
						$(this).removeClass('error');
	
						$(state.form).find('[name="' + $(field).attr('name') + '"]').last().next('label.error').remove();
	
						delete state.errors[$(this).attr('name')];
	
					} else {
	
						renderErrors();
	
					}
	
				});
	
				state.listening = true;
	
			};
	
			$(this).submit(function(event){
	
				checkFields();
	
				if(!state.status){
	
					event.preventDefault();
	
					renderErrors();
	
					$(state.form).find('.error').first().focus();
	
					if(!state.listening){
	
						listenFields();
	
					}
	
				} else if(callback && typeof callback === "function"){
	
					callback(event);
	
				}
	
			});
	
			return this;
	
		};

		$.fn.toggle = function(props, callback){

			"use strict";

			if(!$(this).length) return this;

			var state = $.extend({

				id: Date.now(),

				togglers: this,

				activeClass: 'active',

				animation: {

					'height' : 'toggle'

				},

				speed: 300,

				ease: 'swing',

				scrollTo: false,

				oneOpen: false,

				focused: false

			}, props);

			var getToggleItem = function(toggler){

				if($(toggler).data('toggle-id')){

				return $('#' + $(toggler).data('toggle-id'))[0];

				} if($(toggler).data('toggle-class')){

				return $('.' + $(toggler).data('toggle-class'))[0];

				} if($(toggler).data('toggle-sibling')){

				return $(toggler).siblings($(toggler).data('toggle-sibling'))[0];

				}

			};

			$(this).click(function(event){

				event.preventDefault();

				if(state.oneOpen === true &&
				$(this).hasClass(state.activeClass) ||

				state.oneOpen === true &&
				$(getToggleItem(this)).hasClass(state.activeClass)){

					return false;

				} if(state.oneOpen){

					$(getToggleItem($(state.togglers)

							.filter('.' + state.activeClass)

							.not(this)

							.removeClass(state.activeClass)[0])

					).animate(state.animation, state.speed, state.ease, function(){

						$(this).removeClass(state.activeClass);

					});

				}

				$(getToggleItem(this)).animate(state.animation, state.speed, state.ease,
					function(){

						$(this).toggleClass(state.activeClass);

						if(callback && typeof callback === "function"){

						callback();

						}

					}

				);

				if(state.scrollTo && !$(this).hasClass(state.activeClass)){

					$("html, body").stop().animate({

						scrollTop: $(getToggleItem(this)).offset().top - (100)

					}, state.speed * 1.5, state.ease);

				}

				$(this).toggleClass(state.activeClass);

			});

			if(state.oneOpen === 'focused'){

				$(state.togglers).attr('data-toggle-focus-id', state.id);

				$(getToggleItem(state.togglers)).attr('data-toggle-focus-id', state.id);

				$(state.togglers).each(function(){

					$(getToggleItem(this)).attr('data-toggle-focus-id', state.id);

				})

				$(document).click(function(event){

					console.log();

					if($(event.target).parents('[data-toggle-focus-id="' + state.id + '"]').length === 0 && $(event.target).data('toggle-focus-id') != state.id){

						$(getToggleItem($(state.togglers)

								.filter('.' + state.activeClass)

								.removeClass(state.activeClass)[0])

						).animate(state.animation, state.speed, state.ease, function(){

							$(this).removeClass(state.activeClass);

						});

					}

				});

			}

			return this;

		};

	};

	// AJAX Statuses Controller Object
	window.installation_requests_app_status = {
		status: false,
		initial_error: $('#installation_error_message_text').html(),
		setStatus: function(status, error){
			switch(status){
				case true:
					this.status = true;
					$('.installation_page_form_loader').fadeOut(200);
					break;
				case false:
					this.status = false;
					$('.installation_page_form_loader').fadeIn(200);
					break;
				case 'success':
					this.setStatus(true);
					$('#installation_page_form input, #resellers_page_form textarea').not('[type="submit"]').not('[type="hidden"]').not('[type="checkbox"]').val('');
					$('#installation_page_form select option:first-child').attr('selected','selected');
					$('#installation_page_form [type="checkbox"]').prop('checked', false);
					$('#installation_success_message_wrapper_toggle').fadeIn(200);
					break;
				case 'error':
					this.setStatus(true);
					$('#installation_error_message_wrapper_toggle').fadeIn(200);
					if(error){
						$('#installation_error_message_text').html(error);
					} else {
						$('#installation_error_message_text').html(this.initial_error);
					}
					break;
			}

		},
		getStatus: function(){
			return this.status;
		}

	}

	$(document).ready(function(){

		"use strict";

		$('#installation_success_close_button, #installation_success_close_area').toggle({
			animation: {
				'opacity' : 'toggle'
			},
			speed: 100
		});

		window.installation_requests_app_status.setStatus(true);

		$('#installation_page_form').validate({
			rules: window.eworld_installation_form_rules
		}, function(event){

			event.preventDefault();

			if(window.installation_requests_app_status.getStatus()){

				window.installation_requests_app_status.setStatus(false);

			} else {

				return false;

			}

			$.ajax({
				url: '',
				type: 'POST',
				dataType: 'JSON',
				data: (typeof window.FormData !== 'undefined') ? new FormData($('#installation_page_form')[0]) : $('#installation_page_form').serializeArray(),
				success: function(data){
					if(typeof data === 'object' && data.hasOwnProperty('status') && data['status'] === 'posted'){
						window.installation_requests_app_status.setStatus('success');
					} else {
						window.installation_requests_app_status.setStatus('error', data.error);
					}
				},
				error: function(){
					window.installation_requests_app_status.setStatus('error');
				},
				contentType: false,
				processData: false,
				async: true
			});

		});

	});

})(jQuery);