<?php

/**
* Plugin Name: E-World Order Import - Export
* Description: Importing and exporting reviews tool
* Version:  0.0.1
* Author: E-World
* Author URI: https://www.facebook.com/eworldllc/
**/

if(!defined('ABSPATH')) exit;

if(!class_exists('eworld_order_import_export')){

    final class eworld_order_import_export {

        private static $instance, $errors, $report;

        public static function push_error($error){
            if(!self::$errors) self::$errors = array();
            self::$errors[] = '<p><strong>' . $error . '</strong></p>';
        }

        public static function push_report($report_text){
            if(!self::$report) self::$report = array();
            self::$report[] = '<p>' . $report_text . '</p>';
        }

        public static function init(){

            if(!self::$instance){
                self::get_instance();
            } else {
            return;
            }

            self::add_plugin_links();
            self::get_instance()->add_plugin_menu_page();
            self::export_orders();
            self::import_orders();

        }

        private static function add_plugin_links(){
            add_action('init', function(){
                add_filter('plugin_action_links_'.plugin_basename(__FILE__), function($links){
                    array_unshift($links, 
                        '<a href="' .
                        admin_url( 'admin.php?page=eworld_order_import_export_reviews' ) .
                        '">' . __('Import | Export') . '</a>'
                    );
                    return $links;
                });
            });

        }

        public function add_plugin_menu_page(){

            add_action('admin_menu', function(){
                add_menu_page( 
                    'Orders Import/Export Tools', 
                    'Orders Im/Ex', 
                    'manage_options', 
                    'eworld_order_import_export_reviews', 
                    array($this, 'render_menu_page_content'), 
                    'dashicons-format-status',
                    54 
                );
            });

        }

        private static function get_post_name_memo($post_id, $memo){
            if(!isset($memo[$post_id])){
                $memo[$post_id] = parse_url(get_permalink($post_id), PHP_URL_PATH);
            }
            return $memo;
        }

        private static function get_post_by_path($path, $memo = array()){
            return url_to_postid($path);
        }

        public static function get_orders(){ 

            $all_orders = wc_get_orders(array(
                'orderby' => 'date',
                'order' => 'ASC',
                'limit' => -1
            ));
            $to_return = array();

            for($i = 0; $i < count($all_orders); $i++){
                $order_data = $all_orders[$i]->get_data();

                $order_data['order_items'] = array_map(function($item){
                    return array(
                        'id' => $item->get_id(),
                        'product_id' => $item->get_product_id(),
                        'variation_id' => $item->get_variation_id(),
                        'name' => $item->get_name(),
                        'qty' => $item->get_quantity(),
                        'subtotal' => $item->get_subtotal(),
                        'subtotal_tax' => $item->get_subtotal_tax(),
                        'total' => $item->get_total(),
                        'total_tax' => $item->get_total_tax()
                    );
                }, $all_orders[$i]->get_items());
                
                $to_push = $order_data;
                $to_return[] = $to_push;
            }

            return $to_return;
        }

        public static function post_orders($json){
            if(!function_exists( 'wc_create_order')){ 
                require_once '/includes/wc-core-functions.php'; 
            } 
            $products = array();
            $total_orders_count = 0;

            ini_set('display_errors', 1);
            ini_set('display_startup_errors', 1);
            error_reporting(E_ALL);

            $startTime = microtime(true);
            for($i = 0; $i < count($json); $i++){
                $to_import = $json[$i];
                $order = new WC_Order();
                // save the order so dates are kept set
                $order->save();
                
                $order->set_status($to_import['status'], 'Original Order Id #' . $to_import['id'] . '<br>', false);
                
                if(isset($to_import['customer_note'])){
                    $order->set_customer_note($to_import['customer_note']);
                }
                
                // dates
                if(isset($to_import['date_created']) && $to_import['date_created']['date']){
                    $order->set_date_created($to_import['date_created']['date']);
                }
                if(isset($to_import['date_modified']) && $to_import['date_modified']['date']){
                    $order->set_date_modified($to_import['date_modified']['date']);
                }
                if(isset($to_import['date_completed'])){
                    $order->set_date_completed($to_import['date_completed']);
                }
                if(isset($to_import['date_paid'])){
                    $order->set_date_paid($to_import['date_paid']);
                }

                // payment & prices & discount data
                if(isset($to_import['cart_hash'])){
                    $order->set_cart_hash($to_import['cart_hash']);
                }
                if(isset($to_import['payment_method'])){
                    $order->set_payment_method($to_import['payment_method']);
                }
                if(isset($to_import['currency'])){
                    $order->set_currency($to_import['currency']);
                }
                if(isset($to_import['total'])){
                    $order->set_total($to_import['total']);
                }
                if(isset($to_import['discount_total'])){
                    $order->set_discount_total($to_import['discount_total']);
                }
                if(isset($to_import['discount_tax'])){
                    $order->set_discount_tax($to_import['discount_tax']);
                }
                if(isset($to_import['shipping_total'])){
                    $order->set_shipping_total($to_import['shipping_total']);
                }
                if(isset($to_import['shipping_tax'])){
                    $order->set_shipping_tax($to_import['shipping_tax']);
                }
                // shipping data
                if(isset($to_import['shipping'])){
                    $order->set_address($to_import['shipping'], 'shipping');
                }
                // billing data
                if(isset($to_import['billing'])){
                    $order->set_address($to_import['billing'], 'billing');
                }
                // additional info
                if(isset($to_import['meta_data'])){
                    $order->set_meta_data($to_import['meta_data']);
                }
                if(isset($to_import['order_key'])){
                    $order->set_order_key($to_import['order_key']);
                }
                // add items
                if(isset($to_import['order_items']) && is_array($to_import['order_items']) && !empty($to_import['order_items'])){

                    foreach($to_import['order_items'] as $item_id => $item_data){
                        $item = new WC_Order_Item_Fee();
                        $item->set_props(array(
                            'name'      => $item_data['name'],
                            'total'     => $item_data['total'],
                        ));
                        $order->add_item($item);
                    }
    
                }
                // save order
                $order->save();
                $total_orders_count++;
            }

            self::push_report('<h3 style="margin-bottom: 0px;">Total <strong>' . $total_orders_count . '</strong> order(s) added</h3>');
   
            self::push_report("Time spent:  " . number_format((microtime(true) - $startTime), 4) . " Seconds");
        }

        private static function import_orders(){
            add_action('init', function(){
                if(is_admin() && wp_verify_nonce($_POST['_wpnonce'], 'import_orders')){
                    // check if file is uploaded
                    if(isset($_FILES['json']) && file_exists($_FILES['json']['tmp_name'])){
                        // check if file has json extension
                        if(pathinfo($_FILES['json']['name'], PATHINFO_EXTENSION) == 'json'){

                            $file_content = file_get_contents($_FILES['json']['tmp_name']);
                            $parsed_file_content = json_decode($file_content, true);
                            // check if json is valid
                            if(json_last_error() == JSON_ERROR_NONE){
                                // import
                                self::post_orders($parsed_file_content);
                            } else {
                                self::push_error('The issue occured parsing JSON file');
                            }
                        } else {
                            self::push_error('File extention must have JSON extension');
                        }
                    } else {
                        self::push_error('JSON File is required!');
                    }
                }
            });
        }

        private static function export_orders(){
            add_action('init', function(){
                if(is_admin() && wp_verify_nonce($_GET['_wpnonce'], 'export_orders')){

                    $json_file_location = dirname(__FILE__) . '/export.json';
                    file_put_contents($json_file_location, json_encode(self::get_orders()));
                    if(file_exists($json_file_location)){

                        header($_SERVER["SERVER_PROTOCOL"] . " 200 OK");
                        header("Cache-Control: public");
                        header("Content-Type: application/json");
                        header("Content-Transfer-Encoding: Binary");
                        header("Content-Length:".filesize($json_file_location));
                        header("Content-Disposition: attachment; filename=reviews-export-" . sanitize_title(current_time('Y/m/d')) . '.json');
                        readfile($json_file_location);
                        unlink($json_file_location);
                        die();  
                    }
                }
            });
        }

        public function render_menu_page_content(){

            // register nonces
            $export_nonce = wp_create_nonce('export_orders');
            $import_nonce = wp_create_nonce('import_orders');
            ?>
            <div class="wrap">
                <h1>Export | Import orders in .json format</h1>
                <?php self::render_errors() ?>
                <?php self::render_report() ?>
                <h2 style="margin-bottom: 5px;">Export orders</h2>
                <a href="<?=add_query_arg( array('_wpnonce'=>$export_nonce), '');?>" target="_blank" class="button button-primary" style="margin: 10px 0;">Export All Orders</a>
            
                <h2 style="margin: 10px 0 8px;">Import orders</h2>
                <form enctype="multipart/form-data" action="" method="post">
                    <?php wp_nonce_field('import_orders', '_wpnonce') ?>
                    <input required="true" type="file" name="json" style="border: 1px solid lightgray; padding: 5px; border-radius: 2px; background: white;">
                    <p>
                        <input type="submit" class="button button-primary" value="Import Orders">
                    </p>
                </form>
            </div>

            <?php

        }

        public static function render_errors(){
            
            if(self::$errors){
                ?>
                <div class="notice notice-error">
                    <h3 style="margin-bottom: 0;">Error:</h3>
                    <?=implode(self::$errors)?>
                </div>
            <?php
            }

        }

        public static function render_report(){

            if(self::$report){

                ?>
                <div class="notice notice-info">
                    <h3>Imported Data:</h3>
                    <?=implode(self::$report)?>
                </div>
            <?php
            }

        }


        public static function get_instance(){
            if(static::$instance == NULL){
                static::$instance = new eworld_order_import_export();
            }
            return static::$instance;
        }
        
    }
        eworld_order_import_export::init();
}