<?php 
/**
 * Installation Requests Form Template
 * @uses 
 *  @method get_form_data 
 *  @method is_validated
 */

if(!defined('ABSPATH')) exit;

$form_data = self::get_form_data();

if(!$form_data) return;

$validated_html = ' *';

?>

<div class="resellers_page_contact_form">

<div class="resellers_page_form_loader"><i></i></div>

<div class="resellers_page_grid">

    <form id="resellers_page_form" method="post">
    
        <h3 class="resellers_page_contact_form_title"><?php echo $form_data['title1']?></h3>
        
        <label for="individual_or_company"><?php echo $form_data['individual_or_company']['title']; echo self::is_validated('individual_or_company') ? $validated_html : ''?></label>
        
        <select id="individual_or_company" name="individual_or_company">

            <?php foreach($form_data['individual_or_company']['choices'] as $index=>$value): ?>

            <option value="<?=$value['label']?>"><?=$value['label']?></option>

            <?php endforeach; ?>

        </select>

        <?php wp_nonce_field('post_' . self::get_post_type(), 'nonce'); ?>

        <label for="contact_name"><?php echo $form_data['contact_name']; echo self::is_validated('contact_name') ? $validated_html : '' ?></label>
        
        <input type="text" id="contact_name" name="contact_name">
        
        <label for="title"><?php echo $form_data['title']; echo self::is_validated('title') ? $validated_html : '' ?></label>
        
        <input type="text" id="title" name="title">
        
        <label for="phone"><?php echo $form_data['phone']; echo self::is_validated('phone') ? $validated_html : '' ?></label>
        
        <input type="text" id="phone" name="phone">
        
        <label for="email"><?php echo $form_data['email']; echo self::is_validated('email') ? $validated_html : '' ?></label>
        
        <input type="text" id="email" name="email">
    
        <h4 class="resellers_page_contact_form_subtitle"><?php echo $form_data['preferred']['title']; echo self::is_validated('preferred') ? $validated_html : '' ?></h4>

        <?php foreach($form_data['preferred']['choices'] as $index=>$value): ?>

            <input type="checkbox" value="<?=$value['label']?>" id="preferred" name="preferred[]">
            
            <label class="checkbox"><?=$value['label']?></label>
            
            <?php if(!next($value)) echo '<br>'; ?>

        <?php endforeach; ?>

        <label for="platforms"><?php echo $form_data['platforms']; echo self::is_validated('platforms') ? $validated_html : '' ?></label>
        
        <textarea id="platforms" name="platforms"></textarea>
        
        <p class="submit">
        
            <input type="submit" value="<?php echo $form_data['submit_text'] ?>">
        
        </p>
        
    </form>

</div>

</div>