<?php

/**
* Plugin Name: E-World Reviews Import - Export
* Description: Importing and exporting reviews tool
* Version:  0.0.1
* Author: E-World
* Author URI: https://www.facebook.com/eworldllc/
**/

if(!defined('ABSPATH')) exit;

if(!class_exists('eworld_import_export')){

    final class eworld_import_export {

        private static $instance, $errors, $report;

        public static function push_error($error){
            if(!self::$errors) self::$errors = array();
            self::$errors[] = '<p><strong>' . $error . '</strong></p>';
        }

        public static function push_report($report_text){
            if(!self::$report) self::$report = array();
            self::$report[] = '<p>' . $report_text . '</p>';
        }

        public static function init(){

            if(!self::$instance){
                self::get_instance();
            } else {
            return;
            }

            self::add_plugin_links();
            self::get_instance()->add_plugin_menu_page();
            self::export_reviews();
            self::import_reviews();

        }

        private static function add_plugin_links(){
            add_action('init', function(){
                add_filter('plugin_action_links_'.plugin_basename(__FILE__), function($links){
                    array_unshift($links, 
                        '<a href="' .
                        admin_url( 'admin.php?page=eworld_import_export_reviews' ) .
                        '">' . __('Import | Export') . '</a>'
                    );
                    return $links;
                });
            });

        }

        public function add_plugin_menu_page(){

            add_action('admin_menu', function(){
                add_menu_page( 
                    'Reviews Import/Export Tools', 
                    'Reviews Im/Ex', 
                    'manage_options', 
                    'eworld_import_export_reviews', 
                    array($this, 'render_menu_page_content'), 
                    'dashicons-format-status',
                    55
                );
            });

        }

        private static function get_post_name_memo($post_id, $memo){
            if(!isset($memo[$post_id])){
                $memo[$post_id] = parse_url(get_permalink($post_id), PHP_URL_PATH);
            }
            return $memo;
        }

        private static function get_post_by_path($path, $memo = array()){
            return url_to_postid($path);
        }

        public static function get_comments(){ 
                        
            $all_comments = get_comments(array(
                'status'      => 'approve', 
                'post_status' => 'publish', 
                'post_type'   => 'product'
            ));

            $to_return = array();

            $post_names_memo = array();

            for($i = 0; $i < count($all_comments); $i++){
                $comment = $all_comments[$i];
                $post_names_memo = self::get_post_name_memo($comment->comment_post_ID, $post_names_memo);
                
                $comment->review_score = get_comment_meta($comment->comment_ID, 'rating', true);
                $to_return[$post_names_memo[$comment->comment_post_ID]][] = $comment;


            }

            return $to_return;
        }

        public static function post_reviews($json){
            $products = array();
            $total_comment_count = 0;
            foreach($json as $product_path=>$comments){
                $post_id = self::get_post_by_path($product_path);
                $comment_count = 0;
                if($post_id){
                    
                    foreach($comments as $comment){
   
                        $inserted_comment_id = wp_insert_comment( array(
                            'comment_post_ID'      => $post_id,
                            'comment_author'       => $comment->comment_author,
                            'comment_author_email' => $comment->comment_author_email,
                            'comment_author_url'   => $comment->comment_author_url,
                            'comment_content'      => $comment->comment_content,
                            'comment_type'         => 'review',
                            'comment_parent'       => $comment->comment_parent,
                            'user_id'              => $comment->user_id,
                            'comment_date'         => $comment->comment_date,
                            'comment_approved'     => $comment->comment_approved
                        ) );
                        
                        update_comment_meta( $inserted_comment_id, 'rating', $comment->review_score );
                        
                        $comment_count++;

                    }
                    $total_comment_count += $comment_count;
                    self::push_report('<strong>' . $comment_count . '</strong> review(s) are added to <a href="' . get_permalink($post_id) . '" target="_blank"><strong>' . get_the_title($post_id) . '</strong></a>');

                }
            }
            self::push_report('<h3 style="margin-bottom: 5px;">Total <strong>' . $total_comment_count . '</strong> review(s) are added</h3>');

        }

        private static function import_reviews(){
            add_action('init', function(){
                if(is_admin() && wp_verify_nonce($_POST['_wpnonce'], 'import_reviews')){
                    // check if file is uploaded
                    if(isset($_FILES['json']) && file_exists($_FILES['json']['tmp_name'])){
                        // check if file has json extension
                        if(pathinfo($_FILES['json']['name'], PATHINFO_EXTENSION) == 'json'){

                            $file_content = file_get_contents($_FILES['json']['tmp_name']);
                            $parsed_file_content = json_decode($file_content);
                            // check if json is valid
                            if(json_last_error() == JSON_ERROR_NONE){
                                // import
                                self::post_reviews($parsed_file_content);
                            } else {
                                self::push_error('The issue occured parsing JSON file');
                            }
                        } else {
                            self::push_error('File extention must have JSON extension');
                        }
                    } else {
                        self::push_error('JSON File is required!');
                    }
                }
            });
        }

        private static function export_reviews(){
            add_action('init', function(){
                if(is_admin() && wp_verify_nonce($_GET['_wpnonce'], 'export_reviews')){

                    $json_file_location = dirname(__FILE__) . '/export.json';
                    file_put_contents($json_file_location, json_encode(self::get_comments()));
                    if(file_exists($json_file_location)){

                        header($_SERVER["SERVER_PROTOCOL"] . " 200 OK");
                        header("Cache-Control: public");
                        header("Content-Type: application/json");
                        header("Content-Transfer-Encoding: Binary");
                        header("Content-Length:".filesize($json_file_location));
                        header("Content-Disposition: attachment; filename=reviews-export-" . sanitize_title(current_time('Y/m/d')) . '.json');
                        readfile($json_file_location);
                        unlink($json_file_location);
                        die();  
                    }
                }
            });
        }

        public function render_menu_page_content(){

            // register nonces
            $export_nonce = wp_create_nonce('export_reviews');
            $import_nonce = wp_create_nonce('import_reviews');
            ?>
            <div class="wrap">
                <h1>Export | Import product reviews in .json format</h1>
                <?php self::render_errors() ?>
                <?php self::render_report() ?>
                <h2 style="margin-bottom: 5px;">Export reviews</h2>
                <a href="<?=add_query_arg( array('_wpnonce'=>$export_nonce), '');?>" target="_blank" class="button button-primary" style="margin: 10px 0;">Export All Product Reviews</a>
            
                <h2 style="margin: 10px 0 8px;">Import reviews</h2>
                <form enctype="multipart/form-data" action="" method="post">
                    <?php wp_nonce_field('import_reviews', '_wpnonce') ?>
                    <input required="true" type="file" name="json" style="border: 1px solid lightgray; padding: 5px; border-radius: 2px; background: white;">
                    <p>
                        <input type="submit" class="button button-primary" value="Import Reviews">
                    </p>
                </form>
            </div>

            <?php

        }

        public static function render_errors(){
            
            if(self::$errors){
                ?>
                <div class="notice notice-error">
                    <h3 style="margin-bottom: 0;">Error:</h3>
                    <?=implode(self::$errors)?>
                </div>
            <?php
            }

        }

        public static function render_report(){

            if(self::$report){

                ?>
                <div class="notice notice-info">
                    <h3>Imported Data:</h3>
                    <?=implode(self::$report)?>
                </div>
            <?php
            }

        }


        public static function get_instance(){
            if(static::$instance == NULL){
                static::$instance = new eworld_import_export();
            }
            return static::$instance;
        }
        
    }
        eworld_import_export::init();
}