<?php

/**
* Plugin Name: E-World Scripts
* Description: Adding custom scripts via <strong>Custom Scripts</strong> menu
* Version:  0.0.1
* Author: E-World
* Author URI: https://www.facebook.com/eworldllc/
* Requires: ACF PRO
**/

if(!defined('ABSPATH')) exit;

if(!class_exists('eworld_scripts')){

    final class eworld_scripts {

        private static $instance;

        public static function init(){
            // check plugin dependecies
            if(!self::check_deps()){
                self::deactivate();
                return;
            }
            // check if plugin was not initiated earlier
            if(!self::$instance){
              self::get_instance();
            } else {
              return;
    
            }
            self::add_plugin_settings_link();
            self::add_acf_option_page();
            self::create_acf_field_group();
            self::render_scripts();

        }

        private static function add_plugin_settings_link(){
            add_filter('plugin_action_links_'.plugin_basename(__FILE__), function($links){
                array_unshift($links, '<a href="' .
                admin_url( 'admin.php?page=acf-eworld-scripts' ) .
                '">' . __('Customize Scripts') . '</a>');
                return $links;
            });
        }

        private static function add_acf_option_page(){
            if(function_exists('acf_add_options_page')){
                acf_add_options_page(array(
                    'page_title' 	=> 'Custom Scripts',
                    'menu_title'	=> 'Custom Scripts',
                    'menu_slug' => 'acf-eworld-scripts',
                    'position' => 56,
                    'icon_url' => 'dashicons-editor-code'
                ));
            }
        }

        public static function get_scripts(){
            if(function_exists('get_field')){
                return array(
                    "wp_head" => get_field('custom_header_scripts', 'option'),
                    "wp_footer" => get_field('custom_footer_scripts', 'option')
                );
            }
            return NULL;
        }

        private static function create_acf_field_group(){
            acf_add_local_field_group(array(
                'key' => 'group_5d6e2a7627f74',
                'title' => 'Scripts',
                'fields' => array(
                    array(
                        'key' => 'field_5d6e3b9acf60f',
                        'label' => 'Note',
                        'name' => '',
                        'type' => 'message',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => 'Your snippet must be a valid JS code wrapped into <script> tag, otherwise you will break javascript execution or html structure of the page',
                        'new_lines' => 'wpautop',
                        'esc_html' => 0,
                    ),
                    array(
                        'key' => 'field_5d6e37d9e6b52',
                        'label' => 'Header',
                        'name' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_5d6e3814b96fa',
                        'label' => 'Scripts',
                        'name' => 'custom_header_scripts',
                        'type' => 'repeater',
                        'instructions' => 'The priority property defines scripts rendering position where 1 is right after the title and 99 - right before body opening attribute',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'collapsed' => '',
                        'min' => 0,
                        'max' => 0,
                        'layout' => 'row',
                        'button_label' => 'Add Script',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_5d6e3867b96fb',
                                'label' => 'Scripts',
                                'name' => 'script',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'placeholder' => '',
                                'maxlength' => '',
                                'rows' => '',
                                'new_lines' => '',
                            ),
                            array(
                                'key' => 'field_5d6e3873b96fc',
                                'label' => 'Priority',
                                'name' => 'priority',
                                'type' => 'range',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 99,
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_5d6e37ede6b53',
                        'label' => 'Footer',
                        'name' => '',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'top',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'field_5d6e3a70b59d9',
                        'label' => 'Scripts',
                        'name' => 'custom_footer_scripts',
                        'type' => 'repeater',
                        'instructions' => 'The priority property defines scripts rendering position where 1 is right after the footer and 99 - right before body closing attribute',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'collapsed' => '',
                        'min' => 0,
                        'max' => 0,
                        'layout' => 'row',
                        'button_label' => 'Add Script',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_5d6e3a70b59da',
                                'label' => 'Scripts',
                                'name' => 'script',
                                'type' => 'textarea',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'placeholder' => '',
                                'maxlength' => '',
                                'rows' => '',
                                'new_lines' => '',
                            ),
                            array(
                                'key' => 'field_5d6e3a70b59db',
                                'label' => 'Priority',
                                'name' => 'priority',
                                'type' => 'range',
                                'instructions' => '',
                                'required' => 1,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'default_value' => '',
                                'min' => 1,
                                'max' => 99,
                                'step' => 1,
                                'prepend' => '',
                                'append' => '',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-eworld-scripts',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        }

        private static function render_scripts(){
            $scripts_data = self::get_scripts();
            if($scripts_data){
                foreach($scripts_data as $hook_name=>$script_arr){
                    if(is_array($script_arr) && !empty($script_arr)){
                        foreach($script_arr as $script_data){
                            add_action($hook_name, function() use($script_data){
                                echo $script_data['script'];
                            }, $script_data['priority']);
                        }
                    }
                }
            }
        }

        /**
         * Check Plugin Dependencies
         * @return boolean
         * @since 0.0.1
         */
        private static function check_deps(){
            if(!class_exists('ACF')){
                return false;
            }
            return true;
        }

        /**
         * Deactivate This Plugin
         * @hook admin_init
         * @since 0.0.1
         */
        private static function deactivate(){
            add_action('admin_init', function(){
                deactivate_plugins(__FILE__);
            });
        }

        /**
         * Getting Singleton pattern class instance
         * @since 0.0.1
         */
        private static function get_instance(){
            if(static::$instance == NULL){
                static::$instance = new eworld_scripts();
            }
            return static::$instance;
        }
    }
    add_action('init', function(){
        eworld_scripts::init();
    });
}