<?php

/**
* Plugin Name: E-World DataLayer Tracking Scripts
* Description: Adding custom scripts via <strong>Custom Scripts</strong> menu
* Version:  0.0.1
* Author: E-World
* Author URI: https://www.facebook.com/eworldllc/
* Requires: ACF PRO
**/

if(!defined('ABSPATH')) exit;

if(!class_exists('eworld_tracking')){

    final class eworld_tracking {

        private static $instance;

        private static $datalayer = array();

        public static function init(){
            // check plugin dependecies
            if(!self::check_deps()){
                self::deactivate();
                return;
            }
            // check if plugin was not initiated earlier
            if(!self::$instance){
              self::get_instance();
            } else {
              return;
            }

            add_action('init', function(){
                self::add_plugin_settings_link();
                self::add_acf_option_page();
                self::create_acf_field_group();
                // collect dynamic remarketing data
                self::dynamic_remarketing();
                // collect order data
                self::successful_order_report();
            });

            add_action('wp_footer', function(){
                self::render_datalayer();
            }, 10);

        }

        private static function add_plugin_settings_link(){
            add_filter('plugin_action_links_'.plugin_basename(__FILE__), function($links){
                array_unshift($links, '<a href="' .
                admin_url( 'admin.php?page=acf-eworld-datalayer' ) .
                '">' . __('Tracking Options') . '</a>');
                return $links;
            });
        }

        private static function add_acf_option_page(){
            if(function_exists('acf_add_options_page')){
                acf_add_options_page(array(
                    'page_title' 	=> 'DataLayer',
                    'menu_title'	=> 'DataLayer',
                    'menu_slug' => 'acf-eworld-datalayer',
                    'position' => 57,
                    'icon_url' => 'dashicons-editor-code'
                ));
            }
        }

        public static function datalayer_push($data){
            self::$datalayer[] = $data;
        }

        public static function render_datalayer(){
            if(!self::$datalayer) return '';
            ?><script>window.dataLayer = window.dataLayer || [];<?php 
                foreach(self::$datalayer as $data){
                    ?>window.dataLayer.push(<?=json_encode($data)?>); <?php
                }
            ?></script><?php
        }

        /**
         * Successful Order Report end
         */
        public static function successful_order_report(){
            if(get_field('successful_order_report_status', 'option')){
                add_action('woocommerce_before_thankyou', function($order_id){
                    if(is_order_received_page()){
                        $order = wc_get_order($order_id);
                        if(!$order->has_status('failed')){
                            self::datalayer_push(array(
                                'event' => 'gtm4wp.orderCompletedEEC',
                                'ecommerce' => array(
                                    'purchase' => array(
                                        'actionField' => array(
                                            'id' => $order_id,
                                            'affiliation' => 'Online Store',
                                            'revenue' => strval($order->get_subtotal()),
                                            'shipping' => strval($order->get_data()['shipping_total'])
                                        )
                                    )
                                )
                            ));
                        };
                    }
                }, 9);
            };
        }

        /**
         * Dynamic remarketing
         * Pushing product ids displayed on the page, their total price and page title
         */
        private static $dynamic_remarketing_product_ids = array();

        public static function push_dynamic_remarketing_product_id($product_id){
            if(!in_array($product_id, self::$dynamic_remarketing_product_ids)){
                self::$dynamic_remarketing_product_ids[] = intval($product_id);
            }
        }
        
        public static function get_dynamic_remarketing_product_ids(){
            if(!self::$dynamic_remarketing_product_ids){
                return '';
            } if(count(self::$dynamic_remarketing_product_ids) == 1){
                return strval(self::$dynamic_remarketing_product_ids[0]);
            } else {
                return self::$dynamic_remarketing_product_ids;
            }
        }

        public static function dynamic_remarketing(){
            if(get_field('dynamic_remarketing_option', 'option')){
                // adding product ids
                add_filter('woocommerce_product_type_query', function($false, $product_id){
                    if(get_post_type($product_id) == 'product'){
                        self::push_dynamic_remarketing_product_id($product_id);
                    }
                    return $false;
                }, 10, 2);

                add_action('wp_footer', function(){
                    // stop thankyou page from pushing wrong data (variation prices issue)
                    if(!is_order_received_page()){
                        // get products sum
                        $product_sum = 0;
                        foreach(self::$dynamic_remarketing_product_ids as $product_id){
                            $product_sum = $product_sum + get_post_meta($product_id, '_price', true);
                        }
                        self::datalayer_push(array(
                            'ecomm_prodid' => self::get_dynamic_remarketing_product_ids(),
                            'ecomm_pagetype' => get_the_title(),
                            'ecomm_totalvalue' => $product_sum
                        ));
                    }
                }, 9);
            }
        }
        /**
         * Dynamic remarketing end
         */

        private static function create_acf_field_group(){
            if( function_exists('acf_add_local_field_group') ):
                acf_add_local_field_group(array(
                    'key' => 'group_5d79e2301884c',
                    'title' => 'DataLayer',
                    'fields' => array(
                        array(
                            'key' => 'field_5d79fa79f25ab',
                            'label' => 'Dynamic Remarketing',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'top',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_5d79e3c8fd524',
                            'label' => 'Dynamic Remarketing Status',
                            'name' => 'dynamic_remarketing_option',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 0,
                            'ui' => 1,
                            'ui_on_text' => 'Enabled',
                            'ui_off_text' => 'Disabled',
                        ),
                        array(
                            'key' => 'field_5d79fc2c334ae',
                            'label' => 'Successful Order Report',
                            'name' => '',
                            'type' => 'tab',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'placement' => 'top',
                            'endpoint' => 0,
                        ),
                        array(
                            'key' => 'field_5d79fc57334b0',
                            'label' => 'Successful Order Report Status',
                            'name' => 'successful_order_report_status',
                            'type' => 'true_false',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'message' => '',
                            'default_value' => 0,
                            'ui' => 1,
                            'ui_on_text' => 'Enabled',
                            'ui_off_text' => 'Disabled',
                        ),
                    ),
                    'location' => array(
                        array(
                            array(
                                'param' => 'options_page',
                                'operator' => '==',
                                'value' => 'acf-eworld-datalayer',
                            ),
                        ),
                    ),
                    'menu_order' => 0,
                    'position' => 'normal',
                    'style' => 'default',
                    'label_placement' => 'top',
                    'instruction_placement' => 'label',
                    'hide_on_screen' => '',
                    'active' => true,
                    'description' => '',
                ));
            endif;
        }


        /**
         * Check Plugin Dependencies
         * @return boolean
         * @since 0.0.1
         */
        private static function check_deps(){
            if(!class_exists('ACF')){
                return false;
            }
            return true;
        }

        /**
         * Deactivate This Plugin
         * @hook admin_init
         * @since 0.0.1
         */
        private static function deactivate(){
            add_action('admin_init', function(){
                deactivate_plugins(__FILE__);
            });
        }

        /**
         * Getting Singleton pattern class instance
         * @since 0.0.1
         */
        private static function get_instance(){
            if(static::$instance == NULL){
                static::$instance = new eworld_tracking();
            }
            return static::$instance;
        }
    }
    eworld_tracking::init();
}