<?php
/**
 * Plugin Name: Questions Answers
 * Plugin URI: http://eworldsystems.co.uk/
 * Version: 1.0
 * Author: By Eworld Team
 * Text Domain: woocommerce
 *
 */

define('APFSURL', WP_PLUGIN_URL . "/" . dirname(plugin_basename(__FILE__)));
define('APFPATH', WP_PLUGIN_DIR . "/" . dirname(plugin_basename(__FILE__)));

// Our custom post type function
function questions_answers()
{
    register_post_type('que_ans',
        // CPT Options
        array(
            'labels' => array(
                'name' => __('Questions Answers'),
                'singular_name' => __('questions_answers')
            ),
            'supports' => array('title', 'editor', 'custom-fields',),
            'public' => true,
            'has_archive' => true,
            'rewrite' => array('slug' => 'questions-answers'),
        )
    );
}

// Hooking up our function to theme setup
add_action('init', 'questions_answers');
function apf_enqueuescripts()
{
    wp_enqueue_script('apf', APFSURL . '/js/apf.js', array('jquery'));
    wp_localize_script('apf', 'apfajax', array('ajaxurl' => admin_url('admin-ajax.php')));
}

add_action('wp_enqueue_scripts', 'apf_enqueuescripts');


function questions($atts)
{
    ob_start();
    ?>
    <style>
        #apf-response .success {
            position: -webkit-sticky;
            position: sticky;
            left: 0;
            right: 0;
            top: 40%;
            width: 90%;
            margin: 0 auto;
            background-color: #fff;
            border: 1px solid #379fe8;
            padding: 30px 10px
        }

        #apf-response .success i {
            margin-bottom: 8px;
            font-size: 21px;
            color: #379fe8;
        }

        #apf-response .success h4 {
            color: #2f84ed;
            font-size: 21px;
            line-height: 25px;
        }

        #apf-response .success p {
            line-height: 25px;
            font-size: 15px;
            color: #a2a2a2;
            margin-top: 5px;
        }

        #apf-response {
            display: block;
            position: absolute;
            left: 0;
            right: 0;
            top: 0;
            bottom: 0;
            z-index: 100;
            width: 100%;
            height: 100%;
            padding: 40px 0;
            text-align: center;
            background-color: rgba(255, 255, 255, .5);
        }

        #apfform > * label {
            display: block;
            font-weight: 700;
            margin: 15px 0 5px;
            color: #a2a2a2;
        }

        input#apfname {
            display: block;
            width: 100%;
            padding: 0 12px;
            height: 35px;
            border: 1px solid #ccc;
            background-color: #fff;
            color: #555;
            line-height: 1.5;
            font-size: 14px;
            border-radius: 4px;
            font-family: inherit;
            -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
            box-shadow: inset 0 1px 1px rgba(0, 0, 0, .075);
            -webkit-transition: border-color ease-in-out .15s, -webkit-box-shadow ease-in-out .15s;
            -o-transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
            transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
        }

        .send_questions {
            position: relative;
            display: block;
            width: 100%;
            max-width: 150px;
            padding: 9px 12px;
            margin-top: 15px;
            font-size: 14px;
            font-weight: 700;
            text-align: center;
            border-radius: 4px;
            color: #fff;
            text-decoration: none;
            background-color: #5cb85c;
            border: 1px solid #4cae4c;
        }
    </style>
    <div id="apf-response" style="display: none">
        <div class="success" style="display: block;">
            <i class="fa fa-heart"></i>
            <h4>Thank You!</h4>
            <p>Thank you</p>
        </div>
    </div>

    <h3>ASK A QUESTION </h3>
    <?php ?>
    <form id="apfform" action="" method="post" enctype="multipart/form-data">

        <?php $qu_product_id = get_the_ID(); ?>

        <label for="apfname">Name&nbsp;<b>*</b></label>
        <input type="text" id="apfname" name="apfname"/><br/>
        <br/>
        <input type="hidden" id="qu_product_id" name="qu_product_id" value="<?= $qu_product_id ?>">
        <label for="apfemail">Email&nbsp;<b>*</b></label>
        <input type="email" id="apfemail" name="apfemail"/><br/>
        <br/>

        <label for="apfcontents">Your Question&nbsp;<b>*</b></label>
        <textarea id="apfcontents" name="apfcontents" rows="10" cols="20"></textarea><br/>
        <br/>

        <a class="send_questions" onclick="apfaddpost(apfname.value,apfcontents.value);"
           style="cursor: pointer"><b>Post
                Questions</b></a>


    </form>
    <?php return ob_get_clean();

}

add_shortcode('questions', 'questions');
function apf_addpost()
{
    $results = '';

    $title = $_POST['apfname'];
    $content = $_POST['apfcontents'];
    $apfemail = $_POST['apfemail'];
    $qu_post_id = $_POST['qu_product_id'];
    $post_id = wp_insert_post(array(
        'post_title' => $title,
        'post_content' => $content,
        'post_status' => 'publish',
        'post_type' => 'que_ans',
    ));
    if ($post_id != 0) {
        add_post_meta($post_id, 'email', $apfemail, true);
        add_post_meta($post_id, 'product_id', $qu_post_id, true);
        $results = '*Questions Added';
    } else {
        $results = '*Error occurred while adding the Questions';
    }
    // Return the String
    die($results);
}

// creating Ajax call for WordPress
add_action('wp_ajax_nopriv_apf_addpost', 'apf_addpost');
add_action('wp_ajax_apf_addpost', 'apf_addpost');