<?php
function product_page_structured()
{
    if (is_product()) {

        $product = wc_get_product(get_the_ID());
//        var_dump($product);
        $image_id = $product->get_image_id();

        $image_url = wp_get_attachment_image_url($image_id, 'full');

        $productName = $product->get_title();

        $ProductExcerpt = get_the_excerpt();

        $product_url = get_permalink($product->ID);

        $currency = get_woocommerce_currency();

        $productPrice = $product->get_price();

        $average = $product->get_average_rating();

        $review_count = $product->get_review_count();

        $rating_count = $product->get_rating_count();

        $args = array('post_type' => 'product', 'post_id' => $product->get_id());
        $comments = get_comments($args);
        foreach ($comments as $comment) {
            $comment_date = $comment->comment_date;
            $comment_author = $comment->comment_author;
            $comment_content = $comment->comment_content;;

        }
        ?>
        <script type="application/ld+json">
                {
                    "@context": "https://schema.org/",
                    "@type": "Product",
                    "name": "<?= $productName ?>",
                    "image": "<?= $image_url ?>",
                    "productID": "<?= $product->get_id() ?>",
                    "description": "<?php echo wp_strip_all_tags($ProductExcerpt, true) ?>",
                    "brand": "<?php echo get_bloginfo() ?>",
                    "offers": {
                    "@type": "Offer",
                    "url": "<?= $product_url ?>",
                    "priceCurrency": "<?= $currency ?>",
                    "price": "<?= $productPrice ?>",
                    "availability": "https://schema.org/InStock",
                    "itemCondition": "https://schema.org/NewCondition"
                },


                    "aggregateRating": {
                    "@type": "AggregateRating",
                    "ratingValue": "<?= $average ?>",
                    "bestRating": "<?= $average ?>",
                    "worstRating": "3",
                    "ratingCount": "<?= $rating_count ?>",
                    "reviewCount": "<?= $review_count ?>"
                },

                    "review": {
                    "@type": "Review",
                    "name": "<?= $productName ?>",
                    "reviewBody": "<?= $comment_content ?>",
                    "reviewRating": {
                    "@type": "Rating",
                    "ratingValue": "5",
                    "bestRating": "5",
                    "worstRating": "3"
                },
                    "datePublished": "<?= $comment_date ?>",
                    "author": {"@type": "Person", "name": "<?= $comment_author ?>"},
                    "publisher": {"@type": "Organization", "name": "<?= $comment_author ?>"}
                }
                }



        </script>
        <?php
    }
}

add_action('wp', 'product_page_structured');