<?php
/**
 * @wordpress-plugin
 * Plugin Name: Automate date update
 * Plugin URI: http://eworldsystems.co.uk/
 * Author: Eworld Systems Team
 * Version: 1.0.0
 */

/* wp-config.php Add This Code
 define('DISABLE_WP_CRON', false); */

function myprefix_custom_cron_schedule($schedules)
{
    $schedules['months'] = array(
        'interval' => 2592000, // Every 6 hours
        'display' => __('Every 1 months'),
    );
    return $schedules;
}

add_filter('cron_schedules', 'myprefix_custom_cron_schedule');

//Schedule an action if it's not already scheduled

if (!wp_next_scheduled('myprefix_cron_hook')) {
    wp_schedule_event(time(), 'months', 'myprefix_cron_hook');
}

///Hook into that action that'll fire every six hours
add_action('myprefix_cron_hook', 'myprefix_cron_function');

//create your function, that runs on cron
function myprefix_cron_function()
{
    global $wpdb;

    $wpdb->query($wpdb->prepare('UPDATE msb_comments SET comment_date = CURRENT_TIMESTAMP - INTERVAL FLOOR(RAND() * 90) DAY WHERE comment_type = "review"'));

    $wpdb->query($wpdb->prepare('UPDATE msb_comments SET comment_date_gmt = comment_date WHERE comment_type = "review"'));

    wp_mail( 'ara.melkonyan1996@gmail.com', 'Comment Date Updated Successfully', 'lava che ? ))');

}
