<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Class WFOCU_Compatibility_With_WoodMart_Theme
 */
if ( ! class_exists( 'WFOCU_Compatibility_With_WoodMart_Theme' ) ) {
	class WFOCU_Compatibility_With_WoodMart_Theme {

		public function __construct() {
			add_action( 'wp', [ $this, 'register_elementor_widget' ], 150 );
		}

		public function is_enable() {
			if ( defined( 'WOODMART_THEME_DIR' ) ) {
				return true;
			}

			return false;
		}

		public function register_elementor_widget() {

			if ( true !== $this->is_enable() || is_admin() ) {
				return;
			}

			global $post;
			if ( is_null( $post ) || ! 'wfocu_offer' === $post->post_type ) {
				return;
			}

			if ( false !== strpos( $post->page_template, '-canvas.php' ) ) {
				remove_action( 'wp_enqueue_scripts', 'woodmart_enqueue_base_styles', 10000 );
				remove_action( 'wp_footer', 'woodmart_sticky_toolbar_template' );
			}
		}

	}

	WFOCU_Plugin_Compatibilities::register( new WFOCU_Compatibility_With_WoodMart_Theme(), 'woodmart_theme' );
}