<?php
/**
 * Author PhpStorm.
 */

class UpStroke_Subscriptions_Braintree_Credit_Card extends WFOCU_Gateway_Integration_Braintree_CC {

	public function __construct() {

		add_action( 'wfocu_subscription_created_for_upsell', array( $this, 'save_braintree_token_to_subscription' ), 10, 3 );
		add_filter( 'wfocu_order_copy_meta_keys', array( $this, 'set_braintree_credit_card_keys_to_copy' ), 10, 1 );
	}

	/**
	 * @param WC_Subscription $subscription
	 * @param $key
	 * @param WC_Order $order
	 */
	public function save_braintree_token_to_subscription( $subscription, $key, $order ) {

		if ( ! $order instanceof WC_Order ) {
			return;
		}

		$get_braintree_token = $order->get_meta( '_wc_braintree_credit_card_payment_token', true );

		if ( ! empty( $get_braintree_token ) ) {
			$subscription->update_meta_data( '_wc_braintree_credit_card_payment_token', $get_braintree_token );
			$subscription->save();
		}

	}

	public function set_braintree_credit_card_keys_to_copy( $meta_keys ) {
		array_push( $meta_keys, '_wc_braintree_credit_card_payment_token' );

		return $meta_keys;
	}

}

if ( class_exists( 'WC_Subscriptions' ) ) {
	new UpStroke_Subscriptions_Braintree_Credit_Card();
}
