<?php
/**
 * Plugin Name: UpStroke: Subscriptions
 * Plugin URI: https://buildwoofunnels.com
 * Description: This UpStroke Addon allows you to Upsell Subscription products . It supports product official WooCommerce Subscription plugin
 * Version: 1.9.0
 * Author: WooFunnels
 * Author URL: https://buildwoofunnels.com
 * Text Domain: woofunnels-upstroke-subscriptions
 * Domain Path: /languages/
 *
 * WooFunnels: true
 * WC requires at least: 3.3.1
 * WC tested up to: 3.7.0
 * Requires at least: 4.9.0
 * Tested up to: 5.2.2
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'woofunnels_upstroke_dependency' ) ) {

	/**
	 * Function to check if woofunnels upstroke pro version is loaded and activated or not?
	 * @return bool True|False
	 */
	function woofunnels_upstroke_dependency() {

		$active_plugins = (array) get_option( 'active_plugins', array() );

		if ( is_multisite() ) {
			$active_plugins = array_merge( $active_plugins, get_site_option( 'active_sitewide_plugins', array() ) );
		}

		if ( false === file_exists( plugin_dir_path( __DIR__ ) . 'woofunnels-upstroke-one-click-upsell/woofunnels-upstroke-one-click-upsell.php' ) ) {
			return false;
		}

		return in_array( 'woofunnels-upstroke-one-click-upsell/woofunnels-upstroke-one-click-upsell.php', $active_plugins ) || array_key_exists( 'woofunnels-upstroke-one-click-upsell/woofunnels-upstroke-one-click-upsell.php', $active_plugins );
	}
}

class WooFunnels_UpStroke_Subscriptions {

	public static $instance;

	public function __construct() {

		$this->init_constants();
		$this->init_hooks();
	}

	public function init_constants() {
		define( 'WF_UPSTROKE_WCS_VERSION', '1.9.0' );
		define( 'WFOCU_MIN_WFOCU_VERSION', '2.0.0' );
		define( 'WF_UPSTROKE_WCS_BASENAME', plugin_basename( __FILE__ ) );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function init_hooks() {

		add_action( 'plugins_loaded', array( $this, 'add_files' ) );
		add_action( 'plugins_loaded', array( $this, 'load_textdomain' ) );

	}

	public function add_files() {

		if ( false === wfocu_is_woocommerce_active() ) {
			return;
		}

		if ( ! version_compare( WFOCU_VERSION, WFOCU_MIN_WFOCU_VERSION, '>=' ) ) {
			add_action( 'admin_notices', array( $this, 'wfocu_version_check_notice' ) );

			return false;
		}

		include_once plugin_dir_path( __FILE__ ) . '/gateways/class-upstroke-subscriptions-paypal.php';
		include_once plugin_dir_path( __FILE__ ) . '/gateways/class-upstroke-subscriptions-paypal-checkout.php';
		include_once plugin_dir_path( __FILE__ ) . '/gateways/class-upstroke-subscriptions-ppec.php';
		include_once plugin_dir_path( __FILE__ ) . '/gateways/class-upstroke-subscriptions-stripe.php';
		include_once plugin_dir_path( __FILE__ ) . '/gateways/class-upstroke-subscriptions-authorize-cim.php';
		include_once plugin_dir_path( __FILE__ ) . '/gateways/class-upstroke-subscriptions-braintree-credit-card.php';
		include_once plugin_dir_path( __FILE__ ) . '/gateways/class-upstroke-subscriptions-braintree-paypal.php';
		include_once plugin_dir_path( __FILE__ ) . 'class-woofunnels-support-subscriptions.php';
		include_once plugin_dir_path( __FILE__ ) . 'class-upstroke-subscriptions.php';
	}

	public function wfocu_version_check_notice() {
		?>
        <div class="error">
            <p>
				<?php
				/* translators: %1$s: Min required woocommerce version */
				printf( __( '<strong> Attention: </strong>UpStroke Subscriptions requires  WooFunnels UpStroke: One Click Upsell version %1$s or greater. Kindly update the WooFunnels UpStroke: One Click Upsell plugin.', 'woofunnels-upstroke-subscriptions' ), WFOCU_MIN_WFOCU_VERSION );
				?>
            </p>
        </div>
		<?php
	}

	public function load_textdomain() {

		$locale = is_admin() && function_exists( 'get_user_locale' ) ? get_user_locale() : get_locale();

		unload_textdomain( 'woofunnels-upstroke-subscriptions' );
		load_textdomain( 'woofunnels-upstroke-subscriptions', WP_LANG_DIR . '/woofunnels-upstroke-subscriptions-' . $locale . '.mo' );

		load_plugin_textdomain( 'woofunnels-upstroke-subscriptions', false, plugin_basename( dirname( __FILE__ ) ) . '/languages' );

	}
}


if ( true === woofunnels_upstroke_dependency() ) {
	WooFunnels_UpStroke_Subscriptions::instance();
} else {
	add_action( 'admin_notices', 'wfocu_wcs_not_installed_notice' );
}

/**
 * Adding notice for inactive state of Woofunnels One Click Upsells
 */
function wfocu_wcs_not_installed_notice() {
	?>
    <div class="error">
        <p>
			<?php
			echo __( '<strong> Attention: </strong> UpStroke: WooCommerce Subscriptions is a UpStroke: WooCommerce One Click Upsells addon and would only work if it is installed and activated. Please install and activate it first.', 'woofunnels-upstroke-subscriptions' );
			?>
        </p>
    </div>
	<?php
}
