(function($){
	window.mini_cart_app = function(){
		"use strict";
		if(window.mini_cart) return window.mini_cart;
		var state = {
			siteURL: window.wpSiteUrl,
			dom: {
				items: '#header_cart_items',
				loading: {
					app: '#header_cart_loading',
					items: '#header_cart_items_loading'
				},
				qty: '#header_cart_products_count',
				subtotal: '#header_cart_subtotal',
				empty_show: '.header_card_empty a',
				empty_hide: '#header_card_nav a'
			},
			cart_items: [],
			subtotal_html: '0',
			cart_qty: '0',
			load_status: false
		};
		if(!$(state.dom.items).length || !state.siteURL) return;

		var status_module = function(status){
			switch(status){
				case false:
					state.load_status = false;
					$(state.dom.loading.app).fadeIn('fast');
					$(state.dom.loading.items).fadeIn('fast');
				break;
				case 'loaded':
					state.load_status = true;
					$(state.dom.loading.app).fadeOut('fast');
					$(state.dom.loading.items).fadeOut('fast');
				break;
			}
		}

		var get_cart_data = function(){
			return $.ajax({
				url: state.siteURL + '/wp-json/msb/v2/cart/get',
				method: 'GET',
				success: function(data){
					state.cart_qty = data.qty;
					state.subtotal_html = data.subtotal_html;
					state.cart_items = data.items;
				}
			});
		}

		var render_cart_meta = function(){
			$(state.dom.qty).html(state.cart_qty); 
			$(state.dom.subtotal).html(state.subtotal_html)
		}

		var toggle_cart_status_dom = function(){
			if(state.cart_qty <= 0){
				$(state.dom.empty_show).css('display', 'block');
				$(state.dom.empty_hide).hide();
			} else {
				$(state.dom.empty_show).css('display', 'none');
				$(state.dom.empty_hide).show();
			}
		}

		var render_cart_items = function(){
			$('.header_card_item').remove();
			state.cart_items.forEach(function(cart_item){
				$(state.dom.items).prepend(
					'<li class="header_card_item" data-product-id="' + cart_item.id + '">' +
						'<a href="' + cart_item.permalink + '" class="header_card_item_link">' +
							'<img src="' + cart_item.image + '" alt="' + cart_item.name + '">' +
							'<div class="header_card_item_link_content">' +
								'<h3>' + cart_item.name + '</h3>' +
								'<span>' + cart_item.qty + ' x ' + cart_item.price_html + '</span>' +
							'</div>' +
						'</a>' +
						'<a href="' + cart_item.remove_url + '" data-product-id="' + cart_item.id + '" class="header_card_item_remove"><i class="fas fa-times"></i></a>' +
					'</li>'
				);
			});
		}

		var remove_cart_item = function(url){
			return $.ajax({
				url: url,
				method: 'GET'
			});
		}

		var get_and_render_cart = function(){
			// load cart data
			$.when(get_cart_data()).done(function(){
				render_cart_meta();
				toggle_cart_status_dom();
				render_cart_items();
				status_module('loaded');
			});
		}

		// prevent dropdown if clicked on loading dom
		$(state.dom.loading.app + ', ' + state.dom.loading.items).click(function(event){
			event.preventDefault();
			event.stopPropagation();
		});

		// remove from cart listener
		$(document).delegate('.header_card_item_remove', 'click', function(event){
			event.preventDefault();
			if(!state.load_status) return;

			status_module(false);

			$.when(remove_cart_item($(this).attr('href'))).done(function(){
				get_and_render_cart();
			});
		});
		get_and_render_cart();
		return {
			update: function(){
				status_module(false);
				get_and_render_cart();
			}
		}
	}

	$('.header_nav_list > li > a[data-toggle-sibling], .header_card_link').toggle({
		animation: {	
			'opacity': 'toggle'
		},
		speed: 100,
		oneOpen: 'focused'
	});

	window.mini_cart = mini_cart_app();
	
	$('.header_nav_mobile_toggle_button').toggle();
	$('.header_mobile_dropdown_link').toggle();

	// AJAX search
	window.search_app = {
		to_render: [],
		cache: {},
		query: '',
		timeout: null,
		get_products: function(query){
			var this_ref = this;
			this_ref.query = query;
			if(!this_ref.cache.hasOwnProperty($.param({ s: this_ref.query })) && typeof this_ref.cache[$.param({ s: this_ref.query })] !== 'object'){
				return  $.ajax({
					url: window.wpSiteUrl + '/wp-json/msb/v2/product/search',
					data: {
						s: this_ref.query
					},
					success: function(data){
						this_ref.cache[$.param({ s: this_ref.query })] = data;
						this_ref.to_render = data;
					}
				});
			} else {
				this_ref.to_render = this_ref.cache[$.param({ s: this_ref.query })];
			}
		},
		render_product_price: function(product){
			var to_return = '<div class="product_price">';
			if(product.on_sale){
				to_return += '<p><del>' + product.regular_price + '</del></p>';
				to_return += '<strong>' + product.sale_price + '</strong>';
			} else {
				to_return += '<strong>' + product.regular_price + '</strong>';
			}
			to_return += '</div>';
			return to_return;
		},
		render_products: function(){
			this.status('none');
			$('#header_search_block_results').html('').show();
			if(this.to_render.length){
				this.status('has_result');
				var this_ref = this;
				this.to_render.forEach(function(product){
					var keyWords = this_ref.query.toLowerCase().split(' ');
					var product_name = product.name.trim();
					keyWords.forEach(function(keyWord){
						if(product_name.toLowerCase().indexOf(keyWord) !== -1){
							var regex = new RegExp(keyWord, 'i');
							var replace = product_name.toLowerCase().search(regex);
							replace = product_name.substring(replace).split(' ')[0];
							if(replace.indexOf('<') < 0){
								product_name = product_name.replace(replace, '<b>' + replace + '</b>');
							}
						}
					});
					$('#header_search_block_results').append(
						'<li>' + 
							'<a href="' + product.permalink + '">' +
								'<div class="product_image"><img src="' + product.featured_image + '"></div>' +
								'<p class="product_name">' + product_name + '</p>' +
								this_ref.render_product_price(product) +
							'</a>' +
						'</li>' 
					);
				});
				$('#header_search_block_results').append(
					'<button type="submit" class="header_searc_show_more">...</button>'
				);
			}
		},
		status: function(status){
			if(status == 'searching'){
				$('#header_search_block').addClass(status);
			} else if(status == 'has_result'){
				$('#header_search_block').removeClass('searching').addClass(status);
			} else if(status == 'none'){
				$('#header_search_block_results').hide();
				$('#header_search_block').removeClass('searching').removeClass('has_result');
			}
		},
		init: function(){
			if($('#header_search_block').length){
				var this_ref = this;
				$("#header_search_block input[type='text']").on("keyup focus", function(){
					var val = $(this).val().trim();
					if(this_ref.query != val){
						clearTimeout(this_ref.timeout);
						if(val.length >= 2){
							this_ref.status('searching');
							this_ref.timeout = setTimeout(function(){
								$.when(this_ref.get_products(val)).done(function(){
									this_ref.render_products();
								});
							}, 100);
						} else {
							this_ref.status('none');
						}
					}
				});
				$(document).click(function(event){
					if($(event.target).is('#header_search_block') || $(event.target).parents('#header_search_block').length){
						$('#header_search_block_results').fadeIn(100);
						if(this_ref.to_render.length){
							this_ref.status('has_result');
						}
					} else if(!$('#header_search_block').hasClass('searching')) {
						$('#header_search_block_results').fadeOut(100);
						this_ref.status('none');
					}
				});
			}
		}
	}
	window.search_app.init();
	// focus js
	if($('#header_search_block [name="s"]').is(':focus')){
		$('#header_search_block').addClass('focused');
		$('#header_search_block [name="s"]').trigger('keyup');
	}
	$('#header_search_block [name="s"]').focus(function(){
		$('#header_search_block').addClass('focused');
	}).focusout(function(){
		$('#header_search_block').removeClass('focused');
	});
})(jQuery);