(function($){

	// variation app init. See script.js
	product_variations_app(window.product_variation_app_props);

	// reviews post app init. See script.js
	comment_post_app({
		is_admin: window.is_admin ? true : false,
		validation_rules: {
			rules: {
				rating: {
					required: true
				},
				author: {
					required: true
				},
				comment: {
					required: true,
					min: 10
				},
				email: {
					required: true,
					email: true
				}
			},
			dynamic: true
		},
		dom: {
			loading: '#review_post_loading',
			form: '#write_review_form',
			trigger_button: '.product_page_reviews_header_toggle_buttons [data-toggle-id="write"]'
		}
	});
	
	// ui image upload
	$('[name="attachments[]"]').imageUploadUI();

	// question post app init. See script.js
	comment_post_app({
		is_admin: window.is_admin ? true : false,
		validation_rules: {
			rules: {
				author: {
					required: true
				},
				comment: {
					required: true,
					min: 10
				},
				email: {
					required: true,
					email: true
				}
			},
			dynamic: true
		},
		dom: {
			loading: '#question_post_loading',
			form: '#write_question_form',
			trigger_button: '.product_page_reviews_header_toggle_buttons [data-toggle-id="ask"]'
		}
	});

	// reviews list app init. See script.js
	comment_list_app({
		siteURL: window.wpSiteUrl,
		app_props: window.review_list_app_props,
		post_id: window.post_id,
		dom: {
			list: '#review_list_content',
			loading: '#review_list_loading',
			show_more: '#reviews_list_showmore'
		},
		type__not_in: 'question',
		per_page: 5
	});

	// questions list app init. See script.js
	comment_list_app({
		siteURL: window.wpSiteUrl,
		app_props: window.question_list_app_props,
		post_id: window.post_id,
		dom: {
			list: '#questions_list_content',
			loading: '#questions_list_loading',
			show_more: '#questions_list_show_more'
		},
		type__not_in: 'review',
		per_page: 5
	});

	$('.product_page_faq_list > li > a').toggle();
	
	$('.product_page_reviews_content > header > a').toggle({
		oneOpen: true,
		animation: {
			'display': 'toggle'
		},
		speed: 0
	});
	
	// toggle question and write review buttons
	$('.product_page_reviews_header_toggle_buttons a').toggle({
		scrollTo: true
	});
	
	// image loop
	$('.product_page_main_media_image img').imageLoop();
	
	// gallery slider
	$('.product_page_main_media_images').slider({
		nav: true
	});
	
	// gallery images change
	$('.product_page_main_media_images a').click(function(event){
		event.preventDefault();
		var src = $(this).data('image');
		$('.product_page_main_media_image img').on('load', function(){
			$(this).animate({
				opacity: 1
			}, 300, 'swing');
		});

		$('.product_page_main_media_image img').css('opacity', '0').attr('src', src).stop()
	});
	
	// scroll to rating section
	$('#scroll_to_reviews').click(function(event){
		event.preventDefault();
		if($('.product_page_reviews').length){
			$('html, body').animate({
				scrollTop: $('.product_page_reviews').offset().top
			}, 1000, 'swing');
		}
	});

	// rating js
	$('.write_rating a').click(function(event){
		event.preventDefault();
		$(this).addClass('active').siblings('.active').removeClass('active');
		$('#rating option:selected').removeAttr('selected');
		$('#rating option[value="' + $(this).data('for') + '"]').attr('selected','selected');
		$('#rating').val($(this).data('for')).trigger('change');
	});

	$('#rating').hide();

	// share js
	$(document).delegate('.comment_list_app_content article > .main > footer > a, .comment_list_app_content article > .main > footer > a', 'click', function(event){
		event.preventDefault();
		var sibling = $(this).data('toggle-sibling');
		$(this).siblings(sibling).fadeToggle('fast');
	});


})(jQuery);