window.isTablet = 1180;

window.isMobile = 650;

(function($){
	$.fn.eworld_modified = function(){
		/**
		 * @version 0.0.1
		 * @author EWorld LLC
		 */
		return '0.0.1';
	};
	
    $.fn.lazyLoad = function(props, callback){
		"use strict";
		if(!$(this).length) return this;
		
        var state = $.extend({
            action: 'init',
            elements: $(this)
		}, props);
		
        if('IntersectionObserver' in window){
            state.observer = new IntersectionObserver(function(elements){
                elements.forEach(function(element){
                    if(element.isIntersecting === true){
                        loadElement(element.target);
                    }
                });
            });
        }
 
        var checkElements = function(){
            state.elements = state.elements.filter('[data-src], [data-bg-src]').each(function(){
                if(($(window).scrollTop() + $(window).height()) >= $(this).offset().top){
                    loadElement(this);
                }
            });
        };
 
        var loadElement = function(element){
            var src = $(element).data('src') ? $(element).data('src') : undefined;
            var bg_src = $(element).data('bg-src') ? $(element).data('bg-src') : undefined;
            if(src){
                $(element).attr('src', src).removeAttr('data-src');
            } if(bg_src){
                $(element).css('background-image', 'url(' + $(element).data('bg-src') + ')')
                    .removeAttr('data-bg-src');
            }
            if(state.observer){
                state.observer.unobserve(element);
            }
            if(callback && typeof callback === "function"){
                callback(element, src, bg_src);
            }
        };
 
        switch(state.action){
            case 'init':
                if(state.observer){
                    $(state.elements).each(function(){
                        state.observer.observe(this);
                    });
                } else {
                    checkElements();
                    $(window).scroll(function(){
                        if(state.elements.length){
                            checkElements();
                        }
                    });
 
                    $(window).resize(function(){
                        if(state.elements.length){
                            checkElements();
                        }
                    });
                }
            	break;
            case 'load':
                state.elements.each(function(){
                    loadElement(this);
                });
            	break;
        }
        return this;
    };

	$.fn.validate = function(props, callback){
		"use strict";
		if(!$(this).length) return this;
		var state = $.extend({
			form: this,
			fields: $(this).find('[name]'),
			rules: {},
			messages: {},
			errors: {},
			status: true,
			listening: false,
			dynamic: false
		}, props);

		var checkFields = function(){
			state.errors = {};
			state.status = true;

			for(var field in state.rules){
				if(state.rules.hasOwnProperty(field)){
					checkField({
						name: field,
						dom: $(state.form).find('[name="' + field + '"]').last()[0]
					});
				}
			}
			if(!$.isEmptyObject(state.errors)){
				state.status = false;
			}
		};

		var checkField = function(props){
			var field = $.extend({
				value: $.grep($(state.form).serializeArray(), function(item){
					return item.name === props.name;
				}).length ?
					$.grep($(state.form).serializeArray(), function(item){
						return item.name === props.name;
					})[0].value : (state.dynamic === true) ?
						undefined
					: '',
				status: true
			}, props);

			if(field.value === undefined || !state.rules.hasOwnProperty(field.name)) return true;

			if(state.rules[field.name].required && !field.value.trim()){
				field.status = false;
				state.errors[field.name] = {
					field: field.dom,
					message: state.messages[field.name] && state.messages[field.name].required ?
					state.messages[field.name].required :
					'This field is required!'
				};
			} else if(state.rules[field.name].min && field.value.trim().length < state.rules[field.name].min){

				field.status = false;
				var multiple = state.rules[field.name].min === 1 ? '' : 's';
				state.errors[field.name] = {
					field: field.dom,
					message: state.messages[field.name] && state.messages[field.name].min ?
						state.messages[field.name].min :
						'This field requires at least ' + state.rules[field.name].min + ' character' + multiple + '!'
				};
			} else if(state.rules[field.name].max && field.value.length > state.rules[field.name].max){
				field.status = false;
				state.errors[field.name] = {
					field: field.dom,
					message: state.messages[field.name] && state.messages[field.name].min ?
						state.messages[field.name].max :
						'This field requires not more than ' + state.rules[field.name].max + ' characters!'
				};
			} else if(state.rules[field.name].number && isNaN(field.value) && field.value.trim()){
				field.status = false;
				state.errors[field.name] = {
					field: field.dom,
					message: state.messages[field.name] && state.messages[field.name].min ?
						state.messages[field.name].max :
						'This field must contain only numeric value!'
				};
			} else if(state.rules[field.name].email && !/^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(field.value) && field.value.trim()){
				field.status = false;
				state.errors[field.name] = {
					field: field.dom,
					message: state.messages[field.name] && state.messages[field.name].email ?
						state.messages[field.name].email :
						'Email address is not valid!'
				};
			} else if(state.rules[field.name].url && !/[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/.test(field.value) && field.value.trim()){
				field.status = false;
				state.errors[field.name] = {
					field: field.dom,
					message: state.messages[field.name] && state.messages[field.name].url ?
						state.messages[field.name].url :
						'URL address is not valid!'
				};
			}
			return field.status;
		};

		var renderErrors = function(){
			for(var field in state.rules){
				$(state.form).find('[name="' + field + '"]').addClass('error');
				if(state.rules.hasOwnProperty(field) && state.errors.hasOwnProperty(field)){
					if($(state.errors[field].field).next('label.error').length){
					$(state.errors[field].field)
						.next('label.error').html(state.errors[field].message);
					} else {
						$(state.errors[field].field).after(
							$('<label class="error" data-for="' + field + '">' + state.errors[field].message + '</label>')
						);
						if($(state.errors[field].field).attr('id')){
							$(state.errors[field].field).next('label.error').attr('for', $(state.errors[field].field).attr('id'));
						}
					}
				} if(state.rules.hasOwnProperty(field) && !state.errors.hasOwnProperty(field)){
					$(state.form).find('[name="' + field + '"]').removeClass('error');
					$(state.form).find('[data-for="' + field + '"]').remove();
				}
			}
		};

		var listenFields = function(){
			state.fields.on('keyup change', function(){
				var field = this;
				if(checkField({
					name: $(field).attr('name'),
					dom: $(state.form).find('[name="' + $(field).attr('name') + '"]').last()[0]
					})){
					$(this).removeClass('error');
					$(state.form).find('[name="' + $(field).attr('name') + '"]').last().next('label.error').remove();
					delete state.errors[$(this).attr('name')];
				} else {
					renderErrors();
				}
			});
			state.listening = true;
		};

		if(state.listening){
			listenFields();
		}

		$(this).submit(function(event){
			checkFields();
			if(!state.status){
				event.preventDefault();
				renderErrors();
				$(state.form).find('.error').first().focus();
				if(!state.listening){
					listenFields();
				}
			} else if(callback && typeof callback === "function"){
				callback(event);
			}
		});
		return this;
	};

	$.fn.slider = function(props){
		"use strict";
		var fn = this;
		if(!$(this).length) return this;
		$(this).each(function(){
			var state = $.extend({
				slider: this,
				id: Date.now(),
				draggable: true,
				nav: false,
				viewPort: Math.round($(this).outerWidth() / $(this).find('>*').first().outerWidth()) - 1,
				length: $(this).find('>*').length,
				pos: -Math.round(parseInt($(this).find('>*').first().css('margin-left')) /
								$(this).find('>*').first().outerWidth()),
				navDOM: {
					state: this,
					left: $('<a href="#" class="left_btn"><i class="fas fa-angle-left"></i></a>')[0],
					right: $('<a href="#" class="right_btn"><i class="fas fa-angle-right"></i></a>')[0]
				},
				dottedNav: false,
				dottedNavDOM: {
					container: $('<div class="dotted_nav"></div>')[0],
					item: $('<a href="#"></a>')[0]
				},
				speed: 300,
				autoSlide: false,
				slideTimeout: null,
				slideInterval: null,
				disabledClass: 'disabled',
				activeClass: 'active',
				loaded: false
			}, props);

			var DOMRelationsInit = function(){
				$(state.navDOM.left).click(function(event){
					event.preventDefault();
					if(setPosition(state.pos - 1)){
						slide();
					}
				});

				$(state.navDOM.right).click(function(event){
					event.preventDefault();
					if(setPosition(state.pos + 1)){
						slide();
					}
				});

				$(state.dottedNavDOM.item).click(function(event){
					event.preventDefault();
					if(setPosition($(this).index())){
						slide();
					}
				});
			};

			var setUndraggable = function(){
				$(state.slider).find('*').attr('draggable', 'false').attr('unselectable', 'on').css({
									'-moz-user-select': 'none',
									'-ms-user-select': 'none',
								'-khtml-user-select': 'none',
							'-webkit-user-select': 'none',
						'-webkit-touch-callout': 'none'
				});
			};

			var fetchHeight = function(){
				if($(state.slider).find('>*').eq(state.pos).outerHeight() === $(state.slider).outerHeight() || state.viewPort > 1) return false;
				$(state.slider).animate({
					'height': $(state.slider).find('>*').eq(state.pos).outerHeight() + 'px'
				}, state.speed, 'swing');
			}

			var renderNav = function(){
				if(state.nav){
					$(state.slider).after($(state.navDOM.left), $(state.navDOM.right));
				}

				if(state.dottedNav){
					$(state.dottedNavDOM.container).html('');
					for(var i = 0; i < state.length - state.viewPort; i++){
						$(state.dottedNavDOM.container)
							.append($(state.dottedNavDOM.item).clone(true));
					}
					if($(state.slider).siblings($(state.dottedNavDOM.container)).length){
						$(state.slider).after($(state.dottedNavDOM.container));
					}
				}
			};

			var getViewport = function(){
				var oldViewPort = state.viewPort;
				state.viewPort = Math.round($(state.slider).outerWidth() /
					$(state.slider).find('>*').first().outerWidth()) - 1;
				var slideWidth = $(state.slider).find('>*').first().outerWidth();
				var slidesLength = slideWidth * (state.length - state.viewPort - 1);
				if(slidesLength <= 0) return true;
				$(state.slider).css('justify-content', 'flex-start');
				$(state.slider).css('-webkit-justify-content', 'flex-start');
				return oldViewPort === state.viewPort;
			};

			var setNavStyles = function(){
				$(state.dottedNavDOM.container).find('>*').removeClass(state.activeClass)
					.eq(state.pos).addClass(state.activeClass);
				$(state.navDOM.left).removeClass(state.disabledClass);
				$(state.navDOM.right).removeClass(state.disabledClass);
				if(state.pos === 0){
					$(state.navDOM.left).addClass(state.disabledClass);
				} if(state.pos === (state.length - state.viewPort) - 1 || (state.length - state.viewPort) - 1 <= 0){
					$(state.navDOM.right).addClass(state.disabledClass);
				}
			};

			var checkElementsLength = function(){
				if(state.length !== $(state.slider).find('>*').length){
					state.length = $(state.slider).find('>*').length;
					renderNav();
					if(state.draggable) setUndraggable();
				}
			}

			var setPosition = function(pos){
				checkElementsLength();
				if(pos < 0){
					state.pos = 0;
				} else if(pos >= state.length - state.viewPort){
					state.pos = state.length - state.viewPort - 1;
				} else {
					state.pos = pos;
					return true;
				}
				return false;
			};

			var slide = function(){
				$(state.slider).find('>*').first().stop().animate({
					'margin-left': -($(state.slider).find('>*').first().outerWidth() * state.pos) + 'px'
				}, state.speed, 'swing');

				if(state.loaded){
					fetchHeight();
				} else {
					state.loaded = true;
				}
				setNavStyles();
			};

			fn.__proto__.slide = function(to){
				if(to === 'next'){
					if(setPosition(state.pos + 1)){
						slide();
						return fn;
					}
				} if(to === 'back'){
					if(setPosition(state.pos - 1)){
						slide();
						return fn;
					}
				} else if(!isNaN(to)){
					if(setPosition(to - 1)){
						slide();
						return fn;
					}
				}
				return false;
			};

			DOMRelationsInit();
			if(state.draggable) setUndraggable();
			fetchHeight();
			renderNav();
			slide();

			$(window).resize(function(){
				if(!getViewport()){
					if(state.pos > state.length - state.viewPort - 1){
						state.pos = state.length - state.viewPort - 1;
					}
					renderNav();
				}

				clearTimeout(state.slideTimeout);
				state.slideTimeout = setTimeout(function(){
					slide();
				}, 300);
			});

			if(state.draggable){
				var draggingProps = {
					trigger: false,
					pseudoTrigger: true,
					pageX: {
						init: null,
						current: null
					},
					slideTo: 0
				};

				var drag = function(to){
					var slideWidth = $(state.slider).find('>*').first().outerWidth();
					var slidesLength = slideWidth * (state.length - state.viewPort - 1);
					if(slidesLength <= 0) return true;
					var dragPos = parseInt($(state.slider).find('>*').first().css('margin-left'));
					var move = -(state.pos * slideWidth + to);
					if(move > 0){
						$(state.slider).find('>*').first().css('margin-left',  move / 5 + 'px');
					} else if(dragPos < -slidesLength){
						$(state.slider).find('>*').first().css('margin-left',
						(-(slideWidth * (state.length - state.viewPort -  1)) - 1) -
							(((-(slideWidth * (state.length  - state.viewPort - 1)) - 1) - move) / 5) +
						'px');
					} else if(move < 0) {
						$(state.slider).find('>*').first().css('margin-left',  move + 'px');
					}
				};

				var drop = function(){
					var slideWidth = $(state.slider).find('>*').first().outerWidth();
					var dragPos = parseInt($(state.slider).find('>*').first().css('margin-left'));
					var initPos = -$(state.slider).find('>*').first().outerWidth() * state.pos;
					var to = initPos > dragPos ? -Math.floor(dragPos / slideWidth) :
						-Math.ceil(dragPos / slideWidth);

					if(Math.abs(initPos - dragPos) > 50){
						draggingProps.pseudoTrigger = false;
						setPosition(to);
					} else {
						draggingProps.pseudoTrigger = true;
					}
					slide();
				};

				$(state.slider).on('mousedown touchstart', function(event){
					draggingProps.trigger = true;
					draggingProps.pageX.init = event.originalEvent.touches ?
						event.originalEvent.touches[0].pageX : event.pageX;
				});

				$(document).on('mousemove touchmove', function(event){
					if(draggingProps.trigger){
						draggingProps.pageX.current = event.originalEvent.touches ?
							event.originalEvent.touches[0].pageX : event.pageX;
						drag(draggingProps.pageX.init - draggingProps.pageX.current);
					}
				});

				$(document).on('mouseup touchend', function(){
					if(draggingProps.trigger){
						drop();
						draggingProps.trigger = false;
					}
				});

				$(state.slider).find('*').click(function(event){
					if(!draggingProps.pseudoTrigger){
						event.preventDefault();
						event.stopImmediatePropagation();
					}
				});
			}
		});
		return this;
	};

	$.fn.imageLoop = function(props){
		"use strict";
		if(!$(this).length) return this;
		var state = $.extend({
			id: Math.floor(Date.now() / 1000),
			image: this,
			loopStyle: {
				'width': '150px',
				'height': '150px',
				'background-color': 'white',
				'border-radius': '100%',
				'border': '2px solid lightgray'
			},
			wrapper: $('<div></div>').css({
				'display': 'block',
				'position': 'relative'
			})[0]
		}, props);
		
		$(state.image).wrap($(state.wrapper).attr('data-loop-id', state.id));

		$('[data-loop-id=' + state.id + ']').append(
			$('<div></div>').css(state.loopStyle)
				.css({
					'display': 'none',
					'position': 'absolute',
					'left': '50%',
					'top': '50%',
					'z-index': 99999,
					'background-repeat': 'no-repeat',
					'-ms-transform': 'translate(-50%,-50%) scale(1.5)',
					'-webkit-transform': 'translate(-50%,-50%) scale(1.5)',
					'transform': 'translate(-50%,-50%) scale(1.5)',
					'cursor': 'none'
				})
		);

		$('[data-loop-id=' + state.id + ']').on('touchstart mouseenter', function(){
			$(this).find('div').css({
				'background-image': 'url(' + $(state.image).attr('src') + ')',
				'background-size': $(state.image).outerWidth() * 1.0 + 'px, ' +
					$(state.image).outerHeight() * 1.0 + 'px',
			});
		});

		$(document).mousemove(function(event){
			if(!$(state.image).length) return false;

			if(event.pageX > $(state.image).offset().left && event.pageX <
			$(state.image).offset().left + $(state.image).outerWidth() &&

			event.pageY > $(state.image).offset().top && event.pageY <
			$(state.image).offset().top + $(state.image).outerHeight()){
				var x = event.pageX - $(state.image).offset().left;
				var y = event.pageY - $(state.image).offset().top;
				$('[data-loop-id=' + state.id + '] > div').show().css({
					'left': x + 'px',
					'top': y + 'px',
					'background-position': 'top ' +
					(-y + ($('[data-loop-id=' + state.id + '] > div').outerHeight() / 2)) +
					'px left ' +
					(-x + ($('[data-loop-id=' + state.id + '] > div').outerWidth() / 2)) +
					'px'
				});
			} else {
				$('[data-loop-id=' + state.id + '] > div').css({
					'left': 50 + '%',
					'top': 50 + '%',
				}).hide();
			}
		});
	return this;
	};

	$.fn.toggle = function(props, callback){
		"use strict";
		if(!$(this).length) return this;
		var state = $.extend({
			id: Date.now(),
			togglers: this,
			activeClass: 'active',
			animation: {
				'height' : 'toggle'
			},
			speed: 300,
			ease: 'swing',
			scrollTo: false,
			oneOpen: false,
			focused: false
		}, props);

		var getToggleItem = function(toggler){
			if($(toggler).data('toggle-id')){
				return $('#' + $(toggler).data('toggle-id'))[0];
			} if($(toggler).data('toggle-class')){
				return $('.' + $(toggler).data('toggle-class'))[0];
			} if($(toggler).data('toggle-sibling')){
				return $(toggler).siblings($(toggler).data('toggle-sibling'))[0];
			}
		};

		$(this).click(function(event){
			event.preventDefault();

			if(state.oneOpen === true &&
			$(this).hasClass(state.activeClass) ||
			state.oneOpen === true &&
			$(getToggleItem(this)).hasClass(state.activeClass)){
				return false;
			} if(state.oneOpen){
				$(getToggleItem($(state.togglers)
						.filter('.' + state.activeClass)
						.not(this)
						.removeClass(state.activeClass)[0])
				).animate(state.animation, state.speed, state.ease, function(){
					$(this).removeClass(state.activeClass);
				});
			}

			$(getToggleItem(this)).animate(state.animation, state.speed, state.ease,
				function(){
					$(this).toggleClass(state.activeClass);
					if(callback && typeof callback === "function"){
						callback();
					}
				}
			);

			if(state.scrollTo && !$(this).hasClass(state.activeClass)){
				$("html, body").stop().animate({
					scrollTop: $(getToggleItem(this)).offset().top - (100)
				}, state.speed * 1.5, state.ease);
			}
			$(this).toggleClass(state.activeClass);
		});

		if(state.oneOpen === 'focused'){
			$(state.togglers).attr('data-toggle-focus-id', state.id);
			$(getToggleItem(state.togglers)).attr('data-toggle-focus-id', state.id);
			$(state.togglers).each(function(){
				$(getToggleItem(this)).attr('data-toggle-focus-id', state.id);
			})

			$(document).click(function(event){
				if($(event.target).parents('[data-toggle-focus-id="' + state.id + '"]').length === 0 && $(event.target).data('toggle-focus-id') != state.id){
					$(getToggleItem($(state.togglers)
							.filter('.' + state.activeClass)
							.removeClass(state.activeClass)[0])
					).animate(state.animation, state.speed, state.ease, function(){
						$(this).removeClass(state.activeClass);
					});
				}
			});
		}
		return this;
	};


	$.fn.imageUploadUI = function(){
		"use strict";
		if(!!window.URL.createObjectURL && $(this).length){
			var state = {
				input: this,
				appId: $(this).attr('id') ? $(this).attr('id') + "UI" : $.now(),
				getAppAddId: function(){
					return this.appId + 'Add';
				},
				pushInputImages: function(imagesArr){
					console.log(this.input[0].files);
					Array.prototype.push.apply(imagesArr[0], this.input[0].files);
					console.log(this.input[0].files);
				}
			};

			// append UI DOM and remove input element
			$(this).hide().after(
				'<ul id="' + state.appId + '" class="imageUploadUI">' +
					'<li class="addImage">' + 
						'<label for="' + state.getAppAddId() + '"><i class="fas fa-plus"></i></label>' +
						'<input type="file" id="' + state.getAppAddId() + '" name="' + $(this).attr('name') + '" class="hiddenFileInput" accept="' +  $(this).attr('accept') + '" multiple>' +
					'</li>' +
					'<li class="removeImages">' + 
						'<a href="#" for="' + state.getAppAddId() + '"><i class="fas fa-times"></i></a>' +
					'</li>' +
				'</ul>'
			).remove();
			// change labels for to ui dom
			if($(this).attr('id')){
				$('[for="' + $(this).attr('id') + '"]').attr('for', state.getAppAddId());
			}

			var getInputImagesArr = function(domObj){
				var imagesArr = [];
				if(domObj.files){
					for(var key in domObj.files){
						if(domObj.files.hasOwnProperty(key) && domObj.files[key].type.indexOf('image/') >= 0) {
							imagesArr.push(domObj.files[key]);
						}
					}
				}
				return imagesArr;
			}

			var renderImagesDOM = function(imagesArr){
				$('#'+state.appId).find('.ImageItem').remove();
				if(imagesArr.length){
					$('#'+state.appId).find('.addImage').hide();
					$('#'+state.appId).find('.removeImages').show();
					imagesArr.forEach(function(image){
						$('#'+state.appId).prepend(
							'<li class="ImageItem">' +
								'<a href="#">' +
									'<img src="' + window.URL.createObjectURL(image) + '">' +
								'</a>' +
							'</li>'
						);
					});
				} else {
					$('#'+state.appId).find('.addImage').show();
					$('#'+state.appId).find('.removeImages').hide();
				}
			}
			// change event listener - adds images
			$(document).delegate('#'+state.getAppAddId(), 'change', function(){
				renderImagesDOM(getInputImagesArr(this));
			});

			// click event listener removing image
			$(document).delegate('#'+state.appId+' .removeImages a', 'click', function(event){
				event.preventDefault();
				renderImagesDOM(getInputImagesArr($('#'+state.getAppAddId()).val('')[0]));
			});

		}
		return this;
	};

	// product variation application
	window.product_variations_app = function(variations){
		if(!window.post_id || window.is_product_page !== true) return false;
		if(window.post_id && window.is_product_page){
			/**
			 * Application State
			 */
			var state = {
				siteURL: window.wpSiteUrl,
				variations: variations,
				carriers: window.product_carriers,
				current_variation_attributes: {},
				previous_variation_attributes: {},
				current_product_id: parseInt(window.post_id),
				loading_status: false
			}
			
			/**
			 * Function controlling application loading status
			 */
			var loading_status = function(status){
				var loading_dom = $('#variation_app_loading');
				switch (status) {
					case true:
						loading_dom.fadeOut('fast');
						state.loading_status = true;
						break;
					case false:
						loading_dom.fadeIn('fast');
						state.loading_status = false;
						break;
					case 'success':
						loading_dom.find('i').removeAttr('class').addClass('far fa-check').css('color', 'green');
						state.loading_status = true;
						break;
					case 'fail':
						loading_dom.find('i').removeAttr('class').addClass('far fa-times').css('color', 'darkred');
						loading_dom.delay(800).fadeOut('fast', function(){
							$(this).find('i').removeAttr('class').addClass('far fa-circle-notch fa-spin').removeAttr('style');
						});
						state.loading_status = true;
						break;
				}
			}
				
			/**
			 * Function to set variation attibutes
			 */
			
			var set_current_variation_attributes = function(){
				state.current_variation_attributes = {};
				$('.product_page_main_payment_extra_area select').each(function(){
					state.current_variation_attributes[$(this).attr('name')] = $(this).val();
				});
			}

			/**
			 * Function to retrive current variation id
			 */
			var get_variation_id = function(variation_attributes){
				var check_variation = function(variation_query){
					var query_arr = variation_query.split('&');
					for(var variation in variation_attributes){
						if(variation_attributes.hasOwnProperty(variation)){
							if(query_arr.indexOf(variation + '=' + variation_attributes[variation]) < 0){
								return false;
							}
						}
					}
					return true;
				}
				for(var variation_id in state.variations){
					if(state.variations.hasOwnProperty(variation_id)){
						if(check_variation(state.variations[variation_id].query)){
							return variation_id;
						}
					}
				}
				return false;
			}

			/**
			 * Function that renders product price
			 */
			var render_prices = function(variation_id){
				if(variation_id){
					var main_price_dom = $('#product_regular_price span');
					var sale_prices_dom =  $('#product_sale_prices');
					var variation = state.variations[variation_id];
					if(variation.is_on_sale){
						main_price_dom.html(variation.sale_price);
						sale_prices_dom.show()
							.find('.__product_regular_price').html(variation.regular_price);
		
						sale_prices_dom
							.find('.__product_save_price')
							.html(variation.regular_price - variation.sale_price);
					} else {
						sale_prices_dom.hide();
						main_price_dom.html(variation.regular_price);
					}
				}
			}

			/**
			 * Function that renders variation desciption text
			 * and image html
			 */
			var render_description = function(this_dom){
				var data_source = $(this_dom).find('[value="' + $(this_dom).val() + '"]');
				var data_fallback_source = $(this_dom).find('option:first-child');
				var data = {
					text: data_source.data('text'),
					image: data_source.data('image')
				}
				var render_dom = {
					parent: $('[data-for="' + $(this_dom).attr('name') + '"]'),
					text: $('[data-for="' + $(this_dom).attr('name') + '"] .text'),
					image: $('[data-for="' + $(this_dom).attr('name') + '"] .image')
				}
				if(!data.text && !data.image){
					data.text = data_fallback_source.data('text');
					data.image = data_fallback_source.data('image');
				}
				render_dom.text.html(data.text);
				render_dom.image.html(data.image ? '<img src="' + data.image + '" alt="' + data_source.html() + '">' : '');
				render_dom.parent.addClass('active');

				if(!render_dom.text.html() && !render_dom.image.html()){
					render_dom.parent.removeClass('active');
				}
			}

			/**
			 * Function that adds product to cart
			 */
			var add_to_cart = function(product_id){
				if(product_id){
					return $.ajax({
						url: state.siteURL + '/wp-json/msb/v2/cart/add',
						type: 'POST',
						data: {
							product_id: product_id,
							carriers: get_current_carriers(),
						},
						success: function(data) {
							state.redirect_to = data;
						},
						async: true
					});
				}
			}
			/**
			 * Carriers Functions
			 */
			var get_current_carriers = function(){
				var to_return = [];
				$("input[name^='product_carriers']").each(function(){
					to_return.push($(this).val());
				});
				return to_return;
			}

			var is_chosen_carrier = function(carrier_name){
				var chosen_carriers = get_current_carriers();
				for(var i = 0; i < chosen_carriers.length; i++){
					if(chosen_carriers[i].toLowerCase() === carrier_name.toLowerCase()){
						return true;
					}
				}
				return false;
			}

			var add_carrier = function(carrier_name){
				$('#product_page_chosen_carriers').append(
					'<li>' +
						'<a href="#" class="rendered" data-carrier="' + carrier_name + '">' +
							'<input type="checkbox" name="product_carriers[]" value="' + carrier_name + '" checked>' +
							'<span>' + carrier_name + '</span>' +
						'</a>' +
					'</li>'
				).find(".rendered").animate({
					"height": "25px"
				}, 200, 'swing', function(){
					$(this).removeClass("rendered");
				});
				$('#product_carriers').val('');
			}

			var remove_carrier = function(carrier_name){
				$('[data-carrier="' + carrier_name + '"]').animate({
					"height": "0"
				}, 200, 'swing', function(){
					$(this).remove();
				}).find('input').prop("checked", false);
			}

			var render_carriers = function(query){
				query = query.trim();
				var carriers_dom = $('#product_carriers_suggested');
				carriers_dom.html('');
				if(!is_chosen_carrier(query)){
					var regex = new RegExp(query, 'i');
					state.carriers.forEach(function(carrier){
						if(carrier.name.match(regex) && !is_chosen_carrier(carrier.name) && carrier.name.toLowerCase() !== query.toLowerCase()){
							carriers_dom.append(
								'<li>' +
									'<a href="#" data-value="' + carrier.name + '">' + carrier.name + '</a>' +
								'</li>'
							);
						}
					});
					// also render query
					if(query){
						query = query.charAt(0).toUpperCase() + query.slice(1);
						carriers_dom.append(
							'<li>' +
								'<a href="#" data-value="' + query + '">' + query + '</a>' +
							'</li>'
						);
					}
				}
			}
			/**
			 * Application Event listeners
			 */
			// setup product carriers controller logic
			$('#product_carriers')
				// get suggested on keyup and focus
				.on('keyup focus', function(){
					$('#product_carriers_suggested').fadeIn('fast');
					render_carriers($(this).val());
				})
				.on('keyup', function(){
					$(this).removeClass('error');
				})
				// hide suggested on focuseout
				.focusout(function(){
					$('#product_carriers_suggested').fadeOut('fast');
				});

			// add carriers controller
			$(document).delegate('#product_carriers_suggested a', 'click', function(event){
				event.preventDefault();
				$('#product_carriers').removeClass('error');
				add_carrier($(this).data('value'));
			});

			// remove carriers controller
			$(document).delegate('#product_page_chosen_carriers a', 'click', function(event){
				event.preventDefault();
				$('#product_carriers_suggested').removeClass('error');
				remove_carrier($(this).data('carrier'));
			});
			
			// Make calculations when variation selec field in focused
			$('.product_page_main_payment_extra_area select').change(function(){
				set_current_variation_attributes();
				var this_select_dom = this;
				var this_value = $(this).val();
				var attribute = $(this).attr('name');
				$(this).find('> option').each(function(){
					var to_check = state.current_variation_attributes;
					to_check[attribute] = $(this).attr('value');
					var check_results = get_variation_id(to_check);
					if(check_results){
						$(this).removeAttr('disabled');
					} else {
						$(this).attr('disabled', 'true').removeAttr('selected');
						if(this_value === $(this).attr('value')){
							$(this_select_dom).trigger('change');
						}
					}
				});
			});

			// Render prices and description onchange
			$('.product_page_main_payment_extra_area select').change(function(){
				set_current_variation_attributes();
				var variation_id = get_variation_id(state.current_variation_attributes);
				if(variation_id){
					render_prices(variation_id);
				}
				render_description(this);
			});

			// add to cart action when button is clicked
			$('.product_page_main_payment_footer a.submit').click(function(event){
				event.preventDefault();
				if(!state.loading_status) return false;
				if($('#product_carriers').length && !get_current_carriers().length){
					$('#product_carriers').focus().addClass('error');
					return false;
				}
				// get variation id or simple product id
				var variation_id = get_variation_id(state.current_variation_attributes);
				var post_id = window.post_id;
				if(variation_id){
					post_id = variation_id;
				}
				loading_status(false);

				// add to cart controller
				$.when(add_to_cart(post_id)).done(function(){
					loading_status('success');
					window.location.href = state.redirect_to;
				}).fail(function(){
					loading_status('fail');
				});
			});

			// render initial descriptions
			$('.product_page_main_payment_extra_area select').each(function(){
				render_description(this);
			});
			// set initial variation attributes
			set_current_variation_attributes();
			var variation_id = get_variation_id(state.current_variation_attributes);
			// render intioal price
			render_prices(variation_id);
			loading_status(true);
		}
	}

	// product comment post app
	window.comment_post_app = function(props){
		var state = {
			siteURL: window.wpSiteUrl,
			loading_status: false,
			is_admin: props.is_admin,
			dom: props.dom
		}

		if(!$(state.dom.form).length) return false;

		var loading_status = function(status){
			if(status === undefined) return false;
			if(status === true){
				$(state.dom.loading).fadeOut('fast').find('>i').show();
				$(state.dom.loading).find('.success').hide();
				state.loading_status = true;
			} if(status === false) {
				$(state.dom.loading).fadeIn('fast').find('>i').show();
				$(state.dom.loading).find('.success').hide();
				state.loading_status = false;
			} if(status === 'success'){
				$(state.dom.loading).find('.success').show();
				$(state.dom.loading).find('>i').hide().removeAttr('class')
				.addClass('fas fa-check').css('color', 'green');
				
				$(state.dom.loading).delay(3500).fadeOut('fast', function(){
					$(state.dom.loading).find('>i').removeAttr('class')
					.addClass('far fa-circle-notch fa-spin').removeAttr('style');

					$(state.dom.trigger_button).trigger('click');
					state.loading_status = true;

					clear_form_values();
				});

			} if(status === 'fail'){
				state.loading_status = true;
				$(state.dom.loading).find('>i').show().removeAttr('class').addClass('fas fa-times').css('color', 'darkred');
				$(state.dom.loading).find('.success').hide();
				$(state.dom.loading).delay(800).fadeOut('fast', function(){
					$(this).find('>i').removeAttr('class').addClass('far fa-circle-notch fa-spin').removeAttr('style');
					state.loading_status = true;
				});
			}
		}

		var clear_form_values = function(){
			$(state.dom.form).find('input[type=text], textarea, input[type=email], select, input[type=file]')
			.val('').trigger('change')
			.find('*:selected').removeAttr('selected').trigger('change');
			
			$('.write_rating .active').removeClass('active');
		}

		var post_comment = function(){
			var post_data = {};
			if(!!window.FormData){
				post_data = new FormData(document.querySelector(state.dom.form));
			} else {
				post_data = $.param($(state.dom.form).serializeArray());
			}
			return $.ajax({
				type: 'POST',
				url: state.is_admin ? $(state.dom.form).attr('action') : state.siteURL + '/wp-json/msb/v2/comment/post',
				data: post_data,
				contentType: false,
				processData: false
			});
		}

		$(state.dom.form).validate(props.validation_rules, function(event){
			event.preventDefault();
			if(state.loading_status === true){
				loading_status(false);
				$.when(post_comment()).done(function(){
					loading_status('success');
				}).fail(function(){
					loading_status('fail');
				});
			}
		});
		loading_status(true);
	}

	// product comment get app
	window.comment_list_app = function(props){
		if(!props || !props.app_props) return false;
		var state = {
			siteURL: props.siteURL,
			product_id: parseInt(window.post_id),
			dom: props.dom,
			stars_image: props.app_props.stars_image,
			answer_thumb_url: props.app_props.answer_thumb_url,
			text_var: {
				product_link: props.app_props.product_link,
				share_text: props.app_props.share_text,
				verified_text: props.app_props.verified_text
			},
			type__not_in: props.type__not_in,
			loading_status: false,
			comments_to_render: [],
			page: 1,
			per_page: props.per_page
		}

		if(!$(state.dom.list).length) return false;

		var loading_status = function(status){
			if(status === undefined) return false;

			if(status === true){
				$(state.dom.loading).fadeOut('fast');
				state.loading_status = true;

			} if(status === false) {
				$(state.dom.loading).fadeIn('fast');
				state.loading_status = false;

			} if(status === 'end') {
				state.loading_status = false;
				$(state.dom.loading).fadeOut('fast');
				$(state.dom.show_more).hide();
			}

		}

		var get_comments = function(){
			return $.ajax({
				type: 'GET',
				url: state.siteURL + '/wp-json/msb/v2/comment/list',
				data: {
					post_id: parseInt(state.product_id),
					type__not_in: state.type__not_in,
					per_page: state.per_page,
					page: state.page
				},
				success: function(data){
					state.comments_to_render = data;
					state.page++;
				}
			});
		}

		var render_comment_children = function(children){
			var to_render = '';
			if(children.length === 0) return to_render;
			children.forEach(function(child){
				to_render +=
				'<div class="answer">' +
					'<div class="side">' +
						'<img src="' + state.answer_thumb_url + '" alt="' + child.comment_author + '">' +
					'</div>' +
					'<div class="main">' +
						'<header><b>' + child.comment_author + '</b><span>' + child.comment_date.replace(/ .*/,'').replace(new RegExp('-', 'g'), '/') + '</span></header>' +
						'<p>' + child.comment_content + '</p>' +
					'</div>' +
				'</div>';
			});
			return to_render;
		}

		var render_comment_rating = function(rating){
			if(rating){
				return '<div class="rating" style="background-image: url(\'' + state.stars_image + '\')"><span style="background-image: url(\'' + state.stars_image + '\'); width: ' + (rating * 20) + '%;"></span></div>';
			}
			return '';
		}

		var render_comment_attachments = function(attachments, alt){
			var to_return = '';
			if(attachments){
				attachments.forEach(function(attachment){
					to_return += '<li><a href="' + attachment + '" target="_blank"><img src="' + attachment + '" alt="' + alt + '"></a>';
				});
			}
			return to_return;
		}

		var render_comments = function(){
			state.comments_to_render.forEach(function(data){
				$(state.dom.list).append(
					'<article>' +
					'<div class="side">' + data.comment.comment_author.slice(0, 1).toUpperCase() + '</div>' +
					'<div class="main">' +
						'<header><b>' + data.comment.comment_author +'</b> ' + state.text_var.verified_text + '<span>' + data.comment.comment_date.replace(/ .*/,'').replace(new RegExp('-', 'g'), '/') + '</span></header>' +		
						render_comment_rating(data.rating) +
						'<p>' + data.comment.comment_content + '</p>' +
						'<ul class="attachments">' + render_comment_attachments(data.attachments, data.comment.comment_content) + '</ul>' +
						'<footer>' +
							'<a href="#" data-toggle-sibling="ul">' + state.text_var.share_text + '</a>' +
							'<ul>' +
								'<li><a rel="noreferrer" href="https://www.facebook.com/sharer/sharer.php?u=' + state.text_var.product_link + '" target="_blank">Facebook</a></li>' +
								'<li><a rel="noreferrer" href="http://twitter.com/share?text=' + data.comment.comment_content + '&url=' + state.text_var.product_link + '" target="_blank">Twitter</a></li>' +
								'<li><a rel="noreferrer" href="https://www.linkedin.com/shareArticle?mini=true&source=Yotpo&summary=' + data.comment.comment_content + '&url=' + state.text_var.product_link + '" target="_blank">LinkedIn</a></li>' +
							'</ul>' +
						'</footer>' +
						render_comment_children(data.children) +
					'</div>' +
				'</article>'
				);
			});
		}

		var get_and_render_comments = function(){
			$.when(get_comments()).done(function(){
				if(state.comments_to_render.length === 0 || state.comments_to_render.length < state.per_page){
					loading_status('end');
				} else {
					loading_status(true);
				}
				render_comments();
			});
		}

		get_and_render_comments();

		$(state.dom.show_more).click(function(event){
			event.preventDefault();
			if(!state.loading_status) return false;
			loading_status(false);
			get_and_render_comments();
		});
	}

	// init readmore
	$('.readmore').toggle().click(function(event){
		event.preventDefault();
		if($(this).data('less')){
			if($(this).html() != $(this).data('less')){
				$(this).html($(this).data('less'));
			} else {
				$(this).html($(this).data('more'));
			}
		} else {
			$(this).fadeOut();
		}
	});
	
	// init lazyload
	$('.lazyload').lazyLoad({'action': 'load'}, function(element, src){
		var animation = { opacity: 1 };
		if(src){
			$(element).each(function(){
				$(this).on('load', function(){
					$(this).animate(animation, 300, function(){
						if($(this).parents('.image_loader').length){
							$(this).parents('.image_loader').addClass('loaded');
						}
					});
				});
			})
		}
	});

	$('div.woocommerce').on('change', '.qty', function(){
		$("[name='update_cart']").prop("disabled", false);
		$("[name='update_cart']").trigger("click");
	});
})(jQuery);
//B2B Script start
"use strict"
jQuery(function ($) {
	let qty = $('.b2b_sec2TextSecItem').length;
	for (let i = 0; i < qty; i++) {
		$('.b2b_sec2TextSecItem').eq(i).append(`<span class='itemN'>${i + 1}</span>`);
	}

// Slider

var defaults = {
	item: 3,
	autoWidth: false,
	slideMove: 1,
	slideMargin: 10,
	addClass: '',
	mode: 'slide',
	useCSS: true,
	cssEasing: 'ease', //'cubic-bezier(0.25, 0, 0.25, 1)',
	easing: 'linear', //'for jquery animation',//
	speed: 400, //ms'
	auto: false,
	pauseOnHover: false,
	loop: false,
	slideEndAnimation: true,
	pause: 2000,
	keyPress: false,
	controls: true,
	prevHtml: '',
	nextHtml: '',
	rtl: false,
	adaptiveHeight: false,
	vertical: false,
	verticalHeight: 500,
	vThumbWidth: 100,
	thumbItem: 10,
	pager: true,
	gallery: false,
	galleryMargin: 5,
	thumbMargin: 5,
	currentPagerPosition: 'middle',
	enableTouch: true,
	enableDrag: true,
	freeMove: true,
	swipeThreshold: 40,
	responsive: [],
	/* jshint ignore:start */
	onBeforeStart: function ($el) { },
	onSliderLoad: function ($el) { },
	onBeforeSlide: function ($el, scene) { },
	onAfterSlide: function ($el, scene) { },
	onBeforeNextSlide: function ($el, scene) { },
	onBeforePrevSlide: function ($el, scene) { }
	/* jshint ignore:end */
};
$.fn.lightSlider = function (options) {
	if (this.length === 0) {
		return this;
	}

	if (this.length > 1) {
		this.each(function () {
			$(this).lightSlider(options);
		});
		return this;
	}

	var plugin = {},
		settings = $.extend(true, {}, defaults, options),
		settingsTemp = {},
		$el = this;
	plugin.$el = this;

	if (settings.mode === 'fade') {
		settings.vertical = false;
	}
	var $children = $el.children(),
		windowW = $(window).width(),
		breakpoint = null,
		resposiveObj = null,
		length = 0,
		w = 0,
		on = false,
		elSize = 0,
		$slide = '',
		scene = 0,
		property = (settings.vertical === true) ? 'height' : 'width',
		gutter = (settings.vertical === true) ? 'margin-bottom' : 'margin-right',
		slideValue = 0,
		pagerWidth = 0,
		slideWidth = 0,
		thumbWidth = 0,
		interval = null,
		isTouch = ('ontouchstart' in document.documentElement);
	var refresh = {};

	refresh.chbreakpoint = function () {
		windowW = $(window).width();
		if (settings.responsive.length) {
			var item;
			if (settings.autoWidth === false) {
				item = settings.item;
			}
			if (windowW < settings.responsive[0].breakpoint) {
				for (var i = 0; i < settings.responsive.length; i++) {
					if (windowW < settings.responsive[i].breakpoint) {
						breakpoint = settings.responsive[i].breakpoint;
						resposiveObj = settings.responsive[i];
					}
				}
			}
			if (typeof resposiveObj !== 'undefined' && resposiveObj !== null) {
				for (var j in resposiveObj.settings) {
					if (resposiveObj.settings.hasOwnProperty(j)) {
						if (typeof settingsTemp[j] === 'undefined' || settingsTemp[j] === null) {
							settingsTemp[j] = settings[j];
						}
						settings[j] = resposiveObj.settings[j];
					}
				}
			}
			if (!$.isEmptyObject(settingsTemp) && windowW > settings.responsive[0].breakpoint) {
				for (var k in settingsTemp) {
					if (settingsTemp.hasOwnProperty(k)) {
						settings[k] = settingsTemp[k];
					}
				}
			}
			if (settings.autoWidth === false) {
				if (slideValue > 0 && slideWidth > 0) {
					if (item !== settings.item) {
						scene = Math.round(slideValue / ((slideWidth + settings.slideMargin) * settings.slideMove));
					}
				}
			}
		}
	};

	refresh.calSW = function () {
		if (settings.autoWidth === false) {
			slideWidth = (elSize - ((settings.item * (settings.slideMargin)) - settings.slideMargin)) / settings.item;
		}
	};

	refresh.calWidth = function (cln) {
		var ln = cln === true ? $slide.find('.lslide').length : $children.length;
		if (settings.autoWidth === false) {
			w = ln * (slideWidth + settings.slideMargin);
		} else {
			w = 0;
			for (var i = 0; i < ln; i++) {
				w += (parseInt($children.eq(i).width()) + settings.slideMargin);
			}
		}
		return w;
	};
	plugin = {
		doCss: function () {
			var support = function () {
				var transition = ['transition', 'MozTransition', 'WebkitTransition', 'OTransition', 'msTransition', 'KhtmlTransition'];
				var root = document.documentElement;
				for (var i = 0; i < transition.length; i++) {
					if (transition[i] in root.style) {
						return true;
					}
				}
			};
			if (settings.useCSS && support()) {
				return true;
			}
			return false;
		},
		keyPress: function () {
			if (settings.keyPress) {
				$(document).on('keyup.lightslider', function (e) {
					if (!$(':focus').is('input, textarea')) {
						if (e.preventDefault) {
							e.preventDefault();
						} else {
							e.returnValue = false;
						}
						if (e.keyCode === 37) {
							$el.goToPrevSlide();
						} else if (e.keyCode === 39) {
							$el.goToNextSlide();
						}
					}
				});
			}
		},
		controls: function () {
			if (settings.controls) {
				$el.after('<div class="lSAction"><a class="lSPrev">' + settings.prevHtml + '</a><a class="lSNext">' + settings.nextHtml + '</a></div>');
				if (!settings.autoWidth) {
					if (length <= settings.item) {
						$slide.find('.lSAction').hide();
					}
				} else {
					if (refresh.calWidth(false) < elSize) {
						$slide.find('.lSAction').hide();
					}
				}
				$slide.find('.lSAction a').on('click', function (e) {
					if (e.preventDefault) {
						e.preventDefault();
					} else {
						e.returnValue = false;
					}
					if ($(this).attr('class') === 'lSPrev') {
						$el.goToPrevSlide();
					} else {
						$el.goToNextSlide();
					}
					return false;
				});
			}
		},
		initialStyle: function () {
			var $this = this;
			if (settings.mode === 'fade') {
				settings.autoWidth = false;
				settings.slideEndAnimation = false;
			}
			if (settings.auto) {
				settings.slideEndAnimation = false;
			}
			if (settings.autoWidth) {
				settings.slideMove = 1;
				settings.item = 1;
			}
			if (settings.loop) {
				settings.slideMove = 1;
				settings.freeMove = false;
			}
			settings.onBeforeStart.call(this, $el);
			refresh.chbreakpoint();
			$el.addClass('lightSlider').wrap('<div class="lSSlideOuter ' + settings.addClass + '"><div class="lSSlideWrapper"></div></div>');
			$slide = $el.parent('.lSSlideWrapper');
			if (settings.rtl === true) {
				$slide.parent().addClass('lSrtl');
			}
			if (settings.vertical) {
				$slide.parent().addClass('vertical');
				elSize = settings.verticalHeight;
				$slide.css('height', elSize + 'px');
			} else {
				elSize = $el.outerWidth();
			}
			$children.addClass('lslide');
			if (settings.loop === true && settings.mode === 'slide') {
				refresh.calSW();
				refresh.clone = function () {
					if (refresh.calWidth(true) > elSize) {
						/**/
						var tWr = 0,
							tI = 0;
						for (var k = 0; k < $children.length; k++) {
							tWr += (parseInt($el.find('.lslide').eq(k).width()) + settings.slideMargin);
							tI++;
							if (tWr >= (elSize + settings.slideMargin)) {
								break;
							}
						}
						var tItem = settings.autoWidth === true ? tI : settings.item;

						/**/
						if (tItem < $el.find('.clone.left').length) {
							for (var i = 0; i < $el.find('.clone.left').length - tItem; i++) {
								$children.eq(i).remove();
							}
						}
						if (tItem < $el.find('.clone.right').length) {
							for (var j = $children.length - 1; j > ($children.length - 1 - $el.find('.clone.right').length); j--) {
								scene--;
								$children.eq(j).remove();
							}
						}
						/**/
						for (var n = $el.find('.clone.right').length; n < tItem; n++) {
							$el.find('.lslide').eq(n).clone().removeClass('lslide').addClass('clone right').appendTo($el);
							scene++;
						}
						for (var m = $el.find('.lslide').length - $el.find('.clone.left').length; m > ($el.find('.lslide').length - tItem); m--) {
							$el.find('.lslide').eq(m - 1).clone().removeClass('lslide').addClass('clone left').prependTo($el);
						}
						$children = $el.children();
					} else {
						if ($children.hasClass('clone')) {
							$el.find('.clone').remove();
							$this.move($el, 0);
						}
					}
				};
				refresh.clone();
			}
			refresh.sSW = function () {
				length = $children.length;
				if (settings.rtl === true && settings.vertical === false) {
					gutter = 'margin-left';
				}
				if (settings.autoWidth === false) {
					$children.css(property, slideWidth + 'px');
				}
				$children.css(gutter, settings.slideMargin + 'px');
				w = refresh.calWidth(false);
				$el.css(property, w + 'px');
				if (settings.loop === true && settings.mode === 'slide') {
					if (on === false) {
						scene = $el.find('.clone.left').length;
					}
				}
			};
			refresh.calL = function () {
				$children = $el.children();
				length = $children.length;
			};
			if (this.doCss()) {
				$slide.addClass('usingCss');
			}
			refresh.calL();
			if (settings.mode === 'slide') {
				refresh.calSW();
				refresh.sSW();
				if (settings.loop === true) {
					slideValue = $this.slideValue();
					this.move($el, slideValue);
				}
				if (settings.vertical === false) {
					this.setHeight($el, false);
				}

			} else {
				this.setHeight($el, true);
				$el.addClass('lSFade');
				if (!this.doCss()) {
					$children.fadeOut(0);
					$children.eq(scene).fadeIn(0);
				}
			}
			if (settings.loop === true && settings.mode === 'slide') {
				$children.eq(scene).addClass('active');
			} else {
				$children.first().addClass('active');
			}
		},
		pager: function () {
			var $this = this;
			refresh.createPager = function () {
				thumbWidth = (elSize - ((settings.thumbItem * (settings.thumbMargin)) - settings.thumbMargin)) / settings.thumbItem;
				var $children = $slide.find('.lslide');
				var length = $slide.find('.lslide').length;
				var i = 0,
					pagers = '',
					v = 0;
				for (i = 0; i < length; i++) {
					if (settings.mode === 'slide') {
						// calculate scene * slide value
						if (!settings.autoWidth) {
							v = i * ((slideWidth + settings.slideMargin) * settings.slideMove);
						} else {
							v += ((parseInt($children.eq(i).width()) + settings.slideMargin) * settings.slideMove);
						}
					}
					var thumb = $children.eq(i * settings.slideMove).attr('data-thumb');
					if (settings.gallery === true) {
						pagers += '<li style="width:100%;' + property + ':' + thumbWidth + 'px;' + gutter + ':' + settings.thumbMargin + 'px"><a href="#"><img src="' + thumb + '" /></a></li>';
					} else {
						pagers += '<li><a href="#">' + (i + 1) + '</a></li>';
					}
					if (settings.mode === 'slide') {
						if ((v) >= w - elSize - settings.slideMargin) {
							i = i + 1;
							var minPgr = 2;
							if (settings.autoWidth) {
								pagers += '<li><a href="#">' + (i + 1) + '</a></li>';
								minPgr = 1;
							}
							if (i < minPgr) {
								pagers = null;
								$slide.parent().addClass('noPager');
							} else {
								$slide.parent().removeClass('noPager');
							}
							break;
						}
					}
				}
				var $cSouter = $slide.parent();
				$cSouter.find('.lSPager').html(pagers);
				if (settings.gallery === true) {
					if (settings.vertical === true) {
						// set Gallery thumbnail width
						$cSouter.find('.lSPager').css('width', settings.vThumbWidth + 'px');
					}
					pagerWidth = (i * (settings.thumbMargin + thumbWidth)) + 0.5;
					$cSouter.find('.lSPager').css({
						property: pagerWidth + 'px',
						'transition-duration': settings.speed + 'ms'
					});
					if (settings.vertical === true) {
						$slide.parent().css('padding-right', (settings.vThumbWidth + settings.galleryMargin) + 'px');
					}
					$cSouter.find('.lSPager').css(property, pagerWidth + 'px');
				}
				var $pager = $cSouter.find('.lSPager').find('li');
				$pager.first().addClass('active');
				$pager.on('click', function () {
					if (settings.loop === true && settings.mode === 'slide') {
						scene = scene + ($pager.index(this) - $cSouter.find('.lSPager').find('li.active').index());
					} else {
						scene = $pager.index(this);
					}
					$el.mode(false);
					if (settings.gallery === true) {
						$this.slideThumb();
					}
					return false;
				});
			};
			if (settings.pager) {
				var cl = 'lSpg';
				if (settings.gallery) {
					cl = 'lSGallery';
				}
				$slide.after('<ul class="lSPager ' + cl + '"></ul>');
				var gMargin = (settings.vertical) ? 'margin-left' : 'margin-top';
				$slide.parent().find('.lSPager').css(gMargin, settings.galleryMargin + 'px');
				refresh.createPager();
			}

			setTimeout(function () {
				refresh.init();
			}, 0);
		},
		setHeight: function (ob, fade) {
			var obj = null,
				$this = this;
			if (settings.loop) {
				obj = ob.children('.lslide ').first();
			} else {
				obj = ob.children().first();
			}
			var setCss = function () {
				var tH = obj.outerHeight(),
					tP = 0,
					tHT = tH;
				if (fade) {
					tH = 0;
					tP = ((tHT) * 100) / elSize;
				}
				ob.css({
					'height': tH + 'px',
					'padding-bottom': tP + '%'
				});
			};
			setCss();
			if (obj.find('img').length) {
				if (obj.find('img')[0].complete) {
					setCss();
					if (!interval) {
						$this.auto();
					}
				} else {
					obj.find('img').on('load', function () {
						setTimeout(function () {
							setCss();
							if (!interval) {
								$this.auto();
							}
						}, 100);
					});
				}
			} else {
				if (!interval) {
					$this.auto();
				}
			}
		},
		active: function (ob, t) {
			if (this.doCss() && settings.mode === 'fade') {
				$slide.addClass('on');
			}
			var sc = 0;
			if (scene * settings.slideMove < length) {
				ob.removeClass('active');
				if (!this.doCss() && settings.mode === 'fade' && t === false) {
					ob.fadeOut(settings.speed);
				}
				if (t === true) {
					sc = scene;
				} else {
					sc = scene * settings.slideMove;
				}
				//t === true ? sc = scene : sc = scene * settings.slideMove;
				var l, nl;
				if (t === true) {
					l = ob.length;
					nl = l - 1;
					if (sc + 1 >= l) {
						sc = nl;
					}
				}
				if (settings.loop === true && settings.mode === 'slide') {
					//t === true ? sc = scene - $el.find('.clone.left').length : sc = scene * settings.slideMove;
					if (t === true) {
						sc = scene - $el.find('.clone.left').length;
					} else {
						sc = scene * settings.slideMove;
					}
					if (t === true) {
						l = ob.length;
						nl = l - 1;
						if (sc + 1 === l) {
							sc = nl;
						} else if (sc + 1 > l) {
							sc = 0;
						}
					}
				}

				if (!this.doCss() && settings.mode === 'fade' && t === false) {
					ob.eq(sc).fadeIn(settings.speed);
				}
				ob.eq(sc).addClass('active');
			} else {
				ob.removeClass('active');
				ob.eq(ob.length - 1).addClass('active');
				if (!this.doCss() && settings.mode === 'fade' && t === false) {
					ob.fadeOut(settings.speed);
					ob.eq(sc).fadeIn(settings.speed);
				}
			}
		},
		move: function (ob, v) {
			if (settings.rtl === true) {
				v = -v;
			}
			if (this.doCss()) {
				if (settings.vertical === true) {
					ob.css({
						'transform': 'translate3d(0px, ' + (-v) + 'px, 0px)',
						'-webkit-transform': 'translate3d(0px, ' + (-v) + 'px, 0px)'
					});
				} else {
					ob.css({
						'transform': 'translate3d(' + (-v) + 'px, 0px, 0px)',
						'-webkit-transform': 'translate3d(' + (-v) + 'px, 0px, 0px)',
					});
				}
			} else {
				if (settings.vertical === true) {
					ob.css('position', 'relative').animate({
						top: -v + 'px'
					}, settings.speed, settings.easing);
				} else {
					ob.css('position', 'relative').animate({
						left: -v + 'px'
					}, settings.speed, settings.easing);
				}
			}
			var $thumb = $slide.parent().find('.lSPager').find('li');
			this.active($thumb, true);
		},
		fade: function () {
			this.active($children, false);
			var $thumb = $slide.parent().find('.lSPager').find('li');
			this.active($thumb, true);
		},
		slide: function () {
			var $this = this;
			refresh.calSlide = function () {
				if (w > elSize) {
					slideValue = $this.slideValue();
					$this.active($children, false);
					if ((slideValue) > w - elSize - settings.slideMargin) {
						slideValue = w - elSize - settings.slideMargin;
					} else if (slideValue < 0) {
						slideValue = 0;
					}
					$this.move($el, slideValue);
					if (settings.loop === true && settings.mode === 'slide') {
						if (scene >= (length - ($el.find('.clone.left').length / settings.slideMove))) {
							$this.resetSlide($el.find('.clone.left').length);
						}
						if (scene === 0) {
							$this.resetSlide($slide.find('.lslide').length);
						}
					}
				}
			};
			refresh.calSlide();
		},
		resetSlide: function (s) {
			var $this = this;
			$slide.find('.lSAction a').addClass('disabled');
			setTimeout(function () {
				scene = s;
				$slide.css('transition-duration', '0ms');
				slideValue = $this.slideValue();
				$this.active($children, false);
				plugin.move($el, slideValue);
				setTimeout(function () {
					$slide.css('transition-duration', settings.speed + 'ms');
					$slide.find('.lSAction a').removeClass('disabled');
				}, 50);
			}, settings.speed + 100);
		},
		slideValue: function () {
			var _sV = 0;
			if (settings.autoWidth === false) {
				_sV = scene * ((slideWidth + settings.slideMargin) * settings.slideMove);
			} else {
				_sV = 0;
				for (var i = 0; i < scene; i++) {
					_sV += (parseInt($children.eq(i).width()) + settings.slideMargin);
				}
			}
			return _sV;
		},
		slideThumb: function () {
			var position;
			switch (settings.currentPagerPosition) {
				case 'left':
					position = 0;
					break;
				case 'middle':
					position = (elSize / 2) - (thumbWidth / 2);
					break;
				case 'right':
					position = elSize - thumbWidth;
			}
			var sc = scene - $el.find('.clone.left').length;
			var $pager = $slide.parent().find('.lSPager');
			if (settings.mode === 'slide' && settings.loop === true) {
				if (sc >= $pager.children().length) {
					sc = 0;
				} else if (sc < 0) {
					sc = $pager.children().length;
				}
			}
			var thumbSlide = sc * ((thumbWidth + settings.thumbMargin)) - (position);
			if ((thumbSlide + elSize) > pagerWidth) {
				thumbSlide = pagerWidth - elSize - settings.thumbMargin;
			}
			if (thumbSlide < 0) {
				thumbSlide = 0;
			}
			this.move($pager, thumbSlide);
		},
		auto: function () {
			if (settings.auto) {
				clearInterval(interval);
				interval = setInterval(function () {
					$el.goToNextSlide();
				}, settings.pause);
			}
		},
		pauseOnHover: function () {
			var $this = this;
			if (settings.auto && settings.pauseOnHover) {
				$slide.on('mouseenter', function () {
					$(this).addClass('ls-hover');
					$el.pause();
					settings.auto = true;
				});
				$slide.on('mouseleave', function () {
					$(this).removeClass('ls-hover');
					if (!$slide.find('.lightSlider').hasClass('lsGrabbing')) {
						$this.auto();
					}
				});
			}
		},
		touchMove: function (endCoords, startCoords) {
			$slide.css('transition-duration', '0ms');
			if (settings.mode === 'slide') {
				var distance = endCoords - startCoords;
				var swipeVal = slideValue - distance;
				if ((swipeVal) >= w - elSize - settings.slideMargin) {
					if (settings.freeMove === false) {
						swipeVal = w - elSize - settings.slideMargin;
					} else {
						var swipeValT = w - elSize - settings.slideMargin;
						swipeVal = swipeValT + ((swipeVal - swipeValT) / 5);

					}
				} else if (swipeVal < 0) {
					if (settings.freeMove === false) {
						swipeVal = 0;
					} else {
						swipeVal = swipeVal / 5;
					}
				}
				this.move($el, swipeVal);
			}
		},

		touchEnd: function (distance) {
			$slide.css('transition-duration', settings.speed + 'ms');
			if (settings.mode === 'slide') {
				var mxVal = false;
				var _next = true;
				slideValue = slideValue - distance;
				if ((slideValue) > w - elSize - settings.slideMargin) {
					slideValue = w - elSize - settings.slideMargin;
					if (settings.autoWidth === false) {
						mxVal = true;
					}
				} else if (slideValue < 0) {
					slideValue = 0;
				}
				var gC = function (next) {
					var ad = 0;
					if (!mxVal) {
						if (next) {
							ad = 1;
						}
					}
					if (!settings.autoWidth) {
						var num = slideValue / ((slideWidth + settings.slideMargin) * settings.slideMove);
						scene = parseInt(num) + ad;
						if (slideValue >= (w - elSize - settings.slideMargin)) {
							if (num % 1 !== 0) {
								scene++;
							}
						}
					} else {
						var tW = 0;
						for (var i = 0; i < $children.length; i++) {
							tW += (parseInt($children.eq(i).width()) + settings.slideMargin);
							scene = i + ad;
							if (tW >= slideValue) {
								break;
							}
						}
					}
				};
				if (distance >= settings.swipeThreshold) {
					gC(false);
					_next = false;
				} else if (distance <= -settings.swipeThreshold) {
					gC(true);
					_next = false;
				}
				$el.mode(_next);
				this.slideThumb();
			} else {
				if (distance >= settings.swipeThreshold) {
					$el.goToPrevSlide();
				} else if (distance <= -settings.swipeThreshold) {
					$el.goToNextSlide();
				}
			}
		},



		enableDrag: function () {
			var $this = this;
			if (!isTouch) {
				var startCoords = 0,
					endCoords = 0,
					isDraging = false;
				$slide.find('.lightSlider').addClass('lsGrab');
				$slide.on('mousedown', function (e) {
					if (w < elSize) {
						if (w !== 0) {
							return false;
						}
					}
					if ($(e.target).attr('class') !== ('lSPrev') && $(e.target).attr('class') !== ('lSNext')) {
						startCoords = (settings.vertical === true) ? e.pageY : e.pageX;
						isDraging = true;
						if (e.preventDefault) {
							e.preventDefault();
						} else {
							e.returnValue = false;
						}
						// ** Fix for webkit cursor issue https://code.google.com/p/chromium/issues/detail?id=26723
						$slide.scrollLeft += 1;
						$slide.scrollLeft -= 1;
						// *
						$slide.find('.lightSlider').removeClass('lsGrab').addClass('lsGrabbing');
						clearInterval(interval);
					}
				});
				$(window).on('mousemove', function (e) {
					if (isDraging) {
						endCoords = (settings.vertical === true) ? e.pageY : e.pageX;
						$this.touchMove(endCoords, startCoords);
					}
				});
				$(window).on('mouseup', function (e) {
					if (isDraging) {
						$slide.find('.lightSlider').removeClass('lsGrabbing').addClass('lsGrab');
						isDraging = false;
						endCoords = (settings.vertical === true) ? e.pageY : e.pageX;
						var distance = endCoords - startCoords;
						if (Math.abs(distance) >= settings.swipeThreshold) {
							$(window).on('click.ls', function (e) {
								if (e.preventDefault) {
									e.preventDefault();
								} else {
									e.returnValue = false;
								}
								e.stopImmediatePropagation();
								e.stopPropagation();
								$(window).off('click.ls');
							});
						}

						$this.touchEnd(distance);

					}
				});
			}
		},




		enableTouch: function () {
			var $this = this;
			if (isTouch) {
				var startCoords = {},
					endCoords = {};
				$slide.on('touchstart', function (e) {
					endCoords = e.originalEvent.targetTouches[0];
					startCoords.pageX = e.originalEvent.targetTouches[0].pageX;
					startCoords.pageY = e.originalEvent.targetTouches[0].pageY;
					clearInterval(interval);
				});
				$slide.on('touchmove', function (e) {
					if (w < elSize) {
						if (w !== 0) {
							return false;
						}
					}
					var orig = e.originalEvent;
					endCoords = orig.targetTouches[0];
					var xMovement = Math.abs(endCoords.pageX - startCoords.pageX);
					var yMovement = Math.abs(endCoords.pageY - startCoords.pageY);
					if (settings.vertical === true) {
						if ((yMovement * 3) > xMovement) {
							e.preventDefault();
						}
						$this.touchMove(endCoords.pageY, startCoords.pageY);
					} else {
						if ((xMovement * 3) > yMovement) {
							e.preventDefault();
						}
						$this.touchMove(endCoords.pageX, startCoords.pageX);
					}

				});
				$slide.on('touchend', function () {
					if (w < elSize) {
						if (w !== 0) {
							return false;
						}
					}
					var distance;
					if (settings.vertical === true) {
						distance = endCoords.pageY - startCoords.pageY;
					} else {
						distance = endCoords.pageX - startCoords.pageX;
					}
					$this.touchEnd(distance);
				});
			}
		},
		build: function () {
			var $this = this;
			$this.initialStyle();
			if (this.doCss()) {

				if (settings.enableTouch === true) {
					$this.enableTouch();
				}
				if (settings.enableDrag === true) {
					$this.enableDrag();
				}
			}

			$(window).on('focus', function () {
				$this.auto();
			});

			$(window).on('blur', function () {
				clearInterval(interval);
			});

			$this.pager();
			$this.pauseOnHover();
			$this.controls();
			$this.keyPress();
		}
	};
	plugin.build();
	refresh.init = function () {
		refresh.chbreakpoint();
		if (settings.vertical === true) {
			if (settings.item > 1) {
				elSize = settings.verticalHeight;
			} else {
				elSize = $children.outerHeight();
			}
			$slide.css('height', elSize + 'px');
		} else {
			elSize = $slide.outerWidth();
		}
		if (settings.loop === true && settings.mode === 'slide') {
			refresh.clone();
		}
		refresh.calL();
		if (settings.mode === 'slide') {
			$el.removeClass('lSSlide');
		}
		if (settings.mode === 'slide') {
			refresh.calSW();
			refresh.sSW();
		}
		setTimeout(function () {
			if (settings.mode === 'slide') {
				$el.addClass('lSSlide');
			}
		}, 1000);
		if (settings.pager) {
			refresh.createPager();
		}
		if (settings.adaptiveHeight === true && settings.vertical === false) {
			$el.css('height', $children.eq(scene).outerHeight(true));
		}
		if (settings.adaptiveHeight === false) {
			if (settings.mode === 'slide') {
				if (settings.vertical === false) {
					plugin.setHeight($el, false);
				} else {
					plugin.auto();
				}
			} else {
				plugin.setHeight($el, true);
			}
		}
		if (settings.gallery === true) {
			plugin.slideThumb();
		}
		if (settings.mode === 'slide') {
			plugin.slide();
		}
		if (settings.autoWidth === false) {
			if ($children.length <= settings.item) {
				$slide.find('.lSAction').hide();
			} else {
				$slide.find('.lSAction').show();
			}
		} else {
			if ((refresh.calWidth(false) < elSize) && (w !== 0)) {
				$slide.find('.lSAction').hide();
			} else {
				$slide.find('.lSAction').show();
			}
		}
	};
	$el.goToPrevSlide = function () {
		if (scene > 0) {
			settings.onBeforePrevSlide.call(this, $el, scene);
			scene--;
			$el.mode(false);
			if (settings.gallery === true) {
				plugin.slideThumb();
			}
		} else {
			if (settings.loop === true) {
				settings.onBeforePrevSlide.call(this, $el, scene);
				if (settings.mode === 'fade') {
					var l = (length - 1);
					scene = parseInt(l / settings.slideMove);
				}
				$el.mode(false);
				if (settings.gallery === true) {
					plugin.slideThumb();
				}
			} else if (settings.slideEndAnimation === true) {
				$el.addClass('leftEnd');
				setTimeout(function () {
					$el.removeClass('leftEnd');
				}, 400);
			}
		}
	};
	$el.goToNextSlide = function () {
		var nextI = true;
		if (settings.mode === 'slide') {
			var _slideValue = plugin.slideValue();
			nextI = _slideValue < w - elSize - settings.slideMargin;
		}
		if (((scene * settings.slideMove) < length - settings.slideMove) && nextI) {
			settings.onBeforeNextSlide.call(this, $el, scene);
			scene++;
			$el.mode(false);
			if (settings.gallery === true) {
				plugin.slideThumb();
			}
		} else {
			if (settings.loop === true) {
				settings.onBeforeNextSlide.call(this, $el, scene);
				scene = 0;
				$el.mode(false);
				if (settings.gallery === true) {
					plugin.slideThumb();
				}
			} else if (settings.slideEndAnimation === true) {
				$el.addClass('rightEnd');
				setTimeout(function () {
					$el.removeClass('rightEnd');
				}, 400);
			}
		}
	};
	$el.mode = function (_touch) {
		if (settings.adaptiveHeight === true && settings.vertical === false) {
			$el.css('height', $children.eq(scene).outerHeight(true));
		}
		if (on === false) {
			if (settings.mode === 'slide') {
				if (plugin.doCss()) {
					$el.addClass('lSSlide');
					if (settings.speed !== '') {
						$slide.css('transition-duration', settings.speed + 'ms');
					}
					if (settings.cssEasing !== '') {
						$slide.css('transition-timing-function', settings.cssEasing);
					}
				}
			} else {
				if (plugin.doCss()) {
					if (settings.speed !== '') {
						$el.css('transition-duration', settings.speed + 'ms');
					}
					if (settings.cssEasing !== '') {
						$el.css('transition-timing-function', settings.cssEasing);
					}
				}
			}
		}
		if (!_touch) {
			settings.onBeforeSlide.call(this, $el, scene);
		}
		if (settings.mode === 'slide') {
			plugin.slide();
		} else {
			plugin.fade();
		}
		if (!$slide.hasClass('ls-hover')) {
			plugin.auto();
		}
		setTimeout(function () {
			if (!_touch) {
				settings.onAfterSlide.call(this, $el, scene);
			}
		}, settings.speed);
		on = true;
	};
	$el.play = function () {
		$el.goToNextSlide();
		settings.auto = true;
		plugin.auto();
	};
	$el.pause = function () {
		settings.auto = false;
		clearInterval(interval);
	};
	$el.refresh = function () {
		refresh.init();
	};
	$el.getCurrentSlideCount = function () {
		var sc = scene;
		if (settings.loop) {
			var ln = $slide.find('.lslide').length,
				cl = $el.find('.clone.left').length;
			if (scene <= cl - 1) {
				sc = ln + (scene - cl);
			} else if (scene >= (ln + cl)) {
				sc = scene - ln - cl;
			} else {
				sc = scene - cl;
			}
		}
		return sc + 1;
	};
	$el.getTotalSlideCount = function () {
		return $slide.find('.lslide').length;
	};
	$el.goToSlide = function (s) {
		if (settings.loop) {
			scene = (s + $el.find('.clone.left').length - 1);
		} else {
			scene = s;
		}
		$el.mode(false);
		if (settings.gallery === true) {
			plugin.slideThumb();
		}
	};
	$el.destroy = function () {
		if ($el.lightSlider) {
			$el.goToPrevSlide = function () { };
			$el.goToNextSlide = function () { };
			$el.mode = function () { };
			$el.play = function () { };
			$el.pause = function () { };
			$el.refresh = function () { };
			$el.getCurrentSlideCount = function () { };
			$el.getTotalSlideCount = function () { };
			$el.goToSlide = function () { };
			$el.lightSlider = null;
			refresh = {
				init: function () { }
			};
			$el.parent().parent().find('.lSAction, .lSPager').remove();
			$el.removeClass('lightSlider lSFade lSSlide lsGrab lsGrabbing leftEnd right').removeAttr('style').unwrap().unwrap();
			$el.children().removeAttr('style');
			$children.removeClass('lslide active');
			$el.find('.clone').remove();
			$children = null;
			interval = null;
			on = false;
			scene = 0;
		}

	};
	setTimeout(function () {
		settings.onSliderLoad.call(this, $el);
	}, 10);
	$(window).on('resize orientationchange', function (e) {
		setTimeout(function () {
			if (e.preventDefault) {
				e.preventDefault();
			} else {
				e.returnValue = false;
			}
			refresh.init();
		}, 200);
	});
	return this;
};
$(document).ready(function () {
	$('.b2b_slide').lightSlider({
		item: 1,
		slideMargin: 10,
		loop: true,
	});

	$('input:radio[name=b2b_radio]').change(function() {
		$('#b2b_hiddenForm1').fadeIn(400);
		$('html, body').animate({
			scrollTop: $(".b2b_hiddenForm1").offset().top
			}, 1000);
	if (this.value == 'business') {
		$("#be_radioEnt").prop("checked", false);
		$('#b2b_bus_ent>.first >input').prop("checked", true);

	}
	else if (this.value == 'enterprise') {
		$("#be_radioBus").prop("checked", false);
		$('#b2b_bus_ent>.last >input').prop("checked", true);
	}
});
$('#b2b_form1close >svg').click(function(){
	$('#b2b_hiddenForm1').fadeOut(400);
});
$('#b2b_toForm3').click(function(){
	$('#b2b_hiddenForm2').fadeIn(400);
	$('html, body').animate({
		scrollTop: $(".b2b_sec4Bot").offset().top
	}, 800);
});
$('#b2b_form2close >svg').click(function(){
	$('#b2b_hiddenForm2').fadeOut(400);
});
$('#b2b_hidenForm2_select option:first').attr('disabled', 'disabled');

$('#b2b_toForm4').click(function(){
	$('#b2b_hiddenForm3').fadeIn(400);
	$('html, body').animate({
		scrollTop: $("#b2b_hiddenForm3").offset().top
	}, 800);
});
$('#b2b_form3close >svg').click(function(){
	$('#b2b_hiddenForm3').fadeOut(400);
});

$('#toform1').click(function(){
	$('html, body').animate({
		scrollTop: $(".b2b_sec2").offset().top
	},600);

});
	$('#resellers_success_close_button').on('click', function(){
		$('#resellers_error_message_wrapper_toggle').hide();
		$('#b2b_hiddenForm1').fadeOut(400);
		$('#b2b_hiddenForm2').fadeOut(400);
		$('#b2b_hiddenForm3').fadeOut(400);
	})
	$(".b2b_sec2 .b2b_sec2FormSec form").submit(function(){
		setTimeout(subForm1, 3000);
		function subForm1(){
			if($('.wpcf7-display-none').hasClass( "wpcf7-mail-sent-ok" )){
				$('#resellers_error_message_wrapper_toggle').show();
			}
		}
		
	  });

	  $("#b2b_hiddenForm1 form").submit(function(){
		setTimeout(subForm1, 3000);
		function subForm1(){
			if($('.wpcf7-display-none').hasClass( "wpcf7-mail-sent-ok" )){
				$('#resellers_error_message_wrapper_toggle').show();
			}
		}
		
	  });
	  $("#b2b_hiddenForm2 form").submit(function(){
		setTimeout(subForm1, 3000);
		function subForm1(){
			if($('.wpcf7-display-none').hasClass( "wpcf7-mail-sent-ok" )){
				$('#resellers_error_message_wrapper_toggle').show();
			}
		}
		
	  });
	  $("#b2b_hiddenForm3 form").submit(function(){
		setTimeout(subForm1, 3000);
		function subForm1(){
			if($('.wpcf7-display-none').hasClass( "wpcf7-mail-sent-ok" )){
				$('#resellers_error_message_wrapper_toggle').show();
			}
		}
		
	  });
});

});