(function($){
	
	var blogApp = function(props){
		"use strict";
		var state = {
			siteUrl: window.wpSiteUrl,
			blogCategory: window.blogCategory,
			perPage: window.blogPostPerPage,
			postLinkText: window.blogPostLinkText,
			page: 2,
			trigger: true,
			posts: []
		};

		var getPosts = function(){
			return $.ajax({
				url: state.siteUrl + '/wp-json/wp/v2/posts',
				data: {
					'page': state.page,
					'per_page': state.perPage,
					'categories': state.blogCategory,
					'orderby': 'date',
					'order': 'desc'
				},
				success: function(data) {
						if(data.length){
						state.page++;
						state.posts = data;
					}
				},
				statusCode: {
					400: function(){
						state.posts = [];
					}
				},

			async: true
			});
		};

		var loading = function(prop){
			if(prop){
				$(props.loadingElement).fadeOut(150);
			} else {
				$(props.loadingElement).fadeIn(150);
			}
		};

		var renderPosts = function(){
			state.posts.forEach(function(post){
				$(props.postsContainer).append(
					'<li>' +
						'<div class="side">' +
							'<a href="' + post.link + '"><img alt="' + post.title.rendered + '" src="' + post.featured_image + '"></a>' +
						'</div>' +
						'<div class="main">' +
							'<a href="' + post.link + '">' +
								'<h2>' + post.title.rendered + '</h2>' +
							'</a>' +
							'<div>' + post.excerpt.rendered + ' </div>' +
							'<a href="' + post.link + '">' + state.postLinkText + '</a>' +
						'</div>' +
					'</li>'
				);
			});
		};

		var getOffset = function(){
			state.offset = $(props.showMoreElement).offset().top;
		};

		var checkOffset = function(){
				if($(window).scrollTop() + $(window).outerHeight() > state.offset){
					if(state.trigger){
						loading(false);
						state.trigger = false;
						$.when(getPosts()).done(function(){
							renderPosts();
							loading(true);
							getOffset();
							state.trigger = true;
						}).then('', function(){
							state.trigger = false;
							loading(true);
						});
					}
				}
		};

		if($(props.postsContainer).length){
			getOffset();
			checkOffset();
			$(window).scroll(function(){
				checkOffset();
			});
			$(window).resize(function(){
				if(state.trigger){
					checkOffset();
				}
			});
		}
	};
	
	if(window.blogCategory && window.blogPostPerPage && window.wpSiteUrl && window.blogPostLinkText){
		blogApp({
			showMoreElement: '.blog_list_page_load_element',
			loadingElement: '.blog_list_page_loading_element',
			postsContainer: '.blog_list_page_list'
		});
	}
})(jQuery);