(function($){

	var blogCommentApp = function(props){
		"use strict";
		$(props.replyButton).click(function(event){
			event.preventDefault();
			var val = $(props.commentFormMessageInput).val();
			if(val.search($(this).closest($(this).parent()).find(props.replyAuthor).html()) < 0){
				$(props.commentFormMessageInput).val('@' + $(this).closest($(this).parent()).find(props.replyAuthor).html() + ' ' + val);
			}
			if(scroll){
				$("html, body").stop().animate({scrollTop: $(props.commentFormMessageInput).offset().top - ($(window).outerHeight() / 3)}, 500, 'swing');
			}
			$(props.commentFormMessageInput).focus();
		});
	};

	var thisBlogComments = new blogCommentApp({
		replyButton: '.blog_post_page_comment_reply_toggle',
		replyAuthor: '.blog_post_page_comment_author',
		commentFormMessageInput: '#message'
	});

	$("#blog_post_page_comment_form").validate({
		dynamic: true,
		rules: {
			comment: {
				required: true
			},
			author: {
				required: true
			},
			email: {
				required: true,
				email: true
			}
		}
	});
})(jQuery);