(function($){

	var faqApp = function(props){
		"use strict";
		var state = {
			siteURL: props.wpSiteUrl,
			currentPost: props.currentPost,
			faqCategoryId: props.faqCategoryId,
			historyLength: window.history.length,
			cache: {
				post: []
			},
			post: {
				title: '',
				content: '',
				id: '',
				link: ''
			},
			posts: []

		};

		if(!$(props.searchDom).length ||
			!$(props.postOutputContent).length) return false;

		var getPost = function(){
			return $.ajax({
				url: state.siteURL + '/wp-json/wp/v2/posts' + '?categories=' + state.faqCategoryId + '&per_page=5&include=' + state.currentPost,
				success: function(data) {
					if(data.length){
						
						state.post.title = data[0].title.rendered;
						state.post.content = data[0].content.rendered;
						state.post.id = data[0].id;
						state.post.link = data[0].link;

						state.cache.post.push({
							title: data[0].title.rendered,
							content: data[0].content.rendered,
							id: data[0].id,
							link: data[0].link
						});
					}
			},
			async: true
			});

		};

		var getInitialPost = function(){
			state.post.title = $(props.postOutputTitle).html();
			state.post.content = $(props.postOutputContent).html();
			state.post.id = props.currentPost;
			state.post.link = $('.' + props.postLink + '.' + props.postLinkActive).attr('href');
			state.cache.post.push({
				title: state.post.title,
				content: state.post.content,
				id: state.post.id,
				link: state.post.link
			});

		};

		var getPostCache = function(){
			var status = false;
			state.cache.post.forEach(function(post){
				if(post.id === state.currentPost && !status){
					state.post.content = post.content;
					state.post.title = post.title;
					state.post.link = post.link;
					state.post.id = post.id;
					status = true;
				}
			});
			return status;
		};

		var windowReplaceState = function(){
			window.history.replaceState(
				{postId: state.post.id},
				'',
				state.post.link
			);
		}

		var windowPushState = function(){
			window.history.pushState(
				{postId: state.post.id},
				'',
				state.post.link
			);
		};

		var postLoading = function(status){
			if(status){
				$(props.postLoading).fadeOut(200);
			} else {
				$(props.postLoading).fadeIn(200);
			}
		};

		var renderPost = function(){
			if(props.postLinkActive){
				$('.' + props.postLink).removeClass(props.postLinkActive);
				$('.' + props.postLink + '[data-post-id=' + state.currentPost + ']').addClass(props.postLinkActive);
			}
			$(props.postOutputTitle).html(state.post.title);
			$(props.postOutputContent).html(state.post.content);

			if($(window).outerWidth() < props.isMobile && $(window).scrollTop() > $(props.postOutputTitle).offset().top){
				$("html, body").stop().animate({scrollTop: $(props.postOutputTitle).offset().top - 100}, 500, 'swing');
			}
		};

		var getPosts = function(SearchQuery){
			return $.ajax({
				url: state.siteURL + '/wp-json/wp/v2/posts' + '?categories=' + state.faqCategoryId + '&per_page=5&search=' + SearchQuery,
				success: function(data) {
					state.posts = [];
					data.forEach(function(post){
						state.posts.push({
							link: post.link,
							title: post.title.rendered,
							id: post.id
						});

					});
				},
				async: true
			});
		};

		var searchLoading = function(status, empty){
			if(!status && props.searchInputActive){
				$(props.searchDom).addClass(props.searchInputActive);
				$(props.searchOutput).fadeOut(150);
			} if(status && props.searchInputActive){
				$(props.searchDom).removeClass(props.searchInputActive);
				if(!empty){
					$(props.searchOutput).fadeIn(150);
				}
			}
		};

		var renderPosts = function(searchQuery){
			$(props.searchOutput).html('');
			if(state.posts.length){
				state.posts.forEach(function(post){
					var keyWords = searchQuery.split(' ');
					var title = post.title.trim();
					keyWords.forEach(function(keyWord){
						if(title.indexOf(keyWord) !== -1){
							var regex = new RegExp(keyWord, 'i');
							var replace = title.search(regex);
							replace = title.substring(replace).split(' ')[0];
							title = title.replace(replace, '<b>' + replace + '</b>');
						}
					});

					$(props.searchOutput).append('<li><a href="' + post.link + '" data-post-id="' + post.id + '" class="' + props.postLink + '">' + title + '</a></li>');
				});
			} else {
				$(props.searchOutput).append('<li>No results on your request</li>');
			}
		};

		getInitialPost();
		windowReplaceState();
		window.addEventListener('popstate', function(event) {
			if(event.state){
				state.currentPost = event.state.postId;
				if(!getPostCache()){
					postLoading(false);
					$.when(getPost()).done(function(){
						windowReplaceState();
						renderPost();
						postLoading(true);
					});
				} else {
					renderPost();
					windowReplaceState();
				}
			}
		}, false);

		// search segment
		var timeOut;
		$(props.searchInput).on('input', function(){
			clearTimeout(timeOut);
			if($.trim($(this).val()).length > 2){
				searchLoading(false);
				var val = $(this).val();
				timeOut = setTimeout(function(){
					$.when(getPosts(val)).done(function(){
						searchLoading(true);
						renderPosts(val);
					});
				}, 800);
			} else {
				searchLoading(true, true);
			}
		});

		$(document).click(function(event){
			if(!$(event.target).parents(props.searchDom).length){
				$(props.searchOutput).fadeOut(150);

			} else if(state.posts.length){
				if($(event.target).hasClass(props.postLink)){
					$(props.searchOutput).fadeOut(150);
				} else {
					$(props.searchOutput).fadeIn(150);
				}
			}

			// posts segment
			if($(event.target).hasClass(props.postLink) || $(event.target).parents('.'+props.postLink).length){
				event.preventDefault();
				var postId;
				if($(event.target).data('post-id')){
					postId = $(event.target).data('post-id');
				} else {
					postId = $(event.target).parent('.'+props.postLink).data('post-id');
				}

				if(state.currentPost !== postId){
					state.currentPost = postId;
					if(!getPostCache()){
						postLoading(false);
						$.when(getPost()).done(function(){
							windowPushState();
							renderPost();
							postLoading(true);
						});
					} else {
						windowPushState();
						renderPost();
					}
				}

			} if($(event.target).hasClass(props.postParentLink)){
				event.preventDefault();
				if(props.postParentLinkActive){
					$(event.target).toggleClass(props.postParentLinkActive);
				}
				$(event.target).siblings('ul').animate({
					height: 'toggle'
				}, 250, 'swing');
			}
		});

	};

	if(window.currentPost && window.faqCategoryId){
		faqApp({
			// recieved variables
			currentPost: currentPost,
			faqCategoryId: faqCategoryId,
			wpSiteUrl: wpSiteUrl,
			// search Dom Query
			searchInput: '#faq_list_page_search_input',
			searchOutput: '.faq_list_page_search_output',
			searchDom: '.faq_list_page_search',
			searchInputActive: 'active',
			// post Dom Query
			postParentLink: 'faq_parent_link',
			postParentLinkActive: 'active',
			postLink: 'faq_link',
			postLinkActive: 'active',
			postLoading: '.faq_list_page_loading',
			pastDataId: 'post-id',
			postOutputTitle: '.faq_list_page_content_title',
			postOutputContent: '.faq_list_page_content_main',
			isMobile: isMobile
		});
	}
})(jQuery);