(function($){

	// shop functions
	var shopApp = function(){
		"use strict";
		if(window.shop_app_vars === undefined) return false;
		var state = {
			loading_status: {
				status: false,
				get_status: function(){
					return this.status;
				},
				set_status: function(status){
					if(status === undefined) return false;
					if(status === true){
						$('.shop_page_loading').fadeOut('fast');
						this.status = true;
					} else {
						$('.shop_page_loading').fadeIn('fast');
						this.status = false;
					}
				}
			},
			siteURL: window.wpSiteUrl,
			given_vars: window.shop_app_vars,
			categories_exclude: window.shop_app_vars.categories_exclude,
			child_postfix: '_child',
			current_category_filter: {},
			page: {
				index: 1,
				highlight_bestsellers: window.shop_app_vars.initial_highlight_bestsellers,
				get: function(){
					var to_return = this.index;
					this.index++;
					return to_return;
				},
				scrolled: function(){
					if(this.index === 1) this.index = 2;
				},
				reset: function(){
					this.index = 1;
					this.loaded = true
				},
				loaded: true
			},
			cache: {},
			products: [],
			text_var: {
				sale: window.shop_app_vars.sale_text,
				bestseller: window.shop_app_vars.bestseller_text,
				bestseller_yellow: window.shop_app_vars.bestseller_yellow_text,
				product_link: window.shop_app_vars.product_link_text,
				sale_save: window.shop_app_vars.sale_save_text,
				review_text: window.shop_app_vars.review_text,
				arrow_image: window.shop_app_vars.arrow_image
			}
		}

		// history object initializing step options logic
		var history = {
			index: 0,
			data: [],
			parent_data: [],
			push_state: function(parent_id){
				this.parent_data[this.index] =parent_id;
				var to_push = [];
				for(var categories_id in state.current_category_filter){
					if(state.current_category_filter.hasOwnProperty(categories_id)){
						to_push.push(categories_id);
					}
				}
				this.data.push(to_push);
			},
			back: function(){
				if(this.index === 0) return false;
				this.index--;
				for(var categories_id in state.current_category_filter){
					if(state.current_category_filter.hasOwnProperty(categories_id)){
						if(this.data[this.index].indexOf(categories_id) < 0){
							state.current_category_filter[categories_id] = [];
							$('[data-categories-id="' + categories_id + '"] .active').removeClass('active');
						}
					}
				}
				return true;
			},
			get_parent_id: function(){
				return this.parent_data[this.index];
			}
		}

		var set_category = function(category, parent, multiselect, category_children_id){

			if(!category || !parent) return false;

			// set an array
			if(state.current_category_filter[parent] === undefined){

				state.current_category_filter[parent] = [];

			}
			// unset child categories if there are ones

			if(state.current_category_filter[category_children_id] !== undefined && state.current_category_filter[category_children_id].length){

				state.current_category_filter[category_children_id] = [];

				return false;

			}

			// unset category if it was set
			if(state.current_category_filter[parent].indexOf(category) >= 0){

				state.current_category_filter[parent].splice(
					state.current_category_filter[parent].indexOf(category), 1);

				return false;

			}
			
			if(multiselect === false){

				state.current_category_filter[parent] = [];

			}

			// set category
			state.current_category_filter[parent].push(category);

			return true;

		}

		var get_multiselect_option = function(parent){

			if(!parent) return false;

			if(!state.given_vars.category_list.hasOwnProperty(parent)) return false;

			if(!state.given_vars.category_list[parent].hasOwnProperty('multiselect')) return false;

			return state.given_vars.category_list[parent]['multiselect'];

		}

		var get_highlight_bestsellers_option = function(parent){

			if(!parent) return false;

			if(parent.indexOf(state.child_postfix) > 0){

				parent = parent.replace(state.child_postfix, '');

			}

			if(!state.given_vars.category_list.hasOwnProperty(parent)) return false;

			if(!state.given_vars.category_list[parent].hasOwnProperty('highlight_bestsellers')) return false;

			var to_return = state.given_vars.category_list[parent]['highlight_bestsellers'];

			state.page.highlight_bestsellers = to_return;

			return to_return;

		}

		var get_category_children = function(category, parent){

			if(!state.given_vars.category_list.hasOwnProperty(parent)) return false;

			if(!state.given_vars.category_list[parent]['categories'].hasOwnProperty(category)) return false;

			if(!state.given_vars.category_list[parent]['categories'][category].hasOwnProperty('sub_categories')) return false;

			return state.given_vars.category_list[parent]['categories'][category]['sub_categories'];

		}
		
		var get_categories_arr = function(){

			var to_return = [];

			if(state.given_vars.current_category_id) to_return.push(state.given_vars.current_category_id);

			for(var categories_id in state.current_category_filter){

				if(state.current_category_filter.hasOwnProperty(categories_id)){

					state.current_category_filter[categories_id].forEach(function(category_id){

						to_return.push(category_id);

					});

				}

			}
			
			to_return.sort(function(a,b){

				return a - b;
				
			});
			
			return to_return;

		}

		var get_excluded_categories_arr = function(){

			if(!state.categories_exclude.length) return [];

			var to_return = [];

			state.categories_exclude.forEach(function(category){

				if(parseInt(category)){

					to_return.push(category);

				}

			});

			return to_return;
			
		}

		var set_cache = function(id, data){

			if(!id || !data) return false;

			if(state.cache.hasOwnProperty(id)) return false;

			state.cache[id] = data;

		}

		var get_cache = function(id){

			if(!state.cache.hasOwnProperty(id)) return false;
			state.products = state.cache[id];
			return true;

		}

		var get_products = function(action){

			var category_arr = get_categories_arr();

			var data = {

				'categories' : category_arr,

				'categories_not_in' : get_excluded_categories_arr(),

				'page' : state.page.get()

			};

			var category_cache_id = $.param(data);

			if(get_cache(category_cache_id)) return true;

			return $.ajax({

				url: state.siteURL + '/wp-json/msb/v2/product/list',

				data: data,

				success: function(data) {

					state.products = data;

					set_cache(category_cache_id, data);

				},	
				
				statusCode: {

					400: function(){

						state.products = [];

						console.log(this.url);

					}

				},
				
				async: true
		
			});

		}

		var get_sub_categories_arr_sorted = function(sub_categories){

			var categories_arr = [];

			for(var category_id in sub_categories){

				categories_arr[sub_categories[category_id].index] = sub_categories[category_id];

				categories_arr[sub_categories[category_id].index].id = category_id;

			}

			return categories_arr;

		}

		var render_category_children = function(after_dom, id, data){

			if(!after_dom || !id || !data) return false;

			var arrow_html = state.text_var.arrow_image ? '<i style="background-image: url(' + state.text_var.arrow_image + ');"></i>' : '';

			var subtitle_html = data['subtitle'] ? '<span>' + data['subtitle'] + '</span>' : '';

			after_dom.after(
				
				'<li data-categories-id="' + id + '">' + 

					'<h2>' + data['title'] + arrow_html + '</h2>' +

					subtitle_html +

					'<ul></ul>' + 

				'</li>'
				
			);

			var sub_categories_arr = get_sub_categories_arr_sorted(data['categories']);

			sub_categories_arr.forEach(function(category_data){

				if(category_data){

					var category_id = category_data.id;

					var category_title = category_data.name;

					var category_image = category_data.image;

					var category_description =  category_data.description;

					var category_description_rendered = category_description ? '<p>' + category_description + '</p>' : ''

					$('[data-categories-id="' + id + '"] > ul').append(
					
						'<li>' + 

							'<a href="#" data-category-id="' + category_id + '">' + 

								'<i style="background-image: url(' + category_image + ');"></i>' + 

								'<h4>' + category_title + '</h4>' + 

								category_description_rendered +

							'</a>' +

						'</li>'
				
				);

				}

			});

		}

		var render_product_attributes = function(attributes){

			var to_return = '';

			if(!attributes || !attributes.length || !Array.isArray(attributes)) return to_return;

			attributes.forEach(function(attribute){

				to_return += '<li><i style="background-image: url(\'' + attribute.image + '" title="' + attribute.name + '"></i></li>';

			});

			return to_return;

		}

		var render_product_providers = function(providers){

			var to_return = '';

			if(!providers || !providers.length || !Array.isArray(providers)) return to_return;

			providers.forEach(function(provider){

				to_return += '<li><img src="' + provider.image + '" alt="' + provider.name + '"></li>';

			});

			return to_return;

		}

		var render_product_band = function(band){
			if(!band || !band.color || !band.name) return '';
			return '<div class="band"><span style="background-color: ' + band.color + ';">' + band.name + '</span></div>';
		}

		var render_product_price = function(is_on_sale, regular_price, sale_price, save_price){
			var to_return = '';
			to_return += '<div class="price">';
			if(is_on_sale){
				to_return += '<del>' + regular_price + '</del>';
			}
			to_return += '<span>' + sale_price + '</span>';
			if(is_on_sale){
				to_return += '<strong>' + state.text_var.sale_save + ' ' + save_price + '</strong>';
			}
			to_return += '</div>';
			return to_return;

		}

		var render_product_reviews_and_rating = function(product){
			var to_return = '';
			if(!product.reviews_allowed) return to_return;
			to_return += '<div class="rating" style="background-image: url(' + state.given_vars.star_image + ');">';
			to_return += '<span style="width: ' + (product.average_rating * 20) + '%; background-image: url(' + state.given_vars.star_image + ');" class="lazyload"></span></div> ';
			to_return += '<div class="reviews">' + product.rating_count + ' ' + state.text_var.review_text + '</div>';
			return to_return;
		}

		var render_products = function(highlight_option, action){
			if(action !== 'add'){
				$('.shop_page_products').html('');
			}
			// render only first bestseller varibale
			var seen_bestseller = false;
			state.products.forEach(function(product){
				var render_as_bestseller = (!seen_bestseller && highlight_option && product.is_bestseller);
				if(render_as_bestseller){
					seen_bestseller = true;
				}
				var bestseller_class = render_as_bestseller ? ' class="bestseller"' : '';
				var bestseller_sign = render_as_bestseller && state.text_var.bestseller ? '<div class="free">' + state.text_var.bestseller + '</div>' : '';
				var bestseller_sign_yellow = render_as_bestseller ? '<div class="choice">' + state.text_var.bestseller_yellow + '</div>' : '';
				var sale_sign = product.on_sale ? '<div class="sale">' + state.text_var.sale + '</div>' : '';
				$('.shop_page_products').append(
					'<li' + bestseller_class + '>' + 
						'<div class="image">' + 
							sale_sign +
							'<a href="' + product.permalink + '">' +
							'<img alt="' + product.name + '" src="' + product.featured_image + '"></a>' +
							bestseller_sign +
						'</div>' +
						'<div class="main">' +
							render_product_reviews_and_rating(product) +
							bestseller_sign_yellow +
							'<div class="title"><a href="' + product.permalink + '">' + product.name + '</a></div>' +
						'</div>' +
						'<div class="coverage">' + product.coverage + '</div>' +
						'<ul class="by-use">' +
							render_product_attributes(product.attributes) +
						'</ul>' +
						'<ul class="providers">' +
							render_product_providers(product.providers) +
						'</ul>' +
						'<div class="application">' +
							render_product_band(product.band) +
							'<div class="gsm">' +
								'<span>' + product.gsm + '</span>' +
							'</div>' +
						'</div>' +
						'<div class="price_nd_link">' +
							render_product_price(product.on_sale, product.regular_price, product.sale_price, product.save_price) +
							'<div class="link">' +
								'<a href="' + product.permalink + '">' + state.text_var.product_link + '</a>' +
							'</div>' +
						'</div>' +
					'</li>'
				);
			});
		}

		$(document).delegate('[data-category-id]', 'click', function(event){

			event.preventDefault();

			var options = {
				id: $(this).data('category-id'),
				dom: $(this),
				parent_id: $(this).parents('[data-categories-id]').data('categories-id'),
				parent_dom: $(this).parents('[data-categories-id]'),
				get_children: function(){
					return get_category_children(this.id, this.parent_id);
				},
				get_children_id: function(){
					return this.parent_id + state.child_postfix;
				},
				get_multiselect: function(){
					return get_multiselect_option(this.parent_id)
				},
				get_hightlight_bestsellers: function(){
					var parent = this.parent_id;
					if($(this.parent_dom).next('[data-categories-id]').length){
						parent = $(this.parent_dom).next('[data-categories-id]').data('categories-id')
					}
					return get_highlight_bestsellers_option(parent);
				}
			}

			// if loading is not over return
			if(!state.loading_status.get_status()) return false;
			
			state.loading_status.set_status(false);

			// remove children categories dom
			$('[data-categories-id="' + options.get_children_id() + '"]').remove();
			
			history.push_state(options.parent_id, options.get_children_id());

			// reset page index status
			state.page.reset();

			// set the category
			var category_set = set_category(options.id, options.parent_id, options.get_multiselect(), options.get_children_id());

			// if category is set
			if(category_set){

				if(options.get_multiselect() === false){

					options.parent_dom.find('[data-category-id].active').removeClass('active');

					if(options.get_children()){

						render_category_children(options.parent_dom, options.get_children_id(), options.get_children());

					} 

				}

				$(this).addClass('active');

			} 
			
			// if category is unset
			else {

				$(this).removeClass('active');

			}

			$.when(get_products()).done(function(){

				var is_last_slide = true;

				// if category is set
				if(category_set){

					// if slided (there are more filter elements)
					if($('.shop_page_filter').slide('next')){

						// is not last slide
						is_last_slide = false;

						// incriment the history index status
						history.index++;
					}

				} 

				render_products(options.get_hightlight_bestsellers());

				// scroll to products if is last slide
				if(is_last_slide && $('.shop_page_products li').length && category_set){

					$("html, body").stop().animate({scrollTop: $('.shop_page_products').offset().top - ($(window).outerHeight() / 4)}, 500, 'swing');
					
				}

				if(history.index > 0){

					$('.shop_page_filter_back_button').addClass('active');

				}

				state.loading_status.set_status(true);
				
			});
			
		});

		$('.shop_page_filter_back_button').click(function(event){

			event.preventDefault();

			if(!state.loading_status.get_status() || !history.back()) return false;

			var this_reference = this;

			// reset page index status
			state.page.reset();

			state.loading_status.set_status(false);

			$.when(get_products()).done(function(){

				$('.shop_page_filter').slide('back')

				render_products(get_highlight_bestsellers_option(history.get_parent_id()));

				if(history.index < 1){

					$(this_reference).removeClass('active');

				}

				state.loading_status.set_status(true);

			});

		});

		$(window).scroll(function(){

			if(!state.page.loaded || !state.loading_status.get_status()) return false;

			var window_height = parseInt($(this).outerHeight());
			
			var point_to_load = parseInt($('.shop_page_products').offset().top + $('.shop_page_products').outerHeight());

			if($(this).scrollTop() + window_height * 2 > point_to_load){

				state.page.loaded = false;

				// check length in order not to load 
				// if recieved product length is less than previous
				var previous_length = state.products.length ? state.products.length : -1;

				state.page.scrolled();

				$.when(get_products('add')).done(function(){
		
					if(!state.products.length){

						state.page.loaded = false;

						return false;

					} else if(previous_length > state.products.length){

						render_products(state.page.highlight_bestsellers, 'add');

						return false;

					}

					render_products(state.page.highlight_bestsellers, 'add');

					state.page.loaded = true;

				});

			}

		});

		state.loading_status.set_status(true);

	}
	
	$('.shop_page_filter').slider({
		draggable: false,
		nav: false
	});
	shopApp();

})(jQuery);