<?php 
if(!defined('ABSPATH')){
	exit;
}

use App\Acf;
use App\Walker;

// get post object
$post = App\Storage::get('queried_object');

if(Acf::get('footer_enabled', $post, 'bool')):
	$footer_nav_enabled = Acf::get('footer_nav', $post, 'bool');
	?>
	<footer class="footer grid">
		<?php if(!Acf::get('footer_main_disabled', $post, 'bool')): ?>
			<ul class="footer_content">
				<?php if($footer_nav_enabled && has_nav_menu('footer_info')): ?>
				<li class="footer_content_row"><?php 
						wp_nav_menu(array(
							'theme_location'=> 'footer_info',
							'depth'			=> 1,
							'container'		=> false,
							'fallback_cb'	=> false,
							'walker'		=> new Walker(),
							'items_wrap' 	=> 
								msb_get_menu_by_location('footer_info') ?
								'<h4>' .
									msb_get_menu_by_location('footer_info')->name . 
								'</h4>' .
								'<ul id="%1$s" class="%2$s">%3$s</ul>' :
								'<ul id="%1$s" class="%2$s">%3$s</ul>',
							'extra'			=> array()
						));
					?></li>
				<?php endif; ?>
				<li class="footer_content_row_wide">
					<ul class="footer_content">
						<li class="footer_content_row">
							<h4><?=Acf::get('contacts_info_title', 'option', 'string')?></h4>
							<ul>
								<li><?=do_shortcode('[company-email-link]')?></li>
								<li><?=do_shortcode('[company-phone-link]')?></li>
							</ul>
							<h4><?=Acf::get('address_title', 'option', 'string')?></h4>
							<address> 
								<i class="fa fa-map-marker"></i>
								<?=Acf::get('company_address', 'option', 'string')?>
							</address>
							<?php 
							
							$footer_mail_address = Acf::get('company_mail_address', 'option', 'string');
							if($footer_mail_address):
							?>
							<h4><?=Acf::get('mail_address_title', 'option', 'string')?></h4>
							<address> 
								<i class="fa fa-map-marker"></i>
								<?=$footer_mail_address?>
							</address>
							<?php endif ?>
						</li>
						<li class="footer_content_row">
							<h4><?=Acf::get('about_us_title', 'option', 'string');?></h4>
							<p><?= str_replace(["\r\n", "\r", "\n"], "<br>", strip_tags(get_field('company_about', 'option'))) ?></p>
							<?php
							if($footer_nav_enabled && has_nav_menu('our_shops')){
								wp_nav_menu(array(
									'theme_location'=> 'our_shops',
									'depth'			=> 1,
									'container'		=> false,
									'fallback_cb'	=> false,
									'walker'		=> new Walker(),
									'items_wrap' 	=> 
										msb_get_menu_by_location('our_shops') ?
										'<h4>' .
											msb_get_menu_by_location('our_shops')->name . 
										'</h4>' .
										'<ul id="%1$s" class="%2$s">%3$s</ul>' :
										'<ul id="%1$s" class="%2$s">%3$s</ul>',
									'extra'			=> array()
								));
							}
						?>
						</li>
					</ul>
				</li>
			</ul>
		<?php endif ?>
		<ul class="footer_side">
			<li>
			<?php if(!Acf::get('footer_main_disabled', $post, 'bool')): ?>
				<?=apply_filters('the_content', Acf::get('company_powered_by', 'option', 'string'))?></li>
			<?php endif ?>
			<li>
				<?php if(Acf::get('payment_support_logo', 'option', 'string')): ?>
					<img data-src="<?=msb_get_image_url(Acf::get('payment_support_logo', 'option', 'string'), 'full')?>" class="lazyload" alt="<?=__('Payment Support', 'booster')?>"></li>
				<?php endif; 
				if(Acf::get('footer_socials', $post, 'bool') && has_nav_menu('soical')): 
					?><li>
						<ul class="footer_socials"><?php 
							wp_nav_menu(array(
								'theme_location'=> 'soical',
								'depth'			=> 1,
								'container'		=> false,
								'items_wrap' 	=> '%3$s',
								'fallback_cb'	=> false,
								'walker'		=> new App\Walker(),
								'extra'			=> array(
									"target" 	=> "_blank",
									"icon"		=> true
								)
							));
						?></ul>
				</li><?php endif; 
			if(Acf::get('company_copyright', 'option', 'bool')): ?>
				<li>
					<?php if(!Acf::get('footer_main_disabled', $post, 'bool')): ?>
						<?=apply_filters('the_content', Acf::get('company_copyright', 'option', 'string'));?></li>
					<?php endif ?>
				</li>
			<?php endif ?>
		</ul>
	</footer>
	<?php 
endif;
wp_footer(); 
?>
</body>
</html>