<?php

if(!defined('ABSPATH')){
	exit;
}

require 'vendor/autoload.php';

if(App\Storage::get('config', 'debug') == true) App\Bootstrap::debug(); // include theme debug settings

App\BootstrapAcf::plugin(); // include ACF

App\BootstrapHooks::actions(); // add theme actions

App\BootstrapHooks::filters(); // add theme filters

App\BootstrapWoocommerce::customerSupportUserRole(); // create "Customer Support" Role

App\BootstrapDeliveredOrders::actions(); // init delivered order actions

/**
 * Construct booster product propreties
 * with custom fields retrieved from woocommerce customize options page.
 * Use this variable to access booster categories
 * 
 * @var WCBooster
*/
App\Storage::set('booster_props', new App\WCBooster([
	"categories"	=> array(
		"providers" => [
			"label" => App\Acf::get('msb_product_cat_provider_label', 'option', 'string'),
			"parents" => App\Acf::get('msb_product_cat_provider', 'option', 'array')
		],
		"by_use" => [
			"label" => App\Acf::get('msb_product_cat_by_use_label', 'option', 'string'),
			"parents" => App\Acf::get('msb_product_cat_by_use', 'option', 'array')
		],
		"coverage" => [
			"label" => App\Acf::get('msb_product_cat_coverage_label', 'option', 'string'),
			"parents" => App\Acf::get('msb_product_cat_coverage', 'option', 'array')
		],
		"attr" => [
			"label" => App\Acf::get('msb_product_cat_attr_label', 'option', 'string'),
			"parents" => App\Acf::get('msb_product_cat_attr', 'option', 'array')
		],
		"gsm" => [
			"label" => App\Acf::get('msb_product_cat_gsm_label', 'option', 'string'),
			"parents" => App\Acf::get('msb_product_cat_gsm', 'option', 'array')
		],
		"band" => [
			"label" => App\Acf::get('msb_product_cat_band_label', 'option', 'string'),
			"parents" => App\Acf::get('msb_product_cat_band', 'option', 'array')
		],
		"frequency" => [
			"label" => App\Acf::get('msb_product_cat_frequency_label', 'option', 'string'),
			"parents" => App\Acf::get('msb_product_cat_frequency', 'option', 'array')
		]
	)
]));

$WC_booster = App\Storage::get('booster_props'); // register $WC_booster variable equal to booster props
/**
 * Init functions
 */
require get_template_directory() . '/includes/function-init.php';
function mysite_woocommerce_order_status_processing( $order_id ) {
    
// If you don't have the WC_Order object (from a dynamic $order_id)
$order = wc_get_order(  $order_id );
$invoice = wcpdf_get_invoice( $order, true ); // true makes sets 'init' which makes sure an invoice number is created;
$invoice_number = $invoice->get_number();
// invoice number is an object, but has a __toString magic method so if you use it as a string it will print the formatted number.
// You can also explicitly get the formatted or plain number:
$formatted_invoice_number = $invoice_number->get_formatted();
$plain_invoice_number = $invoice_number->get_plain();
// Add the note
$order->add_order_note( $formatted_invoice_number);

}

add_filter( 'woocommerce_order_number', 'change_woocommerce_order_number' );
function change_woocommerce_order_number( $order_id ) {
    $prefix = 'NOR';
    $suffix = '';
    $new_order_id = $prefix . $order_id . $suffix;
    return $new_order_id;
}


function my_acf_load_value( $value, $post_id, $field ) {
    if( strpos( $post_id, 'product_cat') !== false ) {
        if( $field['_name'] == 'section_image_original' ) {
            $term_meta = get_term_meta( absint( str_replace( 'product_cat_', '', $post_id ) ) );
            $image_urla = $term_meta['section_list_0_section_image'][0];
            if( absint( $image_urla ) !== 0 ){
                $image_url = wp_get_attachment_url( absint( $image_urla ) );
                $value = $image_url;
            }
        }
    }
    return $value;
}

// Apply to all fields.
add_filter('acf/load_value', 'my_acf_load_value', 10, 3);


/*
 * * * * * * * * * * * * * * * * * * * * * 
 *          Levon code start             *
 * * * * * * * * * * * * * * * * * * * * * 
 * */

add_action( 'add_meta_boxes', 'prod_sync_id_meta_box' );
add_action( 'save_post', 'prod_sync_id_meta_box_save' );
function prod_sync_id_meta_box(){
    $args = array();
    add_meta_box(
        'prod_sync_id',
        __( 'Sync ID', 'msb' ),
        'prod_sync_id_callback_function',
        'product',
        'side',
        'high',
        $args
    );
}

function prod_sync_id_callback_function( $post ){
    
    // Add an nonce field so we can check for it later.
    wp_nonce_field( 'prod_sync_id', 'prod_sync_id_nonce' );

    // Use get_post_meta to retrieve an existing value from the database.
    $value = get_post_meta( $post->ID, 'prod_sync_id', true );

    // Display the form, using the current value.
    ?>
        <label for="prod_sync_id"><?php echo __( 'Sync ID', 'msb' ); ?></label>
        <input type="text" name="prod_sync_id" id="prod_sync_id" value="<?php echo $value; ?>" />
    <?php
}

function prod_sync_id_meta_box_save( $post_id ){
    
    /*
        * We need to verify this came from the our screen and with proper authorization,
        * because save_post can be triggered at other times.
        */

    // Check if our nonce is set.
    if ( ! isset( $_POST['prod_sync_id_nonce'] ) ) {
        return $post_id;
    }

    $nonce = $_POST['prod_sync_id_nonce'];

    // Verify that the nonce is valid.
    if ( ! wp_verify_nonce( $nonce, 'prod_sync_id' ) ) {
        return $post_id;
    }

    /*
        * If this is an autosave, our form has not been submitted,
        * so we don't want to do anything.
        */
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return $post_id;
    }

    // Check the user's permissions.
    if ( 'product' != $_POST['post_type'] ) {
        return $post_id;
    } else {
        if ( ! current_user_can( 'edit_post', $post_id ) ) {
            return $post_id;
        }
    }

    /* OK, it's safe for us to save the data now. */

    // Sanitize the user input.
    $mydata = sanitize_text_field( $_POST['prod_sync_id'] );

    // Update the meta field.
    update_post_meta( $post_id, 'prod_sync_id', $mydata );
}

add_action( 'rest_api_init', 'create_api_posts_meta_field' );
function create_api_posts_meta_field() {
 
    // register_rest_field ( 'name-of-post-type', 'name-of-field-to-return', array-of-callbacks-and-schema() )
    register_rest_field( 'product', 'prod_sync_id', array(
           'get_callback' => 'get_post_meta_for_api',
           'schema' => array(
                'description' => __( 'Expose advanced custom fields.', 'msb' ),
                'type' => 'object',
            )
        )
    );
}
 
function get_post_meta_for_api( $object ) {

    //get the id of the post object array
    $post_id = $object['id'];
    $meta = get_post_meta( $post_id, 'prod_sync_id', "" );
    $metadata = "";
    if( is_array( $meta ) ){
        $metadata = $meta[0];
    }

    //return the post meta
    return $metadata;
}

/*
 * * * * * * * * * * * * * * * * * * * * * 
 *            Levon code end             *
 * * * * * * * * * * * * * * * * * * * * * 
 * */
 