<?php
if (!defined('ABSPATH')) {
    exit;
}

use App\Acf;
use App\Walker;

?>
    <!doctype html>
<html <?php language_attributes(); ?>>

    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <style>
		.product_page_main_media_image:before {
    position: absolute;
    z-index: 6;
    left: 0;
    background-image: url(https://www.signalboosters.co.za/wp-content/uploads/2020/08/82964586_2636702283087513_7298731087675523072_n.png);
    background-size: 88px 216px;
    width: 88px;
    height: 216px;
    content: "";
}
			.shop_page_products .image:before {
    position: absolute;
    z-index: 6;
    left: 0;
    background-image: url(https://www.signalboosters.co.za/wp-content/uploads/2020/08/82964586_2636702283087513_7298731087675523072_n.png);
    background-size: 29.3px 72px;
    width: 29px;
    height: 72px;
    content: "";
}
.featured_section_product_list li a:before {
    position: absolute;
    z-index: 6;
    left: 0;
    background-image: url(https://www.signalboosters.co.za/wp-content/uploads/2020/08/82964586_2636702283087513_7298731087675523072_n.png);
    background-size: 60px auto;
    width: 60px;
    height: 132px;
    content: "";
}
			.featured_section_product_header a:before {content:none !important;}
		</style>
		<meta name="google-site-verification" content="pqc1tzkfMZYLi8vu-OHHU4n22LttYTTa6jpZvDpr_Js" />
        <meta charset="<?php bloginfo('charset'); ?>">
        <?php wp_head(); ?>
    </head>
<body>
<?php
wp_body_open();
// get post object
$post = App\Storage::get('queried_object');
// get header enabled option
if (Acf::get('header_enabled', $post, 'bool')):
    // get header naviation enabled option
    $navigation_enabled = Acf::get('header_nav', $post, 'bool');
    // get header benefits enabled option
    if (Acf::get('header_benefits', $post, 'bool')) {
        // get header benefits list
        $benefits_list = Acf::get('header_benefits', 'option', 'array');
    }
    ?>
      <header class="header">
        <div class="grid">
            <ul class="header_main">
                <li class="header_logo">
                    <a href="<?php echo home_url() ?>">
                        <img src="<?= msb_get_image_url(get_theme_mod('custom_logo'), 'medium') ?>"
                             alt="<?= get_bloginfo('name') ?>">
                    </a>
                </li>
                <div class="header_search">
                    <?php if (Acf::get('header_search', $post, 'bool')) get_search_form(); ?>
                </div>
				<?php /*<div class="loginsignup">
					<a href="https://www.mobilesignalboosters.co.uk/my-account/" style="position: relative;display: block;color: #5d5d5d;text-decoration: none;padding: 12px 15px;border-top-left-radius: 2px;white-space: nowrap;border-top-right-radius: 2px;">Login / <span style="background-color: #379fe8;padding: 6px 12px;   color: #fff; border-radius: 9%;">Sign Up</span></a>
                </div>*/?>
                <?php   if (Acf::get('header_cart', $post, 'bool') && WC()->cart) woocommerce_mini_cart();?>
                
                <?php
                // woocommerce minicart
               
                // mobile navigation
                if ($navigation_enabled && has_nav_menu('header_menu_mobile')): ?>
                    <li class="header_nav_mobile_toggle">
                        <a href="#" class="header_nav_mobile_toggle_button" aria-label="menu_toggle"
                           data-toggle-class="header_nav_mobile_list">
                            <div></div>
                            <div></div>
                            <div></div>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>



            <?php if ($navigation_enabled && has_nav_menu('header_menu_mobile')):
                wp_nav_menu(array(
                    'theme_location' => 'header_menu_mobile',
                    'depth' => 0,
                    'container' => false,
                    'menu_class' => 'header_nav_mobile_list',
                    'fallback_cb' => false,
                    'walker' => new Walker(),
                    'extra' => array(
                        'active_class' => 'header_current_page',
                        'parent_class' => 'header_mobile_dropdown_link',
                        'parent_attr' => array(
                            'data-toggle-sibling' => 'ul'
                        ),
                        'dropdown_list_class' => 'header_mobile_nav_dropdown',
                        'dropdown_link_extra' => '<i class="fas fa-caret-down"></i>'
                    ),
                ));

            endif; ?>

            <div class="header_search" id='MobSearch'>
                <?php if (Acf::get('header_search', $post, 'bool')) get_search_form(); ?>
            </div>
            
            <div class='main_nav'>
            <?php if ($navigation_enabled && has_nav_menu('header_menu')): ?>
                    <li class="header_nav"><?php
                    wp_nav_menu(array(
                        'theme_location' => 'header_menu',
                        'depth' => 0,
                        'container' => false,
                        'menu_class' => 'header_nav_list',
                        'fallback_cb' => false,
                        'walker' => new Walker(),
                        'extra' => array(
                            'active_class' => 'header_current_page',
                            'parent_class' => 'header_dropdown_link',
                            'parent_attr' => array(
                                'data-toggle-sibling' => 'ul'
                            ),
                            'dropdown_list_class' => 'header_nav_dropdown'
                        ),
                    ));
                    ?></li><?php endif ;?>
            </div>
        </div>

		<?php
			if( has_action( 'msb_header_banner' ) ){
				do_action( 'msb_header_banner' );
			}
		?>

        <div class="header_benefits <?= Acf::get('header_benefits_style', $post, 'string') ?>">
            <div class="grid">
                <ul class="header_benefits_list">
                    <?php
                    if (isset($benefits_list)):
                        foreach ($benefits_list as $benefit):
                            ?>
                            <li><i class="<?= $benefit['icon']; ?>"></i><?=
                            apply_filters('the_content', $benefit['text']);
                            ?></li>
                        <?php
                        endforeach;
                    endif;
                    ?>
                </ul>
            </div>
        </div>
    </header>
<?php
endif;