<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

use Closure;
use App\ToType;

abstract class AbstractRest {
    /**
     * Instance implimenting singleton pattern
     * 
     * @var NULL|self
     */
    private static $instance = NULL;

    /**
     * Rest route namespace passed to register_rest_route function
     * 
     * @var string
     */
    public $namespace = 'msb/v2';

    /**
     * Rest route passed to register_rest_route function
     * 
     * @var string
     */
    public $route = '';

    /**
     * Request method passed to register_rest_route function
     * 
     * @var string
     */
    public $method = 'GET';

    /**
     * Arguments passed to register_rest_route function
     * Represent Request arguments
     * 
     * @var array
     */
    private $args = array();

    /**
     * Arguments passed to register_rest_route function
     * as rest route callback
     * 
     * @var Closure
     */
    private $callback;

    /**
     * Argument setter method
     * 
     * @param string $key       Request argument key
     * 
     * @param array $val        Request parameters passed as
     *                          argument properties to register_rest_route
     */
    public function setArg(string $key, array $val){
        $this->args[$key] = $val;
    }

    /**
     * Argument getter method
     * 
     * @param string $key       Request argument key
     * 
     * @param array $val        Request parameters passed as
     *                          argument properties to register_rest_route
     * 
     * @return array $this->args
     */
    public function getArgs(){
        return $this->args;
    }

    /**
     * Callback setter method
     * 
     * @param string $key       Request argument key
     * 
     * @param array $val        Request parameters passed as
     *                          argument properties to register_rest_route
     */
    public function setCallback(Closure $callback){
        $this->callback = $callback;
    }

    /**
     * Callback getter method
     * 
     * @return Closure
     */
    public function getCallback(){
        return $this->callback;
    }

    /**
     * Method to get instance implimenting singleton pattern
     * 
     * @return object $caller
     */
    public static function getInstance(){
		if(is_null(self::$instance) || get_called_class() != get_class(self::$instance)){
            $caller = get_called_class();
			self::$instance = new $caller();
		}
		return self::$instance;
    }

        
	private function __construct(){}
    private function __clone(){}
    private function __wakeup(){}
}