<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

use App\Storage;

class BootstrapAcf {
    /**
     * Adding acf option pages and subpages
     */
    public static function optionPages(){
        if(function_exists('acf_add_options_page')){
			// theme settings option page
			acf_add_options_page(array(
				'page_title' 	=> 'All Settings',
				'menu_title'	=> 'Theme Settings',
				'menu_slug' 	=> 'theme-general-settings',
				'capability'	=> 'manage_options',
				'position'      => 60,
				'redirect'		=> false
			));
			// company info sub page
			acf_add_options_sub_page(array(
				'page_title' 	=> 'Theme Company Info',
				'menu_title'	=> 'Company Info',
				'parent_slug'	=> 'theme-general-settings',
			));
			// header sub page
			acf_add_options_sub_page(array(
				'page_title' 	=> 'Theme Header Settings',
				'menu_title'	=> 'Header Settings',
				'parent_slug'	=> 'theme-general-settings',
			));
			// footer sub page
			acf_add_options_sub_page(array(
				'page_title' 	=> 'Theme Footer Settings',
				'menu_title'	=> 'Footer Settings',
				'parent_slug'	=> 'theme-general-settings',
			));
			// blog sub page
			acf_add_options_sub_page(array(
				'page_title' 	=> 'Theme Blog Settings',
				'menu_title'	=> 'Blog Settings',
				'parent_slug'	=> 'theme-general-settings',
			));
			// shortcodes sub page
			acf_add_options_sub_page(array(
				'page_title' 	=> 'Shortcode Settings',
				'menu_title'	=> 'Shortcode Settings',
				'parent_slug'	=> 'theme-general-settings',
			));
			// woocommerce sub page
			acf_add_options_sub_page(array(
				'page_title' 	=> 'Woocommerce Settings',
				'menu_title'	=> 'Woocommerce',
				'parent_slug'	=> 'theme-general-settings',
			));
			// permalinks sub page
			acf_add_options_sub_page(array(
				'page_title' 	=> 'Theme Permalink Settings',
				'menu_title'	=> 'Permalink Settings',
				'parent_slug'	=> 'theme-general-settings',
			));
		}
    }

    /**
     * Syncronize ACF fields saved changes with JSON files
     */
    public static function syncSave(){
        return Storage::get('config', 'acf', 'json');
    }

    /**
     * Function loads sync ACF fields in the given directory
     * 
     * @param array $paths
     * 
     * @return array $paths		replacing first $paths index with theme json path
     * 							constant value
     */
    public static function syncLoad(array $paths){
        $paths[] = Storage::get('config', 'acf', 'json');
		return $paths;
    }

    /**
     * Include the ACF plugin
     * Customize the url setting to fix incorrect asset URLs and
     * hide the ACF admin menu item if theme is in production mode
     */
    public static function plugin(){
		include_once(get_stylesheet_directory().'/includes/acf-plugin/acf.php');
		
        add_filter('acf/settings/url', function($url){
            return Storage::get('config', 'acf', 'url');
        });
        add_filter('acf/settings/show_admin', function($show_admin){
            return Storage::get('config', 'dev');
        });
    }
}