<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

use App\AssetsWizard;
use App\Storage;
use App\Acf;

class BootstrapAssets {
    /**
     * - Remove Emoji scripts
     * - Remove wp-embed
     * - Remove prettyPhoto and fancybox scripts
     * - Remove woocommerce scripts form non-woocommerce pages
     * - Remove all scripts from header
     * - Enqueue theme scripts with AssetWizard class
     * 
     * Scripts localization:
     * - post_id
     * - wpSiteUrl
     * - wc_key
     * - wc_secret
     * - theme_version
     * 
     */
    public static function scripts(){
		remove_action('wp_head', 'print_emoji_detection_script', 7);
		if(!is_user_logged_in()){
			wp_deregister_script('wp-embed');
		}
		wp_dequeue_script('prettyPhoto');
		wp_dequeue_script('prettyPhoto-init');
		wp_dequeue_script('fancybox');
		if(function_exists('is_woocommerce')){
			wp_dequeue_script('wc-single-product');
			
			wp_dequeue_script('wc_price_slider');
			wp_dequeue_script('wc-add-to-cart');
			wp_dequeue_script('wc-add-to-cart-variation');
			wp_dequeue_script('wc-chosen');
			if(!is_checkout()){
				if(!is_user_logged_in() && !is_admin()){
					remove_action('wp_head', 'wp_print_scripts');
					remove_action('wp_head', 'wp_print_head_scripts', 9);
					remove_action('wp_head', 'wp_enqueue_scripts', 1);
				}
				wp_dequeue_script('select2');
				wp_deregister_script('select2');
				wp_dequeue_script('wc-checkout');
				wp_dequeue_script('woocommerce');
				wp_dequeue_script('jquery-blockui');
				wp_dequeue_script('jquery-placeholder');
				wp_dequeue_script('jqueryui');
			}
		}
		AssetsWizard::enqueue_scripts(array(
			'ver' => Storage::get('config', 'assets', 'version'),
			'minify' => Storage::get('config', 'dev') ? false : array(
				'handle' => 'script',
				'basename' => 'script.min.v' . Storage::get('config', 'version') . '.js',
				'deps' => array('jquery')
			),
			'url' => Storage::get('config', 'assets', 'url').'js/',
			'path' => Storage::get('config', 'assets', 'path').'js/',
			'assets' => Storage::get('config', 'assets', 'scripts')
		));
		// post id
		if(boolval(Storage::get('queried_object_id'))){
			wp_localize_script(
				'script',
				'post_id',
				strval(Storage::get('queried_object_id'))
			);
		}
		// site url
		wp_localize_script(
			'script',
			'wpSiteUrl',
			get_site_url()
		);
		// woocommerce CK
		wp_localize_script(
			'script',
			'wc_key',
			Acf::get('woocommerce_api_key', 'option')
		);
		// woocommerce CS
		wp_localize_script(
			'script',
			'wc_secret',
			Acf::get('woocommerce_api_secret', 'option')
		);
		// theme version
		wp_localize_script(
			'script',
			'theme_version',
			Storage::get('config', 'version')
		);
    }

    /**
     * Remove jquery-migrate
     * 
     * @source https://wordpress.stackexchange.com/questions/309234/removing-jquery-migrate-and-working-with-dependencies
     */
    public static function removeJqueryMigrate(&$scripts){
        if(!is_user_logged_in()){
            $scripts->remove('jquery');
            $scripts->add('jquery', false, array('jquery-core'));
        }
    }

    /**
     * - Remove wc-block-style
     * - Remove affwp styles
     * - Remove woocommerce styles form non-woocommerce pages
     * - Add FontAwesome
     * - Enqueue theme styles with AssetWizard class
     */
    public static function styles(){
		if(!is_user_logged_in() && !is_admin()){
			wp_dequeue_style('wc-block-style');
			wp_dequeue_style('wp-block-library');
			wp_dequeue_style('affwp-forms');
			wp_deregister_style('affwp-forms');
		}
		if(function_exists('is_woocommerce')){
			wp_dequeue_style('woocommerce_frontend_styles');
			wp_dequeue_style('woocommerce_fancybox_styles');
			wp_dequeue_style('woocommerce-layout');
			wp_dequeue_style('woocommerce-smallscreen');
			if(!is_checkout() && !is_cart()){
				wp_dequeue_style('select2');
				wp_deregister_style('select2');    
				wp_dequeue_style('woocommerce-general');
				wp_dequeue_style('woocommerce_chosen_styles');
				wp_dequeue_style('woocommerce_prettyPhoto_css');
			}
		}
		wp_enqueue_style('fontawesome', Storage::get('config', 'assets', 'url') . 'fonts/fontawesome/css/all.min.css', array(), Storage::get('config', 'assets', 'version'));
		AssetsWizard::enqueue_styles(array(
			'ver' => Storage::get('config', 'assets', 'version'),
			'minify' => Storage::get('config', 'dev') ? false : array(
				'handle' => 'style',
				'basename' => 'style.min.v' . Storage::get('config', 'version') . '.css',
				'deps' => array('fontawesome')
			),
			'url' => Storage::get('config', 'assets', 'url').'css/',
			'path' => Storage::get('config', 'assets', 'path').'css/',
			'assets' => Storage::get('config', 'assets', 'styles')
		));
    }

	/**
	 * Method to remove compiled assets
	 */
	public static function removeCompiledAssets(){
		$compiled_assets = [
			Storage::get('config', 'assets', 'path').'css/style.min.v'.Storage::get('config', 'version').'.css',
			Storage::get('config', 'assets', 'path').'js/script.min.v'.Storage::get('config', 'version').'.js'
		];
		foreach($compiled_assets as $asset_filepath){
			if(file_exists($asset_filepath)){
				unlink($asset_filepath);
			}
		}
	}

    /**
     * Enqueue theme admin styles
     */
    public static function adminStyles(){
        wp_enqueue_style('admin', Storage::get('config', 'assets', 'url') . 'css/admin.css', array(), Storage::get('config', 'assets', 'version'));
    }

    /**
     * Disable the emoji's
     * @source https://ru.clearfy.pro/kak-udalit-emojis-v-wordpress/
     */
    public static function disableEmojis(){
        remove_action('wp_head', 'print_emoji_detection_script', 7);
        remove_action('admin_print_scripts', 'print_emoji_detection_script');
        remove_action('wp_print_styles', 'print_emoji_styles');
        remove_action('admin_print_styles', 'print_emoji_styles'); 
        remove_filter('the_content_feed', 'wp_staticize_emoji');
        remove_filter('comment_text_rss', 'wp_staticize_emoji'); 
        remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
        add_filter('tiny_mce_plugins', 'App\BootstrapAssets::disableEmojisTinymce');
        add_filter('wp_resource_hints', 'App\BootstrapAssets::disableEmojisRemoveDnsprefetch', 10, 2);
    }

    /**
     * Filter function used to remove the tinymce emoji plugin.
     * 
     * @param array $plugins 
     * @return array Difference betwen the two arrays
     * 
     * @source https://ru.clearfy.pro/kak-udalit-emojis-v-wordpress/
     */
    public static function disableEmojisTinymce($plugins){
        if(is_array($plugins)){
            return array_diff($plugins, array('wpemoji'));
        } else {
            return array();
        }
    }

    /**
    * Remove emoji CDN hostname from DNS prefetching hints.
    *
    * @param array $urls URLs to print for resource hints.
    * @param string $relation_type The relation type the URLs are printed for.
    * @return array Difference betwen the two arrays.

    * @source https://ru.clearfy.pro/kak-udalit-emojis-v-wordpress/
    */
    public static function disableEmojisRemoveDnsprefetch($urls, $relation_type){
        if('dns-prefetch' == $relation_type){
            /** This filter is documented in wp-includes/formatting.php */
            $emoji_svg_url = apply_filters('emoji_svg_url', 'https://s.w.org/images/core/emoji/2/svg/');
            $urls = array_diff($urls, array($emoji_svg_url));
        }
        return $urls;
    }
}