<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

class BootstrapHooks {

    /**
     * Method to add all theme core actions
     */
    public static function actions(){
        if(function_exists('add_action')):
            // add theme support
            add_action('after_setup_theme', 'App\Bootstrap::themeSupport');
            // add theme navigation
            add_action('after_setup_theme', 'App\Bootstrap::navigation');
            // add queried object storage
            add_action('template_redirect', 'App\Bootstrap::queriedObject', 1);
            // register api endpoints and custom fields
            add_action('rest_api_init', 'App\Bootstrap::api');
            // Add posts custom rewrite rules
            add_action('init', 'App\Bootstrap::addPostCategorySlugPrefix');
            // Remove them from admin area
            add_action('admin_init', 'App\Bootstrap::flushRewriteRules');
            // add theme acf option pages
            add_action('acf/init', 'App\BootstrapAcf::optionPages');
            // add theme shortcodes
            add_action('after_setup_theme', 'App\BootstrapShortcodes::add');
            // enqueue scripts
            add_action('wp_enqueue_scripts', 'App\BootstrapAssets::scripts', 99999);
            // enqueue styles
            add_action('wp_enqueue_scripts', 'App\BootstrapAssets::styles', 99999);
            // remove compiled assets
            if(Storage::get('config', 'dev') == true){
                add_action('after_setup_theme', 'App\BootstrapAssets::removeCompiledAssets');
            }

            // enqueue theme admin styles
            add_action('admin_head', 'App\BootstrapAssets::adminStyles');
            // disable WordPress emojis
            add_action('init', 'App\BootstrapAssets::disableEmojis');
            // Add theme Woocommerece order statuses
            add_action('init', 'App\BootstrapWoocommerce::addOrderStatuses', 10, 0);
            // autocomplete orders
            add_action('woocommerce_thankyou', 'App\BootstrapWoocommerce::autocompleteOrders', 10, 1);
        endif;
    }

     /**
      * Method to add all theme core filters and
      * remove some of the core WordPress/Woocommerce filters
      */
    public static function filters(){
        if(function_exists('add_filter')):
            // sync acf on save changes
            add_filter('acf/settings/save_json', 'App\BootstrapAcf::syncSave');
            // sync acf on load changes
            add_filter('acf/settings/load_json', 'App\BootstrapAcf::syncLoad');
            // remove jquery migrate
            add_filter('wp_default_scripts', 'App\BootstrapAssets::removeJqueryMigrate');
            // Remove added to cart message
            add_filter('wc_add_to_cart_message_html', '__return_false');
            // Remove cart updated notice
            add_filter('woocommerce_add_message', '__return_false');
            // add custom woocommerce states
            add_filter('woocommerce_states', 'App\BootstrapWoocommerce::addWoocommerceStates', 10, 1);
            // Unapprove all posted comments
            add_filter('preprocess_comment', 'App\BootstrapWoocommerce::unapprovePostedComments', 10, 2);
            // filter checkout fields
            add_filter('woocommerce_checkout_fields', 'App\BootstrapWoocommerce::filterCheckoutFields', 10, 1);
            // filter billing and shipping checkout error notices
            add_filter('woocommerce_checkout_required_field_notice', 'App\BootstrapWoocommerce::removeCheckoutBillingAndShippinPrefixes', 1, 2);
            // add custom gateway icons
            add_filter('woocommerce_gateway_icon', 'App\BootstrapWoocommerce::addGatewayIcons', 10, 2);
            // filter related products
            add_filter('woocommerce_related_products', 'App\BootstrapWoocommerce::excludeRealatedProducts', 10, 2);
        endif;
        if(function_exists('remove_filter')):
            // Remove p wrapper tag from the_content filter
            remove_filter('the_content', 'wpautop');
        endif;
    }
}