<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

use App\Storage;

class BootstrapShortcodes {

	public static function add(){
		/**
		 * Product categories list and properties
		 */
		self::addShortcode('product-coverage');
		self::addShortcode('product-ideal-for');
		self::addShortcode('product-providers');
		self::addShortcode('product-frequency');
		self::addShortcode('product-overview');
		self::addShortcode('product-technical-sheet', array(
			'title' => '',
			'items' => 99,
			'offset' => 0
		));
		self::addShortcode('product-regular-price');
		self::addShortcode('product-save-price');
		/**
		 * Help to find links
		 */
		self::addShortcode('help-to-find', array(
			'title' => 'CAN’T FIND WHAT YOU’RE LOOKING FOR?'
		));
		self::addShortcode('help-to-find-link', array(
			'to' => '#',
			'text' => '',
			'icon' => '',
			'active' => false
		));
		self::addShortcode('help-to-find-end');
		/**
		 * Cart/Checkout/Thankyou page header
		 */
		self::addShortcode('shop-header');
		self::addShortcode('product-category-fullname');
		self::addShortcode('blog-post-cta', array(
			'title' => 'Ready To Get Started?',
			'text' => 'Choose world’s best and 100% authentic signal boosters from us',
			'linkto' => 'shop',
			'linktext' => 'CHOOSE YOUR BOOSTER'
		));
		/**
		 * Readmore
		 */
		self::addShortcode('readmore-start', array(
			"id" => "read_more"
		));
		self::addShortcode('readmore-end', array(
			"link_text"	=> "Read More",
			"less_text" => "",
			"link_class" => "read_more_link",
			"id" => "read_more"
		));
		self::addShortcode('frequency-list');
		self::addShortcode('category-list', array(
			"categories" => "",
			"style" => "default",
			"centered" => false,
			"title" => ""
		));
		self::addShortcode('404-page-content', array(
			"categories" => "by_use",
			"title" => "Where do you need to <b>BOOST YOUR SIGNAL</b>"
		));
		self::addShortcode('company-phone-link');
		self::addShortcode('company-email-link');
		add_shortcode('year', function(){
			return date('Y');
		});
		self::addShortcode('link', array(
			"to"	=> "#",
			"text" => "link",
			"target" => ""
		));
		self::addShortcode('copyright');
		self::addShortcode('count-helped-customers', array("format"	=> NULL));
	}

	/**
	 * Method to add shortcode with its template 
	 * based in template-parts/shortcodes path also adding props
	 * using shortcode_props global variable that template referres to
	 * 
	 * @param string $slug          shortcode name as well as php template filename
	 * @param array $default_props  default properties passed to the template
	 * 
	 * @since 0.1.1
	 */
	private static function addShortcode(string $slug, array $default_props = array()){
		if(function_exists('add_shortcode')):
			add_shortcode($slug, function($props) use($default_props, $slug){
				// set global variable
				Storage::set('shortcode_props', shortcode_atts($default_props, $props));
				ob_start();
				get_template_part('template-parts/shortcodes/' . $slug);
				return ob_get_clean();
			});
		endif;
	}
}