<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

use App\ToType;

class Rest {

	/**
	 * Function to register rest route
	 * 
	 * @param string $restClassInfo		represents static rest method name
	 * 									acting as rest controller that returns
	 * 									rest instance with valid properties
	 */
	public static function register(string $restClassInfo){
		$restClassInfo = explode('::', $restClassInfo);
		$restInstance = $restClassInfo[0]::getInstance();
		if(is_subclass_of($restInstance, 'App\AbstractRest') && method_exists($restInstance, $restClassInfo[1])){
			$endpointInstance = call_user_func($restClassInfo);
			register_rest_route(
				$endpointInstance->namespace,
				$endpointInstance->route,
				[
					'methods' => $endpointInstance->method,
					'callback' => $endpointInstance->getCallback(),
					'args' => $endpointInstance->getArgs()
				],
				true
			);
		}
	}

	/**
	 * Method to create multiple rest routes
	 */
    public static function massRegister(array $rest_classes){
		for($i = 0; $i < count($rest_classes); $i++){
			self::register($rest_classes[$i]);
		}
	}
}