<?php

namespace App\Rest;

if(!defined('ABSPATH')){
	exit;
}

use WP_REST_Request;
use App\AbstractRest;
use App\BootstrapWoocommerce;
use App\Validate;
use App\Sanitize;
use App\Acf;

class AddToCart extends AbstractRest {

    private $product;

    private function getProduct($post_id = NULL){
        if(!is_null($post_id) || !$this->get_prop('product')){
            $this->product = wc_get_product($post_id);
        }
        return $this->product;
    }

    private function getProductAttributes($post_id, $carriers){
        // vartiation attributes
        $product_attributes = wc_get_product_variation_attributes($post_id);
        // push carriter product attribute
        if($carriers){
            $attributes_slug = ucfirst(sanitize_title(Acf::get('msb_product_carriers_label', 'option', 'str')));
            if($attributes_slug){
                $product_attributes[$attributes_slug] = implode(', ', $carriers);
            }
        }
        return $product_attributes;
    }

    public static function init(){
        $instance = self::getInstance();
        $instance->method = 'POST';
        $instance->namespace = 'msb/v2/cart';
        $instance->route = '/add';

        // set product id argument
        $instance->setArg('product_id', array(
            'required' => true,
            'validate_callback' => function($post_id) use($instance){
                if(Validate::check($post_id, 'int')){
                    $product = $instance->getProduct($post_id);
                    if(is_a($product, 'WC_Product') && $product->is_in_stock() && $product->is_purchasable() && $product->add_to_cart_url() && $product->get_regular_price()){
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            },
            'sanitize_callback' => function($post_id){
                return Sanitize::get($post_id, 'int');
            }
        ));

        // set product carriers argument
        $instance->setArg('carriers', array(
            'required' => false,
            'default' => array(),
            'validate_callback' => function($carriers){
                return is_array($carriers) && empty($carriers) || Validate::check($carriers, 'arr/str');
            },
            'sanitize_callback' => function($carriers){
                return Sanitize::get($carriers, 'arr/str');
            }
        ));

        // set callback function
        $instance->setCallback(function(WP_REST_Request $request) use($instance){
            BootstrapWoocommerce::cart();
            // add to cart
            WC()->cart->add_to_cart(
                $request->get_param('product_id'), // product id
                1, // quantity
                $request->get_param('product_id'), // variation id
                // variation attributes with carriers added
                $instance->getProductAttributes($request->get_param('product_id'), $request->get_param('carriers'))
            );
            // return redirection url
            return wc_get_cart_url() ? wc_get_cart_url() : get_site_url();
        });
        return $instance;
    }
}