<?php

namespace App\Rest;

if(!defined('ABSPATH')){
	exit;
}

use WP_REST_Response;
use App\AbstractRest;
use App\BootstrapWoocommerce;

class GetCart extends AbstractRest {

    public static function getCartItems($cart_items){
        $to_return = array();
        foreach(WC()->cart->get_cart() as $cart_item_key=>$cart_item){
            $wc_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
            $product_id = $cart_item['variation_id'] ? $cart_item['variation_id'] : $cart_item['product_id'];
            if($wc_product && $wc_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key)){
                $to_return[] = array(
                    "id" => $product_id,
                    "name" => $wc_product->get_name(),
                    "image" => msb_get_image_url($wc_product->get_image_id(), 'thumbnail'),
                    "permalink" => $wc_product->is_visible() ? $wc_product->get_permalink($cart_item) : '',
                    "price_html" => WC()->cart->get_product_price($wc_product),
                    "remove_url" => wc_get_cart_remove_url($cart_item_key),
                    "qty" => $cart_item['quantity']
                );
            }
        }
        return $to_return;
    }

    public static function init(){
        $instance = self::getInstance();
        $instance->method = 'GET';
        $instance->namespace = 'msb/v2/cart';
        $instance->route = '/get';

        $instance->setCallback(function(){
            BootstrapWoocommerce::cart();

            $result = new WP_REST_Response([
                "subtotal_html" => wc_price(WC()->cart->get_subtotal()),
                "qty" => WC()->cart->get_cart_contents_count(),
                "items" => self::getCartItems(WC()->cart->get_cart())
            ], 200);
            
            $result->set_headers([
                "Cache-Control" => "no-cache"
            ]);
            return $result;
        });

        return $instance;
    }

}