<?php

namespace App\Rest;

if(!defined('ABSPATH')){
	exit;
}

use WP_REST_Request;
use App\AbstractRest;
use App\ToType;
use App\Validate;
use App\Sanitize;

class GetComments extends AbstractRest {

    public static function getCommentAttachments($comment_id){
        $attachments = get_comment_meta($comment_id, 'attachment_ids', true);
        $attachemnt_ids = explode(',', $attachments);
        $to_return = array();
        if($attachemnt_ids){
            foreach($attachemnt_ids as $attachemnt_id){
                $attachment_src = msb_get_image_url($attachemnt_id, 'full');
                if($attachment_src){
                    $to_return[] = $attachment_src;
                }
            }
        }
        return $to_return;
    }

    public static function init(){
        $instance = self::getInstance();
        $instance->method = 'GET';
        $instance->namespace = 'msb/v2/comment';
        $instance->route = '/list';

        $instance->setArg('post_id', array(
            'required' => true,
            'validate_callback' => function($post_id){
                return ToType::evaluate(get_post_status($post_id), 'bool');
            },
            'sanitize_callback' => function($post_id){
                return Sanitize::get($post_id, 'int');
            },
        )); 

        $instance->setArg('type__not_in', array(
            'required' => null,
            'default' => 'review',
            'validate_callback' => function($type__not_in){
                return Validate::check($type__not_in, 'str');
            },
            'sanitize_callback' => function($post_id){
                return Sanitize::get($post_id, 'str');
            },
        ));

        $instance->setArg('page', array(
            'required' => null,
            'default' => 1,
            'validate_callback' => function($type__not_in){
                return Validate::check($type__not_in, 'int');
            },
            'sanitize_callback' => function($post_id){
                return Sanitize::get($post_id, 'int');
            },
        ));

        $instance->setArg('per_page', array(
            'required' => null,
            'default' => 5,
            'validate_callback' => function($type__not_in){
                return Validate::check($type__not_in, 'int');
            },
            'sanitize_callback' => function($post_id){
                return Sanitize::get($post_id, 'int');
            },
        ));
        $instance->setCallback(function(WP_REST_Request $request){
            // query arguments
            $comment_query_args = array(
                'post_id' => $request->get_param('post_id'),
                'status' => 'approve',
                'type__not_in' => $request->get_param('type__not_in'),
                'hierarchical' => 'threaded',
                'orderby' => 'comment_date',
                'order' => 'DESC',
                'offset' => ($request->get_param('page') - 1) * $request->get_param('per_page'),
                'number' => $request->get_param('per_page')
            );
            // query comments
            $comment_query = get_comments($comment_query_args);
            $to_return = array();
            // loop results
            foreach($comment_query as $comment){
                $to_return[] = array(
                    'comment' => $comment,
                    'rating' => get_comment_meta($comment->comment_ID, 'rating', true),
                    'attachments' => self::getCommentAttachments($comment->comment_ID),
                    'children' => array_values($comment->get_children())
                );
            }
            return $to_return;
        });

        return $instance;
    }

}