<?php

namespace App\Rest;

if(!defined('ABSPATH')){
	exit;
}

use WP_REST_Request;
use App\AbstractRest;
use App\Validate;
use App\Sanitize;
use MimeType\MimeType;

class PostComment extends AbstractRest {

	/**
	 * Function to uplaod attachments
	 * 
	 * @param array $files
	 * 
	 * @return string $attachment_ids		comma delimetered ids 
	 */
	private static function uploadCommentAttachments($files){
		$to_return = array();
		if($files && isset($files['tmp_name'])){
			for($i=0; $i < count($files['tmp_name']); $i++){
				$file_temp = $files['tmp_name'][$i];
				if($file_temp){
					$file_name = $files['name'][$i];
					$file_mime_type = MimeType::getType($file_name);
					// validate if is image
					if(!strstr($file_mime_type, 'image/')){
						continue;
					}
					$file_path = wp_upload_dir()['path'] . '/' . $file_name;
					// validate file movement
					if(!move_uploaded_file($file_temp, $file_path)){
						continue;
					};
					$attachemnt_id = wp_insert_attachment(array(
					  'guid'           => $file_path,
					  'post_mime_type' => $file_mime_type,
					  'post_title'     => sanitize_file_name($file_name),
					  'post_content'   => '',
					  'post_status'    => 'inherit'
					), $file_path, true);

					// validate attachment post
					if(is_wp_error($attachemnt_id)){
					  break;
					}
					require_once(ABSPATH . 'wp-admin/includes/image.php');
					wp_update_attachment_metadata($attachemnt_id, wp_generate_attachment_metadata($attachemnt_id, $file_path));
					$to_return[] = $attachemnt_id;
				}
			  }
		}
		return implode(',', $to_return);
	}

    public static function init(){
        $instance = self::getInstance();
        $instance->method = 'POST';
        $instance->namespace = 'msb/v2/comment';
        $instance->route = '/post';

		$instance->setArg('comment_post_ID', array(
			'required' => true,
			'validate_callback' => function($type){
				return Validate::check($type, 'int');
            },
            'sanitize_callback' => function($type){
				return Sanitize::get($type, 'int');
            },
		));

		$instance->setArg('type', array(
			'default' => 'review',
			'required' => null,
			'validate_callback' => function($type){
				return Validate::check($type, 'str');
            },
            'sanitize_callback' => function($type){
				return Sanitize::get($type, 'str');
            },
		));

		$instance->setArg('author', array(
			'required' => true,
			'validate_callback' => function($author){
				return Validate::check($author, 'str');
            },
            'sanitize_callback' => function($author){
				return Sanitize::get($author, 'str');
            },
		));

		$instance->setArg('email', array(
			'required' => true,
			'validate_callback' => function($email){
				return Validate::check($email, 'email');
            },
            'sanitize_callback' => function($email){
				return Sanitize::get($email, 'email');
            },
		));

		$instance->setArg('comment', array(
			'required' => true,
			'validate_callback' => function($email){
				return Validate::check($email, 'str');
            },
            'sanitize_callback' => function($email){
				return Sanitize::get($email, 'str');
            },
		));

		$instance->setArg('rating', array(
            'default' => 0,
			'required' => null,
			'validate_callback' => function($rating){
				return Validate::check($rating, 'int');
            },
            'sanitize_callback' => function($rating){
				return Sanitize::get($rating, 'int');
            },
		));

        $instance->setCallback(function(WP_REST_Request $request){
			$comment_id = wp_insert_comment(array(
				'comment_post_ID'      => $request->get_param('comment_post_ID'),
				'comment_author'       => $request->get_param('author'),
				'comment_author_email' => $request->get_param('email'),
				'comment_author_url'   => '',
				'comment_content'      => $request->get_param('comment'),
				'comment_parent'       => 0,
				'user_id'              => 999,
				'comment_date'         => date('Y-m-d H:i:s'),
				'comment_approved'     => 0,
				'comment_type'         => $request->get_param('type')
            ));
            
			if($comment_id){
				if($request->get_param('type') == 'review' && $request->get_param('rating')){
					update_comment_meta($comment_id, 'rating', $request->get_param('rating'));
				}
			}
			// attach images to comment
			if($request->get_file_params()){
				$attachment_ids = self::uploadCommentAttachments($request->get_file_params()['attachments'] ?? []);
				if($attachment_ids){
					update_comment_meta($comment_id, 'attachment_ids', $attachment_ids);
				}
			}
			return true;
		});
        return $instance;
    }
}