<?php

namespace App\Rest;

if(!defined('ABSPATH')){
	exit;
}

use WP_Query;
use WP_REST_Request;
use App\AbstractRest;
use App\Acf;
use App\Validate;
use App\Sanitize;
use App\Product;

class SearchProducts extends AbstractRest {

    public static function getProduct($msb_product){
        return [
            'permalink' => $msb_product->wc()->get_permalink(),
            'featured_image' => $msb_product->get_featured_image_url('small_thumbnail'),
            'on_sale' => $msb_product->wc()->is_on_sale(),
            'name' => $msb_product->wc()->get_name(),
            'regular_price' => $msb_product->get_regular_price(true),
            'sale_price' => $msb_product->get_sale_price(true),
        ];
    }

    public static function init(){
        $instance = self::getInstance();
        $instance->method = 'GET';
        $instance->namespace = 'msb/v2/product';
        $instance->route = '/search';

        $instance->setArg('s', array(
			'required' => true,
            'validate_callback' => function($query){
                return Validate::check($query, 'str') && Validate::check($query, 'min', 2);
            },
            'sanitize_callback' => function($rating){
				return Sanitize::get($rating, 'str');
            },
        ));

        $instance->setCallback(function(WP_REST_Request $request){
            // query products
            $query_args = array(
                'post_status' => 'publish',
                's' => $request->get_param('s'),
                'posts_per_page' => 5,
                'tax_query' => [
                    array(
                        'taxonomy'      => 'product_cat',
                        'terms'         => Acf::get('exclude_categories', msb_get_template_page('search'), 'arr'),
                        'field'         => 'term_id',
                        'operator'      => 'NOT IN',
                        'include_children' => false
                    ),
                    array(
                        'taxonomy' => 'product_visibility',
                        'field'    => 'name',
                        'terms'    => array('exclude-from-search'),
                        'operator' => 'NOT IN',
                        'include_children' => false,
                    )
                ]
            );
            // loop query
            $products = [];
            foreach(Product::query($query_args) as $product){
                $products[] = self::getProduct($product);
            }
            return $products;
        });
        return $instance;
    }
}