<?php

namespace App;

if(!defined('ABSPATH')){
	exit;
}

use App\ToType;

class Sanitize {
    public static function get($var, $type = 'str', $cond = NULL){
        if(is_array($var)){
            return array_map(function($item) use($type){
                return self::get($item, $type);
            }, $var);
        } else {
            switch ($type){
                case 'string':
                case 'str':
                    $const = FILTER_SANITIZE_STRING;
                    break;
                case 'int':
                case 'integer':
                    $const = FILTER_SANITIZE_NUMBER_INT;
                    break;
                case 'float':
                    $const = FILTER_SANITIZE_NUMBER_FLOAT;
                    break;
                case 'url':
                    $const = FILTER_SANITIZE_URL;
                    break;
                case 'email':
                case 'mail':
                    $const = FILTER_SANITIZE_EMAIL;
                    break;
            }
        }
        if(isset($const)){
            return filter_var($var, $const);
        } else {
            return ToType::evaluate($var, $type);
        }
    }
}